/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.automatedcuration.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetowner.client.ExternalReferenceManager;
import org.odpi.openmetadata.accessservices.assetowner.client.GovernanceConfigurationClient;
import org.odpi.openmetadata.accessservices.assetowner.client.OpenGovernanceClient;
import org.odpi.openmetadata.accessservices.assetowner.client.OpenMetadataStoreClient;
import org.odpi.openmetadata.accessservices.assetowner.client.ValidValuesAssetOwner;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.EffectiveTimeRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FilterRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.AttachedClassification;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CatalogTargetProperties;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyComparisonOperator;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.openmetadata.enums.SequencingOrder;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementClassification;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ReferenceableElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ValidValueElement;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworkservices.gaf.rest.CatalogTargetResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.CatalogTargetsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.EngineActionElementResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.EngineActionElementsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionProcessElementResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionProcessElementsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionProcessGraphResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionTypeResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionTypesResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.InitiateEngineActionRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.InitiateGovernanceActionProcessRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.InitiateGovernanceActionTypeRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.TemplateRequestBody;
import org.odpi.openmetadata.tokencontroller.TokenController;
import org.odpi.openmetadata.viewservices.automatedcuration.converters.ReferenceableConverter;
import org.odpi.openmetadata.viewservices.automatedcuration.properties.CatalogTemplate;
import org.odpi.openmetadata.viewservices.automatedcuration.properties.ResourceDescription;
import org.odpi.openmetadata.viewservices.automatedcuration.properties.TechnologyTypeReport;
import org.odpi.openmetadata.viewservices.automatedcuration.properties.TechnologyTypeSummary;
import org.odpi.openmetadata.viewservices.automatedcuration.rest.TechnologyTypeElementListResponse;
import org.odpi.openmetadata.viewservices.automatedcuration.rest.TechnologyTypeReportResponse;
import org.odpi.openmetadata.viewservices.automatedcuration.rest.TechnologyTypeSummaryListResponse;
import org.odpi.openmetadata.viewservices.automatedcuration.server.AutomatedCurationInstanceHandler;
import org.slf4j.LoggerFactory;

public class AutomatedCurationRESTServices
extends TokenController {
    private static final AutomatedCurationInstanceHandler instanceHandler = new AutomatedCurationInstanceHandler();
    private static final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(AutomatedCurationRESTServices.class), instanceHandler.getServiceName());
    private final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private final PropertyHelper propertyHelper = new PropertyHelper();

    public TechnologyTypeSummaryListResponse findTechnologyTypes(String serverName, boolean startsWith, boolean endsWith, boolean ignoreCase, int startFrom, int pageSize, FilterRequestBody requestBody) {
        String methodName = "findTechnologyTypes";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "findTechnologyTypes");
        TechnologyTypeSummaryListResponse response = new TechnologyTypeSummaryListResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "findTechnologyTypes");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findTechnologyTypes");
            ValidValuesAssetOwner handler = instanceHandler.getValidValuesAssetOwner(userId, serverName, "findTechnologyTypes");
            Date effectiveTime = new Date();
            if (requestBody != null) {
                effectiveTime = requestBody.getEffectiveTime();
            }
            List validValues = handler.findValidValues(userId, "Egeria:ValidMetadataValue:.*:deployedImplementationType-.*", startFrom, pageSize, effectiveTime);
            if (requestBody != null && requestBody.getFilter() != null && !requestBody.getFilter().isBlank() && validValues != null) {
                ArrayList<ValidValueElement> filteredValidValues = new ArrayList<ValidValueElement>();
                String searchString = instanceHandler.getSearchString(requestBody.getFilter(), startsWith, endsWith, ignoreCase);
                for (ValidValueElement validValue : validValues) {
                    if (validValue == null || validValue.getValidValueProperties() == null || validValue.getValidValueProperties().getPreferredValue() == null || !validValue.getValidValueProperties().getPreferredValue().matches(searchString)) continue;
                    filteredValidValues.add(validValue);
                }
                response.setElements(this.getTechnologySummaries(filteredValidValues));
            } else {
                response.setElements(this.getTechnologySummaries(validValues));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findTechnologyTypes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private List<TechnologyTypeSummary> getTechnologySummaries(List<ValidValueElement> validValues) {
        if (validValues != null) {
            ArrayList<TechnologyTypeSummary> technologySummaries = new ArrayList<TechnologyTypeSummary>();
            for (ValidValueElement validValueElement : validValues) {
                if (validValueElement == null || !validValueElement.getValidValueProperties().getQualifiedName().endsWith(")")) continue;
                TechnologyTypeSummary technologyTypeSummary = new TechnologyTypeSummary();
                technologyTypeSummary.setTechnologyTypeGUID(validValueElement.getElementHeader().getGUID());
                technologyTypeSummary.setQualifiedName(validValueElement.getValidValueProperties().getQualifiedName());
                technologyTypeSummary.setName(validValueElement.getValidValueProperties().getPreferredValue());
                technologyTypeSummary.setDescription(validValueElement.getValidValueProperties().getDescription());
                technologyTypeSummary.setCategory(validValueElement.getValidValueProperties().getCategory());
                technologySummaries.add(technologyTypeSummary);
            }
            if (!technologySummaries.isEmpty()) {
                return technologySummaries;
            }
        }
        return null;
    }

    public TechnologyTypeSummaryListResponse getTechnologyTypesForOpenMetadataType(String serverName, String typeName, int startFrom, int pageSize, EffectiveTimeRequestBody requestBody) {
        String methodName = "getTechnologyTypesForOpenMetadataType";
        String parameterName = "typeName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getTechnologyTypesForOpenMetadataType");
        TechnologyTypeSummaryListResponse response = new TechnologyTypeSummaryListResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getTechnologyTypesForOpenMetadataType");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTechnologyTypesForOpenMetadataType");
            if (typeName != null) {
                ValidValuesAssetOwner handler = instanceHandler.getValidValuesAssetOwner(userId, serverName, "getTechnologyTypesForOpenMetadataType");
                if (requestBody != null) {
                    List validValues = handler.findValidValues(userId, "Egeria:ValidMetadataValue:" + typeName + ":deployedImplementationType-.*", startFrom, pageSize, requestBody.getEffectiveTime());
                    response.setElements(this.getTechnologySummaries(validValues));
                } else {
                    List validValues = handler.findValidValues(userId, "Egeria:ValidMetadataValue:" + typeName + ":deployedImplementationType-.*", startFrom, pageSize, new Date());
                    response.setElements(this.getTechnologySummaries(validValues));
                }
            } else {
                restExceptionHandler.handleMissingValue("typeName", "getTechnologyTypesForOpenMetadataType");
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getTechnologyTypesForOpenMetadataType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public TechnologyTypeReportResponse getTechnologyTypeDetail(String serverName, FilterRequestBody requestBody) {
        String methodName = "getTechnologyTypeDetail";
        String parameterName = "requestBody.filter";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getTechnologyTypeDetail");
        TechnologyTypeReportResponse response = new TechnologyTypeReportResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getTechnologyTypeDetail");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTechnologyTypeDetail");
            if (requestBody != null) {
                if (requestBody.getFilter() != null) {
                    ValidValuesAssetOwner validValuesHandler = instanceHandler.getValidValuesAssetOwner(userId, serverName, "getTechnologyTypeDetail");
                    ExternalReferenceManager externalRefHandler = instanceHandler.getExternalReferenceManager(userId, serverName, "getTechnologyTypeDetail");
                    OpenMetadataStoreClient openHandler = instanceHandler.getOpenMetadataStoreClient(userId, serverName, "getTechnologyTypeDetail");
                    List validValues = validValuesHandler.findValidValues(userId, "Egeria:ValidMetadataValue:.*:deployedImplementationType-.*", 0, 0, requestBody.getEffectiveTime());
                    if (validValues != null) {
                        TechnologyTypeReport report = new TechnologyTypeReport();
                        for (ValidValueElement validValueElement : validValues) {
                            List catalogTemplateList;
                            List resourceList;
                            List subElements;
                            ValidValueElement superElement;
                            if (validValueElement == null || validValueElement.getValidValueProperties() == null || !requestBody.getFilter().equals(validValueElement.getValidValueProperties().getPreferredValue())) continue;
                            report.setTechnologyTypeGUID(validValueElement.getElementHeader().getGUID());
                            report.setQualifiedName(validValueElement.getValidValueProperties().getQualifiedName());
                            report.setName(validValueElement.getValidValueProperties().getPreferredValue());
                            report.setDescription(validValueElement.getValidValueProperties().getDescription());
                            report.setCategory(validValueElement.getValidValueProperties().getCategory());
                            if (validValueElement.getSetGUID() != null && (superElement = validValuesHandler.getValidValueByGUID(userId, validValueElement.getSetGUID())) != null) {
                                report.setTechnologySuperType(superElement.getValidValueProperties().getPreferredValue());
                            }
                            if ((subElements = validValuesHandler.getValidValueSetMembers(userId, validValueElement.getElementHeader().getGUID(), 0, 0)) != null) {
                                ArrayList<String> subElementNames = new ArrayList<String>();
                                for (Object subElement : subElements) {
                                    if (subElement == null) continue;
                                    subElementNames.add(subElement.getValidValueProperties().getPreferredValue());
                                }
                                report.setTechnologySubtypes(subElementNames);
                            }
                            if ((resourceList = externalRefHandler.getResourceList(userId, validValueElement.getElementHeader().getGUID(), 0, 0)) != null) {
                                ArrayList<ResourceDescription> resources = new ArrayList<ResourceDescription>();
                                for (RelatedElement resource : resourceList) {
                                    if (resource == null || resource.getRelationshipProperties() == null || resource.getRelationshipProperties().getExtendedProperties() == null) continue;
                                    Map extendedProperties = resource.getRelationshipProperties().getExtendedProperties();
                                    ResourceDescription resourceDescription = new ResourceDescription();
                                    if (extendedProperties.get(OpenMetadataProperty.RESOURCE_USE.name) != null) {
                                        resourceDescription.setResourceUse(extendedProperties.get(OpenMetadataProperty.RESOURCE_USE.name).toString());
                                    }
                                    if (extendedProperties.get(OpenMetadataProperty.RESOURCE_USE_DESCRIPTION.name) != null) {
                                        resourceDescription.setResourceUseDescription(extendedProperties.get(OpenMetadataProperty.RESOURCE_USE_DESCRIPTION.name).toString());
                                    }
                                    resourceDescription.setRelatedElement(resource.getRelatedElement());
                                    resourceDescription.setSpecification(openHandler.getSpecification(userId, resource.getRelatedElement().getGUID()));
                                    resources.add(resourceDescription);
                                }
                                if (!resources.isEmpty()) {
                                    report.setResourceList(resources);
                                }
                            }
                            if ((catalogTemplateList = externalRefHandler.getCatalogTemplateList(userId, validValueElement.getElementHeader().getGUID(), 0, 0)) != null) {
                                ArrayList<CatalogTemplate> catalogTemplates = new ArrayList<CatalogTemplate>();
                                for (RelatedElement templateElement : catalogTemplateList) {
                                    if (templateElement == null) continue;
                                    CatalogTemplate catalogTemplate = new CatalogTemplate();
                                    catalogTemplate.setRelatedElement(templateElement.getRelatedElement());
                                    List classifications = templateElement.getRelatedElement().getClassifications();
                                    if (classifications != null) {
                                        for (ElementClassification classification : classifications) {
                                            if (classification == null || !classification.getClassificationName().equals(OpenMetadataType.TEMPLATE_CLASSIFICATION.typeName) || classification.getClassificationProperties() == null) continue;
                                            if (classification.getClassificationProperties().get(OpenMetadataProperty.NAME.name) != null) {
                                                catalogTemplate.setName(classification.getClassificationProperties().get(OpenMetadataProperty.NAME.name).toString());
                                                continue;
                                            }
                                            if (classification.getClassificationProperties().get(OpenMetadataProperty.DESCRIPTION.name) != null) {
                                                catalogTemplate.setDescription(classification.getClassificationProperties().get(OpenMetadataProperty.DESCRIPTION.name).toString());
                                                continue;
                                            }
                                            if (classification.getClassificationProperties().get(OpenMetadataProperty.VERSION_IDENTIFIER.name) == null) continue;
                                            catalogTemplate.setVersionIdentifier(classification.getClassificationProperties().get(OpenMetadataProperty.VERSION_IDENTIFIER.name).toString());
                                        }
                                    }
                                    catalogTemplate.setSpecification(openHandler.getSpecification(userId, templateElement.getRelatedElement().getGUID()));
                                    catalogTemplates.add(catalogTemplate);
                                }
                                if (!catalogTemplates.isEmpty()) {
                                    report.setCatalogTemplates(catalogTemplates);
                                }
                            }
                            List externalReferenceElements = externalRefHandler.retrieveAttachedExternalReferences(userId, validValueElement.getElementHeader().getGUID(), 0, 0);
                            report.setExternalReferences(externalReferenceElements);
                            break;
                        }
                        response.setElement(report);
                    }
                } else {
                    restExceptionHandler.handleMissingValue("requestBody.filter", "getTechnologyTypeDetail");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getTechnologyTypeDetail", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getTechnologyTypeDetail", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public TechnologyTypeElementListResponse getTechnologyTypeElements(String serverName, int startFrom, int pageSize, boolean getTemplates, FilterRequestBody requestBody) {
        String methodName = "getTechnologyTypeElements";
        String parameterName = "requestBody.filter";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getTechnologyTypeElements");
        TechnologyTypeElementListResponse response = new TechnologyTypeElementListResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getTechnologyTypeElements");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTechnologyTypeElements");
            if (requestBody != null) {
                if (requestBody.getFilter() != null) {
                    OpenMetadataStoreClient openHandler = instanceHandler.getOpenMetadataStoreClient(userId, serverName, "getTechnologyTypeElements");
                    this.invalidParameterHandler.validateUserId(userId, "getTechnologyTypeElements");
                    this.invalidParameterHandler.validateName(requestBody.getFilter(), "requestBody.filter", "getTechnologyTypeElements");
                    this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getTechnologyTypeElements");
                    List<String> propertyNames = Collections.singletonList(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name);
                    List openMetadataElements = openHandler.findMetadataElements(userId, OpenMetadataType.REFERENCEABLE.typeName, null, this.propertyHelper.getSearchPropertiesByName(propertyNames, requestBody.getFilter(), PropertyComparisonOperator.LIKE), null, null, null, OpenMetadataProperty.QUALIFIED_NAME.name, SequencingOrder.PROPERTY_ASCENDING, false, false, requestBody.getEffectiveTime(), startFrom, pageSize);
                    response.setElements(this.convertReferenceable(openMetadataElements, getTemplates, serverName, "getTechnologyTypeElements"));
                } else {
                    restExceptionHandler.handleMissingValue("requestBody.filter", "getTechnologyTypeElements");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getTechnologyTypeElements", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getTechnologyTypeElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private boolean isTemplate(OpenMetadataElement openMetadataElement) {
        if (openMetadataElement.getClassifications() != null) {
            for (AttachedClassification classification : openMetadataElement.getClassifications()) {
                if (classification == null || !classification.getClassificationName().equals(OpenMetadataType.TEMPLATE_CLASSIFICATION.typeName)) continue;
                return true;
            }
        }
        return false;
    }

    private List<ReferenceableElement> convertReferenceable(List<OpenMetadataElement> openMetadataElements, boolean getTemplates, String serverName, String methodName) throws PropertyServerException {
        ReferenceableConverter<ReferenceableElement> converter = new ReferenceableConverter<ReferenceableElement>(this.propertyHelper, instanceHandler.getServiceName(), serverName);
        if (openMetadataElements != null) {
            ArrayList<ReferenceableElement> referenceableElements = new ArrayList<ReferenceableElement>();
            for (OpenMetadataElement openMetadataElement : openMetadataElements) {
                ReferenceableElement referenceableElement;
                if (openMetadataElement == null) continue;
                if (this.isTemplate(openMetadataElement) && getTemplates && (referenceableElement = converter.getNewBean(ReferenceableElement.class, openMetadataElement, methodName)) != null) {
                    referenceableElements.add(referenceableElement);
                }
                if (this.isTemplate(openMetadataElement) || getTemplates || (referenceableElement = converter.getNewBean(ReferenceableElement.class, openMetadataElement, methodName)) == null) continue;
                referenceableElements.add(referenceableElement);
            }
            return referenceableElements;
        }
        return null;
    }

    public GUIDResponse createElementFromTemplate(String serverName, TemplateRequestBody requestBody) {
        String methodName = "createElementFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "createElementFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "createElementFromTemplate");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createElementFromTemplate");
            if (requestBody != null) {
                OpenMetadataStoreClient openHandler = instanceHandler.getOpenMetadataStoreClient(userId, serverName, "createElementFromTemplate");
                response.setGUID(openHandler.createMetadataElementFromTemplate(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getTypeName(), requestBody.getAnchorGUID(), requestBody.getIsOwnAnchor(), requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), requestBody.getTemplateGUID(), requestBody.getReplacementProperties(), requestBody.getPlaceholderPropertyValues(), requestBody.getParentGUID(), requestBody.getParentRelationshipTypeName(), requestBody.getParentRelationshipProperties(), requestBody.getParentAtEnd1()));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createElementFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createElementFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse getElementFromTemplate(String serverName, TemplateRequestBody requestBody) {
        String methodName = "getElementFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getElementFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getElementFromTemplate");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getElementFromTemplate");
            if (requestBody != null) {
                OpenMetadataStoreClient openHandler = instanceHandler.getOpenMetadataStoreClient(userId, serverName, "getElementFromTemplate");
                response.setGUID(openHandler.getMetadataElementFromTemplate(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getTypeName(), requestBody.getAnchorGUID(), requestBody.getIsOwnAnchor(), requestBody.getEffectiveFrom(), requestBody.getEffectiveTo(), requestBody.getTemplateGUID(), requestBody.getReplacementProperties(), requestBody.getPlaceholderPropertyValues(), requestBody.getParentGUID(), requestBody.getParentRelationshipTypeName(), requestBody.getParentRelationshipProperties(), requestBody.getParentAtEnd1()));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getElementFromTemplate", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getElementFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse addCatalogTarget(String serverName, String integrationConnectorGUID, String metadataElementGUID, CatalogTargetProperties requestBody) {
        String methodName = "addCatalogTarget";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "addCatalogTarget");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "addCatalogTarget");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addCatalogTarget");
            if (requestBody != null) {
                GovernanceConfigurationClient handler = instanceHandler.getGovernanceConfigurationClient(userId, serverName, "addCatalogTarget");
                response.setGUID(handler.addCatalogTarget(userId, integrationConnectorGUID, metadataElementGUID, requestBody));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addCatalogTarget", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addCatalogTarget", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateCatalogTarget(String serverName, String relationshipGUID, CatalogTargetProperties requestBody) {
        String methodName = "updateCatalogTarget";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "updateCatalogTarget");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "updateCatalogTarget");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateCatalogTarget");
            if (requestBody != null) {
                GovernanceConfigurationClient handler = instanceHandler.getGovernanceConfigurationClient(userId, serverName, "updateCatalogTarget");
                handler.updateCatalogTarget(userId, relationshipGUID, requestBody);
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateCatalogTarget", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateCatalogTarget", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public CatalogTargetResponse getCatalogTarget(String serverName, String relationshipGUID) {
        String methodName = "getCatalogTarget";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getCatalogTarget");
        CatalogTargetResponse response = new CatalogTargetResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getCatalogTarget");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCatalogTarget");
            GovernanceConfigurationClient handler = instanceHandler.getGovernanceConfigurationClient(userId, serverName, "getCatalogTarget");
            response.setElement(handler.getCatalogTarget(userId, relationshipGUID));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getCatalogTarget", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public CatalogTargetsResponse getCatalogTargets(String serverName, String integrationConnectorGUID, int startFrom, int pageSize) {
        String methodName = "getCatalogTargets";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getCatalogTargets");
        CatalogTargetsResponse response = new CatalogTargetsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getCatalogTargets");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCatalogTargets");
            GovernanceConfigurationClient handler = instanceHandler.getGovernanceConfigurationClient(userId, serverName, "getCatalogTargets");
            response.setElements(handler.getCatalogTargets(userId, integrationConnectorGUID, startFrom, pageSize));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getCatalogTargets", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeCatalogTarget(String serverName, String relationshipGUID, NullRequestBody requestBody) {
        String methodName = "removeCatalogTarget";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "removeCatalogTarget");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "removeCatalogTarget");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeCatalogTarget");
            GovernanceConfigurationClient handler = instanceHandler.getGovernanceConfigurationClient(userId, serverName, "removeCatalogTarget");
            handler.removeCatalogTarget(userId, relationshipGUID);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeCatalogTarget", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionTypesResponse findGovernanceActionTypes(String serverName, boolean startsWith, boolean endsWith, boolean ignoreCase, int startFrom, int pageSize, FilterRequestBody requestBody) {
        String methodName = "findGovernanceActionTypes";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "findGovernanceActionTypes");
        GovernanceActionTypesResponse response = new GovernanceActionTypesResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "findGovernanceActionTypes");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findGovernanceActionTypes");
            OpenGovernanceClient handler = instanceHandler.getOpenGovernanceClient(userId, serverName, "findGovernanceActionTypes");
            if (requestBody != null) {
                response.setElements(handler.findGovernanceActionTypes(userId, instanceHandler.getSearchString(requestBody.getFilter(), startsWith, endsWith, ignoreCase), startFrom, pageSize, requestBody.getEffectiveTime()));
            } else {
                response.setElements(handler.findGovernanceActionTypes(userId, instanceHandler.getSearchString(null, startsWith, endsWith, ignoreCase), startFrom, pageSize, new Date()));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findGovernanceActionTypes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionTypesResponse getGovernanceActionTypesByName(String serverName, int startFrom, int pageSize, FilterRequestBody requestBody) {
        String methodName = "getGovernanceActionTypesByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getGovernanceActionTypesByName");
        GovernanceActionTypesResponse response = new GovernanceActionTypesResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getGovernanceActionTypesByName");
            restCallLogger.setUserId(token, userId);
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceActionTypesByName");
                OpenGovernanceClient handler = instanceHandler.getOpenGovernanceClient(userId, serverName, "getGovernanceActionTypesByName");
                response.setElements(handler.getGovernanceActionTypesByName(userId, requestBody.getFilter(), startFrom, pageSize, requestBody.getEffectiveTime()));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getGovernanceActionTypesByName", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceActionTypesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionTypeResponse getGovernanceActionTypeByGUID(String serverName, String governanceActionTypeGUID) {
        String methodName = "getGovernanceActionTypeByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getGovernanceActionTypeByGUID");
        GovernanceActionTypeResponse response = new GovernanceActionTypeResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getGovernanceActionTypeByGUID");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceActionTypeByGUID");
            OpenGovernanceClient handler = instanceHandler.getOpenGovernanceClient(userId, serverName, "getGovernanceActionTypeByGUID");
            response.setElement(handler.getGovernanceActionTypeByGUID(userId, governanceActionTypeGUID));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceActionTypeByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionProcessElementsResponse findGovernanceActionProcesses(String serverName, boolean startsWith, boolean endsWith, boolean ignoreCase, int startFrom, int pageSize, FilterRequestBody requestBody) {
        String methodName = "findGovernanceActionProcesses";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "findGovernanceActionProcesses");
        GovernanceActionProcessElementsResponse response = new GovernanceActionProcessElementsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "findGovernanceActionProcesses");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findGovernanceActionProcesses");
            OpenGovernanceClient handler = instanceHandler.getOpenGovernanceClient(userId, serverName, "findGovernanceActionProcesses");
            if (requestBody != null) {
                response.setElements(handler.findGovernanceActionProcesses(userId, instanceHandler.getSearchString(requestBody.getFilter(), startsWith, endsWith, ignoreCase), startFrom, pageSize, requestBody.getEffectiveTime()));
            } else {
                response.setElements(handler.findGovernanceActionProcesses(userId, instanceHandler.getSearchString(null, startsWith, endsWith, ignoreCase), startFrom, pageSize, new Date()));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findGovernanceActionProcesses", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionProcessElementsResponse getGovernanceActionProcessesByName(String serverName, int startFrom, int pageSize, FilterRequestBody requestBody) {
        String methodName = "getGovernanceActionProcessesByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getGovernanceActionProcessesByName");
        GovernanceActionProcessElementsResponse response = new GovernanceActionProcessElementsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getGovernanceActionProcessesByName");
            restCallLogger.setUserId(token, userId);
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceActionProcessesByName");
                OpenGovernanceClient handler = instanceHandler.getOpenGovernanceClient(userId, serverName, "getGovernanceActionProcessesByName");
                response.setElements(handler.getGovernanceActionProcessesByName(userId, requestBody.getFilter(), startFrom, pageSize, requestBody.getEffectiveTime()));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getGovernanceActionProcessesByName", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceActionProcessesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionProcessElementResponse getGovernanceActionProcessByGUID(String serverName, String processGUID) {
        String methodName = "getGovernanceActionProcessByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getGovernanceActionProcessByGUID");
        GovernanceActionProcessElementResponse response = new GovernanceActionProcessElementResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getGovernanceActionProcessByGUID");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceActionProcessByGUID");
            OpenGovernanceClient handler = instanceHandler.getOpenGovernanceClient(userId, serverName, "getGovernanceActionProcessByGUID");
            response.setElement(handler.getGovernanceActionProcessByGUID(userId, processGUID));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceActionProcessByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionProcessGraphResponse getGovernanceActionProcessGraph(String serverName, String processGUID, EffectiveTimeRequestBody requestBody) {
        String methodName = "getGovernanceActionProcessGraph";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getGovernanceActionProcessGraph");
        GovernanceActionProcessGraphResponse response = new GovernanceActionProcessGraphResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getGovernanceActionProcessGraph");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceActionProcessGraph");
            OpenGovernanceClient handler = instanceHandler.getOpenGovernanceClient(userId, serverName, "getGovernanceActionProcessGraph");
            if (requestBody != null) {
                response.setElement(handler.getGovernanceActionProcessGraph(userId, processGUID, requestBody.getEffectiveTime()));
            } else {
                response.setElement(handler.getGovernanceActionProcessGraph(userId, processGUID, new Date()));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceActionProcessGraph", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public EngineActionElementResponse getEngineAction(String serverName, String engineActionGUID) {
        String methodName = "getEngineAction";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getEngineAction");
        AuditLog auditLog = null;
        EngineActionElementResponse response = new EngineActionElementResponse();
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getEngineAction");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getEngineAction");
            OpenGovernanceClient handler = instanceHandler.getOpenGovernanceClient(userId, serverName, "getEngineAction");
            response.setElement(handler.getEngineAction(userId, engineActionGUID));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getEngineAction", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse cancelEngineAction(String serverName, String engineActionGUID) {
        String methodName = "cancelEngineAction";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "cancelEngineAction");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "cancelEngineAction");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "cancelEngineAction");
            OpenGovernanceClient handler = instanceHandler.getOpenGovernanceClient(userId, serverName, "cancelEngineAction");
            handler.cancelEngineAction(userId, engineActionGUID);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "cancelEngineAction", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public EngineActionElementsResponse getEngineActions(String serverName, int startFrom, int pageSize) {
        String methodName = "getEngineActions";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getEngineActions");
        AuditLog auditLog = null;
        EngineActionElementsResponse response = new EngineActionElementsResponse();
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getEngineActions");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getEngineActions");
            OpenGovernanceClient handler = instanceHandler.getOpenGovernanceClient(userId, serverName, "getEngineActions");
            response.setElements(handler.getEngineActions(userId, startFrom, pageSize));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getEngineActions", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public EngineActionElementsResponse getActiveEngineActions(String serverName, int startFrom, int pageSize) {
        String methodName = "getActiveEngineActions";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getActiveEngineActions");
        AuditLog auditLog = null;
        EngineActionElementsResponse response = new EngineActionElementsResponse();
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getActiveEngineActions");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getActiveEngineActions");
            OpenGovernanceClient handler = instanceHandler.getOpenGovernanceClient(userId, serverName, "getActiveEngineActions");
            response.setElements(handler.getActiveEngineActions(userId, startFrom, pageSize));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getActiveEngineActions", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public EngineActionElementsResponse findEngineActions(String serverName, boolean startsWith, boolean endsWith, boolean ignoreCase, int startFrom, int pageSize, FilterRequestBody requestBody) {
        String methodName = "findEngineActions";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "findEngineActions");
        EngineActionElementsResponse response = new EngineActionElementsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "findEngineActions");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findEngineActions");
            OpenGovernanceClient handler = instanceHandler.getOpenGovernanceClient(userId, serverName, "findEngineActions");
            if (requestBody != null) {
                response.setElements(handler.findEngineActions(userId, instanceHandler.getSearchString(requestBody.getFilter(), startsWith, endsWith, ignoreCase), startFrom, pageSize));
            } else {
                response.setElements(handler.findEngineActions(userId, instanceHandler.getSearchString(null, startsWith, endsWith, ignoreCase), startFrom, pageSize));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findEngineActions", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public EngineActionElementsResponse getEngineActionsByName(String serverName, int startFrom, int pageSize, FilterRequestBody requestBody) {
        String methodName = "getEngineActionsByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getEngineActionsByName");
        EngineActionElementsResponse response = new EngineActionElementsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getEngineActionsByName");
            restCallLogger.setUserId(token, userId);
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "getEngineActionsByName");
                OpenGovernanceClient handler = instanceHandler.getOpenGovernanceClient(userId, serverName, "getEngineActionsByName");
                response.setElements(handler.getEngineActionsByName(userId, requestBody.getFilter(), startFrom, pageSize));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getEngineActionsByName", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getEngineActionsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse initiateEngineAction(String serverName, String governanceEngineName, InitiateEngineActionRequestBody requestBody) {
        String methodName = "initiateEngineAction";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "initiateEngineAction");
        AuditLog auditLog = null;
        GUIDResponse response = new GUIDResponse();
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "initiateEngineAction");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "initiateEngineAction");
            if (requestBody != null) {
                OpenGovernanceClient handler = instanceHandler.getOpenGovernanceClient(userId, serverName, "initiateEngineAction");
                response.setGUID(handler.initiateEngineAction(userId, requestBody.getQualifiedName(), requestBody.getDomainIdentifier(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getRequestSourceGUIDs(), requestBody.getActionTargets(), requestBody.getReceivedGuards(), requestBody.getStartDate(), governanceEngineName, requestBody.getRequestType(), requestBody.getRequestParameters(), requestBody.getProcessName(), requestBody.getRequestSourceName(), requestBody.getOriginatorServiceName(), requestBody.getOriginatorEngineName()));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "initiateEngineAction", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "initiateEngineAction", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse initiateGovernanceActionType(String serverName, InitiateGovernanceActionTypeRequestBody requestBody) {
        String methodName = "initiateGovernanceActionType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "initiateGovernanceActionType");
        AuditLog auditLog = null;
        GUIDResponse response = new GUIDResponse();
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "initiateGovernanceActionType");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "initiateGovernanceActionType");
            if (requestBody != null) {
                OpenGovernanceClient handler = instanceHandler.getOpenGovernanceClient(userId, serverName, "initiateGovernanceActionType");
                response.setGUID(handler.initiateGovernanceActionType(userId, requestBody.getGovernanceActionTypeQualifiedName(), requestBody.getRequestSourceGUIDs(), requestBody.getActionTargets(), requestBody.getStartDate(), requestBody.getRequestParameters(), requestBody.getOriginatorServiceName(), requestBody.getOriginatorEngineName()));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "initiateGovernanceActionType", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "initiateGovernanceActionType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse initiateGovernanceActionProcess(String serverName, InitiateGovernanceActionProcessRequestBody requestBody) {
        String methodName = "initiateGovernanceActionProcess";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "initiateGovernanceActionProcess");
        AuditLog auditLog = null;
        GUIDResponse response = new GUIDResponse();
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "initiateGovernanceActionProcess");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "initiateGovernanceActionProcess");
            if (requestBody != null) {
                OpenGovernanceClient handler = instanceHandler.getOpenGovernanceClient(userId, serverName, "initiateGovernanceActionProcess");
                response.setGUID(handler.initiateGovernanceActionProcess(userId, requestBody.getProcessQualifiedName(), requestBody.getRequestSourceGUIDs(), requestBody.getActionTargets(), requestBody.getStartDate(), requestBody.getRequestParameters(), requestBody.getOriginatorServiceName(), requestBody.getOriginatorEngineName()));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "initiateGovernanceActionProcess", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "initiateGovernanceActionProcess", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

