/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.automatedcuration.converters;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.viewservices.automatedcuration.converters.AutomatedCurationConverterBase;
import org.odpi.openmetadata.viewservices.automatedcuration.properties.TechnologyTypeSummary;

public class TechnologyTypeSummaryConverter<B>
extends AutomatedCurationConverterBase<B> {
    public TechnologyTypeSummaryConverter(PropertyHelper propertyHelper, String serviceName, String serverName) {
        super(propertyHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, OpenMetadataElement openMetadataElement, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof TechnologyTypeSummary) {
                TechnologyTypeSummary bean = (TechnologyTypeSummary)returnBean;
                if (openMetadataElement != null) {
                    ElementProperties elementProperties = new ElementProperties(openMetadataElement.getElementProperties());
                    bean.setTechnologyTypeGUID(openMetadataElement.getElementGUID());
                    bean.setName(super.removeName(elementProperties));
                    bean.setQualifiedName(this.removeQualifiedName(elementProperties));
                    bean.setCategory(this.removeCategory(elementProperties));
                    bean.setDescription(this.removeDescription(elementProperties));
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), OpenMetadataElement.class.getName(), methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

