/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.automatedcuration.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetowner.client.ExternalReferenceManager;
import org.odpi.openmetadata.accessservices.assetowner.client.OpenMetadataStoreClient;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.mermaid.HierarchyMermaidGraphBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.AttachedClassification;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElementList;
import org.odpi.openmetadata.frameworks.governanceaction.search.ClassificationCondition;
import org.odpi.openmetadata.frameworks.governanceaction.search.MatchCriteria;
import org.odpi.openmetadata.frameworks.governanceaction.search.PrimitiveTypeCategory;
import org.odpi.openmetadata.frameworks.governanceaction.search.PrimitiveTypePropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyComparisonOperator;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyCondition;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.SearchClassifications;
import org.odpi.openmetadata.frameworks.governanceaction.search.SearchProperties;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ElementStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.SequencingOrder;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementClassification;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ReferenceableElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedElement;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.viewservices.automatedcuration.converters.ReferenceableConverter;
import org.odpi.openmetadata.viewservices.automatedcuration.converters.TechnologyTypeSummaryConverter;
import org.odpi.openmetadata.viewservices.automatedcuration.properties.CatalogTemplate;
import org.odpi.openmetadata.viewservices.automatedcuration.properties.ResourceDescription;
import org.odpi.openmetadata.viewservices.automatedcuration.properties.TechnologyTypeHierarchy;
import org.odpi.openmetadata.viewservices.automatedcuration.properties.TechnologyTypeReport;
import org.odpi.openmetadata.viewservices.automatedcuration.properties.TechnologyTypeSummary;

public class TechnologyTypeHandler {
    private static final PropertyHelper propertyHelper = new PropertyHelper();
    private static final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private final ExternalReferenceManager externalRefHandler;
    private final OpenMetadataStoreClient openHandler;
    private final String serverName;
    private final String serviceName;

    public TechnologyTypeHandler(ExternalReferenceManager externalRefHandler, OpenMetadataStoreClient openHandler, String serviceName, String serverName) {
        this.externalRefHandler = externalRefHandler;
        this.openHandler = openHandler;
        this.serviceName = serviceName;
        this.serverName = serverName;
    }

    public List<TechnologyTypeSummary> findTechnologyTypes(String userId, String searchString, int startFrom, int pageSize, Date effectiveTime, List<ElementStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingProperty) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findTechnologyTypes";
        String parameterName = "searchString";
        invalidParameterHandler.validateSearchString(searchString, "searchString", "findTechnologyTypes");
        List openMetadataElements = this.openHandler.findMetadataElements(userId, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, null, this.getTechnologyTypeConditions(searchString, PropertyComparisonOperator.LIKE), limitResultsByStatus, asOfTime, null, sequencingProperty, sequencingOrder, false, false, effectiveTime, startFrom, pageSize);
        return this.convertTechTypeSummaries(openMetadataElements, "findTechnologyTypes");
    }

    public List<TechnologyTypeSummary> getTechnologyTypesForOpenMetadataType(String userId, String typeName, int startFrom, int pageSize, Date effectiveTime, List<ElementStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingProperty) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getTechnologyTypesForOpenMetadataType";
        String parameterName = "typeName";
        invalidParameterHandler.validateName(typeName, "typeName", "getTechnologyTypesForOpenMetadataType");
        String searchString = "Egeria:ValidMetadataValue:" + typeName + ":deployedImplementationType-.*";
        SearchProperties searchProperties = new SearchProperties();
        PrimitiveTypePropertyValue propertyValue = new PrimitiveTypePropertyValue();
        propertyValue.setTypeName("string");
        propertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING);
        propertyValue.setPrimitiveValue((Object)searchString);
        ArrayList<PropertyCondition> propertyConditions = new ArrayList<PropertyCondition>();
        PropertyCondition propertyCondition = new PropertyCondition();
        propertyCondition.setValue((PropertyValue)propertyValue);
        propertyCondition.setProperty(OpenMetadataProperty.QUALIFIED_NAME.name);
        propertyCondition.setOperator(PropertyComparisonOperator.LIKE);
        propertyConditions.add(propertyCondition);
        searchProperties.setConditions(propertyConditions);
        searchProperties.setMatchCriteria(MatchCriteria.ANY);
        List openMetadataElements = this.openHandler.findMetadataElements(userId, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, null, searchProperties, limitResultsByStatus, asOfTime, null, sequencingProperty, sequencingOrder, false, false, effectiveTime, startFrom, pageSize);
        return this.convertTechTypeSummaries(openMetadataElements, "getTechnologyTypesForOpenMetadataType");
    }

    public TechnologyTypeReport getTechnologyTypeDetail(String userId, String technologyTypeName, Date effectiveTime, List<ElementStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingProperty) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getTechnologyTypeDetail";
        String parameterName = "technologyTypeName";
        invalidParameterHandler.validateName(technologyTypeName, "technologyTypeName", "getTechnologyTypeDetail");
        List openMetadataElements = this.openHandler.findMetadataElements(userId, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, null, this.getTechnologyTypeConditions(technologyTypeName, PropertyComparisonOperator.EQ), limitResultsByStatus, asOfTime, null, sequencingProperty, sequencingOrder, false, false, effectiveTime, 0, 0);
        if (openMetadataElements != null) {
            TechnologyTypeReport report = null;
            for (OpenMetadataElement openMetadataElement : openMetadataElements) {
                List catalogTemplateList;
                if (openMetadataElement == null) continue;
                report = new TechnologyTypeReport(this.convertTechTypeSummary(openMetadataElement));
                List resourceList = this.externalRefHandler.getResourceList(userId, openMetadataElement.getElementGUID(), 0, 0);
                if (resourceList != null) {
                    ArrayList<ResourceDescription> resources = new ArrayList<ResourceDescription>();
                    for (RelatedElement resource : resourceList) {
                        if (resource == null || resource.getRelationshipProperties() == null || resource.getRelationshipProperties().getExtendedProperties() == null) continue;
                        Map extendedProperties = resource.getRelationshipProperties().getExtendedProperties();
                        ResourceDescription resourceDescription = new ResourceDescription();
                        if (extendedProperties.get(OpenMetadataProperty.RESOURCE_USE.name) != null) {
                            resourceDescription.setResourceUse(extendedProperties.get(OpenMetadataProperty.RESOURCE_USE.name).toString());
                        }
                        if (extendedProperties.get(OpenMetadataProperty.RESOURCE_USE_DESCRIPTION.name) != null) {
                            resourceDescription.setResourceUseDescription(extendedProperties.get(OpenMetadataProperty.RESOURCE_USE_DESCRIPTION.name).toString());
                        }
                        resourceDescription.setRelatedElement(resource.getRelatedElement());
                        resourceDescription.setSpecification(this.openHandler.getSpecification(userId, resource.getRelatedElement().getGUID()));
                        resources.add(resourceDescription);
                    }
                    if (!resources.isEmpty()) {
                        report.setResourceList(resources);
                    }
                }
                if ((catalogTemplateList = this.externalRefHandler.getCatalogTemplateList(userId, openMetadataElement.getElementGUID(), 0, 0)) != null) {
                    ArrayList<CatalogTemplate> catalogTemplates = new ArrayList<CatalogTemplate>();
                    for (RelatedElement templateElement : catalogTemplateList) {
                        if (templateElement == null) continue;
                        CatalogTemplate catalogTemplate = new CatalogTemplate();
                        catalogTemplate.setRelatedElement(templateElement.getRelatedElement());
                        List classifications = templateElement.getRelatedElement().getClassifications();
                        if (classifications != null) {
                            for (ElementClassification classification : classifications) {
                                if (classification == null || !classification.getClassificationName().equals(OpenMetadataType.TEMPLATE_CLASSIFICATION.typeName) || classification.getClassificationProperties() == null) continue;
                                if (classification.getClassificationProperties().get(OpenMetadataProperty.NAME.name) != null) {
                                    catalogTemplate.setName(classification.getClassificationProperties().get(OpenMetadataProperty.NAME.name).toString());
                                    continue;
                                }
                                if (classification.getClassificationProperties().get(OpenMetadataProperty.DESCRIPTION.name) != null) {
                                    catalogTemplate.setDescription(classification.getClassificationProperties().get(OpenMetadataProperty.DESCRIPTION.name).toString());
                                    continue;
                                }
                                if (classification.getClassificationProperties().get(OpenMetadataProperty.VERSION_IDENTIFIER.name) == null) continue;
                                catalogTemplate.setVersionIdentifier(classification.getClassificationProperties().get(OpenMetadataProperty.VERSION_IDENTIFIER.name).toString());
                            }
                        }
                        catalogTemplate.setSpecification(this.openHandler.getSpecification(userId, templateElement.getRelatedElement().getGUID()));
                        catalogTemplates.add(catalogTemplate);
                    }
                    if (!catalogTemplates.isEmpty()) {
                        report.setCatalogTemplates(catalogTemplates);
                    }
                }
                List externalReferenceElements = this.externalRefHandler.retrieveAttachedExternalReferences(userId, openMetadataElement.getElementGUID(), 0, 0);
                report.setExternalReferences(externalReferenceElements);
                break;
            }
            return report;
        }
        return null;
    }

    public TechnologyTypeHierarchy getTechnologyTypeHierarchy(String userId, String technologyTypeName, Date effectiveTime, List<ElementStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingProperty) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getTechnologyTypeHierarchy";
        String parameterName = "technologyTypeName";
        invalidParameterHandler.validateName(technologyTypeName, "technologyTypeName", "getTechnologyTypeHierarchy");
        List openMetadataElements = this.openHandler.findMetadataElements(userId, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, null, this.getTechnologyTypeConditions(technologyTypeName, PropertyComparisonOperator.EQ), limitResultsByStatus, asOfTime, null, sequencingProperty, sequencingOrder, false, false, effectiveTime, 0, 0);
        if (openMetadataElements != null) {
            TechnologyTypeHierarchy technologyTypeHierarchy = null;
            for (OpenMetadataElement openMetadataElement : openMetadataElements) {
                if (openMetadataElement == null) continue;
                technologyTypeHierarchy = new TechnologyTypeHierarchy(this.convertTechTypeSummary(openMetadataElement));
                technologyTypeHierarchy.setSubTypes(this.getSubTypes(userId, openMetadataElement.getElementGUID()));
                break;
            }
            return technologyTypeHierarchy;
        }
        return null;
    }

    public String getTechnologyTypeHierarchyMermaidString(TechnologyTypeHierarchy technologyTypeHierarchy) {
        if (technologyTypeHierarchy != null) {
            HierarchyMermaidGraphBuilder mermaidGraphBuilder = new HierarchyMermaidGraphBuilder("Technology type hierarchy", technologyTypeHierarchy.getTechnologyTypeGUID(), technologyTypeHierarchy.getName());
            mermaidGraphBuilder.appendMermaidNode(technologyTypeHierarchy.getTechnologyTypeGUID(), technologyTypeHierarchy.getName(), technologyTypeHierarchy.getCategory());
            this.addTechnologyTypeHierarchyNodesMermaidString(mermaidGraphBuilder, technologyTypeHierarchy.getSubTypes());
            if (technologyTypeHierarchy.getSubTypes() != null) {
                for (TechnologyTypeHierarchy subType : technologyTypeHierarchy.getSubTypes()) {
                    mermaidGraphBuilder.appendMermaidLine(technologyTypeHierarchy.getTechnologyTypeGUID(), null, subType.getTechnologyTypeGUID());
                }
                this.addTechnologyTypeHierarchyLinesMermaidString(mermaidGraphBuilder, technologyTypeHierarchy.getSubTypes());
            }
            return mermaidGraphBuilder.getMermaidGraph();
        }
        return null;
    }

    private void addTechnologyTypeHierarchyNodesMermaidString(HierarchyMermaidGraphBuilder mermaidGraphBuilder, List<TechnologyTypeHierarchy> technologyTypeHierarchies) {
        if (technologyTypeHierarchies != null) {
            for (TechnologyTypeHierarchy technologyTypeHierarchy : technologyTypeHierarchies) {
                mermaidGraphBuilder.appendMermaidNode(technologyTypeHierarchy.getTechnologyTypeGUID(), technologyTypeHierarchy.getName(), technologyTypeHierarchy.getCategory());
                this.addTechnologyTypeHierarchyNodesMermaidString(mermaidGraphBuilder, technologyTypeHierarchy.getSubTypes());
            }
        }
    }

    private void addTechnologyTypeHierarchyLinesMermaidString(HierarchyMermaidGraphBuilder mermaidGraphBuilder, List<TechnologyTypeHierarchy> technologyTypeHierarchies) {
        if (technologyTypeHierarchies != null) {
            for (TechnologyTypeHierarchy technologyTypeHierarchy : technologyTypeHierarchies) {
                if (technologyTypeHierarchy.getSubTypes() == null) continue;
                for (TechnologyTypeHierarchy subType : technologyTypeHierarchy.getSubTypes()) {
                    mermaidGraphBuilder.appendMermaidLine(technologyTypeHierarchy.getTechnologyTypeGUID(), null, subType.getTechnologyTypeGUID());
                }
                this.addTechnologyTypeHierarchyLinesMermaidString(mermaidGraphBuilder, technologyTypeHierarchy.getSubTypes());
            }
        }
    }

    private List<TechnologyTypeHierarchy> getSubTypes(String userId, String technologyTypeGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getSubTypes";
        RelatedMetadataElementList relatedElements = this.openHandler.getRelatedMetadataElements(userId, technologyTypeGUID, 2, OpenMetadataType.VALID_VALUE_ASSOCIATION_RELATIONSHIP.typeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, false, false, new Date(), 0, 0);
        if (relatedElements != null && relatedElements.getElementList() != null) {
            ArrayList<TechnologyTypeHierarchy> technologyTypeHierarchies = new ArrayList<TechnologyTypeHierarchy>();
            for (RelatedMetadataElement relatedMetadataElement : relatedElements.getElementList()) {
                String associationName;
                if (relatedMetadataElement == null || !"isATypeOf".equals(associationName = propertyHelper.getStringProperty(this.serviceName, OpenMetadataProperty.ASSOCIATION_NAME.name, relatedMetadataElement.getRelationshipProperties(), "getSubTypes"))) continue;
                TechnologyTypeHierarchy technologyTypeHierarchy = new TechnologyTypeHierarchy(this.convertTechTypeSummary(relatedMetadataElement.getElement()));
                technologyTypeHierarchy.setSubTypes(this.getSubTypes(userId, relatedMetadataElement.getElement().getElementGUID()));
                technologyTypeHierarchies.add(technologyTypeHierarchy);
            }
            if (!technologyTypeHierarchies.isEmpty()) {
                return technologyTypeHierarchies;
            }
        }
        return null;
    }

    private SearchProperties getTechnologyTypeConditions(String propertyValue, PropertyComparisonOperator operator) {
        SearchProperties searchProperties = new SearchProperties();
        ArrayList<PropertyCondition> propertyConditions = new ArrayList<PropertyCondition>();
        PropertyCondition preferredValueCondition = new PropertyCondition();
        PrimitiveTypePropertyValue preferredValue = new PrimitiveTypePropertyValue();
        preferredValueCondition.setProperty(OpenMetadataProperty.PREFERRED_VALUE.name);
        preferredValueCondition.setOperator(operator);
        preferredValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING);
        preferredValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING.getName());
        preferredValue.setPrimitiveValue((Object)propertyValue);
        preferredValueCondition.setValue((PropertyValue)preferredValue);
        propertyConditions.add(preferredValueCondition);
        PropertyCondition scopeCondition = new PropertyCondition();
        PrimitiveTypePropertyValue scope = new PrimitiveTypePropertyValue();
        scopeCondition.setProperty(OpenMetadataProperty.SCOPE.name);
        scopeCondition.setOperator(PropertyComparisonOperator.EQ);
        scope.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING);
        scope.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING.getName());
        scope.setPrimitiveValue((Object)"Open Metadata Ecosystem");
        scopeCondition.setValue((PropertyValue)scope);
        propertyConditions.add(scopeCondition);
        PropertyCondition categoryCondition = new PropertyCondition();
        PrimitiveTypePropertyValue category = new PrimitiveTypePropertyValue();
        categoryCondition.setProperty(OpenMetadataProperty.CATEGORY.name);
        categoryCondition.setOperator(PropertyComparisonOperator.LIKE);
        category.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING);
        category.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING.getName());
        category.setPrimitiveValue((Object)".*deployedImplementationType");
        categoryCondition.setValue((PropertyValue)category);
        propertyConditions.add(categoryCondition);
        searchProperties.setConditions(propertyConditions);
        searchProperties.setMatchCriteria(MatchCriteria.ALL);
        return searchProperties;
    }

    public List<ReferenceableElement> getTechnologyTypeElements(String userId, String technologyTypeName, boolean getTemplates, int startFrom, int pageSize, Date effectiveTime, List<ElementStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingProperty) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getTechnologyTypeElements";
        String parameterName = "technologyTypeName";
        invalidParameterHandler.validateUserId(userId, "getTechnologyTypeElements");
        invalidParameterHandler.validateName(technologyTypeName, "technologyTypeName", "getTechnologyTypeElements");
        invalidParameterHandler.validatePaging(startFrom, pageSize, "getTechnologyTypeElements");
        List<String> propertyNames = Collections.singletonList(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name);
        List openMetadataElements = this.openHandler.findMetadataElements(userId, OpenMetadataType.REFERENCEABLE.typeName, null, propertyHelper.getSearchPropertiesByName(propertyNames, technologyTypeName, PropertyComparisonOperator.EQ), limitResultsByStatus, asOfTime, this.getMatchClassifications(getTemplates), sequencingProperty, sequencingOrder, false, false, effectiveTime, startFrom, pageSize);
        return this.convertReferenceables(openMetadataElements, getTemplates);
    }

    private SearchClassifications getMatchClassifications(boolean getTemplates) {
        SearchClassifications matchClassifications = null;
        if (getTemplates) {
            matchClassifications = new SearchClassifications();
            ArrayList<ClassificationCondition> classificationConditions = new ArrayList<ClassificationCondition>();
            ClassificationCondition classificationCondition = new ClassificationCondition();
            classificationCondition.setName(OpenMetadataType.TEMPLATE_CLASSIFICATION.typeName);
            classificationConditions.add(classificationCondition);
            matchClassifications.setConditions(classificationConditions);
            matchClassifications.setMatchCriteria(MatchCriteria.ALL);
        }
        return matchClassifications;
    }

    private List<TechnologyTypeSummary> convertTechTypeSummaries(List<OpenMetadataElement> openMetadataElements, String methodName) throws PropertyServerException {
        TechnologyTypeSummaryConverter<TechnologyTypeSummary> converter = new TechnologyTypeSummaryConverter<TechnologyTypeSummary>(propertyHelper, this.serviceName, this.serverName);
        if (openMetadataElements != null) {
            ArrayList<TechnologyTypeSummary> technologyTypeSummaries = new ArrayList<TechnologyTypeSummary>();
            for (OpenMetadataElement openMetadataElement : openMetadataElements) {
                TechnologyTypeSummary technologyTypeSummary;
                if (openMetadataElement == null || (technologyTypeSummary = converter.getNewBean(TechnologyTypeSummary.class, openMetadataElement, methodName)) == null) continue;
                technologyTypeSummaries.add(technologyTypeSummary);
            }
            return technologyTypeSummaries;
        }
        return null;
    }

    private TechnologyTypeSummary convertTechTypeSummary(OpenMetadataElement openMetadataElement) throws PropertyServerException {
        String methodName = "convertTechTypeSummary";
        TechnologyTypeSummaryConverter<TechnologyTypeSummary> converter = new TechnologyTypeSummaryConverter<TechnologyTypeSummary>(propertyHelper, this.serviceName, this.serverName);
        if (openMetadataElement != null) {
            return converter.getNewBean(TechnologyTypeSummary.class, openMetadataElement, "convertTechTypeSummary");
        }
        return null;
    }

    private List<ReferenceableElement> convertReferenceables(List<OpenMetadataElement> openMetadataElements, boolean getTemplates) throws PropertyServerException {
        String methodName = "convertReferenceables";
        ReferenceableConverter<ReferenceableElement> converter = new ReferenceableConverter<ReferenceableElement>(propertyHelper, this.serviceName, this.serverName);
        if (openMetadataElements != null) {
            ArrayList<ReferenceableElement> referenceableElements = new ArrayList<ReferenceableElement>();
            for (OpenMetadataElement openMetadataElement : openMetadataElements) {
                ReferenceableElement referenceableElement;
                if (openMetadataElement == null) continue;
                boolean isTemplate = this.isTemplate(openMetadataElement);
                if (isTemplate && getTemplates && (referenceableElement = converter.getNewBean(ReferenceableElement.class, openMetadataElement, "convertReferenceables")) != null) {
                    referenceableElements.add(referenceableElement);
                }
                if (isTemplate || getTemplates || (referenceableElement = converter.getNewBean(ReferenceableElement.class, openMetadataElement, "convertReferenceables")) == null) continue;
                referenceableElements.add(referenceableElement);
            }
            return referenceableElements;
        }
        return null;
    }

    private boolean isTemplate(OpenMetadataElement openMetadataElement) {
        if (openMetadataElement.getClassifications() != null) {
            for (AttachedClassification classification : openMetadataElement.getClassifications()) {
                if (classification == null || !classification.getClassificationName().equals(OpenMetadataType.TEMPLATE_CLASSIFICATION.typeName)) continue;
                return true;
            }
        }
        return false;
    }
}

