/* SPDX-License-Identifier: Apache-2.0 */
/* Copyright Contributors to the ODPi Egeria project. */
package org.odpi.openmetadata.viewservices.automatedcuration.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.viewservices.automatedcuration.properties.TechnologyTypeSummary;

import java.util.ArrayList;
import java.util.List;

import static com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility.NONE;
import static com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility.PUBLIC_ONLY;


/**
 * TechnologyTypeSummaryListResponse is the response structure used on the OMVS REST API calls that return a
 * list of technology type summaries as a response.
 */
@JsonAutoDetect(getterVisibility=PUBLIC_ONLY, setterVisibility=PUBLIC_ONLY, fieldVisibility=NONE)
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class TechnologyTypeSummaryListResponse extends FFDCResponseBase
{
    private List<TechnologyTypeSummary> elements = null;


    /**
     * Default constructor
     */
    public TechnologyTypeSummaryListResponse()
    {
        super();
    }


    /**
     * Return the list of technology types.
     *
     * @return list of objects or null
     */
    public List<TechnologyTypeSummary> getElements()
    {
        if (elements == null)
        {
            return null;
        }
        else if (elements.isEmpty())
        {
            return null;
        }
        else
        {
            return new ArrayList<>(elements);
        }
    }


    /**
     * Set up the list of technology types.
     *
     * @param elements - list of objects or null
     */
    public void setElements(List<TechnologyTypeSummary> elements)
    {
        this.elements = elements;
    }


    /**
     * JSON-style toString
     *
     * @return return string containing the property names and values
     */
    @Override
    public String toString()
    {
        return "TechnologyTypeSummaryListResponse{" +
                "elements=" + elements +
                "} " + super.toString();
    }
}
