/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.automatedcuration.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.commonservices.ffdc.rest.EffectiveTimeRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.FilterRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CatalogTargetProperties;
import org.odpi.openmetadata.frameworkservices.gaf.rest.CatalogTargetResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.CatalogTargetsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.EngineActionElementResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.EngineActionElementsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionProcessElementResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionProcessElementsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionProcessGraphResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionTypeResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionTypesResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.InitiateEngineActionRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.InitiateGovernanceActionProcessRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.InitiateGovernanceActionTypeRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.TemplateRequestBody;
import org.odpi.openmetadata.viewservices.automatedcuration.rest.TechnologyTypeElementListResponse;
import org.odpi.openmetadata.viewservices.automatedcuration.rest.TechnologyTypeReportResponse;
import org.odpi.openmetadata.viewservices.automatedcuration.rest.TechnologyTypeSummaryListResponse;
import org.odpi.openmetadata.viewservices.automatedcuration.server.AutomatedCurationRESTServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/api/open-metadata/automated-curation"})
@Tag(name="API: Automated Curation OMVS", description="Set up and maintain automation services in Egeria.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omvs/automated-curation/overview/"))
public class AutomatedCurationResource {
    private final AutomatedCurationRESTServices restAPI = new AutomatedCurationRESTServices();

    @PostMapping(path={"/technology-types/by-search-string"})
    @Operation(summary="findTechnologyTypes", description="Retrieve the list of technology types that contain the search string.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/deployed-implementation-type"))
    public TechnologyTypeSummaryListResponse findTechnologyTypes(@PathVariable String serverName, @RequestParam(required=false, defaultValue="false") boolean startsWith, @RequestParam(required=false, defaultValue="false") boolean endsWith, @RequestParam(required=false, defaultValue="true") boolean ignoreCase, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody(required=false) FilterRequestBody requestBody) {
        return this.restAPI.findTechnologyTypes(serverName, startsWith, endsWith, ignoreCase, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/open-metadata-types/{typeName}/technology-types"})
    @Operation(summary="getTechnologyTypesForOpenMetadataType", description="Retrieve the list of technology types that contain the search string.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/types"))
    public TechnologyTypeSummaryListResponse getTechnologyTypesForOpenMetadataType(@PathVariable String serverName, @PathVariable String typeName, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestBody(required=false) EffectiveTimeRequestBody requestBody) {
        return this.restAPI.getTechnologyTypesForOpenMetadataType(serverName, typeName, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/technology-types/by-name"})
    @Operation(summary="getTechnologyTypeDetail", description="Retrieve the details of the named technology type. This name should be the name of the technology type and contain no wild cards.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/deployed-implementation-type"))
    public TechnologyTypeReportResponse getTechnologyTypeDetail(@PathVariable String serverName, @RequestBody FilterRequestBody requestBody) {
        return this.restAPI.getTechnologyTypeDetail(serverName, requestBody);
    }

    @PostMapping(path={"/technology-types/elements"})
    @Operation(summary="getTechnologyTypeElements", description="Retrieve the elements for the requested deployed implementation type. There are no wildcards allowed in the name.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/deployed-implementation-type"))
    public TechnologyTypeElementListResponse getTechnologyTypeElements(@PathVariable String serverName, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean getTemplates, @RequestBody FilterRequestBody requestBody) {
        return this.restAPI.getTechnologyTypeElements(serverName, startFrom, pageSize, getTemplates, requestBody);
    }

    @PostMapping(path={"/catalog-templates/new-element"})
    @Operation(summary="createElementFromTemplate", description="Create a new element from a template.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/features/templated-cataloguing/overview/"))
    public GUIDResponse createElementFromTemplate(@PathVariable String serverName, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createElementFromTemplate(serverName, requestBody);
    }

    @PostMapping(path={"/catalog-templates/get-element"})
    @Operation(summary="getElementFromTemplate", description="Return an element with the same resolved qualified name as would be generated by the template.  If none exist, create a new element from the template.  Note if critical replacement/placeholder properties are missing, the template itself may be returned.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/features/templated-cataloguing/overview/"))
    public GUIDResponse getElementFromTemplate(@PathVariable String serverName, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.getElementFromTemplate(serverName, requestBody);
    }

    @PostMapping(path={"/integration-connectors/{integrationConnectorGUID}/catalog-targets/{metadataElementGUID}"})
    @Operation(summary="addCatalogTarget", description="Add a catalog target to an integration connector.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-connector/"))
    public GUIDResponse addCatalogTarget(@PathVariable String serverName, @PathVariable String integrationConnectorGUID, @PathVariable String metadataElementGUID, @RequestBody CatalogTargetProperties requestBody) {
        return this.restAPI.addCatalogTarget(serverName, integrationConnectorGUID, metadataElementGUID, requestBody);
    }

    @PostMapping(path={"/catalog-targets/{relationshipGUID}/update"})
    @Operation(summary="updateCatalogTarget", description="Update a catalog target for an integration connector.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-connector/"))
    public VoidResponse updateCatalogTarget(@PathVariable String serverName, @PathVariable String relationshipGUID, @RequestBody CatalogTargetProperties requestBody) {
        return this.restAPI.updateCatalogTarget(serverName, relationshipGUID, requestBody);
    }

    @GetMapping(path={"/catalog-targets/{relationshipGUID}"})
    @Operation(summary="getCatalogTarget", description="Retrieve a specific catalog target associated with an integration connector.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-connector/"))
    public CatalogTargetResponse getCatalogTarget(@PathVariable String serverName, @PathVariable String relationshipGUID) {
        return this.restAPI.getCatalogTarget(serverName, relationshipGUID);
    }

    @GetMapping(path={"/integration-connectors/{integrationConnectorGUID}/catalog-targets"})
    @Operation(summary="getCatalogTargets", description="Retrieve the details of the metadata elements identified as catalog targets with an integration connector.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-connector/"))
    public CatalogTargetsResponse getCatalogTargets(@PathVariable String serverName, @PathVariable String integrationConnectorGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getCatalogTargets(serverName, integrationConnectorGUID, startFrom, pageSize);
    }

    @PostMapping(path={"/catalog-targets/{relationshipGUID}/remove"})
    @Operation(summary="removeCatalogTarget", description="Unregister a catalog target from the integration connector.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-connector/"))
    public VoidResponse removeCatalogTarget(@PathVariable String serverName, @PathVariable String relationshipGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeCatalogTarget(serverName, relationshipGUID, requestBody);
    }

    @PostMapping(path={"/governance-action-types/by-search-string"})
    @Operation(summary="findGovernanceActionTypes", description="Retrieve the list of governance action type metadata elements that contain the search string.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-type"))
    public GovernanceActionTypesResponse findGovernanceActionTypes(@PathVariable String serverName, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean startsWith, @RequestParam(required=false, defaultValue="false") boolean endsWith, @RequestParam(required=false, defaultValue="false") boolean ignoreCase, @RequestBody(required=false) FilterRequestBody requestBody) {
        return this.restAPI.findGovernanceActionTypes(serverName, startsWith, endsWith, ignoreCase, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/governance-action-types/by-name"})
    @Operation(summary="getGovernanceActionTypesByName", description="Retrieve the list of governance action type metadata elements with a matching qualified or display name. There are no wildcards supported on this request.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-type"))
    public GovernanceActionTypesResponse getGovernanceActionTypesByName(@PathVariable String serverName, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody FilterRequestBody requestBody) {
        return this.restAPI.getGovernanceActionTypesByName(serverName, startFrom, pageSize, requestBody);
    }

    @GetMapping(path={"/governance-action-types/{governanceActionTypeGUID}"})
    @Operation(summary="getGovernanceActionTypeByGUID", description="Retrieve the governance action type metadata element with the supplied unique identifier.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-type"))
    public GovernanceActionTypeResponse getGovernanceActionTypeByGUID(@PathVariable String serverName, @PathVariable String governanceActionTypeGUID) {
        return this.restAPI.getGovernanceActionTypeByGUID(serverName, governanceActionTypeGUID);
    }

    @PostMapping(path={"/governance-action-processes/by-search-string"})
    @Operation(summary="findGovernanceActionProcesses", description="Retrieve the list of governance action process metadata elements that contain the search string.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public GovernanceActionProcessElementsResponse findGovernanceActionProcesses(@PathVariable String serverName, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean startsWith, @RequestParam(required=false, defaultValue="false") boolean endsWith, @RequestParam(required=false, defaultValue="false") boolean ignoreCase, @RequestBody(required=false) FilterRequestBody requestBody) {
        return this.restAPI.findGovernanceActionProcesses(serverName, startsWith, endsWith, ignoreCase, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/governance-action-processes/by-name"})
    @Operation(summary="getGovernanceActionProcessesByName", description="Retrieve the list of governance action process metadata elements with a matching qualified or display name. There are no wildcards supported on this request.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public GovernanceActionProcessElementsResponse getGovernanceActionProcessesByName(@PathVariable String serverName, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody FilterRequestBody requestBody) {
        return this.restAPI.getGovernanceActionProcessesByName(serverName, startFrom, pageSize, requestBody);
    }

    @GetMapping(path={"/governance-action-processes/{processGUID}"})
    @Operation(summary="getGovernanceActionProcessByGUID", description="Retrieve the governance action process metadata element with the supplied unique identifier.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public GovernanceActionProcessElementResponse getGovernanceActionProcessByGUID(@PathVariable String serverName, @PathVariable String processGUID) {
        return this.restAPI.getGovernanceActionProcessByGUID(serverName, processGUID);
    }

    @PostMapping(path={"/governance-action-processes/{processGUID}/graph"})
    @Operation(summary="getGovernanceActionProcessGraph", description="Retrieve the governance action process metadata element with the supplied unique identifier along with the flow definition describing its implementation.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public GovernanceActionProcessGraphResponse getGovernanceActionProcessGraph(@PathVariable String serverName, @PathVariable String processGUID, @RequestBody(required=false) EffectiveTimeRequestBody requestBody) {
        return this.restAPI.getGovernanceActionProcessGraph(serverName, processGUID, requestBody);
    }

    @PostMapping(path={"/governance-engines/{governanceEngineName}/engine-actions/initiate"})
    @Operation(summary="initiateEngineAction", description="Create an engine action in the metadata store that will trigger the governance service associated with the supplied request type.  The engine action remains to act as a record of the actions taken for auditing.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/engine-action"))
    public GUIDResponse initiateEngineAction(@PathVariable String serverName, @PathVariable String governanceEngineName, @RequestBody InitiateEngineActionRequestBody requestBody) {
        return this.restAPI.initiateEngineAction(serverName, governanceEngineName, requestBody);
    }

    @PostMapping(path={"/governance-action-types/initiate"})
    @Operation(summary="initiateGovernanceActionType", description="Using the named governance action type as a template, initiate an engine action.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-type"))
    public GUIDResponse initiateGovernanceActionType(@PathVariable String serverName, @RequestBody InitiateGovernanceActionTypeRequestBody requestBody) {
        return this.restAPI.initiateGovernanceActionType(serverName, requestBody);
    }

    @PostMapping(path={"/governance-action-processes/initiate"})
    @Operation(summary="initiateGovernanceActionProcess", description="Using the named governance action process as a template, initiate a chain of engine actions.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public GUIDResponse initiateGovernanceActionProcess(@PathVariable String serverName, @RequestBody InitiateGovernanceActionProcessRequestBody requestBody) {
        return this.restAPI.initiateGovernanceActionProcess(serverName, requestBody);
    }

    @GetMapping(path={"/engine-actions/{engineActionGUID}"})
    @Operation(summary="getEngineAction", description="Request the status and properties of an executing engine action request.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/engine-action"))
    public EngineActionElementResponse getEngineAction(@PathVariable String serverName, @PathVariable String engineActionGUID) {
        return this.restAPI.getEngineAction(serverName, engineActionGUID);
    }

    @PostMapping(path={"/engine-actions/{engineActionGUID}/cancel"})
    @Operation(summary="cancelEngineAction", description="Request that an engine action request is cancelled and any running governance service is stopped.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/engine-action"))
    public VoidResponse cancelEngineAction(@PathVariable String serverName, @PathVariable String engineActionGUID) {
        return this.restAPI.cancelEngineAction(serverName, engineActionGUID);
    }

    @GetMapping(path={"/engine-actions"})
    @Operation(summary="getEngineActions", description="Retrieve the engine actions that are known to the server.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/engine-action"))
    public EngineActionElementsResponse getEngineActions(@PathVariable String serverName, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getEngineActions(serverName, startFrom, pageSize);
    }

    @GetMapping(path={"/engine-actions/active"})
    @Operation(summary="getActiveEngineActions", description="Retrieve the engine actions that are still in process.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/engine-action"))
    public EngineActionElementsResponse getActiveEngineActions(@PathVariable String serverName, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getActiveEngineActions(serverName, startFrom, pageSize);
    }

    @PostMapping(path={"/engine-actions/by-search-string"})
    @Operation(summary="findEngineActions", description="Retrieve the list of engine action metadata elements that contain the search string.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/engine-action"))
    public EngineActionElementsResponse findEngineActions(@PathVariable String serverName, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean startsWith, @RequestParam(required=false, defaultValue="false") boolean endsWith, @RequestParam(required=false, defaultValue="false") boolean ignoreCase, @RequestBody(required=false) FilterRequestBody requestBody) {
        return this.restAPI.findEngineActions(serverName, startsWith, endsWith, ignoreCase, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/engine-actions/by-name"})
    @Operation(summary="getEngineActionsByName", description="Retrieve the list of engine action metadata elements with a matching qualified or display name. There are no wildcards supported on this request.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/engine-action"))
    public EngineActionElementsResponse getEngineActionsByName(@PathVariable String serverName, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody FilterRequestBody requestBody) {
        return this.restAPI.getEngineActionsByName(serverName, startFrom, pageSize, requestBody);
    }
}

