/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.automatedcuration.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.enums.SecuritySchemeIn;
import io.swagger.v3.oas.annotations.enums.SecuritySchemeType;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityScheme;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.commonservices.ffdc.rest.BooleanResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.EffectiveTimeRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ElementHeadersResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FilterRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ResultsRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CatalogTargetProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.MetadataCorrelationProperties;
import org.odpi.openmetadata.frameworkservices.gaf.rest.CatalogTargetResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.CatalogTargetsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.EngineActionElementResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.EngineActionElementsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionProcessElementResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionProcessElementsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionProcessGraphResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionTypeResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionTypesResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.InitiateEngineActionRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.InitiateGovernanceActionProcessRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.InitiateGovernanceActionTypeRequestBody;
import org.odpi.openmetadata.frameworkservices.omf.rest.EffectiveTimeQueryRequestBody;
import org.odpi.openmetadata.frameworkservices.omf.rest.MetadataCorrelationHeadersResponse;
import org.odpi.openmetadata.frameworkservices.omf.rest.TemplateRequestBody;
import org.odpi.openmetadata.frameworkservices.omf.rest.UpdateMetadataCorrelatorsRequestBody;
import org.odpi.openmetadata.viewservices.automatedcuration.rest.TechnologyTypeElementListResponse;
import org.odpi.openmetadata.viewservices.automatedcuration.rest.TechnologyTypeHierarchyResponse;
import org.odpi.openmetadata.viewservices.automatedcuration.rest.TechnologyTypeReportResponse;
import org.odpi.openmetadata.viewservices.automatedcuration.rest.TechnologyTypeSummaryListResponse;
import org.odpi.openmetadata.viewservices.automatedcuration.server.AutomatedCurationRESTServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/api/open-metadata/automated-curation"})
@SecurityScheme(name="BearerAuthorization", type=SecuritySchemeType.HTTP, bearerFormat="JWT", scheme="bearer", in=SecuritySchemeIn.HEADER)
@Tag(name="API: Automated Curation OMVS", description="Set up and maintain automation services in Egeria.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omvs/automated-curation/overview/"))
public class AutomatedCurationResource {
    private final AutomatedCurationRESTServices restAPI = new AutomatedCurationRESTServices();

    @PostMapping(path={"/technology-types/by-search-string"})
    @SecurityRequirement(name="BearerAuthorization")
    @Operation(summary="findTechnologyTypes", description="Retrieve the list of technology types that contain the search string.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/deployed-implementation-type"))
    public TechnologyTypeSummaryListResponse findTechnologyTypes(@PathVariable String serverName, @RequestParam(required=false, defaultValue="false") boolean startsWith, @RequestParam(required=false, defaultValue="false") boolean endsWith, @RequestParam(required=false, defaultValue="true") boolean ignoreCase, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody(required=false) FilterRequestBody requestBody) {
        return this.restAPI.findTechnologyTypes(serverName, startsWith, endsWith, ignoreCase, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/open-metadata-types/{typeName}/technology-types"})
    @SecurityRequirement(name="BearerAuthorization")
    @Operation(summary="getTechnologyTypesForOpenMetadataType", description="Retrieve the list of technology types that contain the search string.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/types"))
    public TechnologyTypeSummaryListResponse getTechnologyTypesForOpenMetadataType(@PathVariable String serverName, @PathVariable String typeName, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestBody(required=false) ResultsRequestBody requestBody) {
        return this.restAPI.getTechnologyTypesForOpenMetadataType(serverName, typeName, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/technology-types/by-name"})
    @SecurityRequirement(name="BearerAuthorization")
    @Operation(summary="getTechnologyTypeDetail", description="Retrieve the details of the named technology type. This name should be the name of the technology type and contain no wild cards.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/deployed-implementation-type"))
    public TechnologyTypeReportResponse getTechnologyTypeDetail(@PathVariable String serverName, @RequestBody FilterRequestBody requestBody) {
        return this.restAPI.getTechnologyTypeDetail(serverName, requestBody);
    }

    @PostMapping(path={"/technology-types/hierarchy"})
    @SecurityRequirement(name="BearerAuthorization")
    @Operation(summary="getTechnologyTypeHierarchy", description="Retrieve the details of the named technology type. This name should be the name of the technology type and contain no wild cards. A summary of the technology type is returned with its subtypes.  A mermaid version if the hierarchy is also returned.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/deployed-implementation-type"))
    public TechnologyTypeHierarchyResponse getTechnologyTypeHierarchy(@PathVariable String serverName, @RequestBody FilterRequestBody requestBody) {
        return this.restAPI.getTechnologyTypeHierarchy(serverName, requestBody);
    }

    @PostMapping(path={"/technology-types/elements"})
    @SecurityRequirement(name="BearerAuthorization")
    @Operation(summary="getTechnologyTypeElements", description="Retrieve the elements for the requested deployed implementation type. There are no wildcards allowed in the name.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/deployed-implementation-type"))
    public TechnologyTypeElementListResponse getTechnologyTypeElements(@PathVariable String serverName, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean getTemplates, @RequestBody FilterRequestBody requestBody) {
        return this.restAPI.getTechnologyTypeElements(serverName, startFrom, pageSize, getTemplates, requestBody);
    }

    @PostMapping(path={"/catalog-templates/new-element"})
    @SecurityRequirement(name="BearerAuthorization")
    @Operation(summary="createElementFromTemplate", description="Create a new element from a template.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/features/templated-cataloguing/overview/"))
    public GUIDResponse createElementFromTemplate(@PathVariable String serverName, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createElementFromTemplate(serverName, requestBody);
    }

    @PostMapping(path={"/catalog-templates/get-element"})
    @SecurityRequirement(name="BearerAuthorization")
    @Operation(summary="getElementFromTemplate", description="Return an element with the same resolved qualified name as would be generated by the template.  If none exist, create a new element from the template.  Note if critical replacement/placeholder properties are missing, the template itself may be returned.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/features/templated-cataloguing/overview/"))
    public GUIDResponse getElementFromTemplate(@PathVariable String serverName, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.getElementFromTemplate(serverName, requestBody);
    }

    @PostMapping(path={"/integration-connectors/{integrationConnectorGUID}/catalog-targets/{metadataElementGUID}"})
    @SecurityRequirement(name="BearerAuthorization")
    @Operation(summary="addCatalogTarget", description="Add a catalog target to an integration connector.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-connector/"))
    public GUIDResponse addCatalogTarget(@PathVariable String serverName, @PathVariable String integrationConnectorGUID, @PathVariable String metadataElementGUID, @RequestBody CatalogTargetProperties requestBody) {
        return this.restAPI.addCatalogTarget(serverName, integrationConnectorGUID, metadataElementGUID, requestBody);
    }

    @PostMapping(path={"/catalog-targets/{relationshipGUID}/update"})
    @SecurityRequirement(name="BearerAuthorization")
    @Operation(summary="updateCatalogTarget", description="Update a catalog target for an integration connector.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-connector/"))
    public VoidResponse updateCatalogTarget(@PathVariable String serverName, @PathVariable String relationshipGUID, @RequestBody CatalogTargetProperties requestBody) {
        return this.restAPI.updateCatalogTarget(serverName, relationshipGUID, requestBody);
    }

    @GetMapping(path={"/catalog-targets/{relationshipGUID}"})
    @SecurityRequirement(name="BearerAuthorization")
    @Operation(summary="getCatalogTarget", description="Retrieve a specific catalog target associated with an integration connector.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-connector/"))
    public CatalogTargetResponse getCatalogTarget(@PathVariable String serverName, @PathVariable String relationshipGUID) {
        return this.restAPI.getCatalogTarget(serverName, relationshipGUID);
    }

    @GetMapping(path={"/integration-connectors/{integrationConnectorGUID}/catalog-targets"})
    @SecurityRequirement(name="BearerAuthorization")
    @Operation(summary="getCatalogTargets", description="Retrieve the details of the metadata elements identified as catalog targets with an integration connector.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-connector/"))
    public CatalogTargetsResponse getCatalogTargets(@PathVariable String serverName, @PathVariable String integrationConnectorGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getCatalogTargets(serverName, integrationConnectorGUID, startFrom, pageSize);
    }

    @PostMapping(path={"/catalog-targets/{relationshipGUID}/remove"})
    @SecurityRequirement(name="BearerAuthorization")
    @Operation(summary="removeCatalogTarget", description="Unregister a catalog target from the integration connector.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-connector/"))
    public VoidResponse removeCatalogTarget(@PathVariable String serverName, @PathVariable String relationshipGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeCatalogTarget(serverName, relationshipGUID, requestBody);
    }

    @PostMapping(path={"/governance-action-types/by-search-string"})
    @SecurityRequirement(name="BearerAuthorization")
    @Operation(summary="findGovernanceActionTypes", description="Retrieve the list of governance action type metadata elements that contain the search string.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-type"))
    public GovernanceActionTypesResponse findGovernanceActionTypes(@PathVariable String serverName, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean startsWith, @RequestParam(required=false, defaultValue="false") boolean endsWith, @RequestParam(required=false, defaultValue="false") boolean ignoreCase, @RequestBody(required=false) FilterRequestBody requestBody) {
        return this.restAPI.findGovernanceActionTypes(serverName, startsWith, endsWith, ignoreCase, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/governance-action-types/by-name"})
    @SecurityRequirement(name="BearerAuthorization")
    @Operation(summary="getGovernanceActionTypesByName", description="Retrieve the list of governance action type metadata elements with a matching qualified or display name. There are no wildcards supported on this request.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-type"))
    public GovernanceActionTypesResponse getGovernanceActionTypesByName(@PathVariable String serverName, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody FilterRequestBody requestBody) {
        return this.restAPI.getGovernanceActionTypesByName(serverName, startFrom, pageSize, requestBody);
    }

    @GetMapping(path={"/governance-action-types/{governanceActionTypeGUID}"})
    @SecurityRequirement(name="BearerAuthorization")
    @Operation(summary="getGovernanceActionTypeByGUID", description="Retrieve the governance action type metadata element with the supplied unique identifier.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-type"))
    public GovernanceActionTypeResponse getGovernanceActionTypeByGUID(@PathVariable String serverName, @PathVariable String governanceActionTypeGUID) {
        return this.restAPI.getGovernanceActionTypeByGUID(serverName, governanceActionTypeGUID);
    }

    @PostMapping(path={"/governance-action-processes/by-search-string"})
    @SecurityRequirement(name="BearerAuthorization")
    @Operation(summary="findGovernanceActionProcesses", description="Retrieve the list of governance action process metadata elements that contain the search string.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public GovernanceActionProcessElementsResponse findGovernanceActionProcesses(@PathVariable String serverName, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean startsWith, @RequestParam(required=false, defaultValue="false") boolean endsWith, @RequestParam(required=false, defaultValue="false") boolean ignoreCase, @RequestBody(required=false) FilterRequestBody requestBody) {
        return this.restAPI.findGovernanceActionProcesses(serverName, startsWith, endsWith, ignoreCase, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/governance-action-processes/by-name"})
    @SecurityRequirement(name="BearerAuthorization")
    @Operation(summary="getGovernanceActionProcessesByName", description="Retrieve the list of governance action process metadata elements with a matching qualified or display name. There are no wildcards supported on this request.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public GovernanceActionProcessElementsResponse getGovernanceActionProcessesByName(@PathVariable String serverName, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody FilterRequestBody requestBody) {
        return this.restAPI.getGovernanceActionProcessesByName(serverName, startFrom, pageSize, requestBody);
    }

    @GetMapping(path={"/governance-action-processes/{processGUID}"})
    @SecurityRequirement(name="BearerAuthorization")
    @Operation(summary="getGovernanceActionProcessByGUID", description="Retrieve the governance action process metadata element with the supplied unique identifier.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public GovernanceActionProcessElementResponse getGovernanceActionProcessByGUID(@PathVariable String serverName, @PathVariable String processGUID) {
        return this.restAPI.getGovernanceActionProcessByGUID(serverName, processGUID);
    }

    @PostMapping(path={"/governance-action-processes/{processGUID}/graph"})
    @SecurityRequirement(name="BearerAuthorization")
    @Operation(summary="getGovernanceActionProcessGraph", description="Retrieve the governance action process metadata element with the supplied unique identifier along with the flow definition describing its implementation.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public GovernanceActionProcessGraphResponse getGovernanceActionProcessGraph(@PathVariable String serverName, @PathVariable String processGUID, @RequestBody(required=false) ResultsRequestBody requestBody) {
        return this.restAPI.getGovernanceActionProcessGraph(serverName, processGUID, requestBody);
    }

    @PostMapping(path={"/governance-engines/{governanceEngineName}/engine-actions/initiate"})
    @SecurityRequirement(name="BearerAuthorization")
    @Operation(summary="initiateEngineAction", description="Create an engine action in the metadata store that will trigger the governance service associated with the supplied request type.  The engine action remains to act as a record of the actions taken for auditing.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/engine-action"))
    public GUIDResponse initiateEngineAction(@PathVariable String serverName, @PathVariable String governanceEngineName, @RequestBody InitiateEngineActionRequestBody requestBody) {
        return this.restAPI.initiateEngineAction(serverName, governanceEngineName, requestBody);
    }

    @PostMapping(path={"/governance-action-types/initiate"})
    @SecurityRequirement(name="BearerAuthorization")
    @Operation(summary="initiateGovernanceActionType", description="Using the named governance action type as a template, initiate an engine action.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-type"))
    public GUIDResponse initiateGovernanceActionType(@PathVariable String serverName, @RequestBody InitiateGovernanceActionTypeRequestBody requestBody) {
        return this.restAPI.initiateGovernanceActionType(serverName, requestBody);
    }

    @PostMapping(path={"/governance-action-processes/initiate"})
    @SecurityRequirement(name="BearerAuthorization")
    @Operation(summary="initiateGovernanceActionProcess", description="Using the named governance action process as a template, initiate a chain of engine actions.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public GUIDResponse initiateGovernanceActionProcess(@PathVariable String serverName, @RequestBody InitiateGovernanceActionProcessRequestBody requestBody) {
        return this.restAPI.initiateGovernanceActionProcess(serverName, requestBody);
    }

    @GetMapping(path={"/engine-actions/{engineActionGUID}"})
    @SecurityRequirement(name="BearerAuthorization")
    @Operation(summary="getEngineAction", description="Request the status and properties of an executing engine action request.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/engine-action"))
    public EngineActionElementResponse getEngineAction(@PathVariable String serverName, @PathVariable String engineActionGUID) {
        return this.restAPI.getEngineAction(serverName, engineActionGUID);
    }

    @PostMapping(path={"/engine-actions/{engineActionGUID}/cancel"})
    @SecurityRequirement(name="BearerAuthorization")
    @Operation(summary="cancelEngineAction", description="Request that an engine action request is cancelled and any running governance service is stopped.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/engine-action"))
    public VoidResponse cancelEngineAction(@PathVariable String serverName, @PathVariable String engineActionGUID) {
        return this.restAPI.cancelEngineAction(serverName, engineActionGUID);
    }

    @GetMapping(path={"/engine-actions"})
    @SecurityRequirement(name="BearerAuthorization")
    @Operation(summary="getEngineActions", description="Retrieve the engine actions that are known to the server.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/engine-action"))
    public EngineActionElementsResponse getEngineActions(@PathVariable String serverName, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getEngineActions(serverName, startFrom, pageSize);
    }

    @GetMapping(path={"/engine-actions/active"})
    @SecurityRequirement(name="BearerAuthorization")
    @Operation(summary="getActiveEngineActions", description="Retrieve the engine actions that are still in process.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/engine-action"))
    public EngineActionElementsResponse getActiveEngineActions(@PathVariable String serverName, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getActiveEngineActions(serverName, startFrom, pageSize);
    }

    @PostMapping(path={"/engine-actions/by-search-string"})
    @SecurityRequirement(name="BearerAuthorization")
    @Operation(summary="findEngineActions", description="Retrieve the list of engine action metadata elements that contain the search string.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/engine-action"))
    public EngineActionElementsResponse findEngineActions(@PathVariable String serverName, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean startsWith, @RequestParam(required=false, defaultValue="false") boolean endsWith, @RequestParam(required=false, defaultValue="false") boolean ignoreCase, @RequestBody(required=false) FilterRequestBody requestBody) {
        return this.restAPI.findEngineActions(serverName, startsWith, endsWith, ignoreCase, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/engine-actions/by-name"})
    @SecurityRequirement(name="BearerAuthorization")
    @Operation(summary="getEngineActionsByName", description="Retrieve the list of engine action metadata elements with a matching qualified or display name. There are no wildcards supported on this request.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/engine-action"))
    public EngineActionElementsResponse getEngineActionsByName(@PathVariable String serverName, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody FilterRequestBody requestBody) {
        return this.restAPI.getEngineActionsByName(serverName, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/metadata-elements/{openMetadataElementTypeName}/{openMetadataElementGUID}/external-identifiers/add"})
    @SecurityRequirement(name="BearerAuthorization")
    @Operation(summary="addExternalIdentifier", description="Add the description of a specific external identifier and link it to the associated metadata element.  Note, the external identifier is anchored to the scope (specified in the request body).", externalDocs=@ExternalDocumentation(description="External Identifiers", url="https://egeria-project.org/types/0/0017-External-Identifiers/"))
    public VoidResponse addExternalIdentifier(@PathVariable String serverName, @PathVariable String openMetadataElementGUID, @PathVariable String openMetadataElementTypeName, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody UpdateMetadataCorrelatorsRequestBody requestBody) {
        return this.restAPI.addExternalIdentifier(serverName, openMetadataElementGUID, openMetadataElementTypeName, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/metadata-elements/{openMetadataElementTypeName}/{openMetadataElementGUID}/external-identifiers/update"})
    @SecurityRequirement(name="BearerAuthorization")
    @Operation(summary="updateExternalIdentifier", description="Update the description of a specific external identifier.", externalDocs=@ExternalDocumentation(description="External Identifiers", url="https://egeria-project.org/types/0/0017-External-Identifiers/"))
    public VoidResponse updateExternalIdentifier(@PathVariable String serverName, @PathVariable String openMetadataElementGUID, @PathVariable String openMetadataElementTypeName, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody UpdateMetadataCorrelatorsRequestBody requestBody) {
        return this.restAPI.updateExternalIdentifier(serverName, openMetadataElementGUID, openMetadataElementTypeName, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/metadata-elements/{openMetadataElementTypeName}/{openMetadataElementGUID}/external-identifiers/validate"})
    @SecurityRequirement(name="BearerAuthorization")
    @Operation(summary="validateExternalIdentifier", description="Validate that the external identifier is linked to the open metadata GUID.", externalDocs=@ExternalDocumentation(description="External Identifiers", url="https://egeria-project.org/types/0/0017-External-Identifiers/"))
    public BooleanResponse validateExternalIdentifier(@PathVariable String serverName, @PathVariable String openMetadataElementGUID, @PathVariable String openMetadataElementTypeName, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody UpdateMetadataCorrelatorsRequestBody requestBody) {
        return this.restAPI.validateExternalIdentifier(serverName, openMetadataElementGUID, openMetadataElementTypeName, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/metadata-elements/{openMetadataElementTypeName}/{openMetadataElementGUID}/external-identifiers/remove"})
    @SecurityRequirement(name="BearerAuthorization")
    @Operation(summary="removeExternalIdentifier", description="Remove an external identifier from an existing open metadata element.  The open metadata element is not affected.", externalDocs=@ExternalDocumentation(description="External Identifiers", url="https://egeria-project.org/types/0/0017-External-Identifiers/"))
    public VoidResponse removeExternalIdentifier(@PathVariable String serverName, @PathVariable String openMetadataElementGUID, @PathVariable String openMetadataElementTypeName, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody UpdateMetadataCorrelatorsRequestBody requestBody) {
        return this.restAPI.removeExternalIdentifier(serverName, openMetadataElementGUID, openMetadataElementTypeName, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/external-scope/{externalScopeGUID}/remove"})
    @SecurityRequirement(name="BearerAuthorization")
    @Operation(summary="removeExternalScope", description="Remove the scope associated with a collection of external identifiers.  All associated external identifiers are removed too.  The linked open metadata elements are not affected.", externalDocs=@ExternalDocumentation(description="External Identifiers", url="https://egeria-project.org/types/0/0017-External-Identifiers/"))
    public VoidResponse removeExternalScope(@PathVariable String serverName, @PathVariable String externalScopeGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeRequestBody requestBody) {
        return this.restAPI.removeExternalScope(serverName, externalScopeGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/metadata-elements/{openMetadataElementTypeName}/{openMetadataElementGUID}/synchronized"})
    @SecurityRequirement(name="BearerAuthorization")
    @Operation(summary="confirmSynchronization", description="Confirm that the values of a particular metadata element have been synchronized.  This is important from an audit point of view, and to allow bidirectional updates of metadata using optimistic locking.", externalDocs=@ExternalDocumentation(description="External Identifiers", url="https://egeria-project.org/types/0/0017-External-Identifiers/"))
    public VoidResponse confirmSynchronization(@PathVariable String serverName, @PathVariable String openMetadataElementGUID, @PathVariable String openMetadataElementTypeName, @RequestBody MetadataCorrelationProperties requestBody) {
        return this.restAPI.confirmSynchronization(serverName, openMetadataElementGUID, openMetadataElementTypeName, requestBody);
    }

    @PostMapping(path={"/external-identifiers/open-metadata-elements"})
    @SecurityRequirement(name="BearerAuthorization")
    @Operation(summary="getElementsForExternalIdentifier", description="Retrieve the metadata element associated with a particular external identifier.", externalDocs=@ExternalDocumentation(description="External Identifiers", url="https://egeria-project.org/types/0/0017-External-Identifiers/"))
    public ElementHeadersResponse getElementsForExternalIdentifier(@PathVariable String serverName, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody UpdateMetadataCorrelatorsRequestBody requestBody) {
        return this.restAPI.getElementsForExternalIdentifier(serverName, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/metadata-elements/{openMetadataElementTypeName}/{openMetadataElementGUID}/external-identifiers"})
    @SecurityRequirement(name="BearerAuthorization")
    @Operation(summary="getExternalIdentifiers", description="Retrieve the external identifiers attached to the supplied element guid.", externalDocs=@ExternalDocumentation(description="External Identifiers", url="https://egeria-project.org/types/0/0017-External-Identifiers/"))
    public MetadataCorrelationHeadersResponse getExternalIdentifiers(@PathVariable String serverName, @PathVariable String openMetadataElementGUID, @PathVariable String openMetadataElementTypeName, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getExternalIdentifiers(serverName, openMetadataElementGUID, openMetadataElementTypeName, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }
}

