/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.basicfile.ffdc;

import java.text.MessageFormat;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum BasicFileConnectorErrorCode {
    FILE_NOT_SPECIFIED(400, "BASIC-FILE-CONNECTOR-400-001 ", "The file name is null in the Connection object {0}", "The connector is unable to open the structure file because the name of the file is not passed in the Connection object.", "The name of the file should be set up in the address property of the connection's Endpoint object."),
    DIRECTORY_SPECIFIED(400, "BASIC-FILE-CONNECTOR-400-002 ", "The file {0} given in Connection object {1} is a directory", "The connector is unable to work with a directory.", "Ensure a valid file name is passed in the address property in the Endpoint object of the Connection object."),
    FILE_NOT_READABLE(400, "BASIC-FILE-CONNECTOR-400-003 ", "The file {0} given in Connection object {1} is not readable", "The connector is unable to open the file.", "Ensure a valid file name is passed in the address property in the Endpoint object of the Connection object."),
    FILE_NOT_FOUND(404, "BASIC-FILE-CONNECTOR-404-001 ", "The file named {0} in the Connection object {1} does not exist", "The connector is unable to open the file.", "Add then name of an existing file to the address property of the connection's Endpoint object."),
    UNEXPECTED_SECURITY_EXCEPTION(500, "BASIC-FILE-CONNECTOR-500-001 ", "The connector received an unexpected security exception when reading the file named {0}; the error message was: {1}", "The connector is unable to process the file.", "Use details from the error message to determine the cause of the error and retry the request once it is resolved."),
    UNEXPECTED_IO_EXCEPTION(500, "BASIC-FILE-CONNECTOR-500-002 ", "The connector received an unexpected IO exception when reading the file named {0}; the error message was: {1}", "The connector is unable to process the file.", "Use details from the error message to determine the cause of the error and retry the request once it is resolved.");

    private int httpErrorCode;
    private String errorMessageId;
    private String errorMessage;
    private String systemAction;
    private String userAction;
    private static final Logger log;

    private BasicFileConnectorErrorCode(int newHTTPErrorCode, String newErrorMessageId, String newErrorMessage, String newSystemAction, String newUserAction) {
        this.httpErrorCode = newHTTPErrorCode;
        this.errorMessageId = newErrorMessageId;
        this.errorMessage = newErrorMessage;
        this.systemAction = newSystemAction;
        this.userAction = newUserAction;
    }

    public int getHTTPErrorCode() {
        return this.httpErrorCode;
    }

    public String getErrorMessageId() {
        return this.errorMessageId;
    }

    public String getUnformattedErrorMessage() {
        return this.errorMessage;
    }

    public String getFormattedErrorMessage(String ... params) {
        log.debug(String.format("<== BasicFileConnectorErrorCode.getMessage(%s)", Arrays.toString(params)));
        MessageFormat mf = new MessageFormat(this.errorMessage);
        String result = mf.format(params);
        log.debug(String.format("==> BasicFileConnectorErrorCode.getMessage(%s): %s", Arrays.toString(params), result));
        return result;
    }

    public String getSystemAction() {
        return this.systemAction;
    }

    public String getUserAction() {
        return this.userAction;
    }

    public String toString() {
        return "BasicFileConnectorErrorCode{httpErrorCode=" + this.httpErrorCode + ", errorMessageId='" + this.errorMessageId + '\'' + ", errorMessage='" + this.errorMessage + '\'' + ", systemAction='" + this.systemAction + '\'' + ", userAction='" + this.userAction + '\'' + '}';
    }

    static {
        log = LoggerFactory.getLogger(BasicFileConnectorErrorCode.class);
    }
}

