/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.datastore.basicfile;

import java.io.File;
import org.odpi.openmetadata.adapters.connectors.datastore.basicfile.BasicFileStore;
import org.odpi.openmetadata.adapters.connectors.datastore.basicfile.ffdc.BasicFileConnectorErrorCode;
import org.odpi.openmetadata.adapters.connectors.datastore.basicfile.ffdc.exception.FileException;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBase;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicFileStoreConnector
extends ConnectorBase
implements BasicFileStore {
    protected String fileStoreName = null;
    private static final Logger log = LoggerFactory.getLogger(BasicFileStoreConnector.class);

    public void initialize(String connectorInstanceId, ConnectionProperties connectionProperties) {
        super.initialize(connectorInstanceId, connectionProperties);
        EndpointProperties endpoint = connectionProperties.getEndpoint();
        if (endpoint != null) {
            this.fileStoreName = endpoint.getAddress();
        } else {
            log.error("Null endpoint");
        }
    }

    private void throwException(BasicFileConnectorErrorCode errorCode, String methodName, String fileStoreName, Throwable caughtException) throws FileException {
        ExceptionMessageDefinition messageDefinition = fileStoreName == null ? errorCode.getMessageDefinition(this.connectionBean.getQualifiedName()) : errorCode.getMessageDefinition(fileStoreName, this.connectionBean.getQualifiedName());
        if (caughtException == null) {
            throw new FileException(messageDefinition, this.getClass().getName(), methodName, fileStoreName);
        }
        throw new FileException(messageDefinition, this.getClass().getName(), methodName, caughtException, fileStoreName);
    }

    @Override
    public File getFile() throws FileException {
        String methodName = "getFile";
        return this.getFile("getFile");
    }

    protected File getFile(String methodName) throws FileException {
        try {
            File fileStore;
            if (this.fileStoreName == null) {
                this.throwException(BasicFileConnectorErrorCode.FILE_NOT_SPECIFIED, methodName, null, null);
            }
            if (!(fileStore = new File(this.fileStoreName)).exists()) {
                this.throwException(BasicFileConnectorErrorCode.FILE_NOT_FOUND, methodName, this.fileStoreName, null);
            }
            if (fileStore.isDirectory()) {
                this.throwException(BasicFileConnectorErrorCode.DIRECTORY_SPECIFIED, methodName, this.fileStoreName, null);
            }
            if (!fileStore.canRead()) {
                this.throwException(BasicFileConnectorErrorCode.FILE_NOT_READABLE, methodName, this.fileStoreName, null);
            }
            return fileStore;
        }
        catch (FileException error) {
            log.debug("Throwing error " + ((Object)((Object)error)).getClass().getSimpleName() + " with message " + error.getMessage());
            throw error;
        }
        catch (SecurityException error) {
            this.throwException(BasicFileConnectorErrorCode.UNEXPECTED_SECURITY_EXCEPTION, methodName, this.fileStoreName, error);
        }
        catch (Throwable error) {
            this.throwException(BasicFileConnectorErrorCode.UNEXPECTED_IO_EXCEPTION, methodName, this.fileStoreName, error);
        }
        return null;
    }

    public void disconnect() {
        try {
            super.disconnect();
        }
        catch (Throwable exec) {
            log.debug("Ignoring unexpected exception " + exec.getClass().getSimpleName() + " with message " + exec.getMessage());
        }
        log.debug("Closing File");
    }
}

