/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.datastore.basicfile.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageSet;

public enum BasicFileConnectorErrorCode implements ExceptionMessageSet
{
    FILE_NOT_SPECIFIED(400, "BASIC-FILE-CONNECTOR-400-001", "The file name is null in the Connection object {0}", "The connector is unable to open the file because the name of the file is not passed in the Connection object.", "The name of the file should be set up in the address property of the connection's Endpoint object."),
    DIRECTORY_SPECIFIED(400, "BASIC-FILE-CONNECTOR-400-002", "The file {0} given in Connection object {1} is a directory", "The connector is unable to work with a directory.", "Ensure a valid file name is passed in the address property in the Endpoint object of the Connection object."),
    FILE_NOT_READABLE(400, "BASIC-FILE-CONNECTOR-400-003", "The file {0} given in Connection object {1} is not readable", "The connector is unable to open the file because it does not have sufficient permission.", "Ensure the name of a readable file is passed in the address property in the Endpoint object of the Connection object."),
    FILE_NOT_FOUND(404, "BASIC-FILE-CONNECTOR-404-001", "The file named {0} in the Connection object {1} does not exist", "The connector is unable to locate the file it has been asked to work with.", "Ensure that the name of the file in the address property of the connection's Endpoint object matches the location of the file that the connector is to access."),
    UNEXPECTED_SECURITY_EXCEPTION(500, "BASIC-FILE-CONNECTOR-500-001", "The connector received an unexpected security exception when reading the file named {0}; the error message was: {1}", "The connector is unable to access the file.", "Use details from the error message to determine the cause of the error and retry the request once it is resolved."),
    UNEXPECTED_IO_EXCEPTION(500, "BASIC-FILE-CONNECTOR-500-002", "The connector received an unexpected IO exception when reading the file named {0}; the error message was: {1}", "The connector is unable to process the file.", "Use the details from the error message to determine the cause of the error and retry the request once it is resolved.");

    private ExceptionMessageDefinition messageDefinition;

    private BasicFileConnectorErrorCode(int httpErrorCode, String errorMessageId, String errorMessage, String systemAction, String userAction) {
        this.messageDefinition = new ExceptionMessageDefinition(httpErrorCode, errorMessageId, errorMessage, systemAction, userAction);
    }

    public ExceptionMessageDefinition getMessageDefinition() {
        return this.messageDefinition;
    }

    public ExceptionMessageDefinition getMessageDefinition(String ... params) {
        this.messageDefinition.setMessageParameters(params);
        return this.messageDefinition;
    }

    public String toString() {
        return "BasicFileConnectorErrorCode{messageDefinition=" + this.messageDefinition + '}';
    }
}

