/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.datastore.basicfile;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;
import org.odpi.openmetadata.adapters.connectors.datastore.basicfile.BasicFileStore;
import org.odpi.openmetadata.adapters.connectors.datastore.basicfile.ffdc.BasicFileConnectorErrorCode;
import org.odpi.openmetadata.adapters.connectors.datastore.basicfile.ffdc.exception.FileException;
import org.odpi.openmetadata.adapters.connectors.datastore.basicfile.ffdc.exception.FileReadException;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBase;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicFolderConnector
extends ConnectorBase
implements BasicFileStore {
    protected String folderName = null;
    private static final Logger log = LoggerFactory.getLogger(BasicFolderConnector.class);

    public void initialize(String connectorInstanceId, ConnectionProperties connectionProperties) {
        super.initialize(connectorInstanceId, connectionProperties);
        EndpointProperties endpoint = connectionProperties.getEndpoint();
        if (endpoint != null) {
            if (endpoint.getAddress() == null) {
                log.error("Null endpoint address");
            } else {
                this.folderName = endpoint.getAddress().startsWith("file://") ? endpoint.getAddress().substring(7) : endpoint.getAddress();
            }
        } else {
            log.error("Null endpoint");
        }
    }

    @Override
    public String getFileName() throws FileException {
        String methodName = "getFileName";
        this.getFile("getFileName");
        return this.folderName;
    }

    @Override
    public long getFileLength() throws FileException {
        String methodName = "getFileLength";
        File file = this.getFile("getFileLength");
        return file.length();
    }

    @Override
    public Date getCreationDate() throws FileException, FileReadException {
        String methodName = "getCreationDate";
        File fileStore = this.getFile("getCreationDate");
        try {
            BasicFileAttributes attr = Files.readAttributes(fileStore.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            return new Date(attr.creationTime().toMillis());
        }
        catch (IOException ioException) {
            throw new FileReadException(BasicFileConnectorErrorCode.UNEXPECTED_IO_EXCEPTION.getMessageDefinition(this.folderName, ioException.getMessage()), this.getClass().getName(), "getCreationDate", ioException, this.folderName);
        }
    }

    @Override
    public Date getLastUpdateDate() throws FileException, FileReadException {
        String methodName = "getLastUpdateDate";
        File fileStore = this.getFile("getLastUpdateDate");
        try {
            BasicFileAttributes attr = Files.readAttributes(fileStore.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            return new Date(attr.lastModifiedTime().toMillis());
        }
        catch (IOException ioException) {
            throw new FileReadException(BasicFileConnectorErrorCode.UNEXPECTED_IO_EXCEPTION.getMessageDefinition(this.folderName, ioException.getMessage()), this.getClass().getName(), "getLastUpdateDate", ioException, this.folderName);
        }
    }

    @Override
    public Date getLastAccessDate() throws FileException, FileReadException {
        String methodName = "getLastAccessedDate";
        File fileStore = this.getFile("getLastAccessedDate");
        try {
            BasicFileAttributes attr = Files.readAttributes(fileStore.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            return new Date(attr.lastAccessTime().toMillis());
        }
        catch (IOException ioException) {
            throw new FileReadException(BasicFileConnectorErrorCode.UNEXPECTED_IO_EXCEPTION.getMessageDefinition(this.folderName, ioException.getMessage()), this.getClass().getName(), "getLastAccessedDate", ioException, this.folderName);
        }
    }

    private void throwException(BasicFileConnectorErrorCode errorCode, String methodName, String fileStoreName, Exception caughtException) throws FileException {
        ExceptionMessageDefinition messageDefinition = fileStoreName == null ? errorCode.getMessageDefinition(this.connectionBean.getQualifiedName()) : errorCode.getMessageDefinition(fileStoreName, this.connectionBean.getQualifiedName());
        if (caughtException == null) {
            throw new FileException(messageDefinition, this.getClass().getName(), methodName, fileStoreName);
        }
        throw new FileException(messageDefinition, this.getClass().getName(), methodName, caughtException, fileStoreName);
    }

    @Override
    public File getFile() throws FileException {
        String methodName = "getFile";
        return this.getFile("getFile");
    }

    protected File getFile(String methodName) throws FileException {
        try {
            File fileStore;
            if (this.folderName == null) {
                this.throwException(BasicFileConnectorErrorCode.FOLDER_NOT_SPECIFIED, methodName, null, null);
            }
            if (this.folderName.startsWith("file://")) {
                this.folderName = this.folderName.substring(7);
            }
            if (!(fileStore = new File(this.folderName)).exists()) {
                this.throwException(BasicFileConnectorErrorCode.FOLDER_NOT_FOUND, methodName, this.folderName, null);
            }
            if (!fileStore.isDirectory()) {
                this.throwException(BasicFileConnectorErrorCode.FILE_NOT_DIRECTORY, methodName, this.folderName, null);
            }
            if (!fileStore.canRead()) {
                this.throwException(BasicFileConnectorErrorCode.FOLDER_NOT_READABLE, methodName, this.folderName, null);
            }
            return fileStore;
        }
        catch (FileException error) {
            log.debug("Throwing error " + ((Object)((Object)error)).getClass().getSimpleName() + " with message " + error.getMessage());
            throw error;
        }
        catch (SecurityException error) {
            this.throwException(BasicFileConnectorErrorCode.UNEXPECTED_SECURITY_EXCEPTION, methodName, this.folderName, error);
        }
        catch (Exception error) {
            this.throwException(BasicFileConnectorErrorCode.UNEXPECTED_IO_EXCEPTION, methodName, this.folderName, error);
        }
        return null;
    }

    public void disconnect() {
        try {
            super.disconnect();
        }
        catch (Exception exec) {
            log.debug("Ignoring unexpected exception " + exec.getClass().getSimpleName() + " with message " + exec.getMessage());
        }
        log.debug("Closing File");
    }
}

