/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.datastore.basicfile.ffdc.exception;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;

public class FileException
extends ConnectorCheckedException {
    private static final long serialVersionUID = 1L;
    private final String fileName;

    public FileException(ExceptionMessageDefinition messageDefinition, String className, String actionDescription, String fileName) {
        super(messageDefinition, className, actionDescription);
        this.fileName = fileName;
    }

    public FileException(ExceptionMessageDefinition messageDefinition, String className, String actionDescription, String fileName, Map<String, Object> relatedProperties) {
        super(messageDefinition, className, actionDescription, relatedProperties);
        this.fileName = fileName;
    }

    public FileException(ExceptionMessageDefinition messageDefinition, String className, String actionDescription, Exception caughtError, String fileName) {
        super(messageDefinition, className, actionDescription, (Throwable)caughtError);
        this.fileName = fileName;
    }

    public FileException(ExceptionMessageDefinition messageDefinition, String className, String actionDescription, Exception caughtError, String fileName, Map<String, Object> relatedProperties) {
        super(messageDefinition, className, actionDescription, (Throwable)caughtError, relatedProperties);
        this.fileName = fileName;
    }

    public FileException(int httpCode, String className, String actionDescription, String errorMessage, String errorMessageId, String[] errorMessageParameters, String systemAction, String userAction, String caughtErrorClassName, String fileName, Map<String, Object> relatedProperties) {
        super(httpCode, className, actionDescription, errorMessage, errorMessageId, errorMessageParameters, systemAction, userAction, caughtErrorClassName, relatedProperties);
        this.fileName = fileName;
    }

    @Deprecated
    public FileException(int httpCode, String className, String actionDescription, String errorMessage, String systemAction, String userAction, String fileName) {
        super(httpCode, className, actionDescription, errorMessage, systemAction, userAction);
        this.fileName = fileName;
    }

    @Deprecated
    public FileException(int httpCode, String className, String actionDescription, String errorMessage, String systemAction, String userAction, Exception caughtError, String fileName) {
        super(httpCode, className, actionDescription, errorMessage, systemAction, userAction, (Throwable)caughtError);
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String toString() {
        return "FileException{fileName='" + this.fileName + "', reportedHTTPCode=" + this.getReportedHTTPCode() + ", reportingClassName='" + this.getReportingClassName() + "', reportingActionDescription='" + this.getReportingActionDescription() + "', errorMessage='" + this.getReportedErrorMessage() + "', reportedErrorMessageId='" + this.getReportedErrorMessageId() + "', reportedErrorMessageParameters=" + Arrays.toString(this.getReportedErrorMessageParameters()) + ", reportedSystemAction='" + this.getReportedSystemAction() + "', reportedUserAction='" + this.getReportedUserAction() + "', reportedCaughtException=" + this.getReportedCaughtException() + ", relatedProperties=" + this.getRelatedProperties() + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof FileException)) {
            return false;
        }
        FileException that = (FileException)((Object)objectToCompare);
        if (!super.equals(objectToCompare)) {
            return false;
        }
        return Objects.equals(this.getFileName(), that.getFileName());
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getFileName());
    }
}

