/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLoggingComponent;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorProvider;
import org.odpi.openmetadata.frameworks.connectors.SecretsStoreConnector;
import org.odpi.openmetadata.frameworks.connectors.SecureConnectorExtension;
import org.odpi.openmetadata.frameworks.connectors.VirtualConnectorExtension;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFErrorCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFRuntimeException;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectorTypeProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.EmbeddedConnectionProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.VirtualConnectionProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.VirtualConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorBroker {
    private static final Logger log = LoggerFactory.getLogger(ConnectorBroker.class);
    private static final String userIdPropertyName = "userId";
    private static final String clearPasswordPropertyName = "clearPassword";
    private static final String encryptedPasswordPropertyName = "encryptedPassword";
    private AuditLog auditLog = null;

    public ConnectorBroker() {
    }

    public ConnectorBroker(AuditLog auditLog) {
        this.auditLog = auditLog;
    }

    private void validateConnectionNotNull(ConnectionProperties connection) throws ConnectionCheckedException {
        VirtualConnectionProperties virtualConnection;
        List<EmbeddedConnectionProperties> embeddedConnections;
        String methodName = "validateConnectionNotNull";
        if (connection == null) {
            throw new ConnectionCheckedException(OCFErrorCode.NULL_CONNECTION.getMessageDefinition(), this.getClass().getName(), "validateConnectionNotNull");
        }
        if (connection instanceof VirtualConnectionProperties && ((embeddedConnections = (virtualConnection = (VirtualConnectionProperties)connection).getEmbeddedConnections()) == null || embeddedConnections.isEmpty())) {
            throw new ConnectionCheckedException(OCFErrorCode.INVALID_VIRTUAL_CONNECTION.getMessageDefinition(connection.getConnectionName()), this.getClass().getName(), "validateConnectionNotNull");
        }
    }

    private ConnectorTypeProperties getConnectorType(ConnectionProperties connection, String methodName) throws ConnectionCheckedException {
        ConnectorTypeProperties requestedConnectorType = connection.getConnectorType();
        if (requestedConnectorType == null) {
            throw new ConnectionCheckedException(OCFErrorCode.NULL_CONNECTOR_TYPE.getMessageDefinition(connection.getConnectionName()), this.getClass().getName(), methodName);
        }
        return requestedConnectorType;
    }

    private ConnectorProvider getConnectorProvider(ConnectorTypeProperties requestedConnectorType, String connectionName, String methodName) throws ConnectionCheckedException {
        ConnectorProvider connectorProvider;
        String connectorProviderClassName = requestedConnectorType.getConnectorProviderClassName();
        if (connectorProviderClassName == null) {
            throw new ConnectionCheckedException(OCFErrorCode.NULL_CONNECTOR_PROVIDER.getMessageDefinition(connectionName), this.getClass().getName(), methodName);
        }
        try {
            Class<?> connectorProviderClass = Class.forName(connectorProviderClassName);
            Object potentialConnectorProvider = connectorProviderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            connectorProvider = (ConnectorProvider)potentialConnectorProvider;
        }
        catch (ClassNotFoundException classException) {
            throw new ConnectionCheckedException(OCFErrorCode.UNKNOWN_CONNECTOR_PROVIDER.getMessageDefinition(connectorProviderClassName, connectionName), this.getClass().getName(), methodName, classException);
        }
        catch (ClassCastException castException) {
            throw new ConnectionCheckedException(OCFErrorCode.NOT_CONNECTOR_PROVIDER.getMessageDefinition(connectorProviderClassName, connectionName), this.getClass().getName(), methodName, castException);
        }
        catch (Exception unexpectedSomething) {
            throw new ConnectionCheckedException(OCFErrorCode.INVALID_CONNECTOR_PROVIDER.getMessageDefinition(connectorProviderClassName, connectionName, unexpectedSomething.getClass().getName(), unexpectedSomething.getMessage()), this.getClass().getName(), methodName, unexpectedSomething);
        }
        return connectorProvider;
    }

    private ConnectionProperties getConnection(EmbeddedConnectionProperties embeddedConnection) {
        ConnectionProperties connection = null;
        if (embeddedConnection != null) {
            AccessibleConnection accessibleConnection = new AccessibleConnection(embeddedConnection.getConnectionProperties());
            Connection connectionBean = accessibleConnection.getConnectionBean();
            Map<String, Object> arguments = embeddedConnection.getArguments();
            if (arguments != null) {
                Map<String, Object> configurationProperties = connectionBean.getConfigurationProperties();
                if (configurationProperties == null) {
                    configurationProperties = new HashMap<String, Object>();
                }
                for (String argumentName : arguments.keySet()) {
                    configurationProperties.put(argumentName, arguments.get(argumentName).toString());
                }
                if (configurationProperties.isEmpty()) {
                    configurationProperties = null;
                }
                connectionBean.setConfigurationProperties(configurationProperties);
            }
            connection = new ConnectionProperties(connectionBean);
        }
        return connection;
    }

    public void validateConnection(Connection connection) throws ConnectionCheckedException {
        if (connection == null) {
            this.validateConnection((ConnectionProperties)null);
        } else {
            this.validateConnection(new ConnectionProperties(connection));
        }
    }

    public void validateConnection(ConnectionProperties connection) throws ConnectionCheckedException {
        String methodName = "validateConnection";
        log.debug("==> ConnectorBroker.validateConnection");
        this.validateConnectionNotNull(connection);
        ConnectorTypeProperties requestedConnectorType = this.getConnectorType(connection, "validateConnection");
        this.getConnectorProvider(requestedConnectorType, connection.getConnectionName(), "validateConnection");
        log.debug("<== ConnectorBroker.validateConnection");
    }

    public Connector getConnector(Connection connection) throws ConnectionCheckedException, ConnectorCheckedException {
        if (connection == null) {
            return this.getConnector((ConnectionProperties)null);
        }
        if (connection instanceof VirtualConnection) {
            return this.getConnector(new VirtualConnectionProperties((VirtualConnection)connection));
        }
        return this.getConnector(new ConnectionProperties(connection));
    }

    public Connector getConnector(ConnectionProperties connection) throws ConnectionCheckedException, ConnectorCheckedException {
        Connector connectorInstance;
        String methodName = "getConnector";
        log.debug("==> ConnectorBroker.getConnector");
        this.validateConnection(connection);
        String connectionName = connection.getConnectionName();
        ConnectorTypeProperties requestedConnectorType = this.getConnectorType(connection, "getConnector");
        ConnectorProvider connectorProvider = this.getConnectorProvider(requestedConnectorType, connectionName, "getConnector");
        if (connectorProvider instanceof AuditLoggingComponent) {
            ((AuditLoggingComponent)((Object)connectorProvider)).setAuditLog(this.auditLog);
        }
        try {
            connectorInstance = connectorProvider.getConnector(connection);
        }
        catch (ConnectionCheckedException | ConnectorCheckedException ocfError) {
            throw ocfError;
        }
        catch (Exception unexpectedSomething) {
            throw new ConnectorCheckedException(OCFErrorCode.CAUGHT_EXCEPTION.getMessageDefinition(), this.getClass().getName(), "getConnector", unexpectedSomething);
        }
        if (connectorInstance == null) {
            throw new OCFRuntimeException(OCFErrorCode.NULL_CONNECTOR.getMessageDefinition(requestedConnectorType.getConnectorProviderClassName(), connection.getConnectionName()), this.getClass().getName(), "getConnector");
        }
        if (connection instanceof VirtualConnectionProperties) {
            VirtualConnectionProperties virtualConnectionProperties = (VirtualConnectionProperties)connection;
            if (connectorInstance instanceof VirtualConnectorExtension) {
                VirtualConnectorExtension virtualConnectorExtension = (VirtualConnectorExtension)((Object)connectorInstance);
                AccessibleConnection accessibleConnection = new AccessibleConnection(connection);
                Connection connectionBean = accessibleConnection.getConnectionBean();
                log.debug("Creating embedded connectors for connection name: " + connectionName + "; connectorId: " + connectorInstance.getConnectorInstanceId());
                List<EmbeddedConnectionProperties> embeddedConnections = virtualConnectionProperties.getEmbeddedConnections();
                ArrayList<Connector> embeddedConnectors = new ArrayList<Connector>();
                for (EmbeddedConnectionProperties embeddedConnection : embeddedConnections) {
                    Connector embeddedConnector = this.getConnector(this.getConnection(embeddedConnection));
                    if (embeddedConnector instanceof SecretsStoreConnector) {
                        SecretsStoreConnector secretsStoreConnector = (SecretsStoreConnector)embeddedConnector;
                        if (connectionBean.getUserId() == null) {
                            connectionBean.setUserId(secretsStoreConnector.getSecret(userIdPropertyName));
                            if (connectionBean.getUserId() == null && connection.getSecuredProperties() != null && connection.getSecuredProperties().get(userIdPropertyName) != null) {
                                connectionBean.setUserId(secretsStoreConnector.getSecret(connection.getSecuredProperties().get(userIdPropertyName)));
                            }
                        }
                        if (connection.getClearPassword() == null) {
                            connectionBean.setClearPassword(secretsStoreConnector.getSecret(clearPasswordPropertyName));
                            if (connectionBean.getClearPassword() == null && connection.getSecuredProperties() != null && connection.getSecuredProperties().get(clearPasswordPropertyName) != null) {
                                connectionBean.setClearPassword(secretsStoreConnector.getSecret(connection.getSecuredProperties().get(clearPasswordPropertyName)));
                            }
                        }
                        if (connection.getEncryptedPassword() == null) {
                            connectionBean.setEncryptedPassword(secretsStoreConnector.getSecret(encryptedPasswordPropertyName));
                            if (connectionBean.getEncryptedPassword() == null && connection.getSecuredProperties() != null && connection.getSecuredProperties().get(encryptedPasswordPropertyName) != null) {
                                connectionBean.setEncryptedPassword(secretsStoreConnector.getSecret(connection.getSecuredProperties().get(encryptedPasswordPropertyName)));
                            }
                        }
                        if (connectorInstance instanceof SecureConnectorExtension) {
                            SecureConnectorExtension secureConnectorExtension = (SecureConnectorExtension)((Object)connectorInstance);
                            secureConnectorExtension.initializeSecretsStoreConnector(embeddedConnection.getDisplayName(), secretsStoreConnector);
                        }
                    }
                    embeddedConnectors.add(embeddedConnector);
                }
                virtualConnectorExtension.initializeEmbeddedConnectors(embeddedConnectors);
            } else {
                throw new OCFRuntimeException(OCFErrorCode.NOT_VIRTUAL_CONNECTOR.getMessageDefinition(requestedConnectorType.getConnectorProviderClassName(), connection.getConnectionName()), this.getClass().getName(), "getConnector");
            }
        }
        log.debug("New connector returned: " + connectorInstance.getConnectorInstanceId());
        log.debug("Using Connection: " + connectorInstance.getConnection().getQualifiedName() + "(" + connectorInstance.getConnection().getDisplayName() + ")");
        log.debug("<== ConnectorBroker.getConnector");
        return connectorInstance;
    }

    public String toString() {
        return "ConnectorBroker{}";
    }

    private static class AccessibleConnection
    extends ConnectionProperties {
        private static final long serialVersionUID = 1L;

        AccessibleConnection(ConnectionProperties templateConnection) {
            super(templateConnection);
        }

        @Override
        protected Connection getConnectionBean() {
            return super.getConnectionBean();
        }
    }
}

