/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties;

import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetDetail;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetFeedback;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetLineage;
import org.odpi.openmetadata.frameworks.connectors.properties.Certifications;
import org.odpi.openmetadata.frameworks.connectors.properties.Connections;
import org.odpi.openmetadata.frameworks.connectors.properties.ExternalIdentifiers;
import org.odpi.openmetadata.frameworks.connectors.properties.ExternalReferences;
import org.odpi.openmetadata.frameworks.connectors.properties.Licenses;
import org.odpi.openmetadata.frameworks.connectors.properties.Locations;
import org.odpi.openmetadata.frameworks.connectors.properties.NoteLogs;
import org.odpi.openmetadata.frameworks.connectors.properties.RelatedAssets;
import org.odpi.openmetadata.frameworks.connectors.properties.RelatedMediaReferences;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Asset;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Meaning;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaType;

public class AssetUniverse
extends AssetDetail {
    private static final long serialVersionUID = 1L;
    protected List<Meaning> meanings = null;
    protected AssetFeedback feedback = null;
    protected Locations knownLocations = null;
    protected AssetLineage lineage = null;
    protected RelatedAssets relatedAssets = null;

    protected AssetUniverse() {
    }

    public AssetUniverse(Asset assetBean, ExternalIdentifiers externalIdentifiers, RelatedMediaReferences relatedMediaReferences, NoteLogs noteLogs, ExternalReferences externalReferences, Connections connections, Licenses licenses, Certifications certifications, List<Meaning> meanings, SchemaType schema, AssetFeedback feedback, Locations knownLocations, AssetLineage lineage, RelatedAssets relatedAssets) {
        super(assetBean, externalIdentifiers, relatedMediaReferences, noteLogs, externalReferences, connections, licenses, certifications, schema);
        this.meanings = meanings;
        this.feedback = feedback;
        this.knownLocations = knownLocations;
        this.lineage = lineage;
        this.relatedAssets = relatedAssets;
    }

    public AssetUniverse(Asset assetBean) {
        super(assetBean);
    }

    public AssetUniverse(AssetUniverse template) {
        super(template);
        if (template != null) {
            this.meanings = template.getMeanings();
            AssetFeedback templateFeedback = template.getFeedback();
            Locations templateLocations = template.getKnownLocations();
            AssetLineage templateLineage = template.getLineage();
            RelatedAssets templateRelatedAssets = template.getRelatedAssets();
            if (templateFeedback != null) {
                this.feedback = new AssetFeedback(templateFeedback);
            }
            if (templateLocations != null) {
                this.knownLocations = templateLocations.cloneIterator();
            }
            if (templateLineage != null) {
                this.lineage = new AssetLineage(templateLineage);
            }
            if (templateRelatedAssets != null) {
                this.relatedAssets = templateRelatedAssets.cloneIterator();
            }
        }
    }

    @Override
    public List<Meaning> getMeanings() {
        if (this.meanings == null) {
            return null;
        }
        if (this.meanings.isEmpty()) {
            return null;
        }
        return this.meanings;
    }

    public AssetFeedback getFeedback() {
        if (this.feedback == null) {
            return null;
        }
        return new AssetFeedback(this.feedback);
    }

    public Locations getKnownLocations() {
        if (this.knownLocations == null) {
            return null;
        }
        return this.knownLocations.cloneIterator();
    }

    public AssetLineage getLineage() {
        if (this.lineage == null) {
            return null;
        }
        return new AssetLineage(this.lineage);
    }

    public RelatedAssets getRelatedAssets() {
        if (this.relatedAssets == null) {
            return null;
        }
        return this.relatedAssets.cloneIterator();
    }

    @Override
    public String toString() {
        return "AssetUniverse{externalIdentifiers=" + this.getExternalIdentifiers() + ", relatedMediaReferences=" + this.getRelatedMediaReferences() + ", noteLogs=" + this.getNoteLogs() + ", externalReferences=" + this.getExternalReferences() + ", connections=" + this.getConnections() + ", licenses=" + this.getLicenses() + ", certifications=" + this.getCertifications() + ", schema=" + this.getSchema() + ", meanings=" + this.meanings + ", feedback=" + this.feedback + ", knownLocations=" + this.knownLocations + ", lineage=" + this.lineage + ", relatedAssets=" + this.relatedAssets + ", name='" + this.getResourceName() + "', versionIdentifier='" + this.getVersionIdentifier() + "', displayName='" + this.getDisplayName() + "', shortDescription='" + this.getConnectionDescription() + "', description='" + this.getDisplayDescription() + "', ownerTypeName='" + this.getOwnerTypeName() + "', ownerPropertyName='" + this.getOwnerPropertyName() + "', ownerType=" + this.getOwnerType() + ", zoneMembership=" + this.getZoneMembership() + ", assetOrigin=" + this.getAssetOrigin() + ", referenceData=" + this.isReferenceData() + ", URL='" + this.getURL() + "', extendedProperties=" + this.getExtendedProperties() + ", status=" + this.getStatus() + ", type=" + this.getType() + ", origin=" + this.getOrigin() + ", versions=" + this.getVersions() + ", GUID='" + this.getGUID() + "', classifications=" + this.getClassifications() + ", searchKeywords=" + this.getSearchKeywords() + ", headerVersion=" + this.getHeaderVersion() + ", qualifiedName='" + this.getQualifiedName() + "', additionalProperties=" + this.getAdditionalProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AssetUniverse that = (AssetUniverse)objectToCompare;
        return Objects.equals(this.meanings, that.meanings) && Objects.equals(this.feedback, that.feedback) && Objects.equals(this.knownLocations, that.knownLocations) && Objects.equals(this.lineage, that.lineage) && Objects.equals(this.relatedAssets, that.relatedAssets);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.meanings, this.feedback, this.knownLocations, this.lineage, this.relatedAssets);
    }
}

