/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFErrorCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFRuntimeException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.PropertyIteratorBase;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementBase;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.PropertyBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagingIterator
extends PropertyBase
implements Iterator<ElementBase> {
    private static final long serialVersionUID = 1L;
    protected int maxCacheSize = 1;
    protected int totalElementCount = 0;
    protected int cachedElementStart = 0;
    protected List<ElementBase> cachedElementList = new ArrayList<ElementBase>();
    protected int cachedElementPointer = 0;
    protected PropertyIteratorBase iterator = null;
    protected static final Logger log = LoggerFactory.getLogger(PagingIterator.class);

    public PagingIterator(PropertyIteratorBase iterator, int totalElementCount, int maxCacheSize) {
        log.debug("New PagingIterator:");
        log.debug("==> totalElementCount: " + totalElementCount);
        log.debug("==> maxCacheSize: " + maxCacheSize);
        if (totalElementCount > 0) {
            this.totalElementCount = totalElementCount;
        }
        if (maxCacheSize > 0) {
            this.maxCacheSize = maxCacheSize;
        }
        if (iterator == null) {
            throw new OCFRuntimeException(OCFErrorCode.NO_ITERATOR.getMessageDefinition(this.getClass().getSimpleName()), this.getClass().getName(), "next");
        }
        this.iterator = iterator;
    }

    public PagingIterator(PropertyIteratorBase iterator, PagingIterator templateIterator) {
        super(templateIterator);
        if (templateIterator != null) {
            this.cachedElementStart = 0;
            this.cachedElementPointer = 0;
            this.cachedElementList = new ArrayList<ElementBase>();
            if (templateIterator.totalElementCount > 0) {
                this.totalElementCount = templateIterator.totalElementCount;
            }
            if (templateIterator.maxCacheSize > 0) {
                this.maxCacheSize = templateIterator.maxCacheSize;
            }
            if (iterator == null) {
                throw new OCFRuntimeException(OCFErrorCode.NO_ITERATOR.getMessageDefinition(this.getClass().getSimpleName()), this.getClass().getName(), "next");
            }
            this.iterator = iterator;
            if (templateIterator.cachedElementStart <= templateIterator.maxCacheSize) {
                for (ElementBase templateElement : templateIterator.cachedElementList) {
                    this.cachedElementList.add(iterator.cloneElement(templateElement));
                }
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.cachedElementStart < this.totalElementCount;
    }

    @Override
    public ElementBase next() {
        if (this.hasNext()) {
            if (this.cachedElementPointer == this.cachedElementList.size()) {
                try {
                    this.cachedElementList = this.iterator.getCachedList(this.cachedElementStart, this.maxCacheSize);
                    this.cachedElementPointer = 0;
                }
                catch (PropertyServerException error) {
                    throw new OCFRuntimeException(OCFErrorCode.PROPERTIES_NOT_AVAILABLE.getMessageDefinition(error.getReportedErrorMessage(), this.toString()), this.getClass().getName(), "next", error);
                }
            }
            ElementBase retrievedElement = this.iterator.cloneElement(this.cachedElementList.get(this.cachedElementPointer));
            ++this.cachedElementPointer;
            ++this.cachedElementStart;
            log.debug("Returning next element:");
            log.debug("==> totalElementCount: " + this.totalElementCount);
            log.debug("==> cachedElementPointer: " + this.cachedElementPointer);
            log.debug("==> cachedElementStart:" + this.cachedElementStart);
            log.debug("==> maxCacheSize:" + this.maxCacheSize);
            return retrievedElement;
        }
        throw new OCFRuntimeException(OCFErrorCode.NO_MORE_ELEMENTS.getMessageDefinition(this.getClass().getSimpleName()), this.getClass().getName(), "next");
    }

    public int getElementCount() {
        return this.totalElementCount;
    }

    @Override
    public void remove() {
        throw new OCFRuntimeException(OCFErrorCode.UNABLE_TO_REMOVE.getMessageDefinition(this.iterator.getClass().getName()), this.getClass().getName(), "remove");
    }

    public String toString() {
        return "PagingIterator{maxCacheSize=" + this.maxCacheSize + ", totalElementCount=" + this.totalElementCount + ", cachedElementStart=" + this.cachedElementStart + ", cachedElementList=" + this.cachedElementList + ", cachedElementPointer=" + this.cachedElementPointer + "}";
    }
}

