/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive2_5;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumElementDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefStatus;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive2_6 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "2.6";
    private static final String originatorName = "ODPi Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private OMRSArchiveBuilder archiveBuilder;
    private OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive2_6() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive2_6(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive2_5 previousTypes = new OpenMetadataTypesArchive2_5(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.update0010ManagingMemento();
        this.update0215MoreProcessTypes();
        this.update0422GovernanceActionClassifications();
        this.update0445GovernanceRoles();
        this.update0460GovernanceExecutionPoints();
        this.add0461GovernanceActionEngines();
        this.add0462GovernanceActionTypes();
        this.add0463GovernanceActions();
        this.add0465DuplicateProcessing();
        this.add0470IncidentReports();
        this.add0550InstanceMetadata();
        this.update06xxDiscoveryEnginesAndServices();
    }

    private void update0010ManagingMemento() {
        this.archiveBuilder.addClassificationDef(this.addMementoClassification());
    }

    private ClassificationDef addMementoClassification() {
        String guid = "ecdcd472-6701-4303-8dec-267bcb54feb9";
        String name = "Memento";
        String description = "An element whose real-world counterpart has been deleted or moved to offline archived.";
        String descriptionGUID = null;
        String linkedToEntity = "OpenMetadataRoot";
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("ecdcd472-6701-4303-8dec-267bcb54feb9", "Memento", null, "An element whose real-world counterpart has been deleted or moved to offline archived.", descriptionGUID, this.archiveBuilder.getEntityDef("OpenMetadataRoot"), true);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "archiveDate";
        String attribute1Description = "Timestamp when the archive occurred or was detected.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "archiveUser";
        String attribute2Description = "Name of user that performed the archive - or detected the archive.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "archiveProcess";
        String attribute3Description = "Name of process that performed the archive - or detected the archive.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "archiveService";
        String attribute4Description = "Name of service that created this classification.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "archiveMethod";
        String attribute5Description = "Name of method that created this classification.";
        String attribute5DescriptionGUID = null;
        String attribute6Name = "archiveProperties";
        String attribute6Description = "Properties to locate the real-world counterpart in the archive.";
        String attribute6DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getDateTypeDefAttribute("archiveDate", "Timestamp when the archive occurred or was detected.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("archiveUser", "Name of user that performed the archive - or detected the archive.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("archiveProcess", "Name of process that performed the archive - or detected the archive.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("archiveService", "Name of service that created this classification.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("archiveMethod", "Name of method that created this classification.", attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute("archiveProperties", "Properties to locate the real-world counterpart in the archive.", attribute6DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void update0215MoreProcessTypes() {
        this.archiveBuilder.addEntityDef(this.addEmbeddedProcessEntity());
        this.archiveBuilder.addEntityDef(this.addTransientEmbeddedProcessEntity());
    }

    private EntityDef addEmbeddedProcessEntity() {
        String guid = "8145967e-bb83-44b2-bc8c-68112c6a5a06";
        String name = "EmbeddedProcess";
        String description = "A child process.";
        String descriptionGUID = null;
        String superTypeName = "Process";
        return this.archiveHelper.getDefaultEntityDef("8145967e-bb83-44b2-bc8c-68112c6a5a06", "EmbeddedProcess", this.archiveBuilder.getEntityDef("Process"), "A child process.", descriptionGUID);
    }

    private EntityDef addTransientEmbeddedProcessEntity() {
        String guid = "9bd9d37a-b2ae-48ec-9776-080f667e91c5";
        String name = "TransientEmbeddedProcess";
        String description = "A child process that runs for a short period of time.";
        String descriptionGUID = null;
        String superTypeName = "EmbeddedProcess";
        return this.archiveHelper.getDefaultEntityDef("9bd9d37a-b2ae-48ec-9776-080f667e91c5", "TransientEmbeddedProcess", this.archiveBuilder.getEntityDef("EmbeddedProcess"), "A child process that runs for a short period of time.", descriptionGUID);
    }

    private void update0422GovernanceActionClassifications() {
        this.archiveBuilder.addEnumDef(this.getImpactSeverityEnum());
        this.archiveBuilder.addClassificationDef(this.addImpactClassification());
    }

    private EnumDef getImpactSeverityEnum() {
        String guid = "5b905856-90ec-4944-80c4-0d42bcad484a";
        String name = "ImpactSeverity";
        String description = "Defines the severity of the impact that a situation has.";
        String descriptionGUID = null;
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef("5b905856-90ec-4944-80c4-0d42bcad484a", "ImpactSeverity", "Defines the severity of the impact that a situation has.", descriptionGUID);
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        boolean element1Ordinal = false;
        String element1Value = "Unclassified";
        String element1Description = "There is no assessment of the impact's severity on this data.";
        String element1DescriptionGUID = null;
        EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(0, "Unclassified", "There is no assessment of the impact's severity on this data.", element1DescriptionGUID);
        elementDefs.add(elementDef);
        enumDef.setDefaultValue(elementDef);
        boolean element2Ordinal = true;
        String element2Value = "Low";
        String element2Description = "The impact is low.";
        String element2DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(1, "Low", "The impact is low.", element2DescriptionGUID);
        elementDefs.add(elementDef);
        int element3Ordinal = 2;
        String element3Value = "Medium";
        String element3Description = "The impact is medium.";
        String element3DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(2, "Medium", "The impact is medium.", element3DescriptionGUID);
        elementDefs.add(elementDef);
        int element4Ordinal = 3;
        String element4Value = "High";
        String element4Description = "The impact is high.";
        String element4DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(3, "High", "The impact is high.", element4DescriptionGUID);
        elementDefs.add(elementDef);
        int element99Ordinal = 99;
        String element99Value = "Other";
        String element99Description = "Another impact level.";
        String element99DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(99, "Other", "Another impact level.", element99DescriptionGUID);
        elementDefs.add(elementDef);
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private ClassificationDef addImpactClassification() {
        String guid = "3a6c4ba7-3cc5-48cd-8952-a50a92da016d";
        String name = "Impact";
        String description = "Defines the severity of a situation on the attach entity.";
        String descriptionGUID = null;
        String linkedToEntity = "Referenceable";
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("3a6c4ba7-3cc5-48cd-8952-a50a92da016d", "Impact", null, "Defines the severity of a situation on the attach entity.", descriptionGUID, this.archiveBuilder.getEntityDef("Referenceable"), true);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "status";
        String attribute1Description = "Status of this classification.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "confidence";
        String attribute2Description = "Level of confidence in the classification (0=none -> 100=excellent).";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "steward";
        String attribute3Description = "Person responsible for maintaining this classification.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "source";
        String attribute4Description = "Source of the classification.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "notes";
        String attribute5Description = "Information relating to the classification.";
        String attribute5DescriptionGUID = null;
        String attribute6Name = "level";
        String attribute6Description = "Level of severity associated with this classification";
        String attribute6DescriptionGUID = null;
        String attribute7Name = "levelIdentifier";
        String attribute7Description = "Defined level for this classification.";
        String attribute7DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute("GovernanceClassificationStatus", "status", "Status of this classification.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute("confidence", "Level of confidence in the classification (0=none -> 100=excellent).", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("steward", "Person responsible for maintaining this classification.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("source", "Source of the classification.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("notes", "Information relating to the classification.", attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("ImpactSeverity", "level", "Level of severity associated with this classification", attribute6DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute("levelIdentifier", "Defined level for this classification.", attribute7DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void update0445GovernanceRoles() {
        this.archiveBuilder.addEnumDef(this.getOwnerTypeEnum());
    }

    private EnumDef getOwnerTypeEnum() {
        String guid = "5ce92a70-b86a-4e0d-a9d7-fc961121de97";
        String name = "OwnerType";
        String description = "Defines the type of identifier for a governance owner.";
        String descriptionGUID = null;
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef("5ce92a70-b86a-4e0d-a9d7-fc961121de97", "OwnerType", "Defines the type of identifier for a governance owner.", descriptionGUID);
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        boolean element1Ordinal = false;
        String element1Value = "UserId";
        String element1Description = "The owner's userId is specified (default).";
        String element1DescriptionGUID = null;
        EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(0, "UserId", "The owner's userId is specified (default).", element1DescriptionGUID);
        elementDefs.add(elementDef);
        boolean element2Ordinal = true;
        String element2Value = "ProfileId";
        String element2Description = "The unique identifier (guid) of the profile of the owner.";
        String element2DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(1, "ProfileId", "The unique identifier (guid) of the profile of the owner.", element2DescriptionGUID);
        elementDefs.add(elementDef);
        int element99Ordinal = 99;
        String element99Value = "Other";
        String element99Description = "Another type of owner identifier, probably not supported by open metadata.";
        String element99DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(99, "Other", "Another type of owner identifier, probably not supported by open metadata.", element99DescriptionGUID);
        elementDefs.add(elementDef);
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    public void update0460GovernanceExecutionPoints() {
        this.archiveBuilder.addEntityDef(this.addExecutionPointDefinitionEntity());
        this.archiveBuilder.addEntityDef(this.addControlPointDefinitionEntity());
        this.archiveBuilder.addEntityDef(this.addVerificationPointDefinitionEntity());
        this.archiveBuilder.addEntityDef(this.addEnforcementPointDefinitionEntity());
        this.archiveBuilder.addRelationshipDef(this.addExecutionPointUseRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateControlPointClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateVerificationPointClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateEnforcementPointClassification());
    }

    private EntityDef addExecutionPointDefinitionEntity() {
        String guid = "d7f8d1d2-8cec-4fd2-b9fd-c8307cad750d";
        String name = "ExecutionPointDefinition";
        String description = "A description of an activity that supports the implementation of a governance requirement.";
        String descriptionGUID = null;
        String superTypeName = "Referenceable";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("d7f8d1d2-8cec-4fd2-b9fd-c8307cad750d", "ExecutionPointDefinition", this.archiveBuilder.getEntityDef("Referenceable"), "A description of an activity that supports the implementation of a governance requirement.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "displayName";
        String attribute1Description = "Short name for display and reports.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "description";
        String attribute2Description = "Description of the execution point.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("displayName", "Short name for display and reports.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("description", "Description of the execution point.", attribute2DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef addControlPointDefinitionEntity() {
        String guid = "a376a993-5f1c-4926-b74e-a15a38e1d55a";
        String name = "ControlPointDefinition";
        String description = "A decision needs to be made on how to proceed.";
        String descriptionGUID = null;
        String superTypeName = "ExecutionPointDefinition";
        return this.archiveHelper.getDefaultEntityDef("a376a993-5f1c-4926-b74e-a15a38e1d55a", "ControlPointDefinition", this.archiveBuilder.getEntityDef("ExecutionPointDefinition"), "A decision needs to be made on how to proceed.", descriptionGUID);
    }

    private EntityDef addVerificationPointDefinitionEntity() {
        String guid = "27db26a1-ff66-4042-9932-ddc728b977b9";
        String name = "VerificationPointDefinition";
        String description = "A test is made to ensure the current situation is valid.";
        String descriptionGUID = null;
        String superTypeName = "ExecutionPointDefinition";
        return this.archiveHelper.getDefaultEntityDef("27db26a1-ff66-4042-9932-ddc728b977b9", "VerificationPointDefinition", this.archiveBuilder.getEntityDef("ExecutionPointDefinition"), "A test is made to ensure the current situation is valid.", descriptionGUID);
    }

    private EntityDef addEnforcementPointDefinitionEntity() {
        String guid = "e87ff806-bb9c-4c5d-8106-f38f2dd21037";
        String name = "EnforcementPointDefinition";
        String description = "A change is made to enforce a governance requirement.";
        String descriptionGUID = null;
        String superTypeName = "ExecutionPointDefinition";
        return this.archiveHelper.getDefaultEntityDef("e87ff806-bb9c-4c5d-8106-f38f2dd21037", "EnforcementPointDefinition", this.archiveBuilder.getEntityDef("ExecutionPointDefinition"), "A change is made to enforce a governance requirement.", descriptionGUID);
    }

    private RelationshipDef addExecutionPointUseRelationship() {
        String guid = "3eb268f4-9419-4281-a487-d25ccd88eba3";
        String name = "ExecutionPointUse";
        String description = "Link between a governance execution point definition and the governance definition it supports.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("3eb268f4-9419-4281-a487-d25ccd88eba3", "ExecutionPointUse", null, "Link between a governance execution point definition and the governance definition it supports.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "GovernanceDefinition";
        String end1AttributeName = "supportsGovernanceDefinitions";
        String end1AttributeDescription = "Governance definition that is implemented by this execution point.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernanceDefinition"), "supportsGovernanceDefinitions", "Governance definition that is implemented by this execution point.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "ExecutionPointDefinition";
        String end2AttributeName = "executedThrough";
        String end2AttributeDescription = "Description of the execution points that support the implementation of this governance definition.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("ExecutionPointDefinition"), "executedThrough", "Description of the execution points that support the implementation of this governance definition.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private TypeDefPatch updateControlPointClassification() {
        String typeName = "ControlPoint";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ControlPoint");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "qualifiedName";
        String attribute1Description = "Qualified name of the enforcement point definition.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute("qualifiedName", "Qualified name of the enforcement point definition.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateVerificationPointClassification() {
        String typeName = "VerificationPoint";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("VerificationPoint");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "qualifiedName";
        String attribute1Description = "Qualified name of the enforcement point definition.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute("qualifiedName", "Qualified name of the enforcement point definition.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateEnforcementPointClassification() {
        String typeName = "EnforcementPoint";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("EnforcementPoint");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "qualifiedName";
        String attribute1Description = "Qualified name of the enforcement point definition.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute("qualifiedName", "Qualified name of the enforcement point definition.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void add0461GovernanceActionEngines() {
        this.archiveBuilder.addEntityDef(this.addGovernanceEngineEntity());
        this.archiveBuilder.addEntityDef(this.addGovernanceServiceEntity());
        this.archiveBuilder.addEntityDef(this.addGovernanceActionEngineEntity());
        this.archiveBuilder.addEntityDef(this.addGovernanceActionServiceEntity());
        this.archiveBuilder.addRelationshipDef(this.addSupportedGovernanceServiceRelationship());
    }

    private EntityDef addGovernanceEngineEntity() {
        String guid = "3fa23d4a-aceb-422f-9301-04ed474c6f74";
        String name = "GovernanceEngine";
        String description = "A collection of related governance services of the same type.";
        String descriptionGUID = null;
        String superTypeName = "SoftwareServerCapability";
        return this.archiveHelper.getDefaultEntityDef("3fa23d4a-aceb-422f-9301-04ed474c6f74", "GovernanceEngine", this.archiveBuilder.getEntityDef("SoftwareServerCapability"), "A collection of related governance services of the same type.", descriptionGUID);
    }

    private EntityDef addGovernanceServiceEntity() {
        String guid = "191d870c-26f4-4310-a021-b8ca8772719d";
        String name = "GovernanceService";
        String description = "A connector that performs some governance operation.";
        String descriptionGUID = null;
        String superTypeName = "DeployedConnector";
        return this.archiveHelper.getDefaultEntityDef("191d870c-26f4-4310-a021-b8ca8772719d", "GovernanceService", this.archiveBuilder.getEntityDef("DeployedConnector"), "A connector that performs some governance operation.", descriptionGUID);
    }

    private EntityDef addGovernanceActionEngineEntity() {
        String guid = "5d74250a-57ca-4197-9475-8911f620a94e";
        String name = "GovernanceActionEngine";
        String description = "A collection of related governance services of the same type from the Governance Action Framework (GAF).";
        String descriptionGUID = null;
        String superTypeName = "GovernanceEngine";
        return this.archiveHelper.getDefaultEntityDef("5d74250a-57ca-4197-9475-8911f620a94e", "GovernanceActionEngine", this.archiveBuilder.getEntityDef("GovernanceEngine"), "A collection of related governance services of the same type from the Governance Action Framework (GAF).", descriptionGUID);
    }

    private EntityDef addGovernanceActionServiceEntity() {
        String guid = "ececb378-31ac-4cc3-99b4-1c44e5fbc4d9";
        String name = "GovernanceActionService";
        String description = "A governance service that conforms to the Governance Action Framework (GAF).";
        String descriptionGUID = null;
        String superTypeName = "GovernanceService";
        return this.archiveHelper.getDefaultEntityDef("ececb378-31ac-4cc3-99b4-1c44e5fbc4d9", "GovernanceActionService", this.archiveBuilder.getEntityDef("GovernanceService"), "A governance service that conforms to the Governance Action Framework (GAF).", descriptionGUID);
    }

    private RelationshipDef addSupportedGovernanceServiceRelationship() {
        String guid = "2726df0e-4f3a-44e1-8433-4ca5301457fd";
        String name = "SupportedGovernanceService";
        String description = "Link between a governance engine and one of its services.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("2726df0e-4f3a-44e1-8433-4ca5301457fd", "SupportedGovernanceService", null, "Link between a governance engine and one of its services.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "GovernanceEngine";
        String end1AttributeName = "calledFromGovernanceEngines";
        String end1AttributeDescription = "Governance Engine making use of the governance service.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernanceEngine"), "calledFromGovernanceEngines", "Governance Engine making use of the governance service.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "GovernanceService";
        String end2AttributeName = "supportedGovernanceServices";
        String end2AttributeDescription = "Governance service that is part of the governance engine.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernanceService"), "supportedGovernanceServices", "Governance service that is part of the governance engine.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "requestType";
        String attribute1Description = "The request type used to call the service.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "requestParameters";
        String attribute2Description = "Properties that configure the governance service for this type of request.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("requestType", "The request type used to call the service.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute("requestParameters", "Properties that configure the governance service for this type of request.", attribute2DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0462GovernanceActionTypes() {
        this.archiveBuilder.addEntityDef(this.addGovernanceActionProcessEntity());
        this.archiveBuilder.addEntityDef(this.addGovernanceActionTypeEntity());
        this.archiveBuilder.addRelationshipDef(this.addGovernanceActionFlowRelationship());
        this.archiveBuilder.addRelationshipDef(this.addNextGovernanceActionTypeRelationship());
        this.archiveBuilder.addRelationshipDef(this.addGovernanceActionTypeExecutorRelationship());
    }

    private EntityDef addGovernanceActionProcessEntity() {
        String guid = "4d3a2b8d-9e2e-4832-b338-21c74e45b238";
        String name = "GovernanceActionProcess";
        String description = "A process implemented by chained governance actions.";
        String descriptionGUID = null;
        String superTypeName = "Process";
        return this.archiveHelper.getDefaultEntityDef("4d3a2b8d-9e2e-4832-b338-21c74e45b238", "GovernanceActionProcess", this.archiveBuilder.getEntityDef("Process"), "A process implemented by chained governance actions.", descriptionGUID);
    }

    private EntityDef addGovernanceActionTypeEntity() {
        String guid = "92e20083-0393-40c0-a95b-090724a91ddc";
        String name = "GovernanceActionType";
        String description = "A description of a governance action that acts as a template when creating governance action instances.";
        String descriptionGUID = null;
        String superTypeName = "Referenceable";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("92e20083-0393-40c0-a95b-090724a91ddc", "GovernanceActionType", this.archiveBuilder.getEntityDef("Referenceable"), "A description of a governance action that acts as a template when creating governance action instances.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "domainIdentifier";
        String attribute1Description = "Identifier used to show which governance domain this action type belongs to.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "displayName";
        String attribute2Description = "Name of the action type.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "description";
        String attribute3Description = "Description of the action type.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "owner";
        String attribute4Description = "Person, team or engine responsible for this type of action.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "ownerType";
        String attribute5Description = "Type of element representing the owner.";
        String attribute5DescriptionGUID = null;
        String attribute7Name = "supportedGuards";
        String attribute7Description = "List of guards that this action type produces.";
        String attribute7DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute("domainIdentifier", "Identifier used to show which governance domain this action type belongs to.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("displayName", "Name of the action type.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("description", "Description of the action type.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("owner", "Person, team or engine responsible for this type of action.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("OwnerType", "ownerType", "Type of element representing the owner.", attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("supportedGuards", "List of guards that this action type produces.", attribute7DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef addGovernanceActionFlowRelationship() {
        String guid = "5f6ddee5-31ea-4d4f-9c3f-00ad2fcb2aa0";
        String name = "GovernanceActionFlow";
        String description = "A link between a governance process and its first action.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("5f6ddee5-31ea-4d4f-9c3f-00ad2fcb2aa0", "GovernanceActionFlow", null, "A link between a governance process and its first action.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "GovernanceActionProcess";
        String end1AttributeName = "triggeredFrom";
        String end1AttributeDescription = "Governance process that describes an action flow.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernanceActionProcess"), "triggeredFrom", "Governance process that describes an action flow.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "GovernanceActionType";
        String end2AttributeName = "firstAction";
        String end2AttributeDescription = "First governance action in a governance action process.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernanceActionType"), "firstAction", "First governance action in a governance action process.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef addNextGovernanceActionTypeRelationship() {
        String guid = "d9567840-9904-43a5-990b-4585c0446e00";
        String name = "NextGovernanceActionType";
        String description = "Link between a governance actions in a governance action flow.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("d9567840-9904-43a5-990b-4585c0446e00", "NextGovernanceActionType", null, "Link between a governance actions in a governance action flow.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "GovernanceActionType";
        String end1AttributeName = "dependedOnActionTypes";
        String end1AttributeDescription = "Governance Action Type caller.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernanceActionType"), "dependedOnActionTypes", "Governance Action Type caller.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "GovernanceActionType";
        String end2AttributeName = "followOnActionTypes";
        String end2AttributeDescription = "Governance Action Type called.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernanceActionType"), "followOnActionTypes", "Governance Action Type called.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "guard";
        String attribute1Description = "The guard that is returned by the previous action that means this next action will run.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "mandatoryGuard";
        String attribute2Description = "Is this guard mandatory for the next action to run.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "ignoreMultipleTriggers";
        String attribute3Description = "Trigger one or many next action instances?";
        String attribute3DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("guard", "The guard that is returned by the previous action that means this next action will run.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getBooleanTypeDefAttribute("mandatoryGuard", "Is this guard mandatory for the next action to run.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getBooleanTypeDefAttribute("ignoreMultipleTriggers", "Trigger one or many next action instances?", attribute3DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef addGovernanceActionTypeExecutorRelationship() {
        String guid = "f672245f-35b5-4ca7-b645-014cf61d5b75";
        String name = "GovernanceActionTypeExecutor";
        String description = "Link between a governance action type and the governance engine that will execute it.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("f672245f-35b5-4ca7-b645-014cf61d5b75", "GovernanceActionTypeExecutor", null, "Link between a governance action type and the governance engine that will execute it.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "GovernanceActionType";
        String end1AttributeName = "supportsGovernanceActionTypes";
        String end1AttributeDescription = "Governance action type that drives a governance engine.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernanceActionType"), "supportsGovernanceActionTypes", "Governance action type that drives a governance engine.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "GovernanceEngine";
        String end2AttributeName = "governanceActionTypeExecutor";
        String end2AttributeDescription = "Governance engine that will run the governance action.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernanceEngine"), "governanceActionTypeExecutor", "Governance engine that will run the governance action.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "requestType";
        String attribute1Description = "The request type used to call the service.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "requestParameters";
        String attribute2Description = "Properties that configure the governance service for this type of request.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("requestType", "The request type used to call the service.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute("requestParameters", "Properties that configure the governance service for this type of request.", attribute2DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0463GovernanceActions() {
        this.archiveBuilder.addEnumDef(this.getGovernanceActionStatusEnum());
        this.archiveBuilder.addEntityDef(this.addGovernanceActionEntity());
        this.archiveBuilder.addRelationshipDef(this.addGovernanceActionRequestSourceRelationship());
        this.archiveBuilder.addRelationshipDef(this.addGovernanceActionTypeUseRelationship());
        this.archiveBuilder.addRelationshipDef(this.addTargetForActionRelationship());
        this.archiveBuilder.addRelationshipDef(this.addNextGovernanceActionRelationship());
        this.archiveBuilder.addRelationshipDef(this.addGovernanceActionExecutorRelationship());
    }

    private EnumDef getGovernanceActionStatusEnum() {
        String guid = "a6e698b0-a4f7-4a39-8c80-db0bb0f972ec";
        String name = "GovernanceActionStatus";
        String description = "Defines the current execution status of a governance action.";
        String descriptionGUID = null;
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef("a6e698b0-a4f7-4a39-8c80-db0bb0f972ec", "GovernanceActionStatus", "Defines the current execution status of a governance action.", descriptionGUID);
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        boolean element1Ordinal = false;
        String element1Value = "Requested";
        String element1Description = "The governance action has been created and is pending.";
        String element1DescriptionGUID = null;
        EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(0, "Requested", "The governance action has been created and is pending.", element1DescriptionGUID);
        elementDefs.add(elementDef);
        boolean element2Ordinal = true;
        String element2Value = "Approved";
        String element2Description = "The governance action is approved to run.";
        String element2DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(1, "Approved", "The governance action is approved to run.", element2DescriptionGUID);
        elementDefs.add(elementDef);
        int element3Ordinal = 2;
        String element3Value = "Waiting";
        String element3Description = "The governance action is waiting for its start time or the right conditions to run.";
        String element3DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(2, "Waiting", "The governance action is waiting for its start time or the right conditions to run.", element3DescriptionGUID);
        elementDefs.add(elementDef);
        int element4Ordinal = 3;
        String element4Value = "Activating";
        String element4Description = "The governance service for the governance action is being initialized in the governance engine.";
        String element4DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(3, "Activating", "The governance service for the governance action is being initialized in the governance engine.", element4DescriptionGUID);
        elementDefs.add(elementDef);
        int element9Ordinal = 4;
        String element9Value = "InProgress";
        String element9Description = "The governance engine is running the associated governance service for the governance action.";
        String element9DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(4, "InProgress", "The governance engine is running the associated governance service for the governance action.", element9DescriptionGUID);
        elementDefs.add(elementDef);
        int element5Ordinal = 10;
        String element5Value = "Actioned";
        String element5Description = "The governance service for the governance action has successfully completed processing.";
        String element5DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(10, "Actioned", "The governance service for the governance action has successfully completed processing.", element5DescriptionGUID);
        elementDefs.add(elementDef);
        int element6Ordinal = 11;
        String element6Value = "Invalid";
        String element6Description = "The governance action has not been run because it is not appropriate (for example, a false positive).";
        String element6DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(11, "Invalid", "The governance action has not been run because it is not appropriate (for example, a false positive).", element6DescriptionGUID);
        elementDefs.add(elementDef);
        int element7Ordinal = 12;
        String element7Value = "Ignored";
        String element7Description = "The governance action has not been run because a different governance action was chosen.";
        String element7DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(12, "Ignored", "The governance action has not been run because a different governance action was chosen.", element7DescriptionGUID);
        elementDefs.add(elementDef);
        int element8Ordinal = 13;
        String element8Value = "Failed";
        String element8Description = "The governance service for the governance action failed to execute.";
        String element8DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(13, "Failed", "The governance service for the governance action failed to execute.", element8DescriptionGUID);
        elementDefs.add(elementDef);
        int element99Ordinal = 99;
        String element99Value = "Other";
        String element99Description = "Undefined or unknown governance action status.";
        String element99DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(99, "Other", "Undefined or unknown governance action status.", element99DescriptionGUID);
        elementDefs.add(elementDef);
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EntityDef addGovernanceActionEntity() {
        String guid = "c976d88a-2b11-4b40-b972-c38d41bfc6be";
        String name = "GovernanceAction";
        String description = "A governance action that has been created to support the active governance of the open metadata ecosystem and/or digital landscape.";
        String descriptionGUID = null;
        String superTypeName = "Referenceable";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("c976d88a-2b11-4b40-b972-c38d41bfc6be", "GovernanceAction", this.archiveBuilder.getEntityDef("Referenceable"), "A governance action that has been created to support the active governance of the open metadata ecosystem and/or digital landscape.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "domainIdentifier";
        String attribute1Description = "Identifier used to show which governance domain this action belongs to.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "displayName";
        String attribute2Description = "Name of the governance action.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "description";
        String attribute3Description = "Description of the governance action.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "processingEngineUserId";
        String attribute4Description = "Governance engine responsible for this governance action.";
        String attribute4DescriptionGUID = null;
        String attribute6Name = "actionStatus";
        String attribute6Description = "Current lifecycle state of the governance action.";
        String attribute6DescriptionGUID = null;
        String attribute7Name = "startDate";
        String attribute7Description = "Date and time when the governance action service started running.";
        String attribute7DescriptionGUID = null;
        String attribute8Name = "completionDate";
        String attribute8Description = "Date and time when the governance action service completed.";
        String attribute8DescriptionGUID = null;
        String attribute9Name = "completionGuards";
        String attribute9Description = "List of guards returned by the governance action service.";
        String attribute9DescriptionGUID = null;
        String attribute10Name = "receivedGuards";
        String attribute10Description = "List of guards received from the previous governance action service(s).";
        String attribute10DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute("domainIdentifier", "Identifier used to show which governance domain this action belongs to.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("displayName", "Name of the governance action.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("description", "Description of the governance action.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("processingEngineUserId", "Governance engine responsible for this governance action.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("GovernanceActionStatus", "actionStatus", "Current lifecycle state of the governance action.", attribute6DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("startDate", "Date and time when the governance action service started running.", attribute7DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("completionDate", "Date and time when the governance action service completed.", attribute8DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute("completionGuards", "List of guards returned by the governance action service.", attribute9DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute("receivedGuards", "List of guards received from the previous governance action service(s).", attribute10DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef addGovernanceActionRequestSourceRelationship() {
        String guid = "5323a705-4c1f-456a-9741-41fdcb8e93ac";
        String name = "GovernanceActionRequestSource";
        String description = "Link between a governance action type and the governance engine that will execute it.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("5323a705-4c1f-456a-9741-41fdcb8e93ac", "GovernanceActionRequestSource", null, "Link between a governance action type and the governance engine that will execute it.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "OpenMetadataRoot";
        String end1AttributeName = "sourceActivity";
        String end1AttributeDescription = "Element(s) that caused this governance action to be created.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("OpenMetadataRoot"), "sourceActivity", "Element(s) that caused this governance action to be created.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "GovernanceAction";
        String end2AttributeName = "identifiedActions";
        String end2AttributeDescription = "Governance actions that were initiated for the linked element.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernanceAction"), "identifiedActions", "Governance actions that were initiated for the linked element.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "originGovernanceService";
        String attribute1Description = "The qualifiedName of the governance service that caused the governance action to be created.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "originGovernanceEngine";
        String attribute2Description = "The qualifiedName of the governance engine that caused the governance action to be created.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "requestSourceName";
        String attribute3Description = "The name to identify the request source to the governance service that processes it.";
        String attribute3DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("originGovernanceService", "The qualifiedName of the governance service that caused the governance action to be created.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("originGovernanceEngine", "The qualifiedName of the governance engine that caused the governance action to be created.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("requestSourceName", "The name to identify the request source to the governance service that processes it.", attribute3DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef addGovernanceActionTypeUseRelationship() {
        String guid = "31e734ec-5baf-4e96-9f0d-e8a85081cb14";
        String name = "GovernanceActionTypeUse";
        String description = "Link between a governance action type and a resulting governance action.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("31e734ec-5baf-4e96-9f0d-e8a85081cb14", "GovernanceActionTypeUse", null, "Link between a governance action type and a resulting governance action.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "GovernanceActionType";
        String end1AttributeName = "fromActionTypeTemplate";
        String end1AttributeDescription = "Governance action type that was the template for this governance action.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernanceActionType"), "fromActionTypeTemplate", "Governance action type that was the template for this governance action.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "GovernanceAction";
        String end2AttributeName = "spawnedActions";
        String end2AttributeDescription = "Governance actions that were created from this action type template.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernanceAction"), "spawnedActions", "Governance actions that were created from this action type template.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "originGovernanceService";
        String attribute1Description = "The qualifiedName of the governance service that caused the governance action to be created.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "originGovernanceEngine";
        String attribute2Description = "The qualifiedName of the governance engine that caused the governance action to be created.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("originGovernanceService", "The qualifiedName of the governance service that caused the governance action to be created.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("originGovernanceEngine", "The qualifiedName of the governance engine that caused the governance action to be created.", attribute2DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef addTargetForActionRelationship() {
        String guid = "46ec49bf-af66-4575-aab7-06ce895120cd";
        String name = "TargetForAction";
        String description = "The element(s) that the governance action will work on.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("46ec49bf-af66-4575-aab7-06ce895120cd", "TargetForAction", null, "The element(s) that the governance action will work on.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "GovernanceAction";
        String end1AttributeName = "identifiedActions";
        String end1AttributeDescription = "Governance action that is acting on this element.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernanceAction"), "identifiedActions", "Governance action that is acting on this element.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "Referenceable";
        String end2AttributeName = "actionTarget";
        String end2AttributeDescription = "Element(s) to work on.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Referenceable"), "actionTarget", "Element(s) to work on.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "status";
        String attribute1Description = "The status of the work on this element.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "startDate";
        String attribute2Description = "Date/time that work started on this element for the linked governance action.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "completionDate";
        String attribute3Description = "Date/time that work stopped on this element for the linked governance action.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "actionTargetName";
        String attribute4Description = "The name to identify the action target to the governance service that processes it.";
        String attribute4DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute("GovernanceActionStatus", "status", "The status of the work on this element.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("startDate", "Date/time that work started on this element for the linked governance action.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("completionDate", "Date/time that work stopped on this element for the linked governance action.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("actionTargetName", "The name to identify the action target to the governance service that processes it.", attribute4DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef addNextGovernanceActionRelationship() {
        String guid = "4efd16d4-f397-449c-a75d-ebea42fe581b";
        String name = "NextGovernanceAction";
        String description = "Linking of governance actions to show execution sequence.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("4efd16d4-f397-449c-a75d-ebea42fe581b", "NextGovernanceAction", null, "Linking of governance actions to show execution sequence.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "GovernanceAction";
        String end1AttributeName = "previousActions";
        String end1AttributeDescription = "Governance action that triggered this governance action.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernanceAction"), "previousActions", "Governance action that triggered this governance action.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "GovernanceAction";
        String end2AttributeName = "followOnActions";
        String end2AttributeDescription = "Governance actions that should run next.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernanceAction"), "followOnActions", "Governance actions that should run next.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "guard";
        String attribute1Description = "The guard that is returned by the previous action that means this next action will run.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "mandatoryGuard";
        String attribute2Description = "Is this guard mandatory for the next action to run.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "ignoreMultipleTriggers";
        String attribute3Description = "Trigger one or many next action instances?";
        String attribute3DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("guard", "The guard that is returned by the previous action that means this next action will run.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getBooleanTypeDefAttribute("mandatoryGuard", "Is this guard mandatory for the next action to run.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getBooleanTypeDefAttribute("ignoreMultipleTriggers", "Trigger one or many next action instances?", attribute3DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef addGovernanceActionExecutorRelationship() {
        String guid = "e690ab17-6779-46b4-a8f1-6872d88c1bbb";
        String name = "GovernanceActionExecutor";
        String description = "Link between a governance action and the governance engine that will execute it.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("e690ab17-6779-46b4-a8f1-6872d88c1bbb", "GovernanceActionExecutor", null, "Link between a governance action and the governance engine that will execute it.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "GovernanceAction";
        String end1AttributeName = "supportsGovernanceAction";
        String end1AttributeDescription = "Governance action that drives a governance engine.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernanceAction"), "supportsGovernanceAction", "Governance action that drives a governance engine.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "GovernanceEngine";
        String end2AttributeName = "governanceActionExecutor";
        String end2AttributeDescription = "Governance engine that will run the governance action.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernanceEngine"), "governanceActionExecutor", "Governance engine that will run the governance action.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "requestType";
        String attribute1Description = "The request type used to call the service.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "requestParameters";
        String attribute2Description = "Properties that configure the governance service for this type of request.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("requestType", "The request type used to call the service.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute("requestParameters", "Properties that configure the governance service for this type of request.", attribute2DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    public void add0465DuplicateProcessing() {
        this.archiveBuilder.addEnumDef(this.addDuplicateTypeEnum());
        this.archiveBuilder.addClassificationDef(this.addKnowDuplicateClassification());
        this.archiveBuilder.addRelationshipDef(this.addKnownDuplicateLinkRelationship());
    }

    private EnumDef addDuplicateTypeEnum() {
        String guid = "2f6a3dc1-aa98-4b92-add4-68de53b7369c";
        String name = "DuplicateType";
        String description = "Defines if the duplicates are peers or one is a consolidated duplicate.";
        String descriptionGUID = null;
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef("2f6a3dc1-aa98-4b92-add4-68de53b7369c", "DuplicateType", "Defines if the duplicates are peers or one is a consolidated duplicate.", descriptionGUID);
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        boolean element1Ordinal = false;
        String element1Value = "Peer";
        String element1Description = "The duplicates are peers.";
        String element1DescriptionGUID = null;
        EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(0, "Peer", "The duplicates are peers.", element1DescriptionGUID);
        elementDefs.add(elementDef);
        boolean element2Ordinal = true;
        String element2Value = "Consolidated";
        String element2Description = "One duplicate has been constructed from the other (ands its peers).";
        String element2DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(1, "Consolidated", "One duplicate has been constructed from the other (ands its peers).", element2DescriptionGUID);
        elementDefs.add(elementDef);
        int element99Ordinal = 99;
        String element99Value = "Other";
        String element99Description = "Another duplicate type.";
        String element99DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(99, "Other", "Another duplicate type.", element99DescriptionGUID);
        elementDefs.add(elementDef);
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private ClassificationDef addKnowDuplicateClassification() {
        String guid = "e55062b2-907f-44bd-9831-255642285731";
        String name = "KnownDuplicate";
        String description = "Defines that duplicate resolution processing is required.";
        String descriptionGUID = null;
        String linkedToEntity = "Referenceable";
        return this.archiveHelper.getClassificationDef("e55062b2-907f-44bd-9831-255642285731", "KnownDuplicate", null, "Defines that duplicate resolution processing is required.", descriptionGUID, this.archiveBuilder.getEntityDef("Referenceable"), true);
    }

    private RelationshipDef addKnownDuplicateLinkRelationship() {
        String guid = "7540d9fb-1848-472e-baef-97a44b9f0c45";
        String name = "KnownDuplicateLink";
        String description = "Link between duplicate entities.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("7540d9fb-1848-472e-baef-97a44b9f0c45", "KnownDuplicateLink", null, "Link between duplicate entities.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "Referenceable";
        String end1AttributeName = "knownDuplicateOrigin";
        String end1AttributeDescription = "Oldest element.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Referenceable"), "knownDuplicateOrigin", "Oldest element.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "Referenceable";
        String end2AttributeName = "knownDuplicatePartner";
        String end2AttributeDescription = "Newest element.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Referenceable"), "knownDuplicatePartner", "Newest element.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "duplicateType";
        String attribute1Description = "Type of duplicate.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "status";
        String attribute2Description = "Status of the duplicate processing.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "steward";
        String attribute3Description = "Person responsible for maintaining this classification.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "source";
        String attribute4Description = "Source of the classification.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "notes";
        String attribute5Description = "Information relating to the classification.";
        String attribute5DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute("DuplicateType", "duplicateType", "Type of duplicate.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("GovernanceClassificationStatus", "status", "Status of the duplicate processing.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("steward", "Person responsible for maintaining this classification.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("source", "Source of the classification.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("notes", "Information relating to the classification.", attribute5DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    public void add0470IncidentReports() {
        this.archiveBuilder.addEnumDef(this.getIncidentReportStatusEnum());
        this.archiveBuilder.addEntityDef(this.addIncidentClassifierEntity());
        this.archiveBuilder.addEntityDef(this.addIncidentReportEntity());
        this.archiveBuilder.addRelationshipDef(this.addIncidentOriginatorRelationship());
        this.archiveBuilder.addRelationshipDef(this.addImpactedResourceRelationship());
        this.archiveBuilder.addRelationshipDef(this.addIncidentDependencyRelationship());
    }

    private EnumDef getIncidentReportStatusEnum() {
        String guid = "a9d4f64b-fa24-4eb8-8bf6-308926ef2c14";
        String name = "IncidentReportStatus";
        String description = "Defines the status of an incident report.";
        String descriptionGUID = null;
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef("a9d4f64b-fa24-4eb8-8bf6-308926ef2c14", "IncidentReportStatus", "Defines the status of an incident report.", descriptionGUID);
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        boolean element1Ordinal = false;
        String element1Value = "Raised";
        String element1Description = "The incident report has been raised but no processing has occurred.";
        String element1DescriptionGUID = null;
        EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(0, "Raised", "The incident report has been raised but no processing has occurred.", element1DescriptionGUID);
        elementDefs.add(elementDef);
        boolean element2Ordinal = true;
        String element2Value = "Reviewed";
        String element2Description = "The incident report has been reviewed, possibly classified but no action has been taken.";
        String element2DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(1, "Reviewed", "The incident report has been reviewed, possibly classified but no action has been taken.", element2DescriptionGUID);
        elementDefs.add(elementDef);
        int element3Ordinal = 2;
        String element3Value = "Validated";
        String element3Description = "The incident report records a valid incident and work is underway to resolve it.";
        String element3DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(2, "Validated", "The incident report records a valid incident and work is underway to resolve it.", element3DescriptionGUID);
        elementDefs.add(elementDef);
        int element4Ordinal = 3;
        String element4Value = "Resolved";
        String element4Description = "The reported incident has been resolved.";
        String element4DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(3, "Resolved", "The reported incident has been resolved.", element4DescriptionGUID);
        elementDefs.add(elementDef);
        int element5Ordinal = 4;
        String element5Value = "Invalid";
        String element5Description = "The incident report does not describe a valid incident and has been closed.";
        String element5DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(4, "Invalid", "The incident report does not describe a valid incident and has been closed.", element5DescriptionGUID);
        elementDefs.add(elementDef);
        int element6Ordinal = 5;
        String element6Value = "Ignored";
        String element6Description = "The incident report is valid but has been closed with no action.";
        String element6DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(5, "Ignored", "The incident report is valid but has been closed with no action.", element6DescriptionGUID);
        elementDefs.add(elementDef);
        int element99Ordinal = 99;
        String element99Value = "Other";
        String element99Description = "Another incident report status.";
        String element99DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(99, "Other", "Another incident report status.", element99DescriptionGUID);
        elementDefs.add(elementDef);
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EntityDef addIncidentClassifierEntity() {
        String guid = "1fad7fe4-5115-412b-ae31-a418e93888fe";
        String name = "IncidentClassifier";
        String description = "A definition of a classifier used to label incident reports.";
        String descriptionGUID = null;
        String superTypeName = "Referenceable";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("1fad7fe4-5115-412b-ae31-a418e93888fe", "IncidentClassifier", this.archiveBuilder.getEntityDef("Referenceable"), "A definition of a classifier used to label incident reports.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "classifierLabel";
        String attribute1Description = "Label to add to the incident.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "classifierIdentifier";
        String attribute2Description = "Option for indicator value associated with the classifier label.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "classifierName";
        String attribute3Description = "Display name for the classifier identifier.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "classifierDescription";
        String attribute4Description = "Description of the meaning of the classifier identifier.";
        String attribute4DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("classifierLabel", "Label to add to the incident.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute("classifierIdentifier", "Option for indicator value associated with the classifier label.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("classifierName", "Display name for the classifier identifier.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("classifierDescription", "Description of the meaning of the classifier identifier.", attribute4DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef addIncidentReportEntity() {
        String guid = "072f252b-dea7-4b88-bb2e-8f741c9ca7f6e";
        String name = "IncidentReport";
        String description = "A description of an adverse situation or activity.";
        String descriptionGUID = null;
        String superTypeName = "Referenceable";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("072f252b-dea7-4b88-bb2e-8f741c9ca7f6e", "IncidentReport", this.archiveBuilder.getEntityDef("Referenceable"), "A description of an adverse situation or activity.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "domainIdentifier";
        String attribute1Description = "Identifier used to show which governance domain this incident belongs to.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "background";
        String attribute2Description = "Description of the background cause or activity.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "description";
        String attribute3Description = "Description of the incident.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "owner";
        String attribute4Description = "Person, team or engine responsible for this incident.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "ownerType";
        String attribute5Description = "Type of element representing the owner.";
        String attribute5DescriptionGUID = null;
        String attribute6Name = "incidentStatus";
        String attribute6Description = "Current lifecycle state of the incident report.";
        String attribute6DescriptionGUID = null;
        String attribute7Name = "startDate";
        String attribute7Description = "Date and time when the governance action service started running.";
        String attribute7DescriptionGUID = null;
        String attribute8Name = "completionDate";
        String attribute8Description = "Date and time when the governance action service completed.";
        String attribute8DescriptionGUID = null;
        String attribute9Name = "incidentClassifiers";
        String attribute9Description = "Map of label to level indicator to provide customizable grouping of incidents.";
        String attribute9DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute("domainIdentifier", "Identifier used to show which governance domain this incident belongs to.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("background", "Description of the background cause or activity.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("description", "Description of the incident.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("owner", "Person, team or engine responsible for this incident.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("OwnerType", "ownerType", "Type of element representing the owner.", attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("IncidentReportStatus", "incidentStatus", "Current lifecycle state of the incident report.", attribute6DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("startDate", "Date and time when the governance action service started running.", attribute7DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("completionDate", "Date and time when the governance action service completed.", attribute8DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringIntTypeDefAttribute("incidentClassifiers", "Map of label to level indicator to provide customizable grouping of incidents.", attribute9DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef addIncidentOriginatorRelationship() {
        String guid = "e490772e-c2c5-445a-aea6-1aab3499a76c";
        String name = "IncidentOriginator";
        String description = "Link between an incident report and its originator (person, process, engine, ...).";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("e490772e-c2c5-445a-aea6-1aab3499a76c", "IncidentOriginator", null, "Link between an incident report and its originator (person, process, engine, ...).", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "Referenceable";
        String end1AttributeName = "originators";
        String end1AttributeDescription = "Source(s) of the incident report.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Referenceable"), "originators", "Source(s) of the incident report.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "IncidentReport";
        String end2AttributeName = "resultingIncidentReports";
        String end2AttributeDescription = "Descriptions of detected incidents.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("IncidentReport"), "resultingIncidentReports", "Descriptions of detected incidents.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef addImpactedResourceRelationship() {
        String guid = "0908e153-e0fd-499c-8a30-5ea8b81395cd";
        String name = "ImpactedResource";
        String description = "Link between an impacted referenceable and an incident report.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("0908e153-e0fd-499c-8a30-5ea8b81395cd", "ImpactedResource", null, "Link between an impacted referenceable and an incident report.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "Referenceable";
        String end1AttributeName = "impactedResources";
        String end1AttributeDescription = "Resources impacted by the incident.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Referenceable"), "impactedResources", "Resources impacted by the incident.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "IncidentReport";
        String end2AttributeName = "incidentReports";
        String end2AttributeDescription = "Descriptions of incidents affection this resource and the action taken.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("IncidentReport"), "incidentReports", "Descriptions of incidents affection this resource and the action taken.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "severityLevelIdentifier";
        String attribute1Description = "How severe is the impact on the resource?";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute("severityLevelIdentifier", "How severe is the impact on the resource?", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef addIncidentDependencyRelationship() {
        String guid = "017be6a8-0037-49d8-af5d-c45c41f25e0b";
        String name = "IncidentDependency";
        String description = "Link between an incident report and its predecessors.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("017be6a8-0037-49d8-af5d-c45c41f25e0b", "IncidentDependency", null, "Link between an incident report and its predecessors.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "IncidentReport";
        String end1AttributeName = "priorReportedIncidents";
        String end1AttributeDescription = "Previous reports on the same or related incident.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("IncidentReport"), "priorReportedIncidents", "Previous reports on the same or related incident.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "IncidentReport";
        String end2AttributeName = "followOnReportedIncidents";
        String end2AttributeDescription = "Subsequent reports on the same or related incident.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("IncidentReport"), "followOnReportedIncidents", "Subsequent reports on the same or related incident.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "description";
        String attribute1Description = "Description of the dependency.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("description", "Description of the dependency.", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    public void add0550InstanceMetadata() {
        this.archiveBuilder.addClassificationDef(this.addInstanceMetadataClassification());
    }

    private ClassificationDef addInstanceMetadataClassification() {
        String guid = "e6d5c097-a5e9-4bc4-a614-2506276059af";
        String name = "InstanceMetadata";
        String description = "Defines a data field that contains metadata for the row/record/object.";
        String descriptionGUID = null;
        String linkedToEntity = "SchemaElement";
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("e6d5c097-a5e9-4bc4-a614-2506276059af", "InstanceMetadata", null, "Defines a data field that contains metadata for the row/record/object.", descriptionGUID, this.archiveBuilder.getEntityDef("SchemaElement"), true);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "typeName";
        String attribute1Description = "Open metadata type for the instance metadata (if applicable).";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "description";
        String attribute2Description = "Description of the metadata.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "additionalProperties";
        String attribute3Description = "Additional properties describing properties, valid values or associated processing for this metadata.";
        String attribute3DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("typeName", "Open metadata type for the instance metadata (if applicable).", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("description", "Description of the metadata.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute("additionalProperties", "Additional properties describing properties, valid values or associated processing for this metadata.", attribute3DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void update06xxDiscoveryEnginesAndServices() {
        this.archiveBuilder.addTypeDefPatch(this.updateOpenDiscoveryEngine());
        this.archiveBuilder.addTypeDefPatch(this.updateOpenDiscoveryService());
        this.archiveBuilder.addTypeDefPatch(this.deprecateSupportedDiscoveryService());
    }

    private TypeDefPatch updateOpenDiscoveryEngine() {
        String typeName = "OpenDiscoveryEngine";
        String superTypeName = "GovernanceEngine";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("OpenDiscoveryEngine");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef("GovernanceEngine"));
        return typeDefPatch;
    }

    private TypeDefPatch updateOpenDiscoveryService() {
        String typeName = "OpenDiscoveryService";
        String superTypeName = "GovernanceService";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("OpenDiscoveryService");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef("GovernanceService"));
        return typeDefPatch;
    }

    private TypeDefPatch deprecateSupportedDiscoveryService() {
        String typeName = "SupportedDiscoveryService";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("SupportedDiscoveryService");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }
}

