/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive2_7;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttributeStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefStatus;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive2_8 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "2.8";
    private static final String originatorName = "Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private OMRSArchiveBuilder archiveBuilder;
    private OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive2_8() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive2_8(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive2_7 previousTypes = new OpenMetadataTypesArchive2_7(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.update0025Locations();
        this.update0030HostsAndOperatingPlatforms();
        this.update0050Applications();
        this.update0440OrganizationControls();
        this.update0462GovernanceActionTypes();
    }

    private void update0025Locations() {
        this.archiveBuilder.addTypeDefPatch(this.updateFixedLocation());
        this.archiveBuilder.addTypeDefPatch(this.updateCyberLocation());
    }

    private TypeDefPatch updateFixedLocation() {
        String typeName = "FixedLocation";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("FixedLocation");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "address";
        String attribute1Description = "Postal address of the location (Deprecated).";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "postalAddress";
        String attribute2Description = "Postal address of the location.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "mapProjection";
        String attribute3Description = "The scheme used to define the meaning of the coordinates.";
        String attribute3DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("address", "Postal address of the location (Deprecated).", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("postalAddress", "Postal address of the location.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("mapProjection", "The scheme used to define the meaning of the coordinates.", attribute3DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateCyberLocation() {
        String typeName = "CyberLocation";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("CyberLocation");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "address";
        String attribute1Description = "Address of the location (Deprecated).";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "networkAddress";
        String attribute2Description = "Base network address used to connect to the location's endpoint(s).";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("address", "Address of the location (Deprecated).", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("networkAddress", "Base network address used to connect to the location's endpoint(s).", attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0030HostsAndOperatingPlatforms() {
        this.archiveBuilder.addTypeDefPatch(this.deprecateHostLocation());
    }

    private TypeDefPatch deprecateHostLocation() {
        String typeName = "HostLocation";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("HostLocation");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private void update0050Applications() {
        this.archiveBuilder.addTypeDefPatch(this.deprecateRuntimeForProcess());
    }

    private TypeDefPatch deprecateRuntimeForProcess() {
        String typeName = "RuntimeForProcess";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("RuntimeForProcess");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private void update0440OrganizationControls() {
        this.archiveBuilder.addTypeDefPatch(this.updateBusinessCapabilityEntity());
    }

    private TypeDefPatch updateBusinessCapabilityEntity() {
        String typeName = "BusinessCapability";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("BusinessCapability");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "deployedImplementationType";
        String attribute1Description = "Deprecated attribute. Use the businessCapabilityType attribute to describe the type of business capability.";
        String attribute1DescriptionGUID = null;
        String attribute1ReplacedBy = "deployedImplementationType";
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute("BusinessCapabilityType", "deployedImplementationType", "Deprecated attribute. Use the businessCapabilityType attribute to describe the type of business capability.", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("deployedImplementationType");
        properties.add(property);
        String attribute2Name = "businessCapabilityType";
        String attribute2Description = "Type of business capability.";
        String attribute2DescriptionGUID = null;
        property = this.archiveHelper.getEnumTypeDefAttribute("BusinessCapabilityType", "businessCapabilityType", "Type of business capability.", attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0462GovernanceActionTypes() {
        this.archiveBuilder.addTypeDefPatch(this.updateGovernanceActionTypeEntity());
    }

    private TypeDefPatch updateGovernanceActionTypeEntity() {
        String typeName = "GovernanceActionType";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("GovernanceActionType");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "supportedGuards";
        String attribute1Description = "Deprecated attribute. Use the producedGuards attribute to describe the supported guards.";
        String attribute1DescriptionGUID = null;
        String attribute1ReplacedBy = "producedGuards";
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("supportedGuards", "Deprecated attribute. Use the producedGuards attribute to describe the supported guards.", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("producedGuards");
        properties.add(property);
        String attribute2Name = "producedGuards";
        String attribute2Description = "List of guards that this action type produces.";
        String attribute2DescriptionGUID = null;
        property = this.archiveHelper.getArrayStringTypeDefAttribute("producedGuards", "List of guards that this action type produces.", attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }
}

