/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive3_15;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumElementDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive4_0 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "4.0";
    private static final String originatorName = "Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive4_0() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive4_0(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive3_15 previousTypes = new OpenMetadataTypesArchive3_15(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.update0021Collections();
        this.update0137ToDos();
        this.add0220DataFileCollectionDataSet();
        this.add0224TableDataSet();
        this.add0239DeployedReportType();
        this.update0385ControlledGlossaries();
        this.update0462GovernanceActionType();
        this.create0464DynamicIntegrationGroups();
        this.update0470IncidentClassifierSet();
        this.update0484AgreementActor();
        this.update0545ReferenceData();
        this.update0720InformationSupplyChains();
        this.addFormulaTypeAttribute();
    }

    private void update0385ControlledGlossaries() {
        this.archiveBuilder.addTypeDefPatch(this.updateControlledGlossaryTermEntity());
        this.archiveBuilder.addRelationshipDef(this.addGlossaryTermEvolutionRelationship());
    }

    private TypeDefPatch updateControlledGlossaryTermEntity() {
        String typeName = "ControlledGlossaryTerm";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ControlledGlossaryTerm");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "userDefinedStatus";
        String attribute1Description = "Extend or replace the valid instance statuses with additional statuses controlled through valid metadata values.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("userDefinedStatus", "Extend or replace the valid instance statuses with additional statuses controlled through valid metadata values.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        ArrayList<InstanceStatus> validInstanceStatusList = new ArrayList<InstanceStatus>();
        validInstanceStatusList.add(InstanceStatus.DRAFT);
        validInstanceStatusList.add(InstanceStatus.PREPARED);
        validInstanceStatusList.add(InstanceStatus.PROPOSED);
        validInstanceStatusList.add(InstanceStatus.APPROVED);
        validInstanceStatusList.add(InstanceStatus.REJECTED);
        validInstanceStatusList.add(InstanceStatus.ACTIVE);
        validInstanceStatusList.add(InstanceStatus.DEPRECATED);
        validInstanceStatusList.add(InstanceStatus.OTHER);
        validInstanceStatusList.add(InstanceStatus.DELETED);
        typeDefPatch.setValidInstanceStatusList(validInstanceStatusList);
        return typeDefPatch;
    }

    private RelationshipDef addGlossaryTermEvolutionRelationship() {
        String guid = "b323c9cf-f254-49c7-a391-11222e9da70f";
        String name = "GlossaryTermEvolution";
        String description = "Links a live glossary term with a future version of the term.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("b323c9cf-f254-49c7-a391-11222e9da70f", "GlossaryTermEvolution", null, "Links a live glossary term with a future version of the term.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "ControlledGlossaryTerm";
        String end1AttributeName = "glossaryTermUpdates";
        String end1AttributeDescription = "A glossary term that contains proposed updates to the live glossary term.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("ControlledGlossaryTerm"), "glossaryTermUpdates", "A glossary term that contains proposed updates to the live glossary term.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "GlossaryTerm";
        String end2AttributeName = "liveGlossaryTerm";
        String end2AttributeDescription = "The approved term that is in use.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GlossaryTerm"), "liveGlossaryTerm", "The approved term that is in use.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "description";
        String attribute1Description = "Short description of the update.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("description", "Short description of the update.", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void update0021Collections() {
        this.archiveBuilder.addEnumDef(this.getMembershipStatusEnum());
        this.archiveBuilder.addTypeDefPatch(this.updateCollectionMembershipRelationship());
    }

    private EnumDef getMembershipStatusEnum() {
        String guid = "a3bdb2ac-c28e-4e5a-8ab7-76aa01038832";
        String name = "MembershipStatus";
        String description = "Defines the provenance and confidence that a member belongs in a collection.";
        String descriptionGUID = null;
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef("a3bdb2ac-c28e-4e5a-8ab7-76aa01038832", "MembershipStatus", "Defines the provenance and confidence that a member belongs in a collection.", descriptionGUID);
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        boolean element0Ordinal = false;
        String element0Value = "Unknown";
        String element0Description = "The membership origin is unknown.";
        String element0DescriptionGUID = null;
        EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(0, "Unknown", "The membership origin is unknown.", element0DescriptionGUID);
        elementDefs.add(elementDef);
        enumDef.setDefaultValue(elementDef);
        boolean element1Ordinal = true;
        String element1Value = "Discovered";
        String element1Description = "The membership was discovered by an automated process.";
        String element1DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(1, "Discovered", "The membership was discovered by an automated process.", element1DescriptionGUID);
        elementDefs.add(elementDef);
        int element2Ordinal = 2;
        String element2Value = "Assigned";
        String element2Description = "The membership was proposed by an expert curator.";
        String element2DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(2, "Assigned", "The membership was proposed by an expert curator.", element2DescriptionGUID);
        elementDefs.add(elementDef);
        int element3Ordinal = 3;
        String element3Value = "Imported";
        String element3Description = "The membership was imported from another metadata system.";
        String element3DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(3, "Imported", "The membership was imported from another metadata system.", element3DescriptionGUID);
        elementDefs.add(elementDef);
        int element4Ordinal = 4;
        String element4Value = "Validated";
        String element4Description = "The membership created by an automated process has been validated and approved by an expert curator.";
        String element4DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(4, "Validated", "The membership created by an automated process has been validated and approved by an expert curator.", element4DescriptionGUID);
        elementDefs.add(elementDef);
        int element5Ordinal = 5;
        String element5Value = "Deprecated";
        String element5Description = "The membership should no longer be used.";
        String element5DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(5, "Deprecated", "The membership should no longer be used.", element5DescriptionGUID);
        elementDefs.add(elementDef);
        int element6Ordinal = 6;
        String element6Value = "Obsolete";
        String element6Description = "The membership must no longer be used.";
        String element6DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(6, "Obsolete", "The membership must no longer be used.", element6DescriptionGUID);
        elementDefs.add(elementDef);
        int element99Ordinal = 99;
        String element99Value = "Other";
        String element99Description = "Another membership status.";
        String element99DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(99, "Other", "Another membership status.", element99DescriptionGUID);
        elementDefs.add(elementDef);
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private TypeDefPatch updateCollectionMembershipRelationship() {
        String typeName = "CollectionMembership";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("CollectionMembership");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "membershipRationale";
        String attribute1Description = "Description of how the member is used, or why it is useful in this collection.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "expression";
        String attribute2Description = "Expression describing the membership relationship.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "status";
        String attribute3Description = "The status of the membership relationship.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "confidence";
        String attribute4Description = "Level of confidence in the correctness of the membership relationship.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "steward";
        String attribute5Description = "Person responsible for the membership relationship.";
        String attribute5DescriptionGUID = null;
        String attribute6Name = "source";
        String attribute6Description = "Person, organization or automated process that created the membership relationship.";
        String attribute6DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("membershipRationale", "Description of how the member is used, or why it is useful in this collection.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("expression", "Expression describing the membership relationship.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("MembershipStatus", "status", "The status of the membership relationship.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute("confidence", "Level of confidence in the correctness of the membership relationship.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("steward", "Person responsible for the membership relationship.", attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("source", "Person, organization or automated process that created the membership relationship.", attribute6DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0137ToDos() {
        this.archiveBuilder.addTypeDefPatch(this.updateActionTargetRelationship());
    }

    private TypeDefPatch updateActionTargetRelationship() {
        String typeName = "ActionTarget";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ActionTarget");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "status";
        String attribute1Description = "The status of the work on this element.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "startDate";
        String attribute2Description = "Date/time that work started on this element.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "completionDate";
        String attribute3Description = "Date/time that work stopped on this element.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "actionTargetName";
        String attribute4Description = "The name to identify the action target to the actor that processes it.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "completionMessage";
        String attribute5Description = "Message to provide additional information on the results of acting on the target by the actor or the reasons for any failures.";
        String attribute5DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute("ToDoStatus", "status", "The status of the work on this element.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("startDate", "Date/time that work started on this element.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("completionDate", "Date/time that work stopped on this element.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("actionTargetName", "The name to identify the action target to the actor that processes it.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("completionMessage", "Message to provide additional information on the results of acting on the target by the actor or the reasons for any failures.", attribute5DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void add0220DataFileCollectionDataSet() {
        this.archiveBuilder.addEntityDef(this.getDataFileCollectionDataSetEntity());
    }

    private EntityDef getDataFileCollectionDataSetEntity() {
        String guid = "962de053-ab51-40eb-b843-85b98013f5ca";
        String name = "DataFileCollection";
        String description = "A data set that consists of a collection files (do not need to be co-located).";
        String descriptionGUID = null;
        String superTypeName = "DataSet";
        return this.archiveHelper.getDefaultEntityDef("962de053-ab51-40eb-b843-85b98013f5ca", "DataFileCollection", this.archiveBuilder.getEntityDef("DataSet"), "A data set that consists of a collection files (do not need to be co-located).", descriptionGUID);
    }

    private void add0224TableDataSet() {
        this.archiveBuilder.addEntityDef(this.getTableDataSetEntity());
    }

    private EntityDef getTableDataSetEntity() {
        String guid = "20c45531-5d2e-4eb6-9a47-035cb1067b82";
        String name = "TableDataSet";
        String description = "A tabular data source (typically a database table) that is an asset in its own right.";
        String descriptionGUID = null;
        String superTypeName = "DataSet";
        return this.archiveHelper.getDefaultEntityDef("20c45531-5d2e-4eb6-9a47-035cb1067b82", "TableDataSet", this.archiveBuilder.getEntityDef("DataSet"), "A tabular data source (typically a database table) that is an asset in its own right.", descriptionGUID);
    }

    private void add0239DeployedReportType() {
        this.archiveBuilder.addEntityDef(this.getDeployedReportTypeEntity());
    }

    private EntityDef getDeployedReportTypeEntity() {
        String guid = "ed53a480-e6d4-44f1-aac7-3fac60bbb00e";
        String name = "DeployedReportType";
        String description = "A template for generating report.";
        String descriptionGUID = null;
        String superTypeName = "Asset";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("ed53a480-e6d4-44f1-aac7-3fac60bbb00e", "DeployedReportType", this.archiveBuilder.getEntityDef("Asset"), "A template for generating report.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "id";
        String attribute1Description = "Id of report.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "author";
        String attribute2Description = "Author of the report.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "url";
        String attribute3Description = "url of the report.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "createdTime";
        String attribute4Description = "Report create time.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "lastModifiedTime";
        String attribute5Description = "Report last modified time.";
        String attribute5DescriptionGUID = null;
        String attribute6Name = "lastModifier";
        String attribute6Description = "Report last modifier.";
        String attribute6DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("id", "Id of report.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("author", "Author of the report.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("url", "url of the report.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("createdTime", "Report create time.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("lastModifiedTime", "Report last modified time.", attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("lastModifier", "Report last modifier.", attribute6DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private void update0462GovernanceActionType() {
        this.archiveBuilder.addTypeDefPatch(this.update0462GovernanceActionTypeExecutorRelationship());
    }

    private TypeDefPatch update0462GovernanceActionTypeExecutorRelationship() {
        String typeName = "GovernanceActionTypeExecutor";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("GovernanceActionTypeExecutor");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "requestParameterFilter";
        String attribute1Description = "Which requestParameters to remove before calling governance action.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "requestParameterMap";
        String attribute2Description = "The request parameters to rename before calling the governance action. Map is from old name to new name.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "actionTargetFilter";
        String attribute3Description = "Which actionTargets to remove before calling governance action.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "actionTargetMap";
        String attribute4Description = "The action target to rename before calling the governance action. Map is from old name to new name.";
        String attribute4DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getArrayStringTypeDefAttribute("requestParameterFilter", "Which requestParameters to remove before calling governance action.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute("requestParameterMap", "The request parameters to rename before calling the governance action. Map is from old name to new name.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute("actionTargetFilter", "Which actionTargets to remove before calling governance action.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute("actionTargetMap", "The action target to rename before calling the governance action. Map is from old name to new name.", attribute4DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void create0464DynamicIntegrationGroups() {
        this.archiveBuilder.addEntityDef(this.addIntegrationGroupEntity());
        this.archiveBuilder.addEntityDef(this.addIntegrationConnectorEntity());
        this.archiveBuilder.addEntityDef(this.addIntegrationReportEntity());
        this.archiveBuilder.addRelationshipDef(this.addRegisteredIntegrationConnectorRelationship());
        this.archiveBuilder.addRelationshipDef(this.addCatalogTargetRelationship());
        this.archiveBuilder.addRelationshipDef(this.addRelatedIntegrationReportRelationship());
    }

    private EntityDef addIntegrationGroupEntity() {
        String guid = "4d7c43ec-983b-40e4-af78-6fb66c4f5136";
        String name = "IntegrationGroup";
        String description = "A collection of integration connectors to run together.";
        String descriptionGUID = null;
        String superTypeName = "SoftwareServerCapability";
        return this.archiveHelper.getDefaultEntityDef("4d7c43ec-983b-40e4-af78-6fb66c4f5136", "IntegrationGroup", this.archiveBuilder.getEntityDef("SoftwareServerCapability"), "A collection of integration connectors to run together.", descriptionGUID);
    }

    private EntityDef addIntegrationConnectorEntity() {
        String guid = "759da11b-ebb6-4382-bdc9-72adc7c922db";
        String name = "IntegrationConnector";
        String description = "A definition to control the execution of an integration connector.";
        String descriptionGUID = null;
        String superTypeName = "DeployedConnector";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("759da11b-ebb6-4382-bdc9-72adc7c922db", "IntegrationConnector", this.archiveBuilder.getEntityDef("DeployedConnector"), "A definition to control the execution of an integration connector.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "usesBlockingCalls";
        String attribute1Description = "The integration connector needs to use blocking calls to a third party technology and so needs to run in its own thread.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getBooleanTypeDefAttribute("usesBlockingCalls", "The integration connector needs to use blocking calls to a third party technology and so needs to run in its own thread.", attribute1DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef addIntegrationReportEntity() {
        String guid = "b8703d3f-8668-4e6a-bf26-27db1607220d";
        String name = "IntegrationReport";
        String description = "Details of the metadata changes made by the execution of the refresh() method by an integration connector.";
        String descriptionGUID = null;
        String superTypeName = "OpenMetadataRoot";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("b8703d3f-8668-4e6a-bf26-27db1607220d", "IntegrationReport", this.archiveBuilder.getEntityDef("OpenMetadataRoot"), "Details of the metadata changes made by the execution of the refresh() method by an integration connector.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "connectorName";
        String attribute1Description = "Name of the integration connector for logging purposes.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "connectorId";
        String attribute2Description = "Unique identifier of the integration connector deployment.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "serverName";
        String attribute3Description = "Name of the integration daemon where the integration connector is/was running.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "refreshStartDate";
        String attribute4Description = "Date/time when the refresh() call was made.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "refreshCompletionDate";
        String attribute5Description = "Date/time when the integration connector returned from the refresh() call.";
        String attribute5DescriptionGUID = null;
        String attribute6Name = "createdElements";
        String attribute6Description = "List of elements that were created.";
        String attribute6DescriptionGUID = null;
        String attribute7Name = "updatedElements";
        String attribute7Description = "List of elements that were updated.";
        String attribute7DescriptionGUID = null;
        String attribute8Name = "deletedElements";
        String attribute8Description = "List of elements that were deleted.";
        String attribute8DescriptionGUID = null;
        String attribute9Name = "additionalProperties";
        String attribute9Description = "Additional properties of importance to the integration connector.";
        String attribute9DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("connectorName", "Name of the integration connector for logging purposes.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("connectorId", "Unique identifier of the integration connector deployment.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("serverName", "Name of the integration daemon where the integration connector is/was running.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("refreshStartDate", "Date/time when the refresh() call was made.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("refreshCompletionDate", "Date/time when the integration connector returned from the refresh() call.", attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute("createdElements", "List of elements that were created.", attribute6DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute("updatedElements", "List of elements that were updated.", attribute7DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute("deletedElements", "List of elements that were deleted.", attribute8DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute("additionalProperties", "Additional properties of importance to the integration connector.", attribute9DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef addRegisteredIntegrationConnectorRelationship() {
        String guid = "7528bcd4-ae4c-47d0-a33f-4aeebbaa92c2";
        String name = "RegisteredIntegrationConnector";
        String description = "A link between an integration group and an integration connector that is part of the group.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("7528bcd4-ae4c-47d0-a33f-4aeebbaa92c2", "RegisteredIntegrationConnector", null, "A link between an integration group and an integration connector that is part of the group.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "IntegrationGroup";
        String end1AttributeName = "includedInIntegrationGroups";
        String end1AttributeDescription = "An integration group that this integration connector is a member of.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("IntegrationGroup"), "includedInIntegrationGroups", "An integration group that this integration connector is a member of.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "IntegrationConnector";
        String end2AttributeName = "registeredIntegrationConnectors";
        String end2AttributeDescription = "An integration connector that should run as part of the integration group.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("IntegrationConnector"), "registeredIntegrationConnectors", "An integration connector that should run as part of the integration group.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "connectorName";
        String attribute1Description = "Name of the connector for logging purposes.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "connectorUserId";
        String attribute2Description = "UserId for the integration connector to use when working with open metadata.  The default userId comes from the hosting server if this value is blank.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "metadataSourceQualifiedName";
        String attribute3Description = "Qualified name of a software server capability that is the owner/home of the metadata catalogued by the integration connector.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "startDate";
        String attribute4Description = "Earliest time that the connector can run.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "stopTime";
        String attribute5Description = "Latest time that the connector can run.";
        String attribute5DescriptionGUID = null;
        String attribute6Name = "refreshTimeInterval";
        String attribute6Description = "Describes how frequently the integration connector should run - in minutes.";
        String attribute6DescriptionGUID = null;
        String attribute7Name = "permittedSynchronization";
        String attribute7Description = "Defines the permitted directions of flow of metadata updates between open metadata and a third party technology.";
        String attribute7DescriptionGUID = null;
        String attribute8Name = "generateIntegrationReport";
        String attribute8Description = "Should the integration daemon create integration reports based on the integration connector's activity? (Default is true.)";
        String attribute8DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("connectorName", "Name of the connector for logging purposes.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("connectorUserId", "UserId for the integration connector to use when working with open metadata.  The default userId comes from the hosting server if this value is blank.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("metadataSourceQualifiedName", "Qualified name of a software server capability that is the owner/home of the metadata catalogued by the integration connector.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("startDate", "Earliest time that the connector can run.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("stopTime", "Latest time that the connector can run.", attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getLongTypeDefAttribute("refreshTimeInterval", "Describes how frequently the integration connector should run - in minutes.", attribute6DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("PermittedSynchronization", "permittedSynchronization", "Defines the permitted directions of flow of metadata updates between open metadata and a third party technology.", attribute7DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getBooleanTypeDefAttribute("generateIntegrationReport", "Should the integration daemon create integration reports based on the integration connector's activity? (Default is true.)", attribute8DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef addCatalogTargetRelationship() {
        String guid = "bc5a5eb1-881b-4055-aa2c-78f314282ac2";
        String name = "CatalogTarget";
        String description = "Identifies an element that an integration connector is to work with.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("bc5a5eb1-881b-4055-aa2c-78f314282ac2", "CatalogTarget", null, "Identifies an element that an integration connector is to work with.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "IntegrationConnector";
        String end1AttributeName = "cataloguedByConnectors";
        String end1AttributeDescription = "An integration connector managing metadata synchronization.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("IntegrationConnector"), "cataloguedByConnectors", "An integration connector managing metadata synchronization.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "OpenMetadataRoot";
        String end2AttributeName = "catalogTargets";
        String end2AttributeDescription = "An open metadata element that the integration connector is working on.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("OpenMetadataRoot"), "catalogTargets", "An open metadata element that the integration connector is working on.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "catalogTargetName";
        String attribute1Description = "Symbolic name of the catalog target to help the integration connector to choose when to use it.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("catalogTargetName", "Symbolic name of the catalog target to help the integration connector to choose when to use it.", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef addRelatedIntegrationReportRelationship() {
        String guid = "83d12156-f8f3-4b4b-b31b-18c140df9aa3";
        String name = "RelatedIntegrationReport";
        String description = "Links an integration report to the anchor entity it describes.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("83d12156-f8f3-4b4b-b31b-18c140df9aa3", "RelatedIntegrationReport", null, "Links an integration report to the anchor entity it describes.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "OpenMetadataRoot";
        String end1AttributeName = "anchorSubject";
        String end1AttributeDescription = "The anchor entity that the integration report describes.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("OpenMetadataRoot"), "anchorSubject", "The anchor entity that the integration report describes.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "IntegrationReport";
        String end2AttributeName = "integrationReports";
        String end2AttributeDescription = "A description of the changes made to the anchor entity by an integration report.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("IntegrationReport"), "integrationReports", "A description of the changes made to the anchor entity by an integration report.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void update0545ReferenceData() {
        this.archiveBuilder.addTypeDefPatch(this.updateReferenceValueAssignment());
    }

    private TypeDefPatch updateReferenceValueAssignment() {
        String typeName = "ReferenceValueAssignment";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ReferenceValueAssignment");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "attributeName";
        String attribute1Description = "The name of the attribute that the reference data assignment represents.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("attributeName", "The name of the attribute that the reference data assignment represents.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void addFormulaTypeAttribute() {
        this.archiveBuilder.addTypeDefPatch(this.updateDataSet());
        this.archiveBuilder.addTypeDefPatch(this.updateProcess());
        this.archiveBuilder.addTypeDefPatch(this.updateCalculatedValue());
        this.archiveBuilder.addTypeDefPatch(this.updateProcessCall());
        this.archiveBuilder.addTypeDefPatch(this.updateDataFlow());
    }

    private TypeDefPatch updateDataSet() {
        String typeName = "DataSet";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("DataSet");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "formulaType";
        String attribute1Description = "Format of the expression provided in the formula attribute.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("formulaType", "Format of the expression provided in the formula attribute.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateProcess() {
        String typeName = "Process";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("Process");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "formulaType";
        String attribute1Description = "Format of the expression provided in the formula attribute.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("formulaType", "Format of the expression provided in the formula attribute.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateCalculatedValue() {
        String typeName = "CalculatedValue";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("CalculatedValue");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "formulaType";
        String attribute1Description = "Format of the expression provided in the formula attribute.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("formulaType", "Format of the expression provided in the formula attribute.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateProcessCall() {
        String typeName = "ProcessCall";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ProcessCall");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "formulaType";
        String attribute1Description = "Format of the expression provided in the formula attribute.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("formulaType", "Format of the expression provided in the formula attribute.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateDataFlow() {
        String typeName = "DataFlow";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("DataFlow");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "formulaType";
        String attribute1Description = "Format of the expression provided in the formula attribute.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("formulaType", "Format of the expression provided in the formula attribute.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0470IncidentClassifierSet() {
        this.archiveBuilder.addTypeDefPatch(this.updateIncidentClassifierSetClassification());
    }

    private TypeDefPatch updateIncidentClassifierSetClassification() {
        String typeName = "IncidentClassifierSet";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("IncidentClassifierSet");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "incidentClassifierCategory";
        String attribute1Description = "The category of classifiers used to set the incidentClassifiers in IncidentReport.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("incidentClassifierCategory", "The category of classifiers used to set the incidentClassifiers in IncidentReport.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0484AgreementActor() {
        this.archiveBuilder.addTypeDefPatch(this.updateAgreementActorRelationship());
    }

    private TypeDefPatch updateAgreementActorRelationship() {
        String typeName = "AgreementActor";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("AgreementActor");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setUpdateMultiLink(true);
        typeDefPatch.setMultiLink(true);
        return typeDefPatch;
    }

    private void update0720InformationSupplyChains() {
        this.archiveBuilder.addRelationshipDef(this.getInformationSupplyChainLinkRelationship());
    }

    private RelationshipDef getInformationSupplyChainLinkRelationship() {
        String guid = "207e5130-ab7c-4048-9249-a63a43c13d60";
        String name = "InformationSupplyChainLink";
        String description = "A link between two related information supply chain segments -or to their source or destination.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("207e5130-ab7c-4048-9249-a63a43c13d60", "InformationSupplyChainLink", null, "A link between two related information supply chain segments -or to their source or destination.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "Referenceable";
        String end1AttributeName = "supplyFrom";
        String end1AttributeDescription = "Logical source of the information supply chain.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Referenceable"), "supplyFrom", "Logical source of the information supply chain.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "Referenceable";
        String end2AttributeName = "supplyTo";
        String end2AttributeDescription = "Logical destination of an information supply chain.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Referenceable"), "supplyTo", "Logical destination of an information supply chain.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "description";
        String attribute1Description = "Description of the relationship.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("description", "Description of the relationship.", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }
}

