/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class PrimitivePropertyValue
extends InstancePropertyValue {
    private static final long serialVersionUID = 1L;
    private PrimitiveDefCategory primitiveDefCategory = null;
    private Object primitiveValue = null;

    public PrimitivePropertyValue() {
        super(InstancePropertyCategory.PRIMITIVE);
    }

    public PrimitivePropertyValue(PrimitivePropertyValue template) {
        super(template);
        if (template != null) {
            this.primitiveDefCategory = template.getPrimitiveDefCategory();
            this.primitiveValue = template.getPrimitiveValue();
        }
    }

    @Override
    public InstancePropertyValue cloneFromSubclass() {
        return new PrimitivePropertyValue(this);
    }

    @Override
    public String valueAsString() {
        return this.primitiveValue == null ? "<null>" : this.primitiveValue.toString();
    }

    @Override
    public Object valueAsObject() {
        return this.primitiveValue;
    }

    public PrimitiveDefCategory getPrimitiveDefCategory() {
        return this.primitiveDefCategory;
    }

    public void setPrimitiveDefCategory(PrimitiveDefCategory primitiveDefCategory) {
        this.primitiveValue = this.validateValueAgainstType(primitiveDefCategory, this.primitiveValue);
        this.primitiveDefCategory = primitiveDefCategory;
    }

    public Object getPrimitiveValue() {
        return this.primitiveValue;
    }

    public void setPrimitiveValue(Object primitiveValue) {
        this.primitiveValue = this.validateValueAgainstType(this.primitiveDefCategory, primitiveValue);
    }

    @Override
    public String toString() {
        return "PrimitivePropertyValue{primitiveValue=" + this.primitiveValue + ", primitiveDefCategory=" + this.primitiveDefCategory + ", instancePropertyCategory=" + this.getInstancePropertyCategory() + ", typeGUID='" + this.getTypeGUID() + "', typeName='" + this.getTypeName() + "'}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof PrimitivePropertyValue)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        PrimitivePropertyValue that = (PrimitivePropertyValue)objectToCompare;
        if (this.primitiveDefCategory != that.primitiveDefCategory) {
            return false;
        }
        return this.primitiveValue != null ? this.primitiveValue.equals(that.primitiveValue) : that.primitiveValue == null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getPrimitiveDefCategory(), this.getPrimitiveValue());
    }

    private Object validateValueAgainstType(PrimitiveDefCategory primitiveDefCategory, Object primitiveValue) {
        String methodName = "validateValueAgainstType";
        if (primitiveDefCategory == null || primitiveValue == null) {
            return primitiveValue;
        }
        try {
            Class<?> testJavaClass = Class.forName(primitiveDefCategory.getJavaClassName());
            if (!testJavaClass.isInstance(primitiveValue)) {
                if (primitiveDefCategory == PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE) {
                    if (primitiveValue instanceof Integer) {
                        Integer castValue = (Integer)primitiveValue;
                        return castValue.longValue();
                    }
                    throw new OMRSLogicErrorException(OMRSErrorCode.INVALID_PRIMITIVE_TYPE.getMessageDefinition("OM_PRIMITIVE_TYPE_DATE", primitiveDefCategory.getJavaClassName(), primitiveValue.getClass().getName()), this.getClass().getName(), "validateValueAgainstType");
                }
                if (primitiveDefCategory == PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BIGDECIMAL) {
                    Integer castValue = (Integer)primitiveValue;
                    return new BigDecimal(castValue);
                }
                if (primitiveDefCategory == PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BIGINTEGER) {
                    Long castValue = (Long)primitiveValue;
                    return new BigInteger(castValue.toString());
                }
                if (primitiveDefCategory == PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BYTE) {
                    Integer castValue = (Integer)primitiveValue;
                    return new Byte(castValue.toString());
                }
                if (primitiveDefCategory == PrimitiveDefCategory.OM_PRIMITIVE_TYPE_CHAR) {
                    String castValue = (String)primitiveValue;
                    return Character.valueOf(castValue.charAt(0));
                }
                if (primitiveDefCategory == PrimitiveDefCategory.OM_PRIMITIVE_TYPE_FLOAT) {
                    Double castValue = (Double)primitiveValue;
                    return new Float(castValue);
                }
                if (primitiveDefCategory == PrimitiveDefCategory.OM_PRIMITIVE_TYPE_LONG) {
                    Integer castValue = (Integer)primitiveValue;
                    return new Long(castValue.intValue());
                }
                if (primitiveDefCategory == PrimitiveDefCategory.OM_PRIMITIVE_TYPE_SHORT) {
                    Integer castValue = (Integer)primitiveValue;
                    return new Short(castValue.toString());
                }
                throw new OMRSLogicErrorException(OMRSErrorCode.INVALID_PRIMITIVE_VALUE.getMessageDefinition(primitiveDefCategory.getJavaClassName(), primitiveValue.getClass().getName(), primitiveDefCategory.getName()), this.getClass().getName(), "validateValueAgainstType");
            }
        }
        catch (ClassNotFoundException unknownPrimitiveClass) {
            throw new OMRSLogicErrorException(OMRSErrorCode.INVALID_PRIMITIVE_CLASS_NAME.getMessageDefinition(primitiveDefCategory.getJavaClassName(), primitiveDefCategory.getName()), this.getClass().getName(), "validateValueAgainstType", unknownPrimitiveClass);
        }
        catch (Error invalidPrimitiveCategory) {
            throw new OMRSLogicErrorException(OMRSErrorCode.INVALID_PRIMITIVE_CATEGORY.getMessageDefinition(primitiveDefCategory.getName()), this.getClass().getName(), "validateValueAgainstType", invalidPrimitiveCategory);
        }
        return primitiveValue;
    }
}

