/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive3_14;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttributeStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive3_15 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "3.15";
    private static final String originatorName = "Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive3_15() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive3_15(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive3_14 previousTypes = new OpenMetadataTypesArchive3_14(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.updateGovernanceEngines();
        this.updateGovernanceActionTypes();
        this.updateGovernanceActions();
        this.update0710DigitalServices();
        this.update0715DigitalServiceOwnership();
        this.update0735SolutionPortsAndWires();
    }

    private void updateGovernanceEngines() {
        this.archiveBuilder.addTypeDefPatch(this.updateSupportedGovernanceServiceRelationship());
    }

    private TypeDefPatch updateSupportedGovernanceServiceRelationship() {
        String typeName = "SupportedGovernanceService";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("SupportedGovernanceService");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "serviceRequestType";
        String attribute1Description = "Request type supported by the governance action service (overrides requestType on call to governance service if specified).";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("serviceRequestType", "Request type supported by the governance action service (overrides requestType on call to governance service if specified).", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void updateGovernanceActionTypes() {
        this.archiveBuilder.addTypeDefPatch(this.updateGovernanceActionTypeEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateNextGovernanceActionTypeRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateNextGovernanceActionRelationship());
    }

    private TypeDefPatch updateGovernanceActionTypeEntity() {
        String typeName = "GovernanceActionType";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("GovernanceActionType");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "waitTime";
        String attribute1Description = "The minimum number of minutes that the governance engine should wait before calling the governance service.";
        String attribute1DescriptionGUID = null;
        String attribute3Name = "ignoreMultipleTriggers";
        String attribute3Description = "Trigger one or many governance action instances?";
        String attribute3DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute("waitTime", "The minimum number of minutes that the governance engine should wait before calling the governance service.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getBooleanTypeDefAttribute("ignoreMultipleTriggers", "Trigger one or many governance action instances?", attribute3DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateNextGovernanceActionTypeRelationship() {
        String typeName = "NextGovernanceActionType";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("NextGovernanceActionType");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute3Name = "ignoreMultipleTriggers";
        String attribute3Description = "Trigger one or many next action instances? (deprecated)";
        String attribute3DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getBooleanTypeDefAttribute("ignoreMultipleTriggers", "Trigger one or many next action instances? (deprecated)", attribute3DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateNextGovernanceActionRelationship() {
        String typeName = "NextGovernanceAction";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("NextGovernanceAction");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute3Name = "ignoreMultipleTriggers";
        String attribute3Description = "Trigger one or many next action instances? (deprecated)";
        String attribute3DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getBooleanTypeDefAttribute("ignoreMultipleTriggers", "Trigger one or many next action instances? (deprecated)", attribute3DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void updateGovernanceActions() {
        this.archiveBuilder.addTypeDefPatch(this.updateGovernanceActionEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateTargetForActionRelationship());
    }

    private TypeDefPatch updateGovernanceActionEntity() {
        String typeName = "GovernanceAction";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("GovernanceAction");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "completionMessage";
        String attribute1Description = "Message to provide additional information on the results of running the governance service or the reasons for its failure.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("completionMessage", "Message to provide additional information on the results of running the governance service or the reasons for its failure.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateTargetForActionRelationship() {
        String typeName = "TargetForAction";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("TargetForAction");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "completionMessage";
        String attribute1Description = "Message to provide additional information on the results of acting on the target by the governance service or the reasons for any failures.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("completionMessage", "Message to provide additional information on the results of acting on the target by the governance service or the reasons for any failures.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0710DigitalServices() {
        this.archiveBuilder.addRelationshipDef(this.getDigitalServiceProductRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateDigitalProductClassification());
    }

    private RelationshipDef getDigitalServiceProductRelationship() {
        String guid = "51465a59-c785-406d-929c-def34596e9af";
        String name = "DigitalServiceProduct";
        String description = "A digital product that is maintained by a digital service.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("51465a59-c785-406d-929c-def34596e9af", "DigitalServiceProduct", null, "A digital product that is maintained by a digital service.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "DigitalService";
        String end1AttributeName = "managingDigitalService";
        String end1AttributeDescription = "Digital service responsible for the production of the digital product.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("DigitalService"), "managingDigitalService", "Digital service responsible for the production of the digital product.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "Referenceable";
        String end2AttributeName = "digitalProducts";
        String end2AttributeDescription = "The associated digital products.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Referenceable"), "digitalProducts", "The associated digital products.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private TypeDefPatch updateDigitalProductClassification() {
        String typeName = "DigitalProduct";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("DigitalProduct");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "syncDatesByKey";
        String attribute1Description = "Collection of synchronization dates identified by a key (deprecated, added in error).";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "productName";
        String attribute2Description = "Display name of the product.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "productType";
        String attribute3Description = "Type or category of the product.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "introductionDate";
        String attribute4Description = "Date that the product was made available.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "maturity";
        String attribute5Description = "Level of maturity for the product.";
        String attribute5DescriptionGUID = null;
        String attribute6Name = "serviceLife";
        String attribute6Description = "Length of time that the product is expected to be in service.";
        String attribute6DescriptionGUID = null;
        String attribute7Name = "currentVersion";
        String attribute7Description = "Which is the current supported version that is recommended for consumers.";
        String attribute7DescriptionGUID = null;
        String attribute8Name = "nextVersion";
        String attribute8Description = "When is the next version expected to be released.";
        String attribute8DescriptionGUID = null;
        String attribute9Name = "withdrawDate";
        String attribute9Description = "What date what the product withdrawn, preventing new consumers.";
        String attribute9DescriptionGUID = null;
        String attribute10Name = "additionalProperties";
        String attribute10Description = "Any additional properties needed to describe the product.";
        String attribute10DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getMapStringLongTypeDefAttribute("syncDatesByKey", "Collection of synchronization dates identified by a key (deprecated, added in error).", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("productName", "Display name of the product.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("productType", "Type or category of the product.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("introductionDate", "Date that the product was made available.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("maturity", "Level of maturity for the product.", attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("serviceLife", "Length of time that the product is expected to be in service.", attribute6DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("currentVersion", "Which is the current supported version that is recommended for consumers.", attribute7DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("nextVersion", "When is the next version expected to be released.", attribute8DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("withdrawDate", "What date what the product withdrawn, preventing new consumers.", attribute9DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute("additionalProperties", "Any additional properties needed to describe the product.", attribute10DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0715DigitalServiceOwnership() {
        this.archiveBuilder.addTypeDefPatch(this.updateDigitalServiceOperatorRelationship());
    }

    private TypeDefPatch updateDigitalServiceOperatorRelationship() {
        String typeName = "DigitalServiceOperator";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("DigitalServiceOperator");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end2EntityType = "Referenceable";
        String end2AttributeName = "digitalServiceOperators";
        String end2AttributeDescription = "The unit (team, capability, ...) responsible for managing this digital service.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Referenceable"), "digitalServiceOperators", "The unit (team, capability, ...) responsible for managing this digital service.", end2AttributeDescriptionGUID, end2Cardinality);
        typeDefPatch.setEndDef2(relationshipEndDef);
        return typeDefPatch;
    }

    private void update0735SolutionPortsAndWires() {
        this.archiveBuilder.addTypeDefPatch(this.updateSolutionLinkingWireRelationship());
    }

    private TypeDefPatch updateSolutionLinkingWireRelationship() {
        String typeName = "DigitalServiceOperator";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("DigitalServiceOperator");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end2EntityType = "Referenceable";
        String end2AttributeName = "digitalServiceOperators";
        String end2AttributeDescription = "The unit (team, capability, ...) responsible for managing this digital service.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Referenceable"), "digitalServiceOperators", "The unit (team, capability, ...) responsible for managing this digital service.", end2AttributeDescriptionGUID, end2Cardinality);
        typeDefPatch.setEndDef2(relationshipEndDef);
        return typeDefPatch;
    }
}

