/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.omrstopic;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLoggingComponent;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBase;
import org.odpi.openmetadata.frameworks.connectors.VirtualConnectorExtension;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditingComponent;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopic;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListenerWrapper;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicRepositoryEventListener;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicListener;
import org.odpi.openmetadata.repositoryservices.events.OMRSEventProtocolVersion;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSRegistryEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSTypeDefEvent;
import org.odpi.openmetadata.repositoryservices.events.beans.OMRSEventBean;
import org.odpi.openmetadata.repositoryservices.events.beans.v1.OMRSEventV1;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSAuditCode;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRSTopicConnector
extends ConnectorBase
implements OMRSTopic,
VirtualConnectorExtension,
OpenMetadataTopicListener,
AuditLoggingComponent {
    private static final Logger log = LoggerFactory.getLogger(OMRSTopicConnector.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final ObjectReader OBJECT_READER = OBJECT_MAPPER.reader();
    private static final ObjectWriter OBJECT_WRITER = OBJECT_MAPPER.writer();
    private static final String unknownTopicName = "<Unknown>";
    private List<Connector> embeddedConnectors = null;
    private final List<OMRSTopicListener> internalTopicListeners = new ArrayList<OMRSTopicListener>();
    private final List<OpenMetadataTopicConnector> eventBusConnectors = new ArrayList<OpenMetadataTopicConnector>();
    private String connectionName = OMRSAuditingComponent.OMRS_TOPIC_CONNECTOR.getComponentName();
    private String topicName = "<Unknown>";
    private OMRSEventProtocolVersion eventProtocolVersion = OMRSEventProtocolVersion.V1;
    protected AuditLog auditLog = null;

    @Override
    public void initializeEmbeddedConnectors(List<Connector> embeddedConnectors) {
        this.embeddedConnectors = embeddedConnectors;
    }

    @Override
    public void setAuditLog(AuditLog auditLog) {
        this.auditLog = auditLog;
    }

    @Override
    public ComponentDescription getConnectorComponentDescription() {
        if (this.auditLog != null && this.auditLog.getReport() != null) {
            return this.auditLog.getReport().getReportingComponent();
        }
        return null;
    }

    @Override
    public void setEventProtocolLevel(OMRSEventProtocolVersion eventProtocolVersion) {
        if (eventProtocolVersion != null) {
            this.eventProtocolVersion = eventProtocolVersion;
        }
    }

    @Override
    @Deprecated
    public void registerListener(OMRSTopicListener topicListener) {
        if (topicListener == null) {
            String methodName = "registerListener";
            throw new OMRSLogicErrorException(OMRSErrorCode.NULL_OPEN_METADATA_TOPIC_LISTENER.getMessageDefinition(this.connectionName), this.getClass().getName(), "registerListener");
        }
        this.internalTopicListeners.add(new OMRSTopicListenerWrapper(topicListener, this.auditLog));
    }

    @Override
    public void registerListener(OMRSTopicListener topicListener, String serviceName) {
        if (topicListener == null) {
            String methodName = "registerListener";
            throw new OMRSLogicErrorException(OMRSErrorCode.NULL_OPEN_METADATA_TOPIC_LISTENER.getMessageDefinition(this.connectionName), this.getClass().getName(), "registerListener");
        }
        this.internalTopicListeners.add(new OMRSTopicListenerWrapper(topicListener, serviceName, this.auditLog.createNewAuditLog(OMRSAuditingComponent.ENTERPRISE_TOPIC_LISTENER)));
    }

    @Override
    public void registerListener(OMRSTopicRepositoryEventListener topicListener, String serviceName) {
        if (topicListener == null) {
            String methodName = "registerListener";
            throw new OMRSLogicErrorException(OMRSErrorCode.NULL_OPEN_METADATA_TOPIC_LISTENER.getMessageDefinition(this.connectionName), this.getClass().getName(), "registerListener");
        }
        this.internalTopicListeners.add(new OMRSTopicListenerWrapper(topicListener, serviceName, this.auditLog.createNewAuditLog(OMRSAuditingComponent.ENTERPRISE_TOPIC_LISTENER)));
    }

    @Override
    public void start() throws ConnectorCheckedException {
        super.start();
        String methodName = "start";
        this.connectionName = OMRSAuditingComponent.OMRS_TOPIC_CONNECTOR.getComponentName();
        log.debug("Initializing OMRSTopicConnector: " + this.connectionName);
        if (this.embeddedConnectors != null) {
            log.debug("OMRSTopicConnector: " + this.connectionName + " supplied with " + this.embeddedConnectors.size() + " embedded connectors");
            for (Connector embeddedConnector : this.embeddedConnectors) {
                if (embeddedConnector == null || !(embeddedConnector instanceof OpenMetadataTopicConnector)) continue;
                OpenMetadataTopicConnector realTopicConnector = (OpenMetadataTopicConnector)embeddedConnector;
                if (this.auditLog != null) {
                    realTopicConnector.setAuditLog(this.auditLog.createNewAuditLog(OMRSAuditingComponent.OPEN_METADATA_TOPIC_CONNECTOR));
                }
                this.topicName = realTopicConnector.registerListener(this);
                this.eventBusConnectors.add(realTopicConnector);
                if (this.auditLog == null) continue;
                this.auditLog.logMessage("start", OMRSAuditCode.OMRS_TOPIC_LISTENER_REGISTERED.getMessageDefinition(this.topicName), this.getConnection().toString());
            }
        }
        if (this.eventBusConnectors.isEmpty()) {
            if (this.auditLog != null) {
                this.auditLog.logMessage("start", OMRSAuditCode.OMRS_TOPIC_LISTENER_DEAF.getMessageDefinition(), this.getConnection().toString());
            }
            throw new ConnectorCheckedException(OMRSErrorCode.NO_EVENT_BUS_CONNECTORS.getMessageDefinition(this.connectionName), this.getClass().getName(), "start");
        }
        for (OpenMetadataTopicConnector eventBusConnector : this.eventBusConnectors) {
            eventBusConnector.start();
        }
        if (this.auditLog != null) {
            this.auditLog.logMessage("start", OMRSAuditCode.OMRS_TOPIC_LISTENER_STARTED.getMessageDefinition(this.topicName), this.getConnection().toString());
        }
    }

    private void handleUnsupportedEventVersion(String methodName) throws ConnectorCheckedException {
        log.debug("Unsupported Protocol: " + this.eventProtocolVersion);
        throw new ConnectorCheckedException(OMRSErrorCode.OMRS_UNSUPPORTED_EVENT_PROTOCOL.getMessageDefinition(this.connectionName, this.eventProtocolVersion.toString()), this.getClass().getName(), methodName);
    }

    @Override
    public CompletableFuture<Boolean> sendRegistryEvent(OMRSRegistryEvent registryEvent) throws ConnectorCheckedException {
        String methodName = "sendRegistryEvent";
        if (this.eventProtocolVersion == OMRSEventProtocolVersion.V1) {
            return this.sendEvent(registryEvent.getOMRSEventV1(), true);
        }
        this.handleUnsupportedEventVersion("sendRegistryEvent");
        return CompletableFuture.completedFuture(false);
    }

    @Override
    public CompletableFuture<Boolean> sendTypeDefEvent(OMRSTypeDefEvent typeDefEvent) throws ConnectorCheckedException {
        String methodName = "sendTypeDefEvent";
        if (this.eventProtocolVersion == OMRSEventProtocolVersion.V1) {
            return this.sendEvent(typeDefEvent.getOMRSEventV1(), false);
        }
        this.handleUnsupportedEventVersion("sendTypeDefEvent");
        return CompletableFuture.completedFuture(false);
    }

    @Override
    public void sendInstanceEvent(OMRSInstanceEvent instanceEvent) throws ConnectorCheckedException {
        String methodName = "sendInstanceEvent";
        if (this.eventProtocolVersion == OMRSEventProtocolVersion.V1) {
            this.sendEvent(instanceEvent.getOMRSEventV1(), true);
        } else {
            this.handleUnsupportedEventVersion("sendInstanceEvent");
        }
    }

    private CompletableFuture<Boolean> sendEvent(OMRSEventV1 event, boolean logEvent) {
        String methodName = "sendEvent";
        if (event != null) {
            return CompletableFuture.supplyAsync(() -> this.sendEventTask(event, logEvent));
        }
        log.debug("Unable to send null events");
        throw new OMRSLogicErrorException(OMRSErrorCode.OMRS_TOPIC_SEND_NULL_EVENT.getMessageDefinition(this.connectionName), this.getClass().getName(), "sendEvent");
    }

    private boolean sendEventTask(OMRSEventV1 event, boolean logEvent) {
        String methodName = "sendEventTask";
        try {
            String eventString = OBJECT_WRITER.writeValueAsString(event);
            if (this.auditLog != null && logEvent) {
                this.auditLog.logMessage("sendEventTask", OMRSAuditCode.OUTBOUND_TOPIC_EVENT.getMessageDefinition(event.getEventCategory().getName(), this.topicName), eventString);
            }
            for (OpenMetadataTopicConnector eventBusConnector : this.eventBusConnectors) {
                if (eventBusConnector == null) continue;
                eventBusConnector.sendEvent(eventString);
            }
        }
        catch (ConnectorCheckedException exc) {
            log.debug("Unable to send event: " + exc.getMessage());
            throw new CompletionException(exc);
        }
        catch (Exception exc) {
            log.debug("Unexpected error sending event: " + exc.getMessage());
            throw new CompletionException(exc);
        }
        return true;
    }

    @Override
    public void processEvent(String event) {
        String actionDescription = "Process an OMRS Event";
        String methodName = "processEvent";
        if (event != null) {
            OMRSEventBean eventBean;
            block9: {
                eventBean = null;
                try {
                    eventBean = OBJECT_READER.readValue(event, OMRSEventBean.class);
                }
                catch (Exception exception) {
                    if (this.auditLog == null) break block9;
                    this.auditLog.logException("Process an OMRS Event", OMRSAuditCode.EVENT_PARSING_ERROR.getMessageDefinition(event, exception.toString()), exception);
                }
            }
            if (eventBean instanceof OMRSEventV1) {
                OMRSEventBean finalEventBean = eventBean;
                for (OMRSTopicListener topicListener : this.internalTopicListeners) {
                    try {
                        this.processOMRSEvent((OMRSEventV1)finalEventBean, topicListener);
                    }
                    catch (Exception error) {
                        log.debug("Unable to pass event to one of the topic listeners");
                        if (this.auditLog == null) continue;
                        this.auditLog.logException("processEvent", OMRSAuditCode.EVENT_PROCESSING_ERROR.getMessageDefinition(event, error.toString(), topicListener.toString()), event, (Throwable)error);
                    }
                }
            }
        } else {
            log.debug("Unable to process null events");
            if (this.auditLog != null) {
                this.auditLog.logMessage("Process an OMRS Event", OMRSAuditCode.NULL_EVENT_TO_PROCESS.getMessageDefinition(this.connectionName));
            }
        }
    }

    private void processOMRSEvent(OMRSEventV1 event, OMRSTopicListener topicListener) {
        String actionDescription = "Process Incoming Event";
        if (event != null) {
            switch (event.getEventCategory()) {
                case REGISTRY: {
                    topicListener.processRegistryEvent(new OMRSRegistryEvent(event));
                    break;
                }
                case TYPEDEF: {
                    topicListener.processTypeDefEvent(new OMRSTypeDefEvent(event));
                    break;
                }
                case INSTANCE: {
                    topicListener.processInstanceEvent(new OMRSInstanceEvent(event));
                    break;
                }
                default: {
                    if (this.auditLog != null) {
                        this.auditLog.logMessage(actionDescription, OMRSAuditCode.PROCESS_UNKNOWN_EVENT.getMessageDefinition(), "event {" + event + "}");
                    }
                    log.debug("Unknown event received :|");
                    break;
                }
            }
        } else {
            if (this.auditLog != null) {
                this.auditLog.logMessage(actionDescription, OMRSAuditCode.NULL_OMRS_EVENT_RECEIVED.getMessageDefinition(this.topicName));
            }
            log.debug("Null OMRS Event received :(");
        }
    }

    @Override
    public void disconnect() throws ConnectorCheckedException {
        super.disconnect();
        String actionDescription = "Disconnect OMRS Topic Connector";
        for (OpenMetadataTopicConnector eventBusConnector : this.eventBusConnectors) {
            eventBusConnector.disconnect();
        }
        if (this.auditLog != null && !unknownTopicName.equals(this.topicName)) {
            this.auditLog.logMessage("Disconnect OMRS Topic Connector", OMRSAuditCode.OMRS_TOPIC_LISTENER_DISCONNECTED.getMessageDefinition(this.topicName), this.getConnection().toString());
        }
    }
}

