/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveGUIDMap;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.OpenMetadataArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumElementDef;

public class SimpleCatalogArchiveHelper {
    protected static final String guidMapFileNamePostFix = "GUIDMap.json";
    private static final String ANCHORS_CLASSIFICATION_NAME = "Anchors";
    private static final String ANCHOR_GUID_PROPERTY = "anchorGUID";
    private static final String CONNECTION_TYPE_NAME = "Connection";
    private static final String CONNECTOR_TYPE_TYPE_NAME = "ConnectorType";
    private static final String ENDPOINT_TYPE_NAME = "Endpoint";
    private static final String CONNECTION_CONNECTOR_TYPE_TYPE_NAME = "ConnectionConnectorType";
    private static final String CONNECTION_ENDPOINT_TYPE_NAME = "ConnectionEndpoint";
    private static final String CONNECTOR_CATEGORY_TYPE_NAME = "ConnectorCategory";
    private static final String CONNECTOR_TYPE_DIRECTORY_TYPE_NAME = "ConnectorTypeDirectory";
    private static final String CONNECTOR_IMPL_CHOICE_TYPE_NAME = "ConnectorImplementationChoice";
    private static final String LOCATION_TYPE_NAME = "Location";
    private static final String FIXED_LOCATION_CLASSIFICATION_NAME = "FixedLocation";
    private static final String SECURE_LOCATION_CLASSIFICATION_NAME = "SecureLocation";
    private static final String CYBER_LOCATION_CLASSIFICATION_NAME = "CyberLocation";
    private static final String MOBILE_ASSET_CLASSIFICATION_NAME = "MobileAsset";
    private static final String NESTED_LOCATION_RELATIONSHIP_NAME = "NestedLocation";
    private static final String ADJACENT_LOCATION_RELATIONSHIP_NAME = "AdjacentLocation";
    private static final String ASSET_LOCATION_RELATIONSHIP_NAME = "AssetLocation";
    private static final String COLLECTION_TYPE_NAME = "Collection";
    private static final String COLLECTION_MEMBER_RELATIONSHIP_NAME = "CollectionMembership";
    public static final String NAMING_STANDARD_RULE_SET_TYPE_NAME = "NamingStandardRuleSet";
    public static final String GOVERNANCE_DOMAIN_SET_CLASSIFICATION_NAME = "GovernanceDomainSet";
    public static final String GOVERNANCE_CLASSIFICATION_SET_CLASSIFICATION_NAME = "GovernanceClassificationSet";
    public static final String GOVERNANCE_STATUS_SET_CLASSIFICATION_NAME = "GovernanceStatusSet";
    private static final String SEARCH_KEYWORD_TYPE_NAME = "SearchKeyword";
    private static final String SEARCH_KEYWORD_LINK_RELATIONSHIP_NAME = "SearchKeywordLink";
    private static final String EXTERNAL_REFERENCE_TYPE_NAME = "ExternalReference";
    public static final String EXTERNAL_GLOSSARY_LINK_TYPE_NAME = "ExternalGlossaryLink";
    public static final String RELATED_MEDIA_TYPE_NAME = "RelatedMedia";
    private static final String EXTERNAL_REFERENCE_LINK_RELATIONSHIP_NAME = "ExternalReferenceLink";
    private static final String MEDIA_REFERENCE_RELATIONSHIP_NAME = "MediaReference";
    private static final String MEDIA_USAGE_ENUM_NAME = "MediaUsage";
    public static final int MEDIA_USAGE_ICON = 0;
    public static final int MEDIA_USAGE_THUMBNAIL = 1;
    public static final int MEDIA_USAGE_ILLUSTRATION = 2;
    public static final int MEDIA_USAGE_USAGE_GUIDANCE = 3;
    public static final int MEDIA_USAGE_OTHER = 99;
    private static final String MEDIA_TYPE_ENUM_NAME = "MediaType";
    public static final int MEDIA_TYPE_IMAGE = 0;
    public static final int MEDIA_TYPE_AUDIO = 1;
    public static final int MEDIA_TYPE_DOCUMENT = 2;
    public static final int MEDIA_TYPE_VIDEO = 3;
    public static final int MEDIA_TYPE_OTHER = 99;
    private static final String EXTERNALLY_SOURCED_GLOSSARY_RELATIONSHIP_NAME = "ExternallySourcedGlossary";
    private static final String LIBRARY_CATEGORY_REFERENCE_RELATIONSHIP_NAME = "LibraryCategoryReference";
    private static final String LIBRARY_TERM_REFERENCE_RELATIONSHIP_NAME = "LibraryTermReference";
    private static final String GOVERNANCE_DOMAIN_DESCRIPTION_TYPE_NAME = "GovernanceDomainDescription";
    private static final String GOVERNANCE_DEFINITION_TYPE_NAME = "GovernanceDefinition";
    public static final String GOVERNANCE_DRIVER_TYPE_NAME = "GovernanceDriver";
    public static final String GOVERNANCE_STRATEGY_TYPE_NAME = "GovernanceStrategy";
    public static final String BUSINESS_IMPERATIVE_TYPE_NAME = "BusinessImperative";
    public static final String REGULATION_TYPE_NAME = "Regulation";
    public static final String REGULATION_ARTICLE_TYPE_NAME = "RegulationArticle";
    public static final String THREAT_TYPE_NAME = "Threat";
    public static final String GOVERNANCE_POLICY_TYPE_NAME = "GovernancePolicy";
    public static final String GOVERNANCE_PRINCIPLE_TYPE_NAME = "GovernancePrinciple";
    public static final String GOVERNANCE_OBLIGATION_TYPE_NAME = "GovernanceObligation";
    public static final String GOVERNANCE_APPROACH_TYPE_NAME = "GovernanceApproach";
    public static final String GOVERNANCE_CONTROL_TYPE_NAME = "GovernanceControl";
    public static final String TECHNICAL_CONTROL_TYPE_NAME = "TechnicalControl";
    public static final String SECURITY_GROUP_TYPE_NAME = "SecurityGroup";
    public static final String GOVERNANCE_RULE_TYPE_NAME = "GovernanceRule";
    public static final String NAMING_STANDARD_RULE_TYPE_NAME = "NamingStandardRule";
    public static final String GOVERNANCE_PROCESS_TYPE_NAME = "GovernanceProcess";
    public static final String ORGANIZATIONAL_CONTROL_TYPE_NAME = "OrganizationalControl";
    public static final String GOVERNANCE_RESPONSIBILITY_TYPE_NAME = "GovernanceResponsibility";
    public static final String GOVERNANCE_PROCEDURE_TYPE_NAME = "GovernanceProcedure";
    public static final String LICENSE_TYPE_TYPE_NAME = "LicenseType";
    public static final String CERTIFICATION_TYPE_TYPE_NAME = "CertificationType";
    public static final String DATA_PROCESSING_PURPOSE_TYPE_NAME = "DataProcessingPurpose";
    private static final String GOVERNANCE_DEFINITION_SCOPE_RELATIONSHIP_NAME = "GovernanceDefinitionScope";
    private static final String GOVERNED_BY_RELATIONSHIP_NAME = "GovernedBy";
    private static final String RESOURCE_LIST_RELATIONSHIP_NAME = "ResourceList";
    public static final String GOVERNANCE_DRIVER_LINK_RELATIONSHIP_NAME = "GovernanceDriverLink";
    public static final String GOVERNANCE_RESPONSE_RELATIONSHIP_NAME = "GovernanceResponse";
    public static final String GOVERNANCE_POLICY_LINK_RELATIONSHIP_NAME = "GovernanceDriverLink";
    public static final String GOVERNANCE_IMPLEMENTATION_RELATIONSHIP_NAME = "GovernanceImplementation";
    public static final String GOVERNANCE_CONTROL_LINK_RELATIONSHIP_NAME = "GovernanceControlLink";
    public static final String GOVERNANCE_RULE_IMPLEMENTATION_RELATIONSHIP_NAME = "GovernanceRuleImplementation";
    public static final String GOVERNANCE_PROCESS_IMPLEMENTATION_RELATIONSHIP_NAME = "GovernanceProcessImplementation";
    public static final String GOVERNANCE_RESPONSIBILITY_ASSIGNMENT_RELATIONSHIP_NAME = "GovernanceResponsibilityAssignment";
    private static final String GOVERNANCE_ZONE_TYPE_NAME = "GovernanceZone";
    private static final String ZONE_HIERARCHY_RELATIONSHIP_NAME = "ZoneHierarchy";
    private static final String ASSET_ZONE_MEMBERSHIP_CLASSIFICATION_NAME = "AssetZoneMembership";
    private static final String BUSINESS_CAPABILITY_TYPE_NAME = "BusinessCapability";
    private static final String BUSINESS_CAPABILITY_TYPE_ENUM_NAME = "BusinessCapabilityType";
    public static final int BUSINESS_CAPABILITY_TYPE_UNCLASSIFIED = 0;
    public static final int BUSINESS_CAPABILITY_TYPE_BUSINESS_SERVICE = 1;
    public static final int BUSINESS_CAPABILITY_TYPE_BUSINESS_AREA = 2;
    public static final int BUSINESS_CAPABILITY_TYPE_OTHER = 99;
    private static final String ORGANIZATIONAL_CAPABILITY_RELATIONSHIP_NAME = "OrganizationalCapability";
    private static final String ASSET_ORIGIN_CLASSIFICATION_NAME = "AssetOrigin";
    private static final String PROJECT_CHARTER_TYPE_NAME = "ProjectCharter";
    private static final String PROJECT_CHARTER_LINK_RELATIONSHIP_NAME = "ProjectCharterLink";
    private static final String OWNER_CLASSIFICATION_NAME = "Owner";
    private static final String SUBJECT_AREA_DEFINITION_TYPE_NAME = "SubjectAreaDefinition";
    private static final String SUBJECT_AREA_HIERARCHY_RELATIONSHIP_NAME = "SubjectAreaHierarchy";
    private static final String SUBJECT_AREA_CLASSIFICATION_NAME = "SubjectArea";
    private static final String GLOSSARY_TYPE_NAME = "Glossary";
    private static final String CANONICAL_VOCABULARY_TYPE_NAME = "CanonicalVocabulary";
    private static final String GLOSSARY_CATEGORY_TYPE_NAME = "GlossaryCategory";
    private static final String CATEGORY_ANCHOR_TYPE_NAME = "CategoryAnchor";
    private static final String CATEGORY_HIERARCHY_LINK_TYPE_NAME = "CategoryHierarchyLink";
    private static final String GLOSSARY_TERM_TYPE_NAME = "GlossaryTerm";
    private static final String TERM_ANCHOR_TYPE_NAME = "TermAnchor";
    private static final String TERM_CATEGORIZATION_TYPE_NAME = "TermCategorization";
    private static final String SYNONYM_RELATIONSHIP_TYPE_NAME = "Synonym";
    private static final String SEMANTIC_ASSIGNMENT_TYPE_NAME = "SemanticAssignment";
    private static final String MORE_INFORMATION_TYPE_NAME = "MoreInformation";
    private static final String SPINE_OBJECT_NAME = "SpineObject";
    private static final String SPINE_ATTRIBUTE_NAME = "SpineAttribute";
    private static final String IS_A_TYPE_OF_RELATIONSHIP_NAME = "IsATypeOfRelationship";
    private static final String HAS_A_RELATIONSHIP_NAME = "TermHASARelationship";
    private static final String RELATED_TERM_RELATIONSHIP_NAME = "RelatedTerm";
    private static final String TERM_RELATIONSHIP_STATUS_ENUM_NAME = "TermRelationshipStatus";
    public static final int TERM_RELATIONSHIP_STATUS_DRAFT = 0;
    public static final int TERM_RELATIONSHIP_STATUS_ACTIVE = 1;
    public static final int TERM_RELATIONSHIP_STATUS_DEPRECATED = 2;
    public static final int TERM_RELATIONSHIP_STATUS_OBSOLETE = 3;
    public static final int TERM_RELATIONSHIP_STATUS_OTHER = 4;
    private static final String PERSON_TYPE_NAME = "Person";
    private static final String TEAM_TYPE_NAME = "Team";
    public static final String ORGANIZATION_TYPE_NAME = "Organization";
    private static final String IT_PROFILE_TYPE_NAME = "ITProfile";
    private static final String USER_IDENTITY_TYPE_NAME = "UserIdentity";
    private static final String CONTACT_DETAILS_TYPE_NAME = "ContactDetails";
    private static final String SECURITY_GROUP_MEMBERSHIP_CLASSIFICATION_NAME = "SecurityGroupMembership";
    private static final String SECURITY_TAGS_CLASSIFICATION_NAME = "SecurityTags";
    private static final String CONTACT_METHOD_TYPE_ENUM_NAME = "ContactMethodType";
    public static final int CONTACT_METHOD_TYPE_EMAIL = 0;
    public static final int CONTACT_METHOD_TYPE_PHONE = 1;
    public static final int CONTACT_METHOD_TYPE_CHAT = 2;
    public static final int CONTACT_METHOD_TYPE_PROFILE = 3;
    public static final int CONTACT_METHOD_TYPE_ACCOUNT = 4;
    public static final int CONTACT_METHOD_TYPE_OTHER = 99;
    private static final String PROFILE_LOCATION_RELATIONSHIP_NAME = "ProfileLocation";
    private static final String PROFILE_IDENTITY_RELATIONSHIP_NAME = "ProfileIdentity";
    private static final String CONTACT_THROUGH_RELATIONSHIP_NAME = "ContactThrough";
    private static final String PEER_RELATIONSHIP_NAME = "Peer";
    private static final String PERSONAL_ROLE_APPOINTMENT_RELATIONSHIP_NAME = "PersonRoleAppointment";
    private static final String TEAM_STRUCTURE_RELATIONSHIP_NAME = "TeamStructure";
    private static final String TEAM_MEMBERSHIP_RELATIONSHIP_NAME = "TeamMembership";
    private static final String TEAM_LEADERSHIP_RELATIONSHIP_NAME = "TeamLeadership";
    private static final String IT_INFRASTRUCTURE_PROFILE_RELATIONSHIP_NAME = "ITInfrastructureProfile";
    private static final String ASSIGNMENT_SCOPE_RELATIONSHIP_NAME = "AssignmentScope";
    private static final String PERSON_ROLE_TYPE_NAME = "PersonRole";
    public static final String TEAM_LEADER_TYPE_NAME = "TeamLeader";
    public static final String TEAM_MEMBER_TYPE_NAME = "TeamMember";
    public static final String PROJECT_MANAGER_TYPE_NAME = "ProjectManager";
    public static final String COMMUNITY_MEMBER_TYPE_NAME = "CommunityMember";
    public static final String NOTE_LOG_AUTHOR_TYPE_NAME = "NoteLogAuthor";
    public static final String GOVERNANCE_ROLE_TYPE_NAME = "GovernanceRole";
    public static final String GOVERNANCE_OFFICER_TYPE_NAME = "GovernanceOfficer";
    public static final String GOVERNANCE_REPRESENTATIVE_TYPE_NAME = "GovernanceRepresentative";
    public static final String LOCATION_OWNER_TYPE_NAME = "LocationOwner";
    public static final String BUSINESS_OWNER_TYPE_NAME = "BusinessOwner";
    public static final String SOLUTION_OWNER_TYPE_NAME = "SolutionOwner";
    public static final String ASSET_OWNER_TYPE_NAME = "AssetOwner";
    public static final String SUBJECT_AREA_OWNER_TYPE_NAME = "SubjectAreaOwner";
    public static final String COMPONENT_OWNER_TYPE_NAME = "ComponentOwner";
    public static final String DATA_ITEM_OWNER_TYPE_NAME = "DataItemOwner";
    public static final String PROJECT_TYPE_NAME = "Project";
    public static final String CAMPAIGN_CLASSIFICATION_NAME = "Campaign";
    public static final String TASK_CLASSIFICATION_NAME = "Task";
    public static final String GLOSSARY_PROJECT_CLASSIFICATION_NAME = "GlossaryProject";
    public static final String GOVERNANCE_PROJECT_CLASSIFICATION_NAME = "GovernanceProject";
    private static final String PROJECT_HIERARCHY_RELATIONSHIP_NAME = "ProjectHierarchy";
    private static final String PROJECT_DEPENDENCY_RELATIONSHIP_NAME = "ProjectDependency";
    private static final String PROJECT_TEAM_RELATIONSHIP_NAME = "ProjectTeam";
    private static final String PROJECT_MANAGEMENT_RELATIONSHIP_NAME = "ProjectManagement";
    private static final String STAKEHOLDER_RELATIONSHIP_NAME = "Stakeholder";
    public static final String COMMUNITY_TYPE_NAME = "Community";
    private static final String COMMUNITY_MEMBERSHIP_RELATIONSHIP_NAME = "CommunityMembership";
    private static final String COMMUNITY_MEMBERSHIP_TYPE_ENUM_NAME = "CommunityMembershipType";
    public static final int COMMUNITY_MEMBERSHIP_TYPE_CONTRIBUTOR = 0;
    public static final int COMMUNITY_MEMBERSHIP_TYPE_ADMINISTRATOR = 1;
    public static final int COMMUNITY_MEMBERSHIP_TYPE_LEADER = 2;
    public static final int COMMUNITY_MEMBERSHIP_TYPE_OBSERVER = 3;
    public static final int COMMUNITY_MEMBERSHIP_TYPE_OTHER = 99;
    private static final String CONTEXT_DEFINITION_CLASSIFICATION_NAME = "ContextDefinition";
    private static final String USED_IN_CONTEXT_RELATIONSHIP_NAME = "UsedInContext";
    private static final String DESIGN_MODEL_TYPE_NAME = "DesignModel";
    private static final String CONCEPT_MODEL_CLASSIFICATION_NAME = "ConceptModel";
    private static final String DESIGN_MODEL_SCOPE_TYPE_NAME = "DesignModelScope";
    private static final String DESIGN_MODEL_ELEMENTS_IN_SCOPE_TYPE_NAME = "DesignModelElementsInScope";
    private static final String DESIGN_MODEL_ELEMENT_TYPE_NAME = "DesignModelElement";
    private static final String DESIGN_MODEL_GROUP_TYPE_NAME = "DesignModelGroup";
    private static final String DESIGN_MODEL_GROUP_MEMBERSHIP_NAME = "DesignModelGroupMembership";
    private static final String DESIGN_MODEL_OWNERSHIP_RELATIONSHIP_NAME = "DesignModelOwnership";
    private static final String DESIGN_MODEL_IMPL_RELATIONSHIP_NAME = "DesignModelImplementation";
    private static final String METAMODEL_INSTANCE_CLASSIFICATION_NAME = "MetamodelInstance";
    private static final String METAMODEL_ELEMENT_GUID_PROPERTY_NAME = "metamodelElementGUID";
    private static final String CONCEPT_BEAD_TYPE_NAME = "ConceptBead";
    private static final String CONCEPT_BEAD_LINK_TYPE_NAME = "ConceptBeadLink";
    private static final String CONCEPT_BEAD_ATTRIBUTE_TYPE_NAME = "ConceptBeadAttribute";
    private static final String CONCEPT_BEAD_RELATIONSHIP_END_NAME = "ConceptBeadRelationshipEnd";
    private static final String CONCEPT_BEAD_ATTRIBUTE_LINK_TYPE_NAME = "ConceptBeadAttributeLink";
    private static final String CONCEPT_MODEL_DECORATION_ENUM_NAME = "ConceptModelDecoration";
    public static final int CONCEPT_MODEL_DECORATION_NONE = 0;
    public static final int CONCEPT_MODEL_DECORATION_AGGREGATION = 1;
    public static final int CONCEPT_MODEL_DECORATION_COMPOSITION = 2;
    public static final int CONCEPT_MODEL_DECORATION_EXTENSION = 3;
    private static final String CONCEPT_BEAD_COVERAGE_CATEGORY_ENUM_NAME = "ConceptBeadAttributeCoverageCategory";
    public static final int CONCEPT_BEAD_COVERAGE_UNKNOWN = 0;
    public static final int CONCEPT_BEAD_COVERAGE_UNIQUE_IDENTIFIER = 1;
    public static final int CONCEPT_BEAD_COVERAGE_IDENTIFIER = 2;
    public static final int CONCEPT_BEAD_COVERAGE_CORE_DETAIL = 3;
    public static final int CONCEPT_BEAD_COVERAGE_EXTENDED_DETAIL = 4;
    private static final String CONCEPT_BEAD_COVERAGE_CLASSIFICATION_NAME = "ConceptBeadAttributeCoverage";
    private static final String CONCEPT_BEAD_COVERAGE_CATEGORY_PROPERTY = "coverageCategory";
    private static final String SOFTWARE_CAPABILITY_TYPE_NAME = "SoftwareCapability";
    private static final String ASSET_TYPE_NAME = "Asset";
    private static final String PROCESS_TYPE_NAME = "Process";
    private static final String CONNECTION_TO_ASSET_TYPE_NAME = "ConnectionToAsset";
    private static final String DATA_CONTENT_FOR_DATA_SET_TYPE_NAME = "DataContentForDataSet";
    private static final String ASSET_SCHEMA_TYPE_TYPE_NAME = "AssetSchemaType";
    private static final String ASSET_ZONE_MEMBERSHIP_TYPE_NAME = "AssetZoneMembership";
    private static final String SCHEMA_TYPE_TYPE_NAME = "SchemaType";
    private static final String PRIMITIVE_SCHEMA_TYPE_TYPE_NAME = "PrimitiveSchemaType";
    private static final String SCHEMA_TYPE_OPTION_TYPE_NAME = "SchemaTypeOption";
    private static final String SCHEMA_ATTRIBUTE_TYPE_NAME = "SchemaAttribute";
    private static final String ATTRIBUTE_FOR_SCHEMA_TYPE_NAME = "AttributeForSchema";
    private static final String NESTED_SCHEMA_ATTRIBUTE_TYPE_NAME = "NestedSchemaAttribute";
    private static final String TYPE_EMBEDDED_ATTRIBUTE_TYPE_NAME = "TypeEmbeddedAttribute";
    private static final String CALCULATED_VALUE_TYPE_NAME = "CalculatedValue";
    private static final String DERIVED_QUERY_TARGET_TYPE_NAME = "DerivedSchemaTypeQueryTarget";
    private static final String PRIMARY_KEY_TYPE_NAME = "PrimaryKey";
    private static final String FOREIGN_KEY_TYPE_NAME = "ForeignKey";
    private static final String API_OPERATION_TYPE_NAME = "APIOperation";
    private static final String API_OPERATIONS_TYPE_NAME = "APIOperations";
    public static final String API_HEADER_TYPE_NAME = "APIHeader";
    public static final String API_REQUEST_TYPE_NAME = "APIRequest";
    public static final String API_RESPONSE_TYPE_NAME = "APIResponse";
    private static final String API_PARAMETER_TYPE_NAME = "APIParameter";
    private static final String API_PARAMETER_LIST_TYPE_NAME = "APIParameterList";
    public static final String VALID_VALUE_DEFINITION_TYPE_NAME = "ValidValueDefinition";
    public static final String VALID_VALUE_SET_TYPE_NAME = "ValidValuesSet";
    private static final String VALID_VALUE_MEMBER_TYPE_NAME = "ValidValueMember";
    private static final String VALID_VALUES_ASSIGNMENT_TYPE_NAME = "ValidValuesAssignment";
    private static final String VALID_VALUES_MAPPING_TYPE_NAME = "ValidValuesMapping";
    private static final String VALID_VALUES_IMPLEMENTATION_TYPE_NAME = "ValidValuesImplementation";
    private static final String REFERENCE_VALUE_ASSIGNMENT_TYPE_NAME = "ReferenceValueAssignment";
    private static final String REFERENCE_DATA_CLASSIFICATION_NAME = "ReferenceData";
    protected static final String QUALIFIED_NAME_PROPERTY = "qualifiedName";
    protected static final String ADDITIONAL_PROPERTIES_PROPERTY = "additionalProperties";
    protected static final String NAME_PROPERTY = "name";
    protected static final String VERSION_IDENTIFIER_PROPERTY = "versionIdentifier";
    protected static final String DISPLAY_NAME_PROPERTY = "displayName";
    protected static final String DESCRIPTION_PROPERTY = "description";
    private static final String COORDINATES_PROPERTY = "coordinates";
    private static final String MAP_PROJECTION_PROPERTY = "mapProjection";
    private static final String POSTAL_ADDRESS_PROPERTY = "postalAddress";
    private static final String TIME_ZONE_PROPERTY = "timezone";
    private static final String LEVEL_PROPERTY = "level";
    private static final String ASSOCIATION_TYPE_PROPERTY = "associationType";
    private static final String CONTACT_TYPE_PROPERTY = "contactType";
    private static final String CONTACT_METHOD_TYPE_PROPERTY = "contactMethodType";
    private static final String CONTACT_METHOD_SERVICE_PROPERTY = "contactMethodService";
    private static final String CONTACT_METHOD_VALUE_PROPERTY = "contactMethodValue";
    private static final String DISTINGUISHED_NAME_PROPERTY = "distinguishedName";
    private static final String ROLE_TYPE_NAME_PROPERTY = "roleTypeName";
    private static final String ROLE_GUID_PROPERTY = "roleGUID";
    private static final String IS_PUBLIC_PROPERTY = "isPublic";
    private static final String HEAD_COUNT_PROPERTY = "headCount";
    private static final String PRONOUNS_PROPERTY = "pronouns";
    private static final String TITLE_PROPERTY = "title";
    private static final String INITIALS_PROPERTY = "initials";
    private static final String GIVEN_NAMES_PROPERTY = "givenNames";
    private static final String SURNAME_PROPERTY = "surname";
    private static final String FULL_NAME_PROPERTY = "fullName";
    private static final String JOB_TITLE_PROPERTY = "jobTitle";
    private static final String EMPLOYEE_NUMBER_PROPERTY = "employeeNumber";
    private static final String EMPLOYEE_TYPE_PROPERTY = "employeeType";
    private static final String PREFERRED_LANGUAGE_PROPERTY = "preferredLanguage";
    private static final String DELEGATION_ESCALATION_AUTHORITY_PROPERTY = "delegationEscalationAuthority";
    private static final String TEAM_TYPE_PROPERTY = "teamType";
    private static final String ASSIGNMENT_TYPE_PROPERTY = "assignmentType";
    private static final String DEPENDENCY_SUMMARY_PROPERTY = "dependencySummary";
    private static final String TEAM_ROLE_PROPERTY = "teamRole";
    private static final String START_DATE_PROPERTY = "startDate";
    private static final String PLANNED_END_DATE_PROPERTY = "plannedEndDate";
    private static final String PROJECT_STATUS_PROPERTY = "projectStatus";
    private static final String MISSION_PROPERTY = "mission";
    private static final String MEMBERSHIP_TYPE_PROPERTY = "membershipType";
    private static final String MEMBERSHIP_RATIONALE_PROPERTY = "membershipRationale";
    private static final String PROJECT_TYPE_PROPERTY = "projectType";
    private static final String PURPOSES_PROPERTY = "purposes";
    private static final String DETAILS_PROPERTY = "details";
    private static final String RESOURCE_USE_PROPERTY = "resourceUse";
    private static final String WATCH_RESOURCE_PROPERTY = "watchResource";
    private static final String GROUPS_PROPERTY = "groups";
    private static final String SECURITY_LABELS_PROPERTY = "securityLabels";
    private static final String SECURITY_PROPERTIES_PROPERTY = "securityProperties";
    private static final String ACCESS_GROUPS_PROPERTY = "accessGroups";
    private static final String IDENTIFIER_PROPERTY = "identifier";
    private static final String ORGANIZATION_PROPERTY = "organization";
    private static final String ORGANIZATION_PROPERTY_NAME_PROPERTY = "organizationPropertyName";
    private static final String BUSINESS_CAPABILITY_PROPERTY = "businessCapability";
    private static final String BUSINESS_CAPABILITY_TYPE_PROPERTY = "businessCapabilityType";
    private static final String BUSINESS_CAPABILITY_PROPERTY_NAME_PROPERTY = "businessCapabilityPropertyName";
    private static final String OTHER_ORIGIN_VALUES_PROPERTY = "otherOriginValues";
    private static final String OWNER_PROPERTY = "owner";
    private static final String OWNER_TYPE_NAME_PROPERTY = "ownerTypeName";
    private static final String OWNER_PROPERTY_NAME_PROPERTY = "ownerPropertyName";
    private static final String ATTRIBUTE_NAME_PROPERTY = "attributeName";
    private static final String TECHNICAL_NAME_PROPERTY = "technicalName";
    private static final String DECORATION_PROPERTY = "decoration";
    private static final String VERSION_NUMBER_PROPERTY = "versionNumber";
    private static final String AUTHOR_PROPERTY = "author";
    private static final String POSITION_PROPERTY = "position";
    private static final String MIN_CARDINALITY_PROPERTY = "minCardinality";
    private static final String MAX_CARDINALITY_PROPERTY = "maxCardinality";
    private static final String UNIQUE_VALUES_PROPERTY = "uniqueValues";
    private static final String ORDERED_VALUES_PROPERTY = "orderedValues";
    private static final String NAVIGABLE_PROPERTY = "navigable";
    private static final String ASSET_SUMMARY_PROPERTY = "assetSummary";
    private static final String ZONE_MEMBERSHIP_PROPERTY = "zoneMembership";
    private static final String ZONE_NAME_PROPERTY = "zoneName";
    private static final String SUBJECT_AREA_NAME_PROPERTY = "subjectAreaName";
    public static final String DOMAIN_IDENTIFIER_PROPERTY = "domainIdentifier";
    private static final String PRIORITY_PROPERTY = "priority";
    private static final String IMPLICATIONS_PROPERTY = "implications";
    private static final String OUTCOMES_PROPERTY = "outcomes";
    private static final String RESULTS_PROPERTY = "results";
    private static final String JURISDICTION_PROPERTY = "jurisdiction";
    private static final String RATIONALE_PROPERTY = "rationale";
    private static final String CAPABILITY_TYPE_PROPERTY = "capabilityType";
    private static final String CAPABILITY_VERSION_PROPERTY = "capabilityVersion";
    private static final String PATCH_LEVEL_PROPERTY = "patchLevel";
    private static final String SUPPORTED_ASSET_TYPE_PROPERTY = "supportedAssetTypeName";
    private static final String EXPECTED_DATA_FORMAT_PROPERTY = "expectedDataFormat";
    private static final String CONNECTOR_PROVIDER_PROPERTY = "connectorProviderClassName";
    private static final String CONNECTOR_FRAMEWORK_PROPERTY = "connectorFrameworkNameName";
    private static final String CONNECTOR_FRAMEWORK_DEFAULT = "Open Connector Framework (OCF)";
    private static final String CONNECTOR_INTERFACE_LANGUAGE_PROPERTY = "connectorInterfaceLanguage";
    private static final String CONNECTOR_INTERFACE_LANGUAGE_DEFAULT = "Java";
    private static final String CONNECTOR_INTERFACES_PROPERTY = "connectorInterfaces";
    private static final String TARGET_TECHNOLOGY_SOURCE_PROPERTY = "targetTechnologySource";
    private static final String TARGET_TECHNOLOGY_NAME_PROPERTY = "targetTechnologyName";
    private static final String TARGET_TECHNOLOGY_INTERFACES_PROPERTY = "targetTechnologyInterfaces";
    private static final String TARGET_TECHNOLOGY_VERSIONS_PROPERTY = "targetTechnologyVersions";
    private static final String SECURED_PROPERTIES_PROPERTY = "securedProperties";
    private static final String CONFIGURATION_PROPERTIES_PROPERTY = "configurationProperties";
    private static final String USER_ID_PROPERTY = "userId";
    private static final String CLEAR_PASSWORD_PROPERTY = "clearPassword";
    private static final String ENCRYPTED_PASSWORD_PROPERTY = "encryptedPassword";
    private static final String RECOGNIZED_ADDITIONAL_PROPERTIES_PROPERTY = "recognizedAdditionalProperties";
    private static final String RECOGNIZED_SECURED_PROPERTIES_PROPERTY = "recognizedSecuredProperties";
    private static final String RECOGNIZED_CONFIGURATION_PROPERTIES_PROPERTY = "recognizedConfigurationProperties";
    private static final String NETWORK_ADDRESS_PROPERTY = "networkAddress";
    private static final String PROTOCOL_PROPERTY = "protocol";
    private static final String REQUIRED_PROPERTY = "required";
    private static final String PARAMETER_TYPE_PROPERTY = "parameterType";
    private static final String PATH_PROPERTY = "path";
    private static final String COMMAND_PROPERTY = "command";
    private static final String SCOPE_PROPERTY = "scope";
    private static final String CRITERIA_PROPERTY = "criteria";
    private static final String STATUS_PROPERTY = "status";
    private static final String STEWARD_PROPERTY = "steward";
    private static final String STEWARD_TYPE_NAME_PROPERTY = "stewardTypeName";
    private static final String STEWARD_PROPERTY_NAME_PROPERTY = "stewardPropertyName";
    private static final String SOURCE_PROPERTY = "source";
    private static final String EXPRESSION_PROPERTY = "expression";
    private static final String NOTES_PROPERTY = "notes";
    private static final String FORMULA_PROPERTY = "formula";
    private static final String QUERY_ID_PROPERTY = "queryId";
    private static final String QUERY_PROPERTY = "query";
    private static final String ALLOWS_DUPLICATE_VALUES_PROPERTY = "allowsDuplicateValues";
    private static final String DEFAULT_VALUE_OVERRIDE_PROPERTY = "defaultValueOverride";
    private static final String MINIMUM_LENGTH_PROPERTY = "minimumLength";
    private static final String LENGTH_PROPERTY = "length";
    private static final String PRECISION_PROPERTY = "precision";
    private static final String SIGNIFICANT_DIGITS_PROPERTY = "significantDigits";
    private static final String IS_NULLABLE_PROPERTY = "isNullable";
    private static final String NATIVE_CLASS_PROPERTY = "nativeClass";
    private static final String ALIASES_PROPERTY = "aliases";
    private static final String SORT_ORDER_PROPERTY = "sortOrder";
    private static final String SCHEMA_TYPE_NAME_PROPERTY = "schemaTypeName";
    private static final String IS_DEPRECATED_PROPERTY = "isDeprecated";
    private static final String USAGE_PROPERTY = "usage";
    private static final String ENCODING_STANDARD_PROPERTY = "encodingStandard";
    private static final String NAMESPACE_PROPERTY = "namespace";
    private static final String DATA_TYPE_PROPERTY = "dataType";
    private static final String DEFAULT_VALUE_PROPERTY = "defaultValue";
    private static final String FIXED_VALUE_PROPERTY = "fixedValue";
    private static final String SUMMARY_PROPERTY = "summary";
    private static final String EXAMPLES_PROPERTY = "examples";
    private static final String ABBREVIATION_PROPERTY = "abbreviation";
    private static final String LANGUAGE_PROPERTY = "language";
    private static final String LAST_VERIFIED_PROPERTY = "lastVerified";
    private static final String REFERENCE_ID_PROPERTY = "referenceId";
    private static final String PAGES_PROPERTY = "pages";
    private static final String MEDIA_ID_PROPERTY = "mediaId";
    private static final String MEDIA_USAGE_PROPERTY = "mediaUsage";
    private static final String MEDIA_USAGE_OTHER_ID_PROPERTY = "mediaUsageOtherId";
    private static final String KEYWORD_PROPERTY = "keyword";
    private static final String REFERENCE_TITLE_PROPERTY = "referenceTitle";
    private static final String REFERENCE_ABSTRACT_PROPERTY = "referenceAbstract";
    private static final String AUTHORS_PROPERTY = "authors";
    private static final String NUMBER_OF_PAGES_PROPERTY = "numberOfPages";
    private static final String PAGE_RANGE_PROPERTY = "pageRange";
    private static final String PUBLICATION_SERIES_PROPERTY = "publicationSeries";
    private static final String PUBLICATION_SERIES_VOLUME_PROPERTY = "publicationSeriesVolume";
    private static final String EDITION_PROPERTY = "edition";
    private static final String REFERENCE_VERSION_PROPERTY = "referenceVersion";
    private static final String URL_PROPERTY = "url";
    private static final String PUBLISHER_PROPERTY = "publisher";
    private static final String FIRST_PUBLICATION_DATE_PROPERTY = "firstPublicationDate";
    private static final String PUBLICATION_DATE_PROPERTY = "publicationDate";
    private static final String PUBLICATION_CITY_PROPERTY = "publicationCity";
    private static final String PUBLICATION_YEAR_PROPERTY = "publicationYear";
    private static final String PUBLICATION_NUMBERS_PROPERTY = "publicationNumbers";
    private static final String LICENSE_PROPERTY = "license";
    private static final String COPYRIGHT_PROPERTY = "copyright";
    private static final String ATTRIBUTION_PROPERTY = "attribution";
    private static final String MEDIA_TYPE_PROPERTY = "mediaType";
    private static final String MEDIA_TYPE_OTHER_ID_PROPERTY = "mediaTypeOtherId";
    private static final String DEFAULT_MEDIA_USAGE_PROPERTY = "defaultMediaUsage";
    private static final String DEFAULT_MEDIA_USAGE_OTHER_ID_PROPERTY = "defaultMediaUsageOtherId";
    private static final String STATUS_IDENTIFIER_PROPERTY = "statusIdentifier";
    private static final String CONFIDENCE_PROPERTY = "confidence";
    private static final String ATTRIBUTE_PROPERTY = "attribute";
    private static final String STRICT_REQUIREMENT_PROPERTY = "strictRequirement";
    private static final String PREFERRED_VALUE_PROPERTY = "preferredValue";
    private static final String SYMBOLIC_NAME_PROPERTY = "symbolicName";
    private static final String IMPLEMENTATION_VALUE_PROPERTY = "implementationValue";
    private static final String ADDITIONAL_VALUES_PROPERTY = "additionalValues";
    private static final String ASSOCIATION_DESCRIPTION_PROPERTY = "associationDescription";
    private static final String IS_DEFAULT_VALUE_PROPERTY = "isDefaultValue";
    protected OpenMetadataArchiveBuilder archiveBuilder;
    protected OMRSArchiveHelper archiveHelper;
    protected OMRSArchiveGUIDMap idToGUIDMap;
    protected String archiveRootName;
    protected String originatorName;
    protected String versionName;
    protected EnumElementDef activeStatus;

    public SimpleCatalogArchiveHelper(OpenMetadataArchiveBuilder archiveBuilder, String archiveGUID, String archiveName, String archiveRootName, String originatorName, Date creationDate, long versionNumber, String versionName) {
        this(archiveBuilder, archiveGUID, archiveName, originatorName, creationDate, versionNumber, versionName, archiveRootName + guidMapFileNamePostFix);
    }

    public SimpleCatalogArchiveHelper(OpenMetadataArchiveBuilder archiveBuilder, String archiveGUID, String archiveName, String archiveRootName, String originatorName, Date creationDate, long versionNumber, String versionName, InstanceProvenanceType instanceProvenanceType, String license) {
        this(archiveBuilder, archiveGUID, archiveName, originatorName, creationDate, versionNumber, versionName, instanceProvenanceType, license, archiveRootName + guidMapFileNamePostFix);
    }

    public SimpleCatalogArchiveHelper(OpenMetadataArchiveBuilder archiveBuilder, String archiveGUID, String archiveName, String originatorName, Date creationDate, long versionNumber, String versionName, String guidMapFileName) {
        this(archiveBuilder, archiveGUID, archiveName, originatorName, creationDate, versionNumber, versionName, InstanceProvenanceType.CONTENT_PACK, null, guidMapFileName);
    }

    public SimpleCatalogArchiveHelper(OpenMetadataArchiveBuilder archiveBuilder, String archiveGUID, String archiveName, String originatorName, Date creationDate, long versionNumber, String versionName, InstanceProvenanceType instanceProvenanceType, String license, String guidMapFileName) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, archiveName, originatorName, creationDate, versionNumber, versionName, instanceProvenanceType, license);
        this.idToGUIDMap = new OMRSArchiveGUIDMap(guidMapFileName);
        this.archiveRootName = archiveName;
        this.originatorName = originatorName;
        this.versionName = versionName;
        this.activeStatus = this.archiveHelper.getEnumElement(TERM_RELATIONSHIP_STATUS_ENUM_NAME, 1);
    }

    public String getGUID(String qualifiedName) {
        return this.idToGUIDMap.getGUID(qualifiedName);
    }

    public String queryGUID(String qualifiedName) {
        return this.idToGUIDMap.queryGUID(qualifiedName);
    }

    public void saveGUIDs() {
        System.out.println("GUIDs map size: " + this.idToGUIDMap.getSize());
        this.idToGUIDMap.saveGUIDs();
    }

    public String addExternalReference(String typeName, String qualifiedName, String displayName, String referenceTitle, String referenceAbstract, String description, List<String> authors, int numberOfPages, String pageRange, String authorOrganization, String publicationSeries, String publicationSeriesVolume, String edition, String versionNumber, String referenceURL, String publisher, Date firstPublicationDate, Date publicationDate, String publicationCity, String publicationYear, List<String> publicationNumbers, String license, String copyright, String attribution, List<String> searchKeywords, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) {
        String methodName = "addExternalReference";
        String elementTypeName = EXTERNAL_REFERENCE_TYPE_NAME;
        if (typeName != null) {
            elementTypeName = typeName;
        }
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, REFERENCE_TITLE_PROPERTY, referenceTitle, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, REFERENCE_ABSTRACT_PROPERTY, referenceAbstract, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addExternalReference");
        properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, properties, AUTHORS_PROPERTY, authors, "addExternalReference");
        properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, NUMBER_OF_PAGES_PROPERTY, numberOfPages, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, PAGE_RANGE_PROPERTY, pageRange, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, ORGANIZATION_PROPERTY, authorOrganization, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, REFERENCE_VERSION_PROPERTY, versionNumber, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, PUBLICATION_SERIES_PROPERTY, publicationSeries, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, PUBLICATION_SERIES_VOLUME_PROPERTY, publicationSeriesVolume, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, EDITION_PROPERTY, edition, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, URL_PROPERTY, referenceURL, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, PUBLISHER_PROPERTY, publisher, "addExternalReference");
        properties = this.archiveHelper.addDatePropertyToInstance(this.archiveRootName, properties, FIRST_PUBLICATION_DATE_PROPERTY, firstPublicationDate, "addExternalReference");
        properties = this.archiveHelper.addDatePropertyToInstance(this.archiveRootName, properties, PUBLICATION_DATE_PROPERTY, publicationDate, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, PUBLICATION_CITY_PROPERTY, publicationCity, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, PUBLICATION_YEAR_PROPERTY, publicationYear, "addExternalReference");
        properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, properties, PUBLICATION_NUMBERS_PROPERTY, publicationNumbers, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, LICENSE_PROPERTY, license, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, COPYRIGHT_PROPERTY, copyright, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, ATTRIBUTION_PROPERTY, attribution, "addExternalReference");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addExternalReference");
        properties = this.archiveHelper.addPropertyMapToInstance(this.archiveRootName, properties, extendedProperties, "addExternalReference");
        EntityDetail externalReferenceEntity = this.archiveHelper.getEntityDetail(elementTypeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(externalReferenceEntity);
        if (searchKeywords != null) {
            for (String keyword : searchKeywords) {
                if (keyword == null) continue;
                String keywordGUID = this.idToGUIDMap.queryGUID("SearchKeyword:" + keyword);
                EntityDetail keywordEntity = null;
                InstanceProperties keywordProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, KEYWORD_PROPERTY, keyword, "addExternalReference");
                if (keywordGUID != null) {
                    keywordEntity = this.archiveBuilder.queryEntity(keywordGUID);
                }
                if (keywordEntity == null) {
                    keywordEntity = this.archiveHelper.getEntityDetail(SEARCH_KEYWORD_TYPE_NAME, this.idToGUIDMap.getGUID("SearchKeyword:" + keyword), keywordProperties, InstanceStatus.ACTIVE, null);
                    this.archiveBuilder.addEntity(keywordEntity);
                }
                if (keywordEntity == null) continue;
                EntityProxy end1 = this.archiveHelper.getEntityProxy(externalReferenceEntity);
                EntityProxy end2 = this.archiveHelper.getEntityProxy(keywordEntity);
                this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(SEARCH_KEYWORD_LINK_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(externalReferenceEntity.getGUID() + "_to_" + keywordEntity.getGUID() + "_search_keyword_link_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
            }
        }
        return externalReferenceEntity.getGUID();
    }

    public void addExternalReferenceLink(String referenceableGUID, String externalReferenceGUID, String referenceId, String description, String pages) {
        String methodName = "addExternalReferenceLink";
        EntityDetail referenceableEntity = this.archiveBuilder.getEntity(referenceableGUID);
        EntityDetail externalReferenceEntity = this.archiveBuilder.getEntity(externalReferenceGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(referenceableEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(externalReferenceEntity);
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, REFERENCE_ID_PROPERTY, referenceId, "addExternalReferenceLink");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addExternalReferenceLink");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, PAGES_PROPERTY, pages, "addExternalReferenceLink");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(EXTERNAL_REFERENCE_LINK_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(referenceableGUID + "_to_" + externalReferenceGUID + "_external_reference_link_relationship" + referenceId), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public String addMediaReference(String typeName, String qualifiedName, String displayName, String description, List<String> authors, String authorOrganization, String versionNumber, String referenceURL, String license, String copyright, String attribution, int mediaType, String mediaTypeOtherId, int defaultMediaUsage, String defaultMediaUsageOtherId, List<String> searchKeywords, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) {
        String methodName = "addMediaReference";
        String elementTypeName = RELATED_MEDIA_TYPE_NAME;
        if (typeName != null) {
            elementTypeName = typeName;
        }
        EnumElementDef typeEnumElement = this.archiveHelper.getEnumElement(MEDIA_TYPE_ENUM_NAME, mediaType);
        EnumElementDef usageEnumElement = this.archiveHelper.getEnumElement(MEDIA_USAGE_ENUM_NAME, defaultMediaUsage);
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addMediaReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addMediaReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addMediaReference");
        properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, properties, AUTHORS_PROPERTY, authors, "addMediaReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, ORGANIZATION_PROPERTY, authorOrganization, "addMediaReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, REFERENCE_VERSION_PROPERTY, versionNumber, "addMediaReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, URL_PROPERTY, referenceURL, "addMediaReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, LICENSE_PROPERTY, license, "addMediaReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, COPYRIGHT_PROPERTY, copyright, "addMediaReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, ATTRIBUTION_PROPERTY, attribution, "addMediaReference");
        properties = this.archiveHelper.addEnumPropertyToInstance(this.archiveRootName, properties, MEDIA_TYPE_PROPERTY, typeEnumElement.getOrdinal(), typeEnumElement.getValue(), typeEnumElement.getDescription(), "addMediaReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, MEDIA_TYPE_OTHER_ID_PROPERTY, mediaTypeOtherId, "addMediaReference");
        properties = this.archiveHelper.addEnumPropertyToInstance(this.archiveRootName, properties, DEFAULT_MEDIA_USAGE_PROPERTY, usageEnumElement.getOrdinal(), usageEnumElement.getValue(), usageEnumElement.getDescription(), "addMediaReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DEFAULT_MEDIA_USAGE_OTHER_ID_PROPERTY, defaultMediaUsageOtherId, "addMediaReference");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addMediaReference");
        properties = this.archiveHelper.addPropertyMapToInstance(this.archiveRootName, properties, extendedProperties, "addMediaReference");
        EntityDetail mediaReferenceEntity = this.archiveHelper.getEntityDetail(elementTypeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(mediaReferenceEntity);
        if (searchKeywords != null) {
            for (String keyword : searchKeywords) {
                if (keyword == null) continue;
                String keywordGUID = this.idToGUIDMap.queryGUID("SearchKeyword:" + keyword);
                EntityDetail keywordEntity = null;
                InstanceProperties keywordProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, KEYWORD_PROPERTY, keyword, "addMediaReference");
                if (keywordGUID != null) {
                    keywordEntity = this.archiveBuilder.queryEntity(keywordGUID);
                }
                if (keywordEntity == null) {
                    keywordEntity = this.archiveHelper.getEntityDetail(SEARCH_KEYWORD_TYPE_NAME, this.idToGUIDMap.getGUID("SearchKeyword:" + keyword), keywordProperties, InstanceStatus.ACTIVE, null);
                    this.archiveBuilder.addEntity(keywordEntity);
                }
                if (keywordEntity == null) continue;
                EntityProxy end1 = this.archiveHelper.getEntityProxy(mediaReferenceEntity);
                EntityProxy end2 = this.archiveHelper.getEntityProxy(keywordEntity);
                this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(SEARCH_KEYWORD_LINK_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(mediaReferenceEntity.getGUID() + "_to_" + keywordEntity.getGUID() + "_search_keyword_link_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
            }
        }
        return mediaReferenceEntity.getGUID();
    }

    public void addMediaReferenceLink(String referenceableGUID, String mediaReferenceGUID, String mediaId, String description, int mediaUsage, String mediaUsageOtherId) {
        String methodName = "addMediaReferenceLink";
        EnumElementDef enumElement = this.archiveHelper.getEnumElement(MEDIA_USAGE_ENUM_NAME, mediaUsage);
        EntityDetail referenceableEntity = this.archiveBuilder.getEntity(referenceableGUID);
        EntityDetail externalReferenceEntity = this.archiveBuilder.getEntity(mediaReferenceGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(referenceableEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(externalReferenceEntity);
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, MEDIA_ID_PROPERTY, mediaId, "addMediaReferenceLink");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addMediaReferenceLink");
        properties = this.archiveHelper.addEnumPropertyToInstance(this.archiveRootName, properties, MEDIA_USAGE_PROPERTY, enumElement.getOrdinal(), enumElement.getValue(), enumElement.getDescription(), "addMediaReferenceLink");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, MEDIA_TYPE_OTHER_ID_PROPERTY, mediaUsageOtherId, "addMediaReferenceLink");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(MEDIA_REFERENCE_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(referenceableGUID + "_to_" + mediaReferenceGUID + "_media_reference_relationship" + mediaId), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addDeployedOnRelationship(String deployedElementQName, String deployedOnQName, Date deploymentTime, String deployerTypeName, String deployerPropertyName, String deployer, int deploymentStatus) {
        String methodName = "addDeployedOnRelationship";
        String operationStatus = "OperationalStatus";
        String deployedElementId = this.idToGUIDMap.getGUID(deployedElementQName);
        String deployedOnId = this.idToGUIDMap.getGUID(deployedOnQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(deployedElementId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(deployedOnId));
        EnumElementDef statusEnumElement = this.archiveHelper.getEnumElement("OperationalStatus", deploymentStatus);
        InstanceProperties properties = this.archiveHelper.addDatePropertyToInstance(this.archiveRootName, null, "deploymentTime", deploymentTime, "addDeployedOnRelationship");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "deployerTypeName", deployerTypeName, "addDeployedOnRelationship");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "deployerPropertyName", deployerPropertyName, "addDeployedOnRelationship");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "deployer", deployer, "addDeployedOnRelationship");
        properties = this.archiveHelper.addEnumPropertyToInstance(this.archiveRootName, properties, "OperationalStatus", statusEnumElement.getOrdinal(), statusEnumElement.getValue(), statusEnumElement.getDescription(), "addDeployedOnRelationship");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship("DeployedOn", this.idToGUIDMap.getGUID(deployedElementId + "_to_" + deployedOnId + "_deployed_on_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public String addLocation(String qualifiedName, String identifier, String displayName, String description, Map<String, String> additionalProperties) {
        String methodName = "addLocation";
        return this.addClassifiedLocation(qualifiedName, identifier, displayName, description, additionalProperties, null, null, "addLocation");
    }

    public String addFixedLocation(String qualifiedName, String identifier, String displayName, String description, String coordinates, String mapProjection, String postalAddress, String timeZone, Map<String, String> additionalProperties) {
        String methodName = "addFixedLocation";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, COORDINATES_PROPERTY, coordinates, "addFixedLocation");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, MAP_PROJECTION_PROPERTY, mapProjection, "addFixedLocation");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, POSTAL_ADDRESS_PROPERTY, postalAddress, "addFixedLocation");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, TIME_ZONE_PROPERTY, timeZone, "addFixedLocation");
        return this.addClassifiedLocation(qualifiedName, identifier, displayName, description, additionalProperties, FIXED_LOCATION_CLASSIFICATION_NAME, properties, "addFixedLocation");
    }

    public String addSecureLocation(String qualifiedName, String identifier, String displayName, String description, String level, String securityDescription, Map<String, String> additionalProperties) {
        String methodName = "addSecureLocation";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, LEVEL_PROPERTY, level, "addSecureLocation");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, securityDescription, "addSecureLocation");
        return this.addClassifiedLocation(qualifiedName, identifier, displayName, description, additionalProperties, SECURE_LOCATION_CLASSIFICATION_NAME, properties, "addSecureLocation");
    }

    public String addCyberLocation(String qualifiedName, String identifier, String displayName, String description, String networkAddress, Map<String, String> additionalProperties) {
        String methodName = "addCyberLocation";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, NETWORK_ADDRESS_PROPERTY, networkAddress, "addCyberLocation");
        return this.addClassifiedLocation(qualifiedName, identifier, displayName, description, additionalProperties, CYBER_LOCATION_CLASSIFICATION_NAME, properties, "addCyberLocation");
    }

    private String addClassifiedLocation(String qualifiedName, String identifier, String displayName, String description, Map<String, String> additionalProperties, String classificationName, InstanceProperties classificationProperties, String methodName) {
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, methodName);
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, IDENTIFIER_PROPERTY, identifier, methodName);
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, methodName);
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, methodName);
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, methodName);
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        Classification classification = this.archiveHelper.getClassification(classificationName, classificationProperties, InstanceStatus.ACTIVE);
        classifications.add(classification);
        EntityDetail location = this.archiveHelper.getEntityDetail(LOCATION_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, classifications);
        this.archiveBuilder.addEntity(location);
        return location.getGUID();
    }

    public void addMobileAssetClassification(String assetGUID) {
        EntityDetail assetEntity = this.archiveBuilder.getEntity(assetGUID);
        EntityProxy entityProxy = this.archiveHelper.getEntityProxy(assetEntity);
        Classification classification = this.archiveHelper.getClassification(MOBILE_ASSET_CLASSIFICATION_NAME, null, InstanceStatus.ACTIVE);
        this.archiveBuilder.addClassification(this.archiveHelper.getClassificationEntityExtension(entityProxy, classification));
    }

    public void addLocationHierarchy(String broaderLocationGUID, String nestedLocationGUID) {
        EntityDetail entity1 = this.archiveBuilder.getEntity(broaderLocationGUID);
        EntityDetail entity2 = this.archiveBuilder.getEntity(nestedLocationGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(entity1);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(entity2);
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(NESTED_LOCATION_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(broaderLocationGUID + "_to_" + nestedLocationGUID + "_nested_location_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addPeerLocations(String location1GUID, String location2GUID) {
        EntityDetail referenceableEntity = this.archiveBuilder.getEntity(location1GUID);
        EntityDetail externalReferenceEntity = this.archiveBuilder.getEntity(location2GUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(referenceableEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(externalReferenceEntity);
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(ADJACENT_LOCATION_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(location1GUID + "_to_" + location2GUID + "_adjacent_location_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addAssetLocationRelationship(String locationQName, String assetQName) {
        String validValueId = this.idToGUIDMap.getGUID(locationQName);
        String assetId = this.idToGUIDMap.getGUID(assetQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(validValueId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(assetId));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(ASSET_LOCATION_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(validValueId + "_to_" + assetId + "_asset_location_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public String addUserIdentity(String qualifiedName, String userId, String distinguishedName, Map<String, String> additionalProperties) {
        String methodName = "addUserIdentity";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addUserIdentity");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, USER_ID_PROPERTY, userId, "addUserIdentity");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISTINGUISHED_NAME_PROPERTY, distinguishedName, "addUserIdentity");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addUserIdentity");
        EntityDetail userIdentity = this.archiveHelper.getEntityDetail(USER_IDENTITY_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(userIdentity);
        return userIdentity.getGUID();
    }

    public void addProfileLocationRelationship(String profileQName, String locationQName, String associationType) {
        String methodName = "addProfileLocationRelationship";
        String entity1GUID = this.idToGUIDMap.getGUID(locationQName);
        String entity2GUID = this.idToGUIDMap.getGUID(profileQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(entity1GUID));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(entity2GUID));
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, ASSOCIATION_TYPE_PROPERTY, associationType, "addProfileLocationRelationship");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(PROFILE_LOCATION_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(entity1GUID + "_to_" + entity2GUID + "_profile_location_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addProfileIdentity(String profileGUID, String userIdentityGUID, String roleTypeName, String roleGUID, String description) {
        String methodName = "addProfileIdentity";
        EntityDetail profileEntity = this.archiveBuilder.getEntity(profileGUID);
        EntityDetail userIdentityEntity = this.archiveBuilder.getEntity(userIdentityGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(profileEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(userIdentityEntity);
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, ROLE_TYPE_NAME_PROPERTY, roleTypeName, "addProfileIdentity");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, ROLE_GUID_PROPERTY, roleGUID, "addProfileIdentity");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addProfileIdentity");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(PROFILE_IDENTITY_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(profileGUID + "_to_" + userIdentityGUID + "_profile_identity_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addContactDetails(String profileGUID, String name, String contactType, int contactMethodType, String contactMethodService, String contactMethodValue) {
        String methodName = "addContactDetails";
        EntityDetail profileEntity = this.archiveBuilder.getEntity(profileGUID);
        EnumElementDef enumElement = this.archiveHelper.getEnumElement(CONTACT_METHOD_TYPE_ENUM_NAME, contactMethodType);
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, NAME_PROPERTY, name, "addContactDetails");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, CONTACT_TYPE_PROPERTY, contactType, "addContactDetails");
        properties = this.archiveHelper.addEnumPropertyToInstance(this.archiveRootName, properties, CONTACT_METHOD_TYPE_PROPERTY, enumElement.getOrdinal(), enumElement.getValue(), enumElement.getDescription(), "addContactDetails");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, CONTACT_METHOD_SERVICE_PROPERTY, contactMethodService, "addContactDetails");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, CONTACT_METHOD_VALUE_PROPERTY, contactMethodValue, "addContactDetails");
        EntityDetail contactDetails = this.archiveHelper.getEntityDetail(CONTACT_DETAILS_TYPE_NAME, this.idToGUIDMap.getGUID(contactMethodValue), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(contactDetails);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(profileEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(contactDetails);
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(CONTACT_THROUGH_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(profileGUID + "_to_" + contactDetails.getGUID() + "_contact_through_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public String addPersonRole(String suppliedTypeName, String qualifiedName, String identifier, String name, String description, String scope, boolean setHeadCount, int headCount, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) {
        String methodName = "addPersonRole";
        String typeName = suppliedTypeName;
        if (typeName == null) {
            typeName = PERSON_ROLE_TYPE_NAME;
        }
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addPersonRole");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, IDENTIFIER_PROPERTY, identifier, "addPersonRole");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, NAME_PROPERTY, name, "addPersonRole");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addPersonRole");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, SCOPE_PROPERTY, scope, "addPersonRole");
        if (setHeadCount) {
            properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, HEAD_COUNT_PROPERTY, headCount, "addPersonRole");
        }
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addPersonRole");
        properties = this.archiveHelper.addPropertyMapToInstance(this.archiveRootName, properties, extendedProperties, "addPersonRole");
        EntityDetail role = this.archiveHelper.getEntityDetail(typeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(role);
        return role.getGUID();
    }

    public String addGovernanceRole(String suppliedTypeName, String qualifiedName, int domainIdentifier, String identifier, String name, String description, String scope, boolean setHeadCount, int headCount, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) {
        String methodName = "addPersonRole";
        String typeName = suppliedTypeName;
        if (typeName == null) {
            typeName = PERSON_ROLE_TYPE_NAME;
        }
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addPersonRole");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, IDENTIFIER_PROPERTY, identifier, "addPersonRole");
        properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, DOMAIN_IDENTIFIER_PROPERTY, domainIdentifier, "addPersonRole");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, NAME_PROPERTY, name, "addPersonRole");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addPersonRole");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, SCOPE_PROPERTY, scope, "addPersonRole");
        if (setHeadCount) {
            properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, HEAD_COUNT_PROPERTY, headCount, "addPersonRole");
        }
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addPersonRole");
        properties = this.archiveHelper.addPropertyMapToInstance(this.archiveRootName, properties, extendedProperties, "addPersonRole");
        EntityDetail role = this.archiveHelper.getEntityDetail(typeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(role);
        return role.getGUID();
    }

    public void addPersonRoleAppointmentRelationship(String personQName, String personRoleQName, boolean isPublic) {
        String methodName = "addPersonRoleAppointmentRelationship";
        String guid1 = this.idToGUIDMap.getGUID(personQName);
        String guid2 = this.idToGUIDMap.getGUID(personRoleQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid1));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid2));
        InstanceProperties properties = this.archiveHelper.addBooleanPropertyToInstance(this.archiveRootName, null, IS_PUBLIC_PROPERTY, isPublic, "addPersonRoleAppointmentRelationship");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(PERSONAL_ROLE_APPOINTMENT_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(guid1 + "_to_" + guid2 + "_person_role_appointment_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addPeerRelationship(String person1QName, String person2QName) {
        String guid1 = this.idToGUIDMap.getGUID(person1QName);
        String guid2 = this.idToGUIDMap.getGUID(person2QName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid1));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid2));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(PEER_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(guid1 + "_to_" + guid2 + "_peer_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public String addPerson(String qualifiedName, String name, String pronouns, String description, String initials, String title, String givenNames, String surname, String fullName, String jobTitle, String employeeNumber, String employeeType, String preferredLanguage, boolean isPublic, Map<String, String> additionalProperties) {
        String methodName = "addPerson";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addPerson");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, NAME_PROPERTY, name, "addPerson");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, PRONOUNS_PROPERTY, pronouns, "addPerson");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addPerson");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, TITLE_PROPERTY, title, "addPerson");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, INITIALS_PROPERTY, initials, "addPerson");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, GIVEN_NAMES_PROPERTY, givenNames, "addPerson");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, SURNAME_PROPERTY, surname, "addPerson");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, FULL_NAME_PROPERTY, fullName, "addPerson");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, JOB_TITLE_PROPERTY, jobTitle, "addPerson");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, EMPLOYEE_NUMBER_PROPERTY, employeeNumber, "addPerson");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, EMPLOYEE_TYPE_PROPERTY, employeeType, "addPerson");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, PREFERRED_LANGUAGE_PROPERTY, preferredLanguage, "addPerson");
        properties = this.archiveHelper.addBooleanPropertyToInstance(this.archiveRootName, properties, IS_PUBLIC_PROPERTY, isPublic, "addPerson");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addPerson");
        EntityDetail person = this.archiveHelper.getEntityDetail(PERSON_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(person);
        return person.getGUID();
    }

    public String addTeam(String suppliedTypeName, String qualifiedName, String name, String description, String teamType, String identifier, Map<String, String> additionalProperties) {
        String methodName = "addTeam";
        String typeName = suppliedTypeName;
        if (typeName == null) {
            typeName = TEAM_TYPE_NAME;
        }
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addTeam");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, NAME_PROPERTY, name, "addTeam");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addTeam");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, TEAM_TYPE_PROPERTY, teamType, "addTeam");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, IDENTIFIER_PROPERTY, teamType, "addTeam");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addTeam");
        EntityDetail profile = this.archiveHelper.getEntityDetail(typeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(profile);
        return profile.getGUID();
    }

    public void addTeamLeadershipRelationship(String personRoleQName, String teamQName, String position) {
        String methodName = "addTeamLeadershipRelationship";
        String guid1 = this.idToGUIDMap.getGUID(personRoleQName);
        String guid2 = this.idToGUIDMap.getGUID(teamQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid1));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid2));
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, POSITION_PROPERTY, position, "addTeamLeadershipRelationship");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(TEAM_LEADERSHIP_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(guid1 + "_to_" + guid2 + "_team_leadership_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addTeamMembershipRelationship(String personRoleQName, String teamQName, String position) {
        String methodName = "addTeamMembershipRelationship";
        String guid1 = this.idToGUIDMap.getGUID(personRoleQName);
        String guid2 = this.idToGUIDMap.getGUID(teamQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid1));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid2));
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, POSITION_PROPERTY, position, "addTeamMembershipRelationship");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(TEAM_MEMBERSHIP_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(guid1 + "_to_" + guid2 + "_team_membership_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addTeamStructureRelationship(String superTeamQName, String subTeamQName, boolean delegationEscalationAuthority) {
        String methodName = "addTeamStructureRelationship";
        String guid1 = this.idToGUIDMap.getGUID(superTeamQName);
        String guid2 = this.idToGUIDMap.getGUID(subTeamQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid1));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid2));
        InstanceProperties properties = this.archiveHelper.addBooleanPropertyToInstance(this.archiveRootName, null, DELEGATION_ESCALATION_AUTHORITY_PROPERTY, delegationEscalationAuthority, "addTeamStructureRelationship");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(TEAM_STRUCTURE_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(guid1 + "_to_" + guid2 + "_team_structure_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public String addITProfileToAsset(String assetGUID, String qualifiedName, String name, String description, Map<String, String> additionalProperties) {
        String methodName = "addITProfile";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addITProfile");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, NAME_PROPERTY, name, "addITProfile");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addITProfile");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addITProfile");
        EntityDetail profile = this.archiveHelper.getEntityDetail(IT_PROFILE_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(profile);
        if (assetGUID != null) {
            EntityDetail assetEntity = this.archiveBuilder.getEntity(assetGUID);
            EntityProxy end1 = this.archiveHelper.getEntityProxy(assetEntity);
            EntityProxy end2 = this.archiveHelper.getEntityProxy(profile);
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(IT_INFRASTRUCTURE_PROFILE_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(assetGUID + "_to_" + profile.getGUID() + "_it_infrastructure_profile_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
        }
        return profile.getGUID();
    }

    public void addAssignmentScopeRelationship(String actorQName, String scopeQName, String assignmentType, String description) {
        String methodName = "addAssignmentScopeRelationship";
        String guid1 = this.idToGUIDMap.getGUID(actorQName);
        String guid2 = this.idToGUIDMap.getGUID(scopeQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid1));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid2));
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, ASSIGNMENT_TYPE_PROPERTY, assignmentType, "addAssignmentScopeRelationship");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addAssignmentScopeRelationship");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(ASSIGNMENT_SCOPE_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(guid1 + "_to_" + guid2 + "_assignment_scope_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public String addProject(String suppliedTypeName, String qualifiedName, String identifier, String name, String description, Date startDate, Date plannedEndDate, String projectStatus, boolean setCampaignClassification, boolean setTaskClassification, String projectTypeClassification, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) {
        Classification classification;
        String methodName = "addProject";
        String typeName = suppliedTypeName;
        if (typeName == null) {
            typeName = PROJECT_TYPE_NAME;
        }
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addProject");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, IDENTIFIER_PROPERTY, identifier, "addProject");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, NAME_PROPERTY, name, "addProject");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addProject");
        properties = this.archiveHelper.addDatePropertyToInstance(this.archiveRootName, properties, START_DATE_PROPERTY, startDate, "addProject");
        properties = this.archiveHelper.addDatePropertyToInstance(this.archiveRootName, properties, PLANNED_END_DATE_PROPERTY, plannedEndDate, "addProject");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, PROJECT_STATUS_PROPERTY, projectStatus, "addProject");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addProject");
        properties = this.archiveHelper.addPropertyMapToInstance(this.archiveRootName, properties, extendedProperties, "addProject");
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        if (setCampaignClassification) {
            classification = this.archiveHelper.getClassification(CAMPAIGN_CLASSIFICATION_NAME, null, InstanceStatus.ACTIVE);
            classifications.add(classification);
        }
        if (setTaskClassification) {
            classification = this.archiveHelper.getClassification(TASK_CLASSIFICATION_NAME, null, InstanceStatus.ACTIVE);
            classifications.add(classification);
        }
        if (projectTypeClassification != null) {
            classification = this.archiveHelper.getClassification(projectTypeClassification, null, InstanceStatus.ACTIVE);
            classifications.add(classification);
        }
        if (classifications.isEmpty()) {
            classifications = null;
        }
        EntityDetail project = this.archiveHelper.getEntityDetail(typeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, classifications);
        this.archiveBuilder.addEntity(project);
        return project.getGUID();
    }

    public void addProjectHierarchyRelationship(String projectQName, String subprojectQName) {
        String guid1 = this.idToGUIDMap.getGUID(projectQName);
        String guid2 = this.idToGUIDMap.getGUID(subprojectQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid1));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid2));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(PROJECT_HIERARCHY_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(guid1 + "_to_" + guid2 + "_project_hierarchy_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addStakeHolderRelationship(String referenceableQName, String actorQName) {
        String guid1 = this.idToGUIDMap.getGUID(referenceableQName);
        String guid2 = this.idToGUIDMap.getGUID(actorQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid1));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid2));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(STAKEHOLDER_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(guid1 + "_to_" + guid2 + "_stakeholder_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addProjectDependencyRelationship(String projectQName, String dependsOnProjectQName, String dependencySummary) {
        String methodName = "addProjectDependencyRelationship";
        String guid1 = this.idToGUIDMap.getGUID(projectQName);
        String guid2 = this.idToGUIDMap.getGUID(dependsOnProjectQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid1));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid2));
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, DEPENDENCY_SUMMARY_PROPERTY, dependencySummary, "addProjectDependencyRelationship");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(PROJECT_DEPENDENCY_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(guid1 + "_to_" + guid2 + "_project_dependency_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addProjectTeamRelationship(String personQName, String personRoleQName, String teamRole) {
        String methodName = "addProjectTeamRelationship";
        String guid1 = this.idToGUIDMap.getGUID(personQName);
        String guid2 = this.idToGUIDMap.getGUID(personRoleQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid1));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid2));
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, TEAM_ROLE_PROPERTY, teamRole, "addProjectTeamRelationship");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(PROJECT_TEAM_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(guid1 + "_to_" + guid2 + "_project_team_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addProjectManagementRelationship(String projectQName, String projectManagerRoleQName) {
        String guid1 = this.idToGUIDMap.getGUID(projectQName);
        String guid2 = this.idToGUIDMap.getGUID(projectManagerRoleQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid1));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid2));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(PROJECT_MANAGEMENT_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(guid1 + "_to_" + guid2 + "_project_management_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public String addCommunity(String suppliedTypeName, String qualifiedName, String name, String description, String mission, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) {
        String methodName = "addCommunity";
        String typeName = suppliedTypeName;
        if (typeName == null) {
            typeName = COMMUNITY_TYPE_NAME;
        }
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addCommunity");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, NAME_PROPERTY, name, "addCommunity");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addCommunity");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, MISSION_PROPERTY, mission, "addCommunity");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addCommunity");
        properties = this.archiveHelper.addPropertyMapToInstance(this.archiveRootName, properties, extendedProperties, "addCommunity");
        EntityDetail project = this.archiveHelper.getEntityDetail(typeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(project);
        return project.getGUID();
    }

    public void addCommunityMembershipRelationship(String communityQName, String membershipRoleQName, int membershipType) {
        String methodName = "addCommunityMembershipRelationship";
        EnumElementDef enumElement = this.archiveHelper.getEnumElement(COMMUNITY_MEMBERSHIP_TYPE_ENUM_NAME, membershipType);
        String guid1 = this.idToGUIDMap.getGUID(communityQName);
        String guid2 = this.idToGUIDMap.getGUID(membershipRoleQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid1));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid2));
        InstanceProperties properties = this.archiveHelper.addEnumPropertyToInstance(this.archiveRootName, null, MEMBERSHIP_TYPE_PROPERTY, enumElement.getOrdinal(), enumElement.getValue(), enumElement.getDescription(), "addCommunityMembershipRelationship");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(COMMUNITY_MEMBERSHIP_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(guid1 + "_to_" + guid2 + "_community_membership_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public String addCollection(String suppliedTypeName, String classificationName, String qualifiedName, String displayName, String description, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) {
        String methodName = "addCollection";
        String typeName = COLLECTION_TYPE_NAME;
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        ArrayList<Classification> classifications = null;
        if (classificationName != null) {
            classifications = new ArrayList<Classification>();
            Classification classification = this.archiveHelper.getClassification(classificationName, null, InstanceStatus.ACTIVE);
            classifications.add(classification);
        }
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addCollection");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, NAME_PROPERTY, displayName, "addCollection");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addCollection");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addCollection");
        properties = this.archiveHelper.addPropertyMapToInstance(this.archiveRootName, properties, extendedProperties, "addCollection");
        EntityDetail newEntity = this.archiveHelper.getEntityDetail(typeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, classifications);
        this.archiveBuilder.addEntity(newEntity);
        return newEntity.getGUID();
    }

    public void addMemberToCollection(String collectionGUID, String memberGUID, String membershipRationale) {
        String methodName = "addMemberToCollection";
        EntityDetail entity1 = this.archiveBuilder.getEntity(collectionGUID);
        EntityDetail entity2 = this.archiveBuilder.getEntity(memberGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(entity1);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(entity2);
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, MEMBERSHIP_RATIONALE_PROPERTY, membershipRationale, "addMemberToCollection");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(COLLECTION_MEMBER_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(collectionGUID + "_to_" + memberGUID + "_collection_membership_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public String addGovernanceDomainDescription(String governanceDomainSetGUID, String qualifiedName, int domainIdentifier, String displayName, String description, Map<String, String> additionalProperties) {
        String methodName = "addGovernanceDomainDescription";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addGovernanceDomainDescription");
        properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, DOMAIN_IDENTIFIER_PROPERTY, domainIdentifier, "addGovernanceDomainDescription");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addGovernanceDomainDescription");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addGovernanceDomainDescription");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addGovernanceDomainDescription");
        EntityDetail newEntity = this.archiveHelper.getEntityDetail(GOVERNANCE_DOMAIN_DESCRIPTION_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(newEntity);
        if (governanceDomainSetGUID != null) {
            this.addMemberToCollection(governanceDomainSetGUID, newEntity.getGUID(), null);
        }
        return newEntity.getGUID();
    }

    public String addGovernanceDefinition(String suppliedTypeName, String qualifiedName, String title, String summary, String description, String scope, int domainIdentifier, String priority, List<String> implications, List<String> outcomes, List<String> results, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) {
        String methodName = "addGovernanceDefinition";
        String typeName = GOVERNANCE_DEFINITION_TYPE_NAME;
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addGovernanceDefinition");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, TITLE_PROPERTY, title, "addGovernanceDefinition");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, SUMMARY_PROPERTY, summary, "addGovernanceDefinition");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addGovernanceDefinition");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, SCOPE_PROPERTY, scope, "addGovernanceDefinition");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, PRIORITY_PROPERTY, priority, "addGovernanceDefinition");
        properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, DOMAIN_IDENTIFIER_PROPERTY, domainIdentifier, "addGovernanceDefinition");
        properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, properties, IMPLICATIONS_PROPERTY, implications, "addGovernanceDefinition");
        properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, properties, OUTCOMES_PROPERTY, outcomes, "addGovernanceDefinition");
        properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, properties, RESULTS_PROPERTY, results, "addGovernanceDefinition");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addGovernanceDefinition");
        properties = this.archiveHelper.addPropertyMapToInstance(this.archiveRootName, properties, extendedProperties, "addGovernanceDefinition");
        EntityDetail newEntity = this.archiveHelper.getEntityDetail(typeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(newEntity);
        return newEntity.getGUID();
    }

    public void addGovernanceDefinitionScopeRelationship(String referenceableQName, String governanceDefinitionQName) {
        String guid1 = this.idToGUIDMap.getGUID(referenceableQName);
        String guid2 = this.idToGUIDMap.getGUID(governanceDefinitionQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid1));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid2));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(GOVERNANCE_DEFINITION_SCOPE_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(guid1 + "_to_" + guid2 + "_governance_definition_scope_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addGovernedByRelationship(String referenceableQName, String governanceDefinitionQName) {
        String guid1 = this.idToGUIDMap.getGUID(referenceableQName);
        String guid2 = this.idToGUIDMap.getGUID(governanceDefinitionQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid1));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid2));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(GOVERNED_BY_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(guid1 + "_to_" + guid2 + "_governed_by_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addResourceListRelationship(String referenceableQName, String resourceQName, String resourceUse, boolean watchResource) {
        String methodName = "addResourceListRelationship";
        String guid1 = this.idToGUIDMap.getGUID(referenceableQName);
        String guid2 = this.idToGUIDMap.getGUID(resourceQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid1));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid2));
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, RESOURCE_USE_PROPERTY, resourceUse, "addResourceListRelationship");
        properties = this.archiveHelper.addBooleanPropertyToInstance(this.archiveRootName, properties, WATCH_RESOURCE_PROPERTY, watchResource, "addResourceListRelationship");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(RESOURCE_LIST_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(guid1 + "_to_" + guid2 + "_resource_list_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addGovernanceDefinitionPeerRelationship(String relationshipTypeName, String governanceDefinition1QName, String governanceDefinition2QName, String description) {
        String methodName = "addGovernanceDefinitionPeerRelationship";
        String guid1 = this.idToGUIDMap.getGUID(governanceDefinition1QName);
        String guid2 = this.idToGUIDMap.getGUID(governanceDefinition2QName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid1));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid2));
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, DESCRIPTION_PROPERTY, description, "addGovernanceDefinitionPeerRelationship");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(relationshipTypeName, this.idToGUIDMap.getGUID(guid1 + "_to_" + guid2 + "_governance_definition_" + relationshipTypeName + "_peer_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addGovernanceDefinitionDelegationRelationship(String relationshipTypeName, String governanceDefinition1QName, String governanceDefinition2QName, String rationale) {
        String methodName = "addGovernanceDefinitionDelegationRelationship";
        String guid1 = this.idToGUIDMap.getGUID(governanceDefinition1QName);
        String guid2 = this.idToGUIDMap.getGUID(governanceDefinition2QName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid1));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid2));
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, RATIONALE_PROPERTY, rationale, "addGovernanceDefinitionDelegationRelationship");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(relationshipTypeName, this.idToGUIDMap.getGUID(guid1 + "_to_" + guid2 + "_governance_definition_" + relationshipTypeName + "_delegation_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public String addGovernanceZone(String qualifiedName, String zoneName, String displayName, String description, String criteria, String scope, int domainIdentifier, Map<String, String> additionalProperties) {
        String methodName = "addGovernanceZone";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addGovernanceZone");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, ZONE_NAME_PROPERTY, zoneName, "addGovernanceZone");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addGovernanceZone");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addGovernanceZone");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, SCOPE_PROPERTY, scope, "addGovernanceZone");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, CRITERIA_PROPERTY, criteria, "addGovernanceZone");
        properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, DOMAIN_IDENTIFIER_PROPERTY, domainIdentifier, "addGovernanceZone");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addGovernanceZone");
        EntityDetail newEntity = this.archiveHelper.getEntityDetail(GOVERNANCE_ZONE_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(newEntity);
        return newEntity.getGUID();
    }

    public void addZoneHierarchy(String broaderGovernanceZoneGUID, String nestedGovernanceZoneGUID) {
        EntityDetail entity1 = this.archiveBuilder.getEntity(broaderGovernanceZoneGUID);
        EntityDetail entity2 = this.archiveBuilder.getEntity(nestedGovernanceZoneGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(entity1);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(entity2);
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(ZONE_HIERARCHY_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(broaderGovernanceZoneGUID + "_to_" + nestedGovernanceZoneGUID + "_zone_hierarchy_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addAssetZoneMembershipClassification(String assetGUID, List<String> zones) {
        String methodName = "addAssetZoneMembershipClassification";
        EntityDetail assetEntity = this.archiveBuilder.getEntity(assetGUID);
        EntityProxy entityProxy = this.archiveHelper.getEntityProxy(assetEntity);
        Classification classification = this.archiveHelper.getClassification("AssetZoneMembership", this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, null, ZONE_MEMBERSHIP_PROPERTY, zones, "addAssetZoneMembershipClassification"), InstanceStatus.ACTIVE);
        this.archiveBuilder.addClassification(this.archiveHelper.getClassificationEntityExtension(entityProxy, classification));
    }

    public String addSubjectAreaDefinition(String qualifiedName, String subjectAreaName, String displayName, String description, String scope, String usage, int domainIdentifier, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) {
        String methodName = "addSubjectAreaDefinition";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addSubjectAreaDefinition");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, SUBJECT_AREA_NAME_PROPERTY, subjectAreaName, "addSubjectAreaDefinition");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addSubjectAreaDefinition");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addSubjectAreaDefinition");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, SCOPE_PROPERTY, scope, "addSubjectAreaDefinition");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, USAGE_PROPERTY, usage, "addSubjectAreaDefinition");
        properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, DOMAIN_IDENTIFIER_PROPERTY, domainIdentifier, "addSubjectAreaDefinition");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addSubjectAreaDefinition");
        properties = this.archiveHelper.addPropertyMapToInstance(this.archiveRootName, properties, extendedProperties, "addSubjectAreaDefinition");
        EntityDetail newEntity = this.archiveHelper.getEntityDetail(SUBJECT_AREA_DEFINITION_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(newEntity);
        return newEntity.getGUID();
    }

    public void addSubjectAreaHierarchy(String broaderSubjectAreaGUID, String nestedSubjectAreaGUID) {
        EntityDetail referenceableEntity = this.archiveBuilder.getEntity(broaderSubjectAreaGUID);
        EntityDetail externalReferenceEntity = this.archiveBuilder.getEntity(nestedSubjectAreaGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(referenceableEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(externalReferenceEntity);
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(SUBJECT_AREA_HIERARCHY_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(broaderSubjectAreaGUID + "_to_" + nestedSubjectAreaGUID + "_subject_area_hierarchy_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addSubjectAreaClassification(String referenceableGUID, String subjectAreaQualifiedName) {
        String methodName = "addSubjectAreaClassification";
        EntityDetail referenceableEntity = this.archiveBuilder.getEntity(referenceableGUID);
        EntityProxy referenceableEntityProxy = this.archiveHelper.getEntityProxy(referenceableEntity);
        Classification subjectAreaClassification = this.archiveHelper.getClassification(SUBJECT_AREA_CLASSIFICATION_NAME, this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, NAME_PROPERTY, subjectAreaQualifiedName, "addSubjectAreaClassification"), InstanceStatus.ACTIVE);
        this.archiveBuilder.addClassification(this.archiveHelper.getClassificationEntityExtension(referenceableEntityProxy, subjectAreaClassification));
    }

    public String addBusinessArea(String qualifiedName, String identifier, String displayName, String description, Map<String, String> additionalProperties) {
        String methodName = "addBusinessArea";
        EnumElementDef businessCapabilityTypeEnum = this.archiveHelper.getEnumElement(BUSINESS_CAPABILITY_TYPE_ENUM_NAME, 2);
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addBusinessArea");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, IDENTIFIER_PROPERTY, identifier, "addBusinessArea");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addBusinessArea");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addBusinessArea");
        properties = this.archiveHelper.addEnumPropertyToInstance(this.archiveRootName, properties, BUSINESS_CAPABILITY_TYPE_PROPERTY, businessCapabilityTypeEnum.getOrdinal(), businessCapabilityTypeEnum.getValue(), businessCapabilityTypeEnum.getDescription(), "addBusinessArea");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addBusinessArea");
        EntityDetail newEntity = this.archiveHelper.getEntityDetail(BUSINESS_CAPABILITY_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(newEntity);
        return newEntity.getGUID();
    }

    public void addOrganizationalCapabilityRelationship(String businessCapabilityQName, String teamQName, String scope) {
        String methodName = "addOrganizationalCapabilityRelationship";
        String end1GUID = this.idToGUIDMap.getGUID(businessCapabilityQName);
        String end2GUID = this.idToGUIDMap.getGUID(teamQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(end1GUID));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(end2GUID));
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, SCOPE_PROPERTY, scope, "addOrganizationalCapabilityRelationship");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(IS_A_TYPE_OF_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(end1GUID + "_to_" + end2GUID + "_organizational_capability_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public String addDesignModel(String typeName, String classificationName, String qualifiedName, String displayName, String technicalName, String description, String versionNumber, String author, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) {
        String methodName = "addDesignModel";
        String elementTypeName = DESIGN_MODEL_TYPE_NAME;
        if (typeName != null) {
            elementTypeName = typeName;
        }
        ArrayList<Classification> entityClassifications = null;
        if (classificationName != null) {
            entityClassifications = new ArrayList<Classification>();
            Classification classification = this.archiveHelper.getClassification(classificationName, null, InstanceStatus.ACTIVE);
            entityClassifications.add(classification);
        }
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addDesignModel");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, NAME_PROPERTY, displayName, "addDesignModel");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, TECHNICAL_NAME_PROPERTY, technicalName, "addDesignModel");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addDesignModel");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, VERSION_NUMBER_PROPERTY, versionNumber, "addDesignModel");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, AUTHOR_PROPERTY, author, "addDesignModel");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addDesignModel");
        properties = this.archiveHelper.addPropertyMapToInstance(this.archiveRootName, properties, extendedProperties, "addDesignModel");
        EntityDetail newEntity = this.archiveHelper.getEntityDetail(elementTypeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, entityClassifications);
        this.archiveBuilder.addEntity(newEntity);
        return newEntity.getGUID();
    }

    public String addDesignModelElement(String designModelGUID, String typeName, String qualifiedName, String displayName, String technicalName, String description, String versionNumber, String author, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, List<Classification> classifications) {
        String methodName = "addDesignModelElement";
        String elementTypeName = DESIGN_MODEL_ELEMENT_TYPE_NAME;
        if (typeName != null) {
            elementTypeName = typeName;
        }
        List<Classification> entityClassifications = classifications;
        if (designModelGUID != null) {
            if (entityClassifications == null) {
                entityClassifications = new ArrayList<Classification>();
            }
            InstanceProperties classificationProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, ANCHOR_GUID_PROPERTY, designModelGUID, "addDesignModelElement");
            Classification classification = this.archiveHelper.getClassification(ANCHORS_CLASSIFICATION_NAME, classificationProperties, InstanceStatus.ACTIVE);
            entityClassifications.add(classification);
        }
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addDesignModelElement");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addDesignModelElement");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, TECHNICAL_NAME_PROPERTY, technicalName, "addDesignModelElement");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addDesignModelElement");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, VERSION_NUMBER_PROPERTY, versionNumber, "addDesignModelElement");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, AUTHOR_PROPERTY, author, "addDesignModelElement");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addDesignModelElement");
        properties = this.archiveHelper.addPropertyMapToInstance(this.archiveRootName, properties, extendedProperties, "addDesignModelElement");
        EntityDetail newEntity = this.archiveHelper.getEntityDetail(elementTypeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, entityClassifications);
        this.archiveBuilder.addEntity(newEntity);
        if (designModelGUID != null) {
            EntityDetail designModelEntity = this.archiveBuilder.getEntity(designModelGUID);
            EntityDetail designModelElementEntity = this.archiveBuilder.getEntity(newEntity.getGUID());
            EntityProxy end1 = this.archiveHelper.getEntityProxy(designModelEntity);
            EntityProxy end2 = this.archiveHelper.getEntityProxy(designModelElementEntity);
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(DESIGN_MODEL_GROUP_MEMBERSHIP_NAME, this.idToGUIDMap.getGUID(designModelGUID + "_to_" + newEntity.getGUID() + "_design_model_group_membership_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        }
        return newEntity.getGUID();
    }

    public void addDesignModelGroupMembership(String groupGUID, String memberGUID) {
        EntityDetail designModelGroupEntity = this.archiveBuilder.getEntity(groupGUID);
        EntityDetail designModelElementEntity = this.archiveBuilder.getEntity(memberGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(designModelGroupEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(designModelElementEntity);
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(DESIGN_MODEL_GROUP_MEMBERSHIP_NAME, this.idToGUIDMap.getGUID(groupGUID + "_to_" + memberGUID + "_design_model_group_membership_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addConceptBeadRelationshipEnd(String conceptBeadLinkGUID, String conceptBeadGUID, String attributeName, int conceptModelDecoration, int position, int minCardinality, int maxCardinality, boolean uniqueValues, boolean orderedValues, boolean navigable) {
        String methodName = "addConceptBeadRelationshipEnd";
        EntityDetail entityOne = this.archiveBuilder.getEntity(conceptBeadLinkGUID);
        EntityDetail entityTwo = this.archiveBuilder.getEntity(conceptBeadGUID);
        EnumElementDef conceptModelDecorationEnum = this.archiveHelper.getEnumElement(CONCEPT_MODEL_DECORATION_ENUM_NAME, conceptModelDecoration);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(entityOne);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(entityTwo);
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, ATTRIBUTE_NAME_PROPERTY, attributeName, "addConceptBeadRelationshipEnd");
        properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, POSITION_PROPERTY, position, "addConceptBeadRelationshipEnd");
        properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, MIN_CARDINALITY_PROPERTY, minCardinality, "addConceptBeadRelationshipEnd");
        properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, MAX_CARDINALITY_PROPERTY, maxCardinality, "addConceptBeadRelationshipEnd");
        properties = this.archiveHelper.addEnumPropertyToInstance(this.archiveRootName, properties, DECORATION_PROPERTY, conceptModelDecorationEnum.getOrdinal(), conceptModelDecorationEnum.getValue(), conceptModelDecorationEnum.getDescription(), "addConceptBeadRelationshipEnd");
        properties = this.archiveHelper.addBooleanPropertyToInstance(this.archiveRootName, properties, UNIQUE_VALUES_PROPERTY, uniqueValues, "addConceptBeadRelationshipEnd");
        properties = this.archiveHelper.addBooleanPropertyToInstance(this.archiveRootName, properties, ORDERED_VALUES_PROPERTY, orderedValues, "addConceptBeadRelationshipEnd");
        properties = this.archiveHelper.addBooleanPropertyToInstance(this.archiveRootName, properties, NAVIGABLE_PROPERTY, navigable, "addConceptBeadRelationshipEnd");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(DESIGN_MODEL_GROUP_MEMBERSHIP_NAME, this.idToGUIDMap.getGUID(conceptBeadLinkGUID + "_to_" + conceptBeadGUID + "_concept_bead_relationship_end_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addConceptBeadAttributeLink(String conceptBeadGUID, String conceptBeadAttributeGUID, int position, int minCardinality, int maxCardinality, boolean uniqueValues, boolean orderedValues) {
        String methodName = "addConceptBeadAttributeLink";
        EntityDetail entityOne = this.archiveBuilder.getEntity(conceptBeadGUID);
        EntityDetail entityTwo = this.archiveBuilder.getEntity(conceptBeadAttributeGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(entityOne);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(entityTwo);
        InstanceProperties properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, null, POSITION_PROPERTY, position, "addConceptBeadAttributeLink");
        properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, MIN_CARDINALITY_PROPERTY, minCardinality, "addConceptBeadAttributeLink");
        properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, MAX_CARDINALITY_PROPERTY, maxCardinality, "addConceptBeadAttributeLink");
        properties = this.archiveHelper.addBooleanPropertyToInstance(this.archiveRootName, properties, UNIQUE_VALUES_PROPERTY, uniqueValues, "addConceptBeadAttributeLink");
        properties = this.archiveHelper.addBooleanPropertyToInstance(this.archiveRootName, properties, ORDERED_VALUES_PROPERTY, orderedValues, "addConceptBeadAttributeLink");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(DESIGN_MODEL_GROUP_MEMBERSHIP_NAME, this.idToGUIDMap.getGUID(conceptBeadGUID + "_to_" + conceptBeadAttributeGUID + "_concept_bead_attribute_link_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public String addAsset(String typeName, String qualifiedName, String name, String description, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, List<Classification> classifications) {
        return this.addAsset(typeName, qualifiedName, name, null, description, additionalProperties, extendedProperties, classifications);
    }

    public String addAsset(String typeName, String qualifiedName, String name, String versionIdentifier, String description, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, List<Classification> classifications) {
        String methodName = "addAsset";
        String assetTypeName = ASSET_TYPE_NAME;
        if (typeName != null) {
            assetTypeName = typeName;
        }
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addAsset");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, NAME_PROPERTY, name, "addAsset");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, VERSION_IDENTIFIER_PROPERTY, versionIdentifier, "addAsset");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addAsset");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addAsset");
        properties = this.archiveHelper.addPropertyMapToInstance(this.archiveRootName, properties, extendedProperties, "addAsset");
        EntityDetail assetEntity = this.archiveHelper.getEntityDetail(assetTypeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, classifications);
        this.archiveBuilder.addEntity(assetEntity);
        return assetEntity.getGUID();
    }

    public String addAsset(String typeName, String qualifiedName, String name, String description, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) {
        return this.addAsset(typeName, qualifiedName, name, description, additionalProperties, extendedProperties, null);
    }

    public String addAsset(String typeName, String qualifiedName, String name, String description, List<String> governanceZones, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) {
        return this.addAsset(typeName, qualifiedName, name, null, description, governanceZones, additionalProperties, extendedProperties);
    }

    public String addAsset(String typeName, String qualifiedName, String name, String versionIdentifier, String description, List<String> governanceZones, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) {
        String methodName = "addAsset (with governance zones)";
        if (governanceZones == null) {
            return this.addAsset(typeName, qualifiedName, name, versionIdentifier, description, additionalProperties, extendedProperties, null);
        }
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        InstanceProperties properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, null, ZONE_MEMBERSHIP_PROPERTY, governanceZones, "addAsset (with governance zones)");
        Classification classification = this.archiveHelper.getClassification("AssetZoneMembership", properties, InstanceStatus.ACTIVE);
        classifications.add(classification);
        return this.addAsset(typeName, qualifiedName, name, description, additionalProperties, extendedProperties, classifications);
    }

    public String addProcess(String typeName, String qualifiedName, String name, String description, String formula, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, List<Classification> classifications) {
        return this.addProcess(typeName, qualifiedName, name, null, description, formula, additionalProperties, extendedProperties, classifications);
    }

    public String addProcess(String typeName, String qualifiedName, String name, String versionIdentifier, String description, String formula, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, List<Classification> classifications) {
        String methodName = "addProcess";
        String processTypeName = PROCESS_TYPE_NAME;
        if (typeName != null) {
            processTypeName = typeName;
        }
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addProcess");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, NAME_PROPERTY, name, "addProcess");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, VERSION_IDENTIFIER_PROPERTY, versionIdentifier, "addProcess");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addProcess");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, FORMULA_PROPERTY, formula, "addProcess");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addProcess");
        properties = this.archiveHelper.addPropertyMapToInstance(this.archiveRootName, properties, extendedProperties, "addProcess");
        EntityDetail assetEntity = this.archiveHelper.getEntityDetail(processTypeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, classifications);
        this.archiveBuilder.addEntity(assetEntity);
        return assetEntity.getGUID();
    }

    public String addSoftwareCapability(String typeName, String qualifiedName, String name, String description, String capabilityType, String capabilityVersion, String patchLevel, String source, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) {
        String methodName = "addSoftwareCapability";
        String entityTypeName = SOFTWARE_CAPABILITY_TYPE_NAME;
        if (typeName != null) {
            entityTypeName = typeName;
        }
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addSoftwareCapability");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, NAME_PROPERTY, name, "addSoftwareCapability");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addSoftwareCapability");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, CAPABILITY_TYPE_PROPERTY, capabilityType, "addSoftwareCapability");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, CAPABILITY_VERSION_PROPERTY, capabilityVersion, "addSoftwareCapability");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, PATCH_LEVEL_PROPERTY, patchLevel, "addSoftwareCapability");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, SOURCE_PROPERTY, source, "addSoftwareCapability");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addSoftwareCapability");
        properties = this.archiveHelper.addPropertyMapToInstance(this.archiveRootName, properties, extendedProperties, "addSoftwareCapability");
        EntityDetail entity = this.archiveHelper.getEntityDetail(entityTypeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(entity);
        return entity.getGUID();
    }

    public void addConnectionForAsset(String assetGUID, String assetSummary, String connectionGUID) {
        String methodName = "addConnectionForAsset";
        EntityDetail assetEntity = this.archiveBuilder.getEntity(assetGUID);
        EntityDetail connectionEntity = this.archiveBuilder.getEntity(connectionGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(connectionEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(assetEntity);
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, ASSET_SUMMARY_PROPERTY, assetSummary, "addConnectionForAsset");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(CONNECTION_TO_ASSET_TYPE_NAME, this.idToGUIDMap.getGUID(assetGUID + "_to_" + connectionGUID + "_asset_connection_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addDataContentForDataSet(String dataContentGUID, String dataSetGUID) {
        this.addDataContentForDataSet(dataContentGUID, dataSetGUID, null, null);
    }

    public void addDataContentForDataSet(String dataContentGUID, String dataSetGUID, String queryId, String query) {
        String methodName = "addDataContentForDataSet";
        EntityDetail dataContentEntity = this.archiveBuilder.getEntity(dataContentGUID);
        EntityDetail dataSetEntity = this.archiveBuilder.getEntity(dataSetGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(dataContentEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(dataSetEntity);
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUERY_ID_PROPERTY, queryId, "addDataContentForDataSet");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, QUERY_PROPERTY, query, "addDataContentForDataSet");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(DATA_CONTENT_FOR_DATA_SET_TYPE_NAME, this.idToGUIDMap.getGUID(dataContentGUID + "_to_" + dataSetGUID + "_data_content_for_data_set_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public String addTopLevelSchemaType(String assetGUID, String typeName, String qualifiedName, String displayName, String description, Map<String, String> additionalProperties) {
        String methodName = "addTopLevelSchemaType";
        String schemaTypeTypeName = SCHEMA_TYPE_TYPE_NAME;
        if (typeName != null) {
            schemaTypeTypeName = typeName;
        }
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addTopLevelSchemaType");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addTopLevelSchemaType");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addTopLevelSchemaType");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addTopLevelSchemaType");
        EntityDetail schemaTypeEntity = this.archiveHelper.getEntityDetail(schemaTypeTypeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(schemaTypeEntity);
        if (assetGUID != null) {
            EntityDetail assetEntity = this.archiveBuilder.getEntity(assetGUID);
            EntityProxy end1 = this.archiveHelper.getEntityProxy(assetEntity);
            EntityProxy end2 = this.archiveHelper.getEntityProxy(schemaTypeEntity);
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(ASSET_SCHEMA_TYPE_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName + "_asset_schema_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        }
        return schemaTypeEntity.getGUID();
    }

    public String addAPIOperation(String apiSchemaTypeGUID, String qualifiedName, String displayName, String description, String path, String command, Map<String, String> additionalProperties) {
        String methodName = "addAPIOperation";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addAPIOperation");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addAPIOperation");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addAPIOperation");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, PATH_PROPERTY, path, "addAPIOperation");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, COMMAND_PROPERTY, command, "addAPIOperation");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addAPIOperation");
        EntityDetail schemaTypeEntity = this.archiveHelper.getEntityDetail(API_OPERATION_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(schemaTypeEntity);
        if (apiSchemaTypeGUID != null) {
            EntityDetail parentEntity = this.archiveBuilder.getEntity(apiSchemaTypeGUID);
            EntityProxy end1 = this.archiveHelper.getEntityProxy(parentEntity);
            EntityProxy end2 = this.archiveHelper.getEntityProxy(schemaTypeEntity);
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(API_OPERATIONS_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName + "_parent_api_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        }
        return schemaTypeEntity.getGUID();
    }

    public String addAPIParameterList(String apiOperationGUID, String relationshipTypeName, String qualifiedName, String displayName, String description, boolean required, Map<String, String> additionalProperties) {
        String methodName = "addAPIParameterList";
        String typeName = API_REQUEST_TYPE_NAME;
        if (relationshipTypeName != null) {
            typeName = relationshipTypeName;
        }
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addAPIParameterList");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addAPIParameterList");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addAPIParameterList");
        properties = this.archiveHelper.addBooleanPropertyToInstance(this.archiveRootName, properties, REQUIRED_PROPERTY, required, "addAPIParameterList");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addAPIParameterList");
        EntityDetail parameterListEntity = this.archiveHelper.getEntityDetail(API_PARAMETER_LIST_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(parameterListEntity);
        if (apiOperationGUID != null) {
            EntityDetail operationEntity = this.archiveBuilder.getEntity(apiOperationGUID);
            EntityProxy end1 = this.archiveHelper.getEntityProxy(operationEntity);
            EntityProxy end2 = this.archiveHelper.getEntityProxy(parameterListEntity);
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(typeName, this.idToGUIDMap.getGUID(qualifiedName + "_api_parameter_to_operation_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        }
        return parameterListEntity.getGUID();
    }

    public String addAPIParameter(String typeName, String schemaTypeName, String qualifiedName, String displayName, String description, String dataType, int length, int position, String parameterType, Map<String, String> additionalProperties) {
        String methodName = "addAPIParameter";
        String schemaAttributeTypeName = API_PARAMETER_TYPE_NAME;
        if (typeName != null) {
            schemaAttributeTypeName = typeName;
        }
        String schemaTypeTypeName = PRIMITIVE_SCHEMA_TYPE_TYPE_NAME;
        if (schemaTypeName != null) {
            schemaTypeTypeName = schemaTypeName;
        }
        InstanceProperties entityProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addAPIParameter");
        entityProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, entityProperties, DISPLAY_NAME_PROPERTY, displayName, "addAPIParameter");
        entityProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, entityProperties, DESCRIPTION_PROPERTY, description, "addAPIParameter");
        entityProperties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, entityProperties, POSITION_PROPERTY, position, "addAPIParameter");
        entityProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, entityProperties, PARAMETER_TYPE_PROPERTY, parameterType, "addAPIParameter");
        entityProperties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, entityProperties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addAPIParameter");
        InstanceProperties classificationProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, SCHEMA_TYPE_NAME_PROPERTY, schemaTypeTypeName, "addAPIParameter");
        classificationProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, classificationProperties, DATA_TYPE_PROPERTY, dataType, "addAPIParameter");
        classificationProperties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, classificationProperties, LENGTH_PROPERTY, length, "addAPIParameter");
        Classification classification = this.archiveHelper.getClassification(TYPE_EMBEDDED_ATTRIBUTE_TYPE_NAME, classificationProperties, InstanceStatus.ACTIVE);
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        classifications.add(classification);
        EntityDetail schemaAttributeEntity = this.archiveHelper.getEntityDetail(schemaAttributeTypeName, this.idToGUIDMap.getGUID(qualifiedName), entityProperties, InstanceStatus.ACTIVE, classifications);
        this.archiveBuilder.addEntity(schemaAttributeEntity);
        return schemaAttributeEntity.getGUID();
    }

    public void addSchemaTypeOption(String schemaTypeChoiceGUID, String schemaTypeOptionGUID) {
        EntityDetail schemaTypeChoiceEntity = this.archiveBuilder.getEntity(schemaTypeChoiceGUID);
        EntityDetail schemaTypeOptionEntity = this.archiveBuilder.getEntity(schemaTypeOptionGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(schemaTypeChoiceEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(schemaTypeOptionEntity);
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(SCHEMA_TYPE_OPTION_TYPE_NAME, this.idToGUIDMap.getGUID(schemaTypeChoiceGUID + "_to_" + schemaTypeOptionGUID + "_schema_type_option_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addAttributeForSchemaType(String schemaTypeGUID, String schemaAttributeGUID) {
        EntityDetail schemaTypeChoiceEntity = this.archiveBuilder.getEntity(schemaTypeGUID);
        EntityDetail schemaTypeOptionEntity = this.archiveBuilder.getEntity(schemaAttributeGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(schemaTypeChoiceEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(schemaTypeOptionEntity);
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(ATTRIBUTE_FOR_SCHEMA_TYPE_NAME, this.idToGUIDMap.getGUID(schemaTypeGUID + "_to_" + schemaAttributeGUID + "_attribute_for_schema_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addNestedSchemaAttribute(String parentSchemaAttributeGUID, String childSchemaAttributeGUID) {
        EntityDetail parentSchemaAttributeEntity = this.archiveBuilder.getEntity(parentSchemaAttributeGUID);
        EntityDetail childSchemaAttributeEntity = this.archiveBuilder.getEntity(childSchemaAttributeGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(parentSchemaAttributeEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(childSchemaAttributeEntity);
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(NESTED_SCHEMA_ATTRIBUTE_TYPE_NAME, this.idToGUIDMap.getGUID(parentSchemaAttributeGUID + "_to_" + childSchemaAttributeGUID + "_nested_schema_attribute_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public String addSchemaAttribute(String typeName, String schemaTypeName, String qualifiedName, String displayName, String description, String dataType, int length, int position, Map<String, String> additionalProperties) {
        String methodName = "addSchemaAttribute";
        String schemaAttributeTypeName = SCHEMA_ATTRIBUTE_TYPE_NAME;
        if (typeName != null) {
            schemaAttributeTypeName = typeName;
        }
        String schemaTypeTypeName = PRIMITIVE_SCHEMA_TYPE_TYPE_NAME;
        if (schemaTypeName != null) {
            schemaTypeTypeName = schemaTypeName;
        }
        InstanceProperties entityProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addSchemaAttribute");
        entityProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, entityProperties, DISPLAY_NAME_PROPERTY, displayName, "addSchemaAttribute");
        entityProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, entityProperties, DESCRIPTION_PROPERTY, description, "addSchemaAttribute");
        entityProperties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, entityProperties, POSITION_PROPERTY, position, "addSchemaAttribute");
        entityProperties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, entityProperties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addSchemaAttribute");
        InstanceProperties classificationProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, SCHEMA_TYPE_NAME_PROPERTY, schemaTypeTypeName, "addSchemaAttribute");
        classificationProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, classificationProperties, DATA_TYPE_PROPERTY, dataType, "addSchemaAttribute");
        classificationProperties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, classificationProperties, LENGTH_PROPERTY, length, "addSchemaAttribute");
        Classification classification = this.archiveHelper.getClassification(TYPE_EMBEDDED_ATTRIBUTE_TYPE_NAME, classificationProperties, InstanceStatus.ACTIVE);
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        classifications.add(classification);
        EntityDetail schemaAttributeEntity = this.archiveHelper.getEntityDetail(schemaAttributeTypeName, this.idToGUIDMap.getGUID(qualifiedName), entityProperties, InstanceStatus.ACTIVE, classifications);
        this.archiveBuilder.addEntity(schemaAttributeEntity);
        return schemaAttributeEntity.getGUID();
    }

    public String addConnection(String qualifiedName, String displayName, String description, String userId, String clearPassword, String encryptedPassword, Map<String, String> securedProperties, Map<String, Object> configurationProperties, Map<String, String> additionalProperties, String connectorTypeGUID, String endpointGUID) {
        EntityProxy end2;
        EntityProxy end1;
        String methodName = "addConnection";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addConnection");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addConnection");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addConnection");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, USER_ID_PROPERTY, userId, "addConnection");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, CLEAR_PASSWORD_PROPERTY, clearPassword, "addConnection");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, ENCRYPTED_PASSWORD_PROPERTY, encryptedPassword, "addConnection");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, SECURED_PROPERTIES_PROPERTY, securedProperties, "addConnection");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addConnection");
        properties = this.archiveHelper.addMapPropertyToInstance(this.archiveRootName, properties, CONFIGURATION_PROPERTIES_PROPERTY, configurationProperties, "addConnection");
        EntityDetail connectionEntity = this.archiveHelper.getEntityDetail(CONNECTION_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(connectionEntity);
        if (connectorTypeGUID != null) {
            EntityDetail connectorTypeEntity = this.archiveBuilder.getEntity(connectorTypeGUID);
            end1 = this.archiveHelper.getEntityProxy(connectionEntity);
            end2 = this.archiveHelper.getEntityProxy(connectorTypeEntity);
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(CONNECTION_CONNECTOR_TYPE_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName + "_connectorType_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        }
        if (endpointGUID != null) {
            EntityDetail endpointEntity = this.archiveBuilder.getEntity(endpointGUID);
            end1 = this.archiveHelper.getEntityProxy(endpointEntity);
            end2 = this.archiveHelper.getEntityProxy(connectionEntity);
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(CONNECTION_ENDPOINT_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName + "_endpoint_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        }
        return connectionEntity.getGUID();
    }

    public String addConnectorType(String connectorCategoryGUID, String connectorTypeGUID, String qualifiedName, String displayName, String description, String supportedAssetTypeName, String expectedDataFormat, String connectorProviderClassName, String connectorFrameworkName, String connectorInterfaceLanguage, List<String> connectorInterfaces, String targetTechnologySource, String targetTechnologyName, List<String> targetTechnologyInterfaces, List<String> targetTechnologyVersions, List<String> recognizedSecuredProperties, List<String> recognizedConfigurationProperties, List<String> recognizedAdditionalProperties, Map<String, String> additionalProperties) {
        this.idToGUIDMap.setGUID(qualifiedName, connectorTypeGUID);
        try {
            return this.addConnectorType(connectorCategoryGUID, qualifiedName, displayName, description, supportedAssetTypeName, expectedDataFormat, connectorProviderClassName, connectorFrameworkName, connectorInterfaceLanguage, connectorInterfaces, targetTechnologySource, targetTechnologyName, targetTechnologyInterfaces, targetTechnologyVersions, recognizedSecuredProperties, recognizedConfigurationProperties, recognizedAdditionalProperties, additionalProperties);
        }
        catch (Exception alreadyDefined) {
            return connectorTypeGUID;
        }
    }

    protected String addConnectorType(String connectorCategoryGUID, String qualifiedName, String displayName, String description, String supportedAssetTypeName, String expectedDataFormat, String connectorProviderClassName, String connectorFrameworkName, String connectorInterfaceLanguage, List<String> connectorInterfaces, String targetTechnologySource, String targetTechnologyName, List<String> targetTechnologyInterfaces, List<String> targetTechnologyVersions, List<String> recognizedSecuredProperties, List<String> recognizedConfigurationProperties, List<String> recognizedAdditionalProperties, Map<String, String> additionalProperties) {
        String methodName = "addConnectorType";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addConnectorType");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addConnectorType");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addConnectorType");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, SUPPORTED_ASSET_TYPE_PROPERTY, supportedAssetTypeName, "addConnectorType");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, EXPECTED_DATA_FORMAT_PROPERTY, expectedDataFormat, "addConnectorType");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, CONNECTOR_PROVIDER_PROPERTY, connectorProviderClassName, "addConnectorType");
        properties = connectorFrameworkName != null ? this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, CONNECTOR_FRAMEWORK_PROPERTY, connectorFrameworkName, "addConnectorType") : this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, CONNECTOR_FRAMEWORK_PROPERTY, CONNECTOR_FRAMEWORK_DEFAULT, "addConnectorType");
        properties = connectorInterfaceLanguage != null ? this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, CONNECTOR_INTERFACE_LANGUAGE_PROPERTY, connectorInterfaceLanguage, "addConnectorType") : this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, CONNECTOR_INTERFACE_LANGUAGE_PROPERTY, CONNECTOR_INTERFACE_LANGUAGE_DEFAULT, "addConnectorType");
        properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, properties, CONNECTOR_INTERFACES_PROPERTY, connectorInterfaces, "addConnectorType");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, TARGET_TECHNOLOGY_SOURCE_PROPERTY, targetTechnologySource, "addConnectorType");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, TARGET_TECHNOLOGY_NAME_PROPERTY, targetTechnologyName, "addConnectorType");
        properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, properties, TARGET_TECHNOLOGY_INTERFACES_PROPERTY, targetTechnologyInterfaces, "addConnectorType");
        properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, properties, TARGET_TECHNOLOGY_VERSIONS_PROPERTY, targetTechnologyVersions, "addConnectorType");
        properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, properties, RECOGNIZED_SECURED_PROPERTIES_PROPERTY, recognizedSecuredProperties, "addConnectorType");
        properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, properties, RECOGNIZED_ADDITIONAL_PROPERTIES_PROPERTY, recognizedAdditionalProperties, "addConnectorType");
        properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, properties, RECOGNIZED_CONFIGURATION_PROPERTIES_PROPERTY, recognizedConfigurationProperties, "addConnectorType");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addConnectorType");
        EntityDetail connectorTypeEntity = this.archiveHelper.getEntityDetail(CONNECTOR_TYPE_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(connectorTypeEntity);
        if (connectorCategoryGUID != null) {
            EntityDetail connectorCategoryEntity = this.archiveBuilder.getEntity(connectorCategoryGUID);
            EntityProxy end1 = this.archiveHelper.getEntityProxy(connectorCategoryEntity);
            EntityProxy end2 = this.archiveHelper.getEntityProxy(connectorTypeEntity);
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(CONNECTOR_IMPL_CHOICE_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName + "_connector_category_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        }
        return connectorTypeEntity.getGUID();
    }

    public String addConnectorCategory(String connectorTypeDirectoryGUID, String qualifiedName, String displayName, String description, String targetTechnologySource, String targetTechnologyName, Map<String, Boolean> recognizedSecuredProperties, Map<String, Boolean> recognizedConfigurationProperties, Map<String, Boolean> recognizedAdditionalProperties, Map<String, String> additionalProperties) {
        String methodName = "addConnectorCategory";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addConnectorCategory");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addConnectorCategory");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addConnectorCategory");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, TARGET_TECHNOLOGY_SOURCE_PROPERTY, targetTechnologySource, "addConnectorCategory");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, TARGET_TECHNOLOGY_NAME_PROPERTY, targetTechnologyName, "addConnectorCategory");
        properties = this.archiveHelper.addBooleanMapPropertyToInstance(this.archiveRootName, properties, RECOGNIZED_SECURED_PROPERTIES_PROPERTY, recognizedSecuredProperties, "addConnectorCategory");
        properties = this.archiveHelper.addBooleanMapPropertyToInstance(this.archiveRootName, properties, RECOGNIZED_ADDITIONAL_PROPERTIES_PROPERTY, recognizedAdditionalProperties, "addConnectorCategory");
        properties = this.archiveHelper.addBooleanMapPropertyToInstance(this.archiveRootName, properties, RECOGNIZED_CONFIGURATION_PROPERTIES_PROPERTY, recognizedConfigurationProperties, "addConnectorCategory");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addConnectorCategory");
        EntityDetail connectorCategoryEntity = this.archiveHelper.getEntityDetail(CONNECTOR_CATEGORY_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(connectorCategoryEntity);
        if (connectorTypeDirectoryGUID != null) {
            EntityDetail connectorTypeDirectoryEntity = this.archiveBuilder.getEntity(connectorTypeDirectoryGUID);
            EntityProxy end1 = this.archiveHelper.getEntityProxy(connectorTypeDirectoryEntity);
            EntityProxy end2 = this.archiveHelper.getEntityProxy(connectorCategoryEntity);
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(COLLECTION_MEMBER_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(qualifiedName + "_connector_type_directory_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        }
        return connectorCategoryEntity.getGUID();
    }

    public String addConnectorTypeDirectory(String qualifiedName, String displayName, String description, Map<String, String> additionalProperties) {
        String methodName = "addConnectorTypeDirectory";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addConnectorTypeDirectory");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addConnectorTypeDirectory");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addConnectorTypeDirectory");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addConnectorTypeDirectory");
        Classification classification = this.archiveHelper.getClassification(CONNECTOR_TYPE_DIRECTORY_TYPE_NAME, null, InstanceStatus.ACTIVE);
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        classifications.add(classification);
        EntityDetail connectorTypeDirectoryEntity = this.archiveHelper.getEntityDetail(COLLECTION_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, classifications);
        this.archiveBuilder.addEntity(connectorTypeDirectoryEntity);
        return connectorTypeDirectoryEntity.getGUID();
    }

    public String addEndpoint(String qualifiedName, String displayName, String description, String networkAddress, String protocol, Map<String, String> additionalProperties) {
        String methodName = "addEndpoint";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addEndpoint");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addEndpoint");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addEndpoint");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, NETWORK_ADDRESS_PROPERTY, networkAddress, "addEndpoint");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, PROTOCOL_PROPERTY, protocol, "addEndpoint");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addEndpoint");
        EntityDetail endpointEntity = this.archiveHelper.getEntityDetail(ENDPOINT_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(endpointEntity);
        return endpointEntity.getGUID();
    }

    public String addGlossary(String qualifiedName, String displayName, String description, String language, String usage, String externalLink, String scope) {
        return this.addGlossary(qualifiedName, displayName, description, language, usage, externalLink, scope, null);
    }

    public String addGlossary(String qualifiedName, String displayName, String description, String language, String usage, String externalLink, String scope, Map<String, String> additionalProperties) {
        String methodName = "addGlossary";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addGlossary");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addGlossary");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addGlossary");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, LANGUAGE_PROPERTY, language, "addGlossary");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, USAGE_PROPERTY, usage, "addGlossary");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addGlossary");
        ArrayList<Classification> classifications = null;
        if (scope != null) {
            Classification canonicalVocabClassification = this.archiveHelper.getClassification(CANONICAL_VOCABULARY_TYPE_NAME, this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, SCOPE_PROPERTY, scope, "addGlossary"), InstanceStatus.ACTIVE);
            classifications = new ArrayList<Classification>();
            classifications.add(canonicalVocabClassification);
        }
        EntityDetail glossaryEntity = this.archiveHelper.getEntityDetail(GLOSSARY_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, classifications);
        this.archiveBuilder.addEntity(glossaryEntity);
        if (externalLink != null) {
            String externalLinkQualifiedName = qualifiedName + "_external_link";
            properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, externalLinkQualifiedName, "addGlossary");
            properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, URL_PROPERTY, externalLink, "addGlossary");
            properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, ORGANIZATION_PROPERTY, this.originatorName, "addGlossary");
            properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, REFERENCE_VERSION_PROPERTY, this.versionName, "addGlossary");
            EntityDetail externalLinkEntity = this.archiveHelper.getEntityDetail(EXTERNAL_GLOSSARY_LINK_TYPE_NAME, this.idToGUIDMap.getGUID(externalLinkQualifiedName), properties, InstanceStatus.ACTIVE, classifications);
            this.archiveBuilder.addEntity(externalLinkEntity);
            EntityProxy end1 = this.archiveHelper.getEntityProxy(glossaryEntity);
            EntityProxy end2 = this.archiveHelper.getEntityProxy(externalLinkEntity);
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(EXTERNALLY_SOURCED_GLOSSARY_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(qualifiedName + "_link_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        }
        return glossaryEntity.getGUID();
    }

    public String addCategory(String glossaryGUID, String qualifiedName, String displayName, String description, String subjectArea) {
        return this.addCategory(glossaryGUID, qualifiedName, displayName, description, subjectArea, null);
    }

    public String addCategory(String glossaryGUID, String qualifiedName, String displayName, String description, String subjectArea, Map<String, String> additionalProperties) {
        String methodName = "addCategory";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addCategory");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addCategory");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addCategory");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addCategory");
        ArrayList<Classification> classifications = null;
        if (subjectArea != null) {
            Classification subjectAreaClassification = this.archiveHelper.getClassification(SUBJECT_AREA_CLASSIFICATION_NAME, this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, NAME_PROPERTY, subjectArea, "addCategory"), InstanceStatus.ACTIVE);
            classifications = new ArrayList<Classification>();
            classifications.add(subjectAreaClassification);
        }
        EntityDetail categoryEntity = this.archiveHelper.getEntityDetail(GLOSSARY_CATEGORY_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, classifications);
        this.archiveBuilder.addEntity(categoryEntity);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(glossaryGUID));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(categoryEntity);
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(CATEGORY_ANCHOR_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName + "_anchor_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        return categoryEntity.getGUID();
    }

    public String addTerm(String glossaryGUID, List<String> categoryGUIDs, String qualifiedName, String displayName, String description) {
        return this.addTerm(glossaryGUID, categoryGUIDs, false, qualifiedName, displayName, null, description, null, null, null, false, false, false, null, null, null);
    }

    public String addTerm(String glossaryGUID, List<String> categoryIds, boolean categoriesAsNames, String qualifiedName, String displayName, String summary, String description, String examples, String abbreviation, String usage, boolean isSpineObject, boolean isSpineAttribute, boolean isContext, String contextDescription, String contextScope, Map<String, String> additionalProperties) {
        Classification newClassification;
        String methodName = "addTerm";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addTerm");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addTerm");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, SUMMARY_PROPERTY, summary, "addTerm");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addTerm");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, EXAMPLES_PROPERTY, examples, "addTerm");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, ABBREVIATION_PROPERTY, abbreviation, "addTerm");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, USAGE_PROPERTY, usage, "addTerm");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addTerm");
        if (examples != null) {
            properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, EXAMPLES_PROPERTY, examples, "addTerm");
        }
        ArrayList<Classification> classifications = null;
        if (isSpineObject) {
            newClassification = this.archiveHelper.getClassification(SPINE_OBJECT_NAME, null, InstanceStatus.ACTIVE);
            classifications = new ArrayList<Classification>();
            classifications.add(newClassification);
        }
        if (isSpineAttribute) {
            newClassification = this.archiveHelper.getClassification(SPINE_ATTRIBUTE_NAME, null, InstanceStatus.ACTIVE);
            if (classifications == null) {
                classifications = new ArrayList();
            }
            classifications.add(newClassification);
        }
        if (isContext) {
            InstanceProperties classificationProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, DESCRIPTION_PROPERTY, contextDescription, "addTerm");
            classificationProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, classificationProperties, SCOPE_PROPERTY, contextScope, "addTerm");
            Classification newClassification2 = this.archiveHelper.getClassification(CONTEXT_DEFINITION_CLASSIFICATION_NAME, classificationProperties, InstanceStatus.ACTIVE);
            if (classifications == null) {
                classifications = new ArrayList();
            }
            classifications.add(newClassification2);
        }
        EntityDetail termEntity = this.archiveHelper.getEntityDetail(GLOSSARY_TERM_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, classifications);
        this.archiveBuilder.addEntity(termEntity);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(glossaryGUID));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(termEntity);
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(TERM_ANCHOR_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName + "_anchor_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        if (categoryIds != null) {
            InstanceProperties categorizationProperties = this.archiveHelper.addEnumPropertyToInstance(this.archiveRootName, null, STATUS_PROPERTY, this.activeStatus.getOrdinal(), this.activeStatus.getValue(), this.activeStatus.getDescription(), "addTerm");
            for (String categoryId : categoryIds) {
                if (categoryId == null) continue;
                String categoryGUID = categoryId;
                if (categoriesAsNames) {
                    categoryGUID = this.idToGUIDMap.getGUID(categoryId);
                }
                end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(categoryGUID));
                this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(TERM_CATEGORIZATION_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName + "_category_" + categoryId + "_term_categorization_relationship"), categorizationProperties, InstanceStatus.ACTIVE, end1, end2));
            }
        }
        return termEntity.getGUID();
    }

    public void addCategoryToCategory(String parentCategoryGUID, String childCategoryGUID) {
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(parentCategoryGUID));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(childCategoryGUID));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(CATEGORY_HIERARCHY_LINK_TYPE_NAME, this.idToGUIDMap.getGUID(parentCategoryGUID + "_to_" + childCategoryGUID + "_category_hierarchy_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addTermToContext(String contextGUID, String termGUID, int status, String description) {
        String methodName = "addTermToContext";
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(termGUID));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(contextGUID));
        EnumElementDef termStatus = this.archiveHelper.getEnumElement(TERM_RELATIONSHIP_STATUS_ENUM_NAME, status);
        InstanceProperties properties = this.archiveHelper.addEnumPropertyToInstance(this.archiveRootName, null, STATUS_PROPERTY, termStatus.getOrdinal(), termStatus.getValue(), termStatus.getDescription(), "addTermToContext");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addTermToContext");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(USED_IN_CONTEXT_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(contextGUID + "_to_" + termGUID + "_used_in_context_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addTermToSynonym(String synonymGUID, String termGUID, int status, String description, String expression, String steward, String source) {
        String methodName = "addTermToSynonym";
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(synonymGUID));
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(termGUID));
        EnumElementDef termStatus = this.archiveHelper.getEnumElement(TERM_RELATIONSHIP_STATUS_ENUM_NAME, status);
        InstanceProperties properties = this.archiveHelper.addEnumPropertyToInstance(this.archiveRootName, null, STATUS_PROPERTY, termStatus.getOrdinal(), termStatus.getValue(), termStatus.getDescription(), "addTermToSynonym");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addTermToSynonym");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, EXPRESSION_PROPERTY, expression, "addTermToSynonym");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, STEWARD_PROPERTY, steward, "addTermToSynonym");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, SOURCE_PROPERTY, source, "addTermToSynonym");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(SYNONYM_RELATIONSHIP_TYPE_NAME, this.idToGUIDMap.getGUID(synonymGUID + "_to_" + termGUID + "_synonym_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addTermToCategory(String categoryGUID, String termGUID) {
        this.addTermToCategory(categoryGUID, termGUID, 1, null);
    }

    public void addTermToCategory(String categoryGUID, String termGUID, int status, String description) {
        String methodName = "addTermToCategory";
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(categoryGUID));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(termGUID));
        EnumElementDef termStatus = this.archiveHelper.getEnumElement(TERM_RELATIONSHIP_STATUS_ENUM_NAME, status);
        InstanceProperties properties = this.archiveHelper.addEnumPropertyToInstance(this.archiveRootName, null, STATUS_PROPERTY, termStatus.getOrdinal(), termStatus.getValue(), termStatus.getDescription(), "addTermToCategory");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addTermToCategory");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(TERM_CATEGORIZATION_TYPE_NAME, this.idToGUIDMap.getGUID(categoryGUID + "_to_" + termGUID + "_term_categorization_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addLibraryCategoryReference(String categoryGUID, String externalGlossaryLinkGUID, String identifier, String description, String steward, Date lastVerified) {
        String methodName = "addLibraryCategoryReference";
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(categoryGUID));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(externalGlossaryLinkGUID));
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, IDENTIFIER_PROPERTY, identifier, "addLibraryCategoryReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addLibraryCategoryReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, STEWARD_PROPERTY, steward, "addLibraryCategoryReference");
        properties = this.archiveHelper.addDatePropertyToInstance(this.archiveRootName, properties, LAST_VERIFIED_PROPERTY, lastVerified, "addLibraryCategoryReference");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(LIBRARY_CATEGORY_REFERENCE_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(categoryGUID + "_to_" + externalGlossaryLinkGUID + "_library_category_reference_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addLibraryTermReference(String termGUID, String externalGlossaryLinkGUID, String identifier, String description, String steward, Date lastVerified) {
        String methodName = "addLibraryTermReference";
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(termGUID));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(externalGlossaryLinkGUID));
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, IDENTIFIER_PROPERTY, identifier, "addLibraryTermReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addLibraryTermReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, STEWARD_PROPERTY, steward, "addLibraryTermReference");
        properties = this.archiveHelper.addDatePropertyToInstance(this.archiveRootName, properties, LAST_VERIFIED_PROPERTY, lastVerified, "addLibraryTermReference");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(LIBRARY_TERM_REFERENCE_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(termGUID + "_to_" + externalGlossaryLinkGUID + "_library_term_reference_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addMoreInformationLink(String describedElementId, String describerElementId) {
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(describedElementId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(describerElementId));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(MORE_INFORMATION_TYPE_NAME, this.idToGUIDMap.getGUID(describedElementId + "_to_" + describerElementId + "_more_information_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public void linkTermToReferenceable(String termId, String referenceableId) {
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(referenceableId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(termId));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(SEMANTIC_ASSIGNMENT_TYPE_NAME, this.idToGUIDMap.getGUID(referenceableId + "_to_" + termId + "_semantic_assignment_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addIsATypeOfRelationship(String specialTermQName, String generalizedTermQName) {
        String specializedTermId = this.idToGUIDMap.getGUID(specialTermQName);
        String generalizedTermId = this.idToGUIDMap.getGUID(generalizedTermQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(specializedTermId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(generalizedTermId));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(IS_A_TYPE_OF_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(specializedTermId + "_to_" + generalizedTermId + "_isatypeof_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addHasARelationship(String conceptQName, String propertyQName) {
        String conceptId = this.idToGUIDMap.getGUID(conceptQName);
        String propertyId = this.idToGUIDMap.getGUID(propertyQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(propertyId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(conceptId));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(HAS_A_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(conceptId + "_to_" + propertyId + "_hasa_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addRelatedTermRelationship(String conceptQName, String propertyQName) {
        String conceptId = this.idToGUIDMap.getGUID(conceptQName);
        String propertyId = this.idToGUIDMap.getGUID(propertyQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(conceptId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(propertyId));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(RELATED_TERM_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(conceptId + "_to_" + propertyId + "_related_term_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public String addValidValue(String typeName, String qualifiedName, String displayName, String description, String usage, String scope, String preferredValue, boolean isDeprecated, Map<String, String> additionalProperties) {
        String methodName = "addValidValue";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addValidValue");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addValidValue");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addValidValue");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, USAGE_PROPERTY, usage, "addValidValue");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, SCOPE_PROPERTY, scope, "addValidValue");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, PREFERRED_VALUE_PROPERTY, preferredValue, "addValidValue");
        properties = this.archiveHelper.addBooleanPropertyToInstance(this.archiveRootName, properties, IS_DEPRECATED_PROPERTY, isDeprecated, "addValidValue");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addValidValue");
        EntityDetail termEntity = this.archiveHelper.getEntityDetail(typeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(termEntity);
        return termEntity.getGUID();
    }

    public void addValidValueMembershipRelationship(String setQName, String memberQName, boolean isDefaultValue) {
        String methodName = "addValidValuesAssignmentRelationship";
        String setId = this.idToGUIDMap.getGUID(setQName);
        String memberId = this.idToGUIDMap.getGUID(memberQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(setId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(memberId));
        InstanceProperties properties = this.archiveHelper.addBooleanPropertyToInstance(this.archiveRootName, null, IS_DEFAULT_VALUE_PROPERTY, isDefaultValue, "addValidValuesAssignmentRelationship");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(VALID_VALUE_MEMBER_TYPE_NAME, this.idToGUIDMap.getGUID(setId + "_to_" + memberId + "_valid_value_member_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addValidValuesAssignmentRelationship(String dataFieldQName, String validValueQName, boolean strictRequirement) {
        String methodName = "addValidValuesAssignmentRelationship";
        String dataFieldId = this.idToGUIDMap.getGUID(dataFieldQName);
        String validValueId = this.idToGUIDMap.getGUID(validValueQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(dataFieldId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(validValueId));
        InstanceProperties properties = this.archiveHelper.addBooleanPropertyToInstance(this.archiveRootName, null, STRICT_REQUIREMENT_PROPERTY, strictRequirement, "addValidValuesAssignmentRelationship");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(VALID_VALUES_ASSIGNMENT_TYPE_NAME, this.idToGUIDMap.getGUID(dataFieldId + "_to_" + validValueId + "_valid_values_assignment_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addValidValuesMappingRelationship(String matchingValue1QName, String matchingValue2QName, String associationDescription, int confidence, String steward, String stewardTypeName, String stewardPropertyName, String notes) {
        String methodName = "addValidValuesMappingRelationship";
        String matchingValue1Id = this.idToGUIDMap.getGUID(matchingValue1QName);
        String matchingValueId = this.idToGUIDMap.getGUID(matchingValue2QName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(matchingValue1Id));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(matchingValueId));
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, ASSOCIATION_DESCRIPTION_PROPERTY, associationDescription, "addValidValuesMappingRelationship");
        properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, CONFIDENCE_PROPERTY, confidence, "addValidValuesMappingRelationship");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, STEWARD_PROPERTY, steward, "addValidValuesMappingRelationship");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, STEWARD_TYPE_NAME_PROPERTY, stewardTypeName, "addValidValuesMappingRelationship");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, STEWARD_PROPERTY_NAME_PROPERTY, stewardPropertyName, "addValidValuesMappingRelationship");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, NOTES_PROPERTY, notes, "addValidValuesMappingRelationship");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(VALID_VALUES_MAPPING_TYPE_NAME, this.idToGUIDMap.getGUID(matchingValue1Id + "_to_" + matchingValueId + "_valid_values_mapping_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addReferenceValueAssignmentRelationship(String referenceableQName, String validValueQName, int confidence, String steward, String stewardTypeName, String stewardPropertyName, String notes) {
        String methodName = "addReferenceValueAssignmentRelationship";
        String referenceableId = this.idToGUIDMap.getGUID(referenceableQName);
        String validValueId = this.idToGUIDMap.getGUID(validValueQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(referenceableId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(validValueId));
        InstanceProperties properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, null, CONFIDENCE_PROPERTY, confidence, "addReferenceValueAssignmentRelationship");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, STEWARD_PROPERTY, steward, "addReferenceValueAssignmentRelationship");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, STEWARD_TYPE_NAME_PROPERTY, stewardTypeName, "addReferenceValueAssignmentRelationship");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, STEWARD_PROPERTY_NAME_PROPERTY, stewardPropertyName, "addReferenceValueAssignmentRelationship");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, NOTES_PROPERTY, notes, "addReferenceValueAssignmentRelationship");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(REFERENCE_VALUE_ASSIGNMENT_TYPE_NAME, this.idToGUIDMap.getGUID(referenceableId + "_to_" + validValueId + "_reference_value_assignment_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addValidValuesImplementationRelationship(String validValueQName, String assetQName, String symbolicName, String implementationValue, Map<String, String> additionalValues) {
        String methodName = "addValidValuesImplementationRelationship";
        String validValueId = this.idToGUIDMap.getGUID(validValueQName);
        String assetId = this.idToGUIDMap.getGUID(assetQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(validValueId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(assetId));
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, SYMBOLIC_NAME_PROPERTY, symbolicName, "addValidValuesImplementationRelationship");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, IMPLEMENTATION_VALUE_PROPERTY, implementationValue, "addValidValuesImplementationRelationship");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_VALUES_PROPERTY, additionalValues, "addValidValuesImplementationRelationship");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(VALID_VALUES_IMPLEMENTATION_TYPE_NAME, this.idToGUIDMap.getGUID(validValueId + "_to_" + assetId + "_valid_values_implementation_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addReferenceDataClassification(String assetGUID) {
        EntityDetail assetEntity = this.archiveBuilder.getEntity(assetGUID);
        EntityProxy referenceableEntityProxy = this.archiveHelper.getEntityProxy(assetEntity);
        Classification classification = this.archiveHelper.getClassification(REFERENCE_DATA_CLASSIFICATION_NAME, null, InstanceStatus.ACTIVE);
        this.archiveBuilder.addClassification(this.archiveHelper.getClassificationEntityExtension(referenceableEntityProxy, classification));
    }

    public void addSecurityTagsClassification(String assetGUID, List<String> securityLabels, Map<String, Object> securityProperties, Map<String, List<String>> accessGroups) {
        String methodName = "addSecurityTagsClassification";
        EntityDetail assetEntity = this.archiveBuilder.getEntity(assetGUID);
        EntityProxy entityProxy = this.archiveHelper.getEntityProxy(assetEntity);
        InstanceProperties properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, null, SECURITY_LABELS_PROPERTY, securityLabels, "addSecurityTagsClassification");
        properties = this.archiveHelper.addMapPropertyToInstance(this.archiveRootName, properties, SECURITY_PROPERTIES_PROPERTY, securityProperties, "addSecurityTagsClassification");
        properties = this.archiveHelper.addStringArrayStringMapPropertyToInstance(this.archiveRootName, properties, ACCESS_GROUPS_PROPERTY, accessGroups, "addSecurityTagsClassification");
        Classification classification = this.archiveHelper.getClassification(SECURITY_TAGS_CLASSIFICATION_NAME, properties, InstanceStatus.ACTIVE);
        this.archiveBuilder.addClassification(this.archiveHelper.getClassificationEntityExtension(entityProxy, classification));
    }
}

