/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.archiveutilities.bigglossaries.catalogcontent;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.OpenMetadataArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.samples.archiveutilities.SimpleCatalogArchiveHelper;

public class BigGlossaryArchiveBuilder {
    private static final String archiveGUID = "9e594f24-2494-4000-ac20-59f374eaa0e6";
    private static final String archiveNamePrefix = "BigGlossary";
    private static final String archiveLicense = "Apache-2.0";
    private static final String archiveDescription = "Sample glossary with 10,000 unique terms.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.REPOSITORY_BACKUP;
    private static final String originatorName = "Egeria";
    private static final Date creationDate = new Date(1681646242899L);
    private static final String glossaryTermPrefix = "Term";
    private static final String glossaryTermSummaryPrefix = "Summary of glossary term: ";
    private static final String glossaryTermDescriptionPrefix = "Description of glossary term: ";
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final SimpleCatalogArchiveHelper archiveHelper;
    private final String glossaryIdentifier;

    public BigGlossaryArchiveBuilder(String glossaryIdentifier) {
        ArrayList<OpenMetadataArchive> dependentOpenMetadataArchives = new ArrayList<OpenMetadataArchive>();
        String archiveName = "BigGlossary:" + glossaryIdentifier;
        this.glossaryIdentifier = glossaryIdentifier;
        dependentOpenMetadataArchives.add(new OpenMetadataTypesArchive().getOpenMetadataArchive());
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, originatorName, archiveLicense, creationDate, dependentOpenMetadataArchives);
        this.archiveHelper = new SimpleCatalogArchiveHelper((OpenMetadataArchiveBuilder)this.archiveBuilder, archiveGUID, archiveName, archiveNamePrefix, originatorName, creationDate, 1L, versionName, InstanceProvenanceType.LOCAL_COHORT, null);
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String glossaryGUID = this.archiveHelper.addGlossary("Glossary:" + this.glossaryIdentifier, this.glossaryIdentifier, null, null, null, null, null);
        for (int i = 1; i < 10001; ++i) {
            String glossaryTermName = MessageFormat.format("Term{1, number,000000}", glossaryTermPrefix, i);
            System.out.println("Adding glossary term: " + glossaryTermName);
            this.archiveHelper.addTerm(glossaryGUID, null, "GlossaryTerm:" + glossaryTermName, glossaryTermName, glossaryTermDescriptionPrefix + glossaryTermName);
        }
        this.archiveHelper.saveGUIDs();
        return this.archiveBuilder.getOpenMetadataArchive();
    }
}

