/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive4_2;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "4.3";
    private static final String originatorName = "Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive4_2 previousTypes = new OpenMetadataTypesArchive4_2(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.update0010Base();
        this.update0017ExternalIdentifiers();
        this.update0035Hosts();
        this.update0112People();
        this.update0210DataStores();
        this.update0212APIs();
        this.update0224Databases();
        this.update0215SoftwareComponents();
        this.update0223Events();
    }

    private void update0010Base() {
        this.archiveBuilder.addTypeDefPatch(this.updateDataSet());
    }

    private TypeDefPatch updateDataSet() {
        String typeName = "DataSet";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("DataSet");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "deployedImplementationType";
        String attribute1Description = "Name of the technology used to implement this data set.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("deployedImplementationType", "Name of the technology used to implement this data set.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0017ExternalIdentifiers() {
        this.archiveBuilder.addTypeDefPatch(this.updateExternalId());
    }

    private TypeDefPatch updateExternalId() {
        String typeName = "ExternalId";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ExternalId");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "externalInstanceCreatedBy";
        String attribute1Description = "The username of the person or process that created the instance in the external system.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "externalInstanceCreationTime";
        String attribute2Description = "The date/time when the instance in the external system was created.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "externalInstanceLastUpdatedBy";
        String attribute3Description = "The username of the person or process that last updated the instance in the external system.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "externalInstanceLastUpdateTime";
        String attribute4Description = "The date/time when the instance in the external system was last updated.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "externalInstanceVersion";
        String attribute5Description = "The latest version of the element in the external system.";
        String attribute5DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("externalInstanceCreatedBy", "The username of the person or process that created the instance in the external system.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("externalInstanceCreationTime", "The date/time when the instance in the external system was created.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("externalInstanceLastUpdatedBy", "The username of the person or process that last updated the instance in the external system.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("externalInstanceLastUpdateTime", "The date/time when the instance in the external system was last updated.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getLongTypeDefAttribute("externalInstanceVersion", "The latest version of the element in the external system.", attribute5DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0035Hosts() {
        this.archiveBuilder.addTypeDefPatch(this.updateHostClusterMemberRelationship());
    }

    private TypeDefPatch updateHostClusterMemberRelationship() {
        String typeName = "HostClusterMember";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("HostClusterMember");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "memberRole";
        String attribute1Description = "The role of the member in the host cluster.  This value is typically defined by the technology of the host cluster.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "additionalProperties";
        String attribute2Description = "Additional properties that define the configuration and properties of the member.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("memberRole", "The role of the member in the host cluster.  This value is typically defined by the technology of the host cluster.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute("additionalProperties", "Additional properties that define the configuration and properties of the member.", attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0112People() {
        this.archiveBuilder.addTypeDefPatch(this.updatePerson());
    }

    private TypeDefPatch updatePerson() {
        String typeName = "Person";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("Person");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "residentCountry";
        String attribute1Description = "Country that is the person's primary residence.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "timeZone";
        String attribute2Description = "Principle time zone where this person is located.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("residentCountry", "Country that is the person's primary residence.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("timeZone", "Principle time zone where this person is located.", attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0210DataStores() {
        this.archiveBuilder.addTypeDefPatch(this.updateDataStore());
    }

    private TypeDefPatch updateDataStore() {
        String typeName = "DataStore";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("DataStore");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "deployedImplementationType";
        String attribute1Description = "Name of the technology used to implement this data store.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("deployedImplementationType", "Name of the technology used to implement this data store.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0212APIs() {
        this.archiveBuilder.addTypeDefPatch(this.updateDeployedAPI());
    }

    private TypeDefPatch updateDeployedAPI() {
        String typeName = "DeployedAPI";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("DeployedAPI");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "deployedImplementationType";
        String attribute1Description = "Name of the technology used to implement this API.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("deployedImplementationType", "Name of the technology used to implement this API.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0215SoftwareComponents() {
        this.archiveBuilder.addTypeDefPatch(this.updateDeployedSoftwareComponent());
    }

    private TypeDefPatch updateDeployedSoftwareComponent() {
        String typeName = "DeployedSoftwareComponent";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("DeployedSoftwareComponent");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "deployedImplementationType";
        String attribute1Description = "Name of the technology used to implement this component.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("deployedImplementationType", "Name of the technology used to implement this component.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0223Events() {
        this.archiveBuilder.addTypeDefPatch(this.updateDataFeed());
    }

    private TypeDefPatch updateDataFeed() {
        String typeName = "DataFeed";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("DataFeed");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "deployedImplementationType";
        String attribute1Description = "Name of the technology used to implement this data feed.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("deployedImplementationType", "Name of the technology used to implement this data feed.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0224Databases() {
        this.archiveBuilder.addEntityDef(this.addRelationalDatabaseEntity());
    }

    private EntityDef addRelationalDatabaseEntity() {
        String guid = "6a28e242-4eca-4664-81cb-e2096d769568";
        String name = "RelationalDatabase";
        String description = "A database that follows the relational schema (tables and columns) and can be accessed through Java Database Connectivity (JDBC).";
        String descriptionGUID = null;
        String superTypeName = "Database";
        return this.archiveHelper.getDefaultEntityDef("6a28e242-4eca-4664-81cb-e2096d769568", "RelationalDatabase", this.archiveBuilder.getEntityDef("Database"), "A database that follows the relational schema (tables and columns) and can be accessed through Java Database Connectivity (JDBC).", descriptionGUID);
    }
}

