/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive3_12;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive3_13 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "3.13";
    private static final String originatorName = "Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive3_13() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive3_13(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive3_12 previousTypes = new OpenMetadataTypesArchive3_12(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.update0010BaseModel();
        this.update0022Translations();
        this.addArea1Actors();
        this.add0222DataFilesAndFolders();
        this.add0223DataFeed();
        this.add0430ServiceLevelObjectives();
        this.update0481Licenses();
        this.add0483TermsAndConditions();
        this.add0484Agreements();
        this.add00710DigitalProduct();
        this.add00711DigitalSubscription();
        this.update0715DigitalServiceOwnership();
    }

    private void update0010BaseModel() {
        this.archiveBuilder.addTypeDefPatch(this.updateAsset());
    }

    private TypeDefPatch updateAsset() {
        String typeName = "Asset";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("Asset");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "versionIdentifier";
        String attribute1Description = "Version identifier to allow different versions of the same resource to appear in the catalog as separate assets.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("versionIdentifier", "Version identifier to allow different versions of the same resource to appear in the catalog as separate assets.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0022Translations() {
        this.archiveBuilder.addTypeDefPatch(this.updateTranslation());
    }

    private TypeDefPatch updateTranslation() {
        String typeName = "TranslationDetail";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("TranslationDetail");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "languageCode";
        String attribute1Description = "Code for identifying the language - for example from ISO-639.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("languageCode", "Code for identifying the language - for example from ISO-639.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void addArea1Actors() {
        this.archiveBuilder.addEntityDef(this.getActorEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateActorProfile());
        this.archiveBuilder.addTypeDefPatch(this.updateUserIdentity());
        this.archiveBuilder.addTypeDefPatch(this.updatePersonRole());
        this.archiveBuilder.addTypeDefPatch(this.updateProjectTeam());
        this.archiveBuilder.addTypeDefPatch(this.updateToDo());
        this.archiveBuilder.addTypeDefPatch(this.updateActionAssignment());
        this.archiveBuilder.addTypeDefPatch(this.updateCrowdSourcingContribution());
    }

    private EntityDef getActorEntity() {
        String guid = "16d2c34a-43db-476b-93ae-6a2996f514ec";
        String name = "Actor";
        String description = "The representation of a person or group of people that are identified to perform an action or take on a responsibility.";
        String descriptionGUID = null;
        String superTypeName = "Referenceable";
        return this.archiveHelper.getDefaultEntityDef("16d2c34a-43db-476b-93ae-6a2996f514ec", "Actor", this.archiveBuilder.getEntityDef("Referenceable"), "The representation of a person or group of people that are identified to perform an action or take on a responsibility.", descriptionGUID);
    }

    private TypeDefPatch updateActorProfile() {
        String typeName = "ActorProfile";
        String superTypeName = "Actor";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ActorProfile");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef("Actor"));
        return typeDefPatch;
    }

    private TypeDefPatch updateUserIdentity() {
        String typeName = "UserIdentity";
        String superTypeName = "Actor";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("UserIdentity");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef("Actor"));
        return typeDefPatch;
    }

    private TypeDefPatch updatePersonRole() {
        String typeName = "PersonRole";
        String superTypeName = "Actor";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("PersonRole");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef("Actor"));
        return typeDefPatch;
    }

    private TypeDefPatch updateProjectTeam() {
        String typeName = "ProjectTeam";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ProjectTeam");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end2EntityType = "Actor";
        String end2AttributeName = "supportingActors";
        String end2AttributeDescription = "People and teams supporting this project.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Actor"), "supportingActors", "People and teams supporting this project.", end2AttributeDescriptionGUID, end2Cardinality);
        typeDefPatch.setEndDef2(relationshipEndDef);
        return typeDefPatch;
    }

    private TypeDefPatch updateToDo() {
        String typeName = "ToDo";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ToDo");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "toDoType";
        String attribute1Description = "Type of to do - typically managed in a valid value set and used in stewardship automation.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("toDoType", "Type of to do - typically managed in a valid value set and used in stewardship automation.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateActionAssignment() {
        String typeName = "ActionAssignment";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ActionAssignment");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end2EntityType = "Actor";
        String end2AttributeName = "assignedActor";
        String end2AttributeDescription = "The person/people assigned to perform the action(s) requested in the to do.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Actor"), "assignedActor", "The person/people assigned to perform the action(s) requested in the to do.", end2AttributeDescriptionGUID, end2Cardinality);
        typeDefPatch.setEndDef2(relationshipEndDef);
        return typeDefPatch;
    }

    private TypeDefPatch updateCrowdSourcingContribution() {
        String typeName = "CrowdSourcingContribution";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("CrowdSourcingContribution");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end2EntityType = "Actor";
        String end2AttributeName = "contributors";
        String end2AttributeDescription = "The person/people making the contribution.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Actor"), "contributors", "The person/people making the contribution.", end2AttributeDescriptionGUID, end2Cardinality);
        typeDefPatch.setEndDef2(relationshipEndDef);
        return typeDefPatch;
    }

    private void add0222DataFilesAndFolders() {
        this.archiveBuilder.addEntityDef(this.getParquetFileEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateDataFileEntity());
    }

    private TypeDefPatch updateDataFileEntity() {
        String typeName = "DataFile";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("DataFile");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "fileName";
        String attribute1Description = "The name of the file with extension.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("fileName", "The name of the file with extension.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private EntityDef getParquetFileEntity() {
        String guid = "97cba3a0-1dfd-4129-82b6-798de3eec0a4";
        String name = "ParquetFile";
        String description = "A data file which is formatted using the Apache Parquet format.";
        String descriptionGUID = null;
        String superTypeName = "DataFile";
        return this.archiveHelper.getDefaultEntityDef("97cba3a0-1dfd-4129-82b6-798de3eec0a4", "ParquetFile", this.archiveBuilder.getEntityDef("DataFile"), "A data file which is formatted using the Apache Parquet format.", descriptionGUID);
    }

    private void add0223DataFeed() {
        this.archiveBuilder.addEntityDef(this.getDataFeedEntity());
    }

    private EntityDef getDataFeedEntity() {
        String guid = "e87836ad-f8bd-4c52-aecd-0f1872c692e5";
        String name = "DataFeed";
        String description = "A data source that provides a constant stream of data, such as a sensor monitoring the environment.";
        String descriptionGUID = null;
        String superTypeName = "Asset";
        return this.archiveHelper.getDefaultEntityDef("e87836ad-f8bd-4c52-aecd-0f1872c692e5", "DataFeed", this.archiveBuilder.getEntityDef("Asset"), "A data source that provides a constant stream of data, such as a sensor monitoring the environment.", descriptionGUID);
    }

    private void add0430ServiceLevelObjectives() {
        this.archiveBuilder.addEntityDef(this.getServiceLevelObjectivesEntity());
    }

    private EntityDef getServiceLevelObjectivesEntity() {
        String guid = "22c4e433-1b87-4446-840a-03f83d2dc113";
        String name = "ServiceLevelObjective";
        String description = "The set of behavior related objectives that an asset or capability seeks to achieve.";
        String descriptionGUID = null;
        String superTypeName = "TechnicalControl";
        return this.archiveHelper.getDefaultEntityDef("22c4e433-1b87-4446-840a-03f83d2dc113", "ServiceLevelObjective", this.archiveBuilder.getEntityDef("TechnicalControl"), "The set of behavior related objectives that an asset or capability seeks to achieve.", descriptionGUID);
    }

    private void update0481Licenses() {
        this.archiveBuilder.addTypeDefPatch(this.updateLicenseRelationship());
    }

    private TypeDefPatch updateLicenseRelationship() {
        String typeName = "License";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("License");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "entitlements";
        String attribute1Description = "The list of rights and permissions granted.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "restrictions";
        String attribute2Description = "The list of limiting conditions or measures imposed.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "obligations";
        String attribute3Description = "The list of actions, duties or commitments required.";
        String attribute3DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getMapStringStringTypeDefAttribute("entitlements", "The list of rights and permissions granted.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute("restrictions", "The list of limiting conditions or measures imposed.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute("obligations", "The list of actions, duties or commitments required.", attribute3DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void add0483TermsAndConditions() {
        this.archiveBuilder.addEntityDef(this.getTermsAndConditionsEntity());
        this.archiveBuilder.addRelationshipDef(this.getAttachedTermsAndConditionsRelationship());
    }

    private EntityDef getTermsAndConditionsEntity() {
        String guid = "2ddc42d3-7791-4b4e-a064-91df9300290a";
        String name = "TermsAndConditions";
        String description = "The set of entitlements, restrictions and obligations associated with an agreement, license etc.";
        String descriptionGUID = null;
        String superTypeName = "Referenceable";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("2ddc42d3-7791-4b4e-a064-91df9300290a", "TermsAndConditions", this.archiveBuilder.getEntityDef("Referenceable"), "The set of entitlements, restrictions and obligations associated with an agreement, license etc.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "entitlements";
        String attribute1Description = "The list of rights and permissions granted.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "restrictions";
        String attribute2Description = "The list of limiting conditions or measures imposed.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "obligations";
        String attribute3Description = "The list of actions, duties or commitments required.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "displayName";
        String attribute4Description = "Short name for the terms and conditions.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "description";
        String attribute5Description = "An overview of the terms and conditions.";
        String attribute5DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getMapStringStringTypeDefAttribute("entitlements", "The list of rights and permissions granted.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute("restrictions", "The list of limiting conditions or measures imposed.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute("obligations", "The list of actions, duties or commitments required.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("displayName", "Short name for the terms and conditions.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("description", "An overview of the terms and conditions.", attribute5DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getAttachedTermsAndConditionsRelationship() {
        String guid = "8292343f-6a96-4ca8-a447-38f734c75634";
        String name = "AttachedTermsAndConditions";
        String description = "The terms and conditions associated with an agreement, license etc.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("8292343f-6a96-4ca8-a447-38f734c75634", "AttachedTermsAndConditions", null, "The terms and conditions associated with an agreement, license etc.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "Referenceable";
        String end1AttributeName = "subjectOfTermsAndConditions";
        String end1AttributeDescription = "Entity that the terms and condition applied.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Referenceable"), "subjectOfTermsAndConditions", "Entity that the terms and condition applied.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "TermsAndConditions";
        String end2AttributeName = "termsAndConditions";
        String end2AttributeDescription = "Entitlements, restrictions and obligations.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("TermsAndConditions"), "termsAndConditions", "Entitlements, restrictions and obligations.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "displayName";
        String attribute1Description = "Short name for the related terms and conditions.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("displayName", "Short name for the related terms and conditions.", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0484Agreements() {
        this.archiveBuilder.addEntityDef(this.getAgreementEntity());
        this.archiveBuilder.addRelationshipDef(this.getAgreementActorRelationship());
        this.archiveBuilder.addRelationshipDef(this.getAgreementItemRelationship());
        this.archiveBuilder.addRelationshipDef(this.getContractLinkRelationship());
    }

    private EntityDef getAgreementEntity() {
        String guid = "88886b53-c839-48fa-bcfa-83ebcf8abbb5";
        String name = "Agreement";
        String description = "An agreement between parties.";
        String descriptionGUID = null;
        String superTypeName = "Referenceable";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("88886b53-c839-48fa-bcfa-83ebcf8abbb5", "Agreement", this.archiveBuilder.getEntityDef("Referenceable"), "An agreement between parties.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "agreementType";
        String attribute1Description = "The type of agreement - values typically defined in a valid value set.";
        String attribute1DescriptionGUID = null;
        String attribute4Name = "displayName";
        String attribute4Description = "Short name for the terms and conditions.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "description";
        String attribute5Description = "An overview of the terms and conditions.";
        String attribute5DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("agreementType", "The type of agreement - values typically defined in a valid value set.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("displayName", "Short name for the terms and conditions.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("description", "An overview of the terms and conditions.", attribute5DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getAgreementActorRelationship() {
        String guid = "1c811d0b-e9ce-44af-b6ed-133e73322e32";
        String name = "AgreementActor";
        String description = "An actor identified in an agreement.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("1c811d0b-e9ce-44af-b6ed-133e73322e32", "AgreementActor", null, "An actor identified in an agreement.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "Agreement";
        String end1AttributeName = "relatedAgreements";
        String end1AttributeDescription = "The agreements that include the actor.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Agreement"), "relatedAgreements", "The agreements that include the actor.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "Actor";
        String end2AttributeName = "agreementActors";
        String end2AttributeDescription = "The actors that are named in the agreement.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Actor"), "agreementActors", "The actors that are named in the agreement.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "actorName";
        String attribute1Description = "Name used to identify a specific actor in the agreement.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("actorName", "Name used to identify a specific actor in the agreement.", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getAgreementItemRelationship() {
        String guid = "a540c361-0ed1-45d6-b525-007592ae806d";
        String name = "AgreementItem";
        String description = "An identified item in an agreement.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("a540c361-0ed1-45d6-b525-007592ae806d", "AgreementItem", null, "An identified item in an agreement.", descriptionGUID, classificationPropagationRule);
        relationshipDef.setMultiLink(true);
        String end1EntityType = "Agreement";
        String end1AttributeName = "agreementContents";
        String end1AttributeDescription = "The agreement that the item relates to.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Agreement"), "agreementContents", "The agreement that the item relates to.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "Referenceable";
        String end2AttributeName = "agreementItems";
        String end2AttributeDescription = "Specific items in the agreement.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Referenceable"), "agreementItems", "Specific items in the agreement.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute0Name = "agreementItemId";
        String attribute0Description = "unique identifier for the item within the agreement.";
        String attribute0DescriptionGUID = null;
        String attribute1Name = "entitlements";
        String attribute1Description = "The list of rights and permissions granted.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "restrictions";
        String attribute2Description = "The list of limiting conditions or measures imposed.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "obligations";
        String attribute3Description = "The list of actions, duties or commitments required.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "agreementStart";
        String attribute4Description = "Date/time when this item becomes active in the agreement.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "agreementEnd";
        String attribute5Description = "Date/time when this item becomes inactive in the agreement.";
        String attribute5DescriptionGUID = null;
        String attribute6Name = "usageMeasurements";
        String attribute6Description = "Measurements of the actual use of this item under the agreement.";
        String attribute6DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("agreementItemId", "unique identifier for the item within the agreement.", attribute0DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute("entitlements", "The list of rights and permissions granted.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute("restrictions", "The list of limiting conditions or measures imposed.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute("obligations", "The list of actions, duties or commitments required.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("agreementStart", "Date/time when this item becomes active in the agreement.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("agreementEnd", "Date/time when this item becomes inactive in the agreement.", attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute("usageMeasurements", "Measurements of the actual use of this item under the agreement.", attribute6DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getContractLinkRelationship() {
        String guid = "33937ece-5ab6-4cd3-a348-b8196ffc3b4e";
        String name = "ContractLink";
        String description = "Link to the contract document.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("33937ece-5ab6-4cd3-a348-b8196ffc3b4e", "ContractLink", null, "Link to the contract document.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "Agreement";
        String end1AttributeName = "agreements";
        String end1AttributeDescription = "Agreements related to the contract.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Agreement"), "agreements", "Agreements related to the contract.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "ExternalReference";
        String end2AttributeName = "contracts";
        String end2AttributeDescription = "Details of the contract documents.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("ExternalReference"), "contracts", "Details of the contract documents.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "contractId";
        String attribute1Description = "Identifier for the contract used in the agreement.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "contractLiaison";
        String attribute2Description = "Identifier of actor to contact with queries relating to the contract.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "contractLiaisonTypeName";
        String attribute3Description = "Type name of actor element.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "contractLiaisonPropertyName";
        String attribute4Description = "The property from the actor element used as the identifier.";
        String attribute4DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("contractId", "Identifier for the contract used in the agreement.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("contractLiaison", "Identifier of actor to contact with queries relating to the contract.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("contractLiaisonTypeName", "Type name of actor element.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("contractLiaisonPropertyName", "The property from the actor element used as the identifier.", attribute4DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add00710DigitalProduct() {
        this.archiveBuilder.addClassificationDef(this.addDigitalProductClassification());
    }

    private ClassificationDef addDigitalProductClassification() {
        String guid = "4aaaa7ca-6b4b-4c4b-997f-d5dfd42917b0";
        String name = "DigitalProduct";
        String description = "Identifies an element that represents a digital product.";
        String descriptionGUID = null;
        String linkedToEntity = "Referenceable";
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("4aaaa7ca-6b4b-4c4b-997f-d5dfd42917b0", "DigitalProduct", null, "Identifies an element that represents a digital product.", descriptionGUID, this.archiveBuilder.getEntityDef("Referenceable"), true);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "syncDatesByKey";
        String attribute1Description = "Collection of synchronization dates identified by a key";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getMapStringLongTypeDefAttribute("syncDatesByKey", "Collection of synchronization dates identified by a key", attribute1DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void add00711DigitalSubscription() {
        this.archiveBuilder.addEntityDef(this.getDigitalSubscriptionEntity());
        this.archiveBuilder.addRelationshipDef(this.getDigitalSubscriberRelationship());
    }

    private EntityDef getDigitalSubscriptionEntity() {
        String guid = "ad6ed361-af14-458f-8fb7-d4c11baa45d2";
        String name = "DigitalSubscription";
        String description = "A specialized agreement that represents a subscription to a digital service or digital product.";
        String descriptionGUID = null;
        String superTypeName = "Agreement";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("ad6ed361-af14-458f-8fb7-d4c11baa45d2", "DigitalSubscription", this.archiveBuilder.getEntityDef("Agreement"), "A specialized agreement that represents a subscription to a digital service or digital product.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "supportLevel";
        String attribute1Description = "Level of support agreed for the subscriber.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "serviceLevels";
        String attribute2Description = "Levels of service agreed with the subscriber.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("supportLevel", "Level of support agreed for the subscriber.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute("serviceLevels", "Levels of service agreed with the subscriber.", attribute2DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getDigitalSubscriberRelationship() {
        String guid = "567cc4e7-ef89-4d36-af0d-3cb4fe9b8cf4";
        String name = "DigitalSubscriber";
        String description = "The link between a digital subscriber and the subscription details.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("567cc4e7-ef89-4d36-af0d-3cb4fe9b8cf4", "DigitalSubscriber", null, "The link between a digital subscriber and the subscription details.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "Referenceable";
        String end1AttributeName = "digitalSubscribers";
        String end1AttributeDescription = "The digital subscribers registered under a subscription.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Referenceable"), "digitalSubscribers", "The digital subscribers registered under a subscription.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "DigitalSubscription";
        String end2AttributeName = "digitalSubscriptions";
        String end2AttributeDescription = "The digital subscriptions in use by the subscriber.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("DigitalSubscription"), "digitalSubscriptions", "The digital subscriptions in use by the subscriber.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "subscriberId";
        String attribute1Description = "Unique identifier for the subscriber.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("subscriberId", "Unique identifier for the subscriber.", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void update0715DigitalServiceOwnership() {
        this.archiveBuilder.addTypeDefPatch(this.updateDigitalServiceOperator());
    }

    private TypeDefPatch updateDigitalServiceOperator() {
        String typeName = "DigitalServiceOperator";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("DigitalServiceOperator");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end1EntityType = "DigitalService";
        String end1AttributeName = "operatesDigitalServices";
        String end1AttributeDescription = "The digital services that this team/organization operates.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("DigitalService"), "operatesDigitalServices", "The digital services that this team/organization operates.", end1AttributeDescriptionGUID, end1Cardinality);
        typeDefPatch.setEndDef1(relationshipEndDef);
        String end2EntityType = "Team";
        String end2AttributeName = "digitalServiceOperators";
        String end2AttributeDescription = "The teams/organizations responsible for operating the digital service.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Team"), "digitalServiceOperators", "The teams/organizations responsible for operating the digital service.", end2AttributeDescriptionGUID, end2Cardinality);
        typeDefPatch.setEndDef2(relationshipEndDef);
        return typeDefPatch;
    }
}

