/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive4_0;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttributeStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefStatus;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive4_1 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "4.1";
    private static final String originatorName = "Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive4_1() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive4_1(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive4_0 previousTypes = new OpenMetadataTypesArchive4_0(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.update0010BasicModel();
        this.update0011ManagingReferenceables();
        this.update0210DataStores();
        this.update0320CategoryHierarchy();
        this.update0385ControlledGlossaryDevelopment();
        this.update0423SecurityAccessControl();
        this.update504ImplementationSnippets();
        this.update0710DigitalServices();
    }

    private void update0010BasicModel() {
        this.archiveBuilder.addRelationshipDef(this.getSampleDataRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateProcess());
    }

    private RelationshipDef getSampleDataRelationship() {
        String guid = "0ee9c0f1-a89b-4806-8276-7c74f07fe190";
        String name = "SampleData";
        String description = "Links an Asset entity describing a collection of sample data that originates from the resource represented by the Referenceable entity.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("0ee9c0f1-a89b-4806-8276-7c74f07fe190", "SampleData", null, "Links an Asset entity describing a collection of sample data that originates from the resource represented by the Referenceable entity.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "Referenceable";
        String end1AttributeName = "sourceOfSample";
        String end1AttributeDescription = "Represents the resource where the sample was taken from.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Referenceable"), "sourceOfSample", "Represents the resource where the sample was taken from.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "Asset";
        String end2AttributeName = "sampleData";
        String end2AttributeDescription = "Describes the location of the resource that holds the sampe data.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Asset"), "sampleData", "Describes the location of the resource that holds the sampe data.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "samplingMethod";
        String attribute1Description = "Description of the technique used to create the sample.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("samplingMethod", "Description of the technique used to create the sample.", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private TypeDefPatch updateProcess() {
        String typeName = "Process";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("Process");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attributeName = "displayName";
        String attributeDescription = "Display name of the process";
        String attributeDescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("displayName", "Display name of the process", attributeDescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0011ManagingReferenceables() {
        this.archiveBuilder.addClassificationDef(this.getTemplateSubstituteClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateSourcedFromRelationship());
    }

    private TypeDefPatch updateSourcedFromRelationship() {
        String typeName = "SourcedFrom";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("SourcedFrom");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "sourceVersionNumber";
        String attribute1Description = "The version number of the template element when the copy was created.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getLongTypeDefAttribute("sourceVersionNumber", "The version number of the template element when the copy was created.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private ClassificationDef getTemplateSubstituteClassification() {
        String guid = "93b293c3-1185-4921-aa1c-237d3f0a5d5c";
        String name = "TemplateSubstitute";
        String description = "An element that has been introduced in a template to provide an end to a relationship that is part of the template but should not be visible outside of the template use.";
        String descriptionGUID = null;
        String linkedToEntity = "Referenceable";
        return this.archiveHelper.getClassificationDef("93b293c3-1185-4921-aa1c-237d3f0a5d5c", "TemplateSubstitute", null, "An element that has been introduced in a template to provide an end to a relationship that is part of the template but should not be visible outside of the template use.", descriptionGUID, this.archiveBuilder.getEntityDef("Referenceable"), false);
    }

    private void update0210DataStores() {
        this.archiveBuilder.addClassificationDef(this.getDataFieldValuesClassification());
    }

    private ClassificationDef getDataFieldValuesClassification() {
        String guid = "740e76e1-77b4-4426-ad52-d0a4ed15fff9";
        String name = "DataFieldValues";
        String description = "Characterizations of a collection of data values.";
        String descriptionGUID = null;
        String linkedToEntity = "Referenceable";
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("740e76e1-77b4-4426-ad52-d0a4ed15fff9", "DataFieldValues", null, "Characterizations of a collection of data values.", descriptionGUID, this.archiveBuilder.getEntityDef("Referenceable"), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "defaultValue";
        String attribute1Description = "Value that is used when an instance of the data field is created.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "sampleValues";
        String attribute2Description = "List of sample values for the data field.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "dataPattern";
        String attribute3Description = "A regular expression that characterizes the values in the data field.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "namePattern";
        String attribute4Description = "A regular expression that characterizes the name of the data field.";
        String attribute4DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("defaultValue", "Value that is used when an instance of the data field is created.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute("sampleValues", "List of sample values for the data field.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute("dataPattern", "A regular expression that characterizes the values in the data field.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute("namePattern", "A regular expression that characterizes the name of the data field.", attribute4DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void update0320CategoryHierarchy() {
        this.archiveBuilder.addClassificationDef(this.getRootCategoryClassification());
    }

    private ClassificationDef getRootCategoryClassification() {
        String guid = "1d0fec82-7444-4e4c-abd4-4765bb855ce3";
        String name = "RootCategory";
        String description = "A category that is at the top of a category hierarchy";
        String descriptionGUID = null;
        String linkedToEntity = "GlossaryCategory";
        return this.archiveHelper.getClassificationDef("1d0fec82-7444-4e4c-abd4-4765bb855ce3", "RootCategory", null, "A category that is at the top of a category hierarchy", descriptionGUID, this.archiveBuilder.getEntityDef("GlossaryCategory"), false);
    }

    private void update0385ControlledGlossaryDevelopment() {
        this.archiveBuilder.addClassificationDef(this.getEditingGlossaryClassification());
        this.archiveBuilder.addClassificationDef(this.getStagingGlossaryClassification());
        this.archiveBuilder.addTypeDefPatch(this.deprecateGlossaryTermEvolution());
        this.archiveBuilder.addTypeDefPatch(this.updateGlossaryTermEntity());
    }

    private ClassificationDef getEditingGlossaryClassification() {
        String guid = "173614ba-c582-4ecc-8fcc-cde5fb664548";
        String name = "EditingGlossary";
        String description = "A glossary holding copies of glossary content that is being edited.  The glossary content is typically sourced from another glossary";
        String descriptionGUID = null;
        String linkedToEntity = "Glossary";
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("173614ba-c582-4ecc-8fcc-cde5fb664548", "EditingGlossary", null, "A glossary holding copies of glossary content that is being edited.  The glossary content is typically sourced from another glossary", descriptionGUID, this.archiveBuilder.getEntityDef("Glossary"), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "description";
        String attribute1Description = "Description of the updates.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("description", "Description of the updates.", attribute1DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef getStagingGlossaryClassification() {
        String guid = "361fa044-e703-404c-bb83-9402f9221f54";
        String name = "StagingGlossary";
        String description = "A glossary that is acting as a temporary home for glossary elements that are being introduced into another glossary.";
        String descriptionGUID = null;
        String linkedToEntity = "Referenceable";
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("361fa044-e703-404c-bb83-9402f9221f54", "StagingGlossary", null, "A glossary that is acting as a temporary home for glossary elements that are being introduced into another glossary.", descriptionGUID, this.archiveBuilder.getEntityDef("Referenceable"), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "description";
        String attribute1Description = "Description of the updates.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("description", "Description of the updates.", attribute1DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private TypeDefPatch deprecateGlossaryTermEvolution() {
        String typeName = "GlossaryTermEvolution";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("GlossaryTermEvolution");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private TypeDefPatch updateGlossaryTermEntity() {
        String typeName = "GlossaryTerm";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("GlossaryTerm");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "publishVersionIdentifier";
        String attribute1Description = "The author-controlled version identifier for the term.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("publishVersionIdentifier", "The author-controlled version identifier for the term.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0423SecurityAccessControl() {
        this.archiveBuilder.addTypeDefPatch(this.updateSecurityTagsClassification());
        this.archiveBuilder.addEntityDef(this.addSecurityAccessControlEntity());
        this.archiveBuilder.addRelationshipDef(this.addAssociatedGroupRelationship());
    }

    private TypeDefPatch updateSecurityTagsClassification() {
        String typeName = "SecurityTags";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("SecurityTags");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "accessGroups";
        String attribute1Description = "Map of access groups.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getMapStringObjectTypeDefAttribute("accessGroups", "Map of access groups.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private RelationshipDef addAssociatedGroupRelationship() {
        String guid = "e47a19d0-7e12-4cf7-9ad7-50856da7faa2";
        String name = "AssociatedGroup";
        String description = "Links a security access control to a security group.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("e47a19d0-7e12-4cf7-9ad7-50856da7faa2", "AssociatedGroup", null, "Links a security access control to a security group.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "SecurityAccessControl";
        String end1AttributeName = "usedInAccessControls";
        String end1AttributeDescription = "An access control definition that uses the security group.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SecurityAccessControl"), "usedInAccessControls", "An access control definition that uses the security group.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "SecurityGroup";
        String end2AttributeName = "associatedSecurityGroups";
        String end2AttributeDescription = "The security groups to use to validate access for the operation.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SecurityGroup"), "associatedSecurityGroups", "The security groups to use to validate access for the operation.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "operationName";
        String attribute1Description = "Name of the operation to that is controlled by the linked security group.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("operationName", "Name of the operation to that is controlled by the linked security group.", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private EntityDef addSecurityAccessControlEntity() {
        String guid = "f53bd594-5f75-4cf9-9f77-f5c35396590e";
        String name = "SecurityAccessControl";
        String description = "A technical control that defines who has access to the attach element.";
        String descriptionGUID = null;
        String superTypeName = "TechnicalControl";
        return this.archiveHelper.getDefaultEntityDef("f53bd594-5f75-4cf9-9f77-f5c35396590e", "SecurityAccessControl", this.archiveBuilder.getEntityDef("TechnicalControl"), "A technical control that defines who has access to the attach element.", descriptionGUID);
    }

    private void update504ImplementationSnippets() {
        this.archiveBuilder.addTypeDefPatch(this.deprecateSchemaTypeSnippet());
        this.archiveBuilder.addRelationshipDef(this.getAssociatedSnippetRelationship());
    }

    private TypeDefPatch deprecateSchemaTypeSnippet() {
        String typeName = "SchemaTypeSnippet";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("SchemaTypeSnippet");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private RelationshipDef getAssociatedSnippetRelationship() {
        String guid = "6f89c320-22aa-4d99-9a97-442e8d214655";
        String name = "AssociatedSnippet";
        String description = "Link between an element such as a schema type or data class and an implementation snippet.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("6f89c320-22aa-4d99-9a97-442e8d214655", "AssociatedSnippet", null, "Link between an element such as a schema type or data class and an implementation snippet.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "Referenceable";
        String end1AttributeName = "snippetRelevantForElements";
        String end1AttributeDescription = "Element describing logical structure for data element.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Referenceable"), "snippetRelevantForElements", "Element describing logical structure for data element.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "ImplementationSnippet";
        String end2AttributeName = "implementationSnippetsForElement";
        String end2AttributeDescription = "Template implementation of the element.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("ImplementationSnippet"), "implementationSnippetsForElement", "Template implementation of the element.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void update0710DigitalServices() {
        this.archiveBuilder.addTypeDefPatch(this.updateDigitalProductClassification());
    }

    private TypeDefPatch updateDigitalProductClassification() {
        String typeName = "DigitalProduct";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("DigitalProduct");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<InstanceStatus> validInstanceStatusList = new ArrayList<InstanceStatus>();
        validInstanceStatusList.add(InstanceStatus.DRAFT);
        validInstanceStatusList.add(InstanceStatus.PREPARED);
        validInstanceStatusList.add(InstanceStatus.PROPOSED);
        validInstanceStatusList.add(InstanceStatus.APPROVED);
        validInstanceStatusList.add(InstanceStatus.REJECTED);
        validInstanceStatusList.add(InstanceStatus.APPROVED_CONCEPT);
        validInstanceStatusList.add(InstanceStatus.UNDER_DEVELOPMENT);
        validInstanceStatusList.add(InstanceStatus.DEVELOPMENT_COMPLETE);
        validInstanceStatusList.add(InstanceStatus.APPROVED_FOR_DEPLOYMENT);
        validInstanceStatusList.add(InstanceStatus.ACTIVE);
        validInstanceStatusList.add(InstanceStatus.DISABLED);
        validInstanceStatusList.add(InstanceStatus.DEPRECATED);
        validInstanceStatusList.add(InstanceStatus.OTHER);
        validInstanceStatusList.add(InstanceStatus.DELETED);
        typeDefPatch.setValidInstanceStatusList(validInstanceStatusList);
        return typeDefPatch;
    }
}

