/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.GovernedReferenceable;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Asset
extends GovernedReferenceable {
    protected String resourceName = null;
    protected String resourceDescription = null;
    protected String versionIdentifier = null;
    protected String displayName = null;
    protected String displaySummary = null;
    protected String displayDescription = null;
    protected String abbreviation = null;
    protected String usage = null;

    public Asset() {
    }

    public Asset(Asset template) {
        super(template);
        if (template != null) {
            this.resourceName = template.getResourceName();
            this.resourceDescription = template.getResourceDescription();
            this.versionIdentifier = template.getVersionIdentifier();
            this.displayName = template.getDisplayName();
            this.displaySummary = template.getDisplaySummary();
            this.displayDescription = template.getDisplayDescription();
            this.abbreviation = template.getAbbreviation();
            this.usage = template.getUsage();
        }
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String name) {
        this.resourceName = name;
    }

    public String getResourceDescription() {
        return this.resourceDescription;
    }

    public void setResourceDescription(String resourceDescription) {
        this.resourceDescription = resourceDescription;
    }

    public String getVersionIdentifier() {
        return this.versionIdentifier;
    }

    public void setVersionIdentifier(String versionIdentifier) {
        this.versionIdentifier = versionIdentifier;
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            return this.resourceName;
        }
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplaySummary() {
        return this.displaySummary;
    }

    public void setDisplaySummary(String displaySummary) {
        this.displaySummary = displaySummary;
    }

    public String getDisplayDescription() {
        return this.displayDescription;
    }

    public void setDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public void setAbbreviation(String abbreviation) {
        this.abbreviation = abbreviation;
    }

    public String getUsage() {
        return this.usage;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    @Override
    public String toString() {
        return "Asset{resourceName='" + this.resourceName + "', resourceDescription='" + this.resourceDescription + "', versionIdentifier='" + this.versionIdentifier + "', displayName='" + this.displayName + "', displaySummary='" + this.displaySummary + "', displayDescription='" + this.displayDescription + "', abbreviation='" + this.abbreviation + "', usage='" + this.usage + "', extendedProperties=" + this.getExtendedProperties() + ", status=" + this.getStatus() + ", type=" + this.getType() + ", versions=" + this.getVersions() + ", GUID='" + this.getGUID() + "', classifications=" + this.getClassifications() + ", meanings=" + this.getMeanings() + ", searchKeywords=" + this.getSearchKeywords() + ", headerVersion=" + this.getHeaderVersion() + ", qualifiedName='" + this.getQualifiedName() + "', additionalProperties=" + this.getAdditionalProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof Asset)) {
            return false;
        }
        Asset asset = (Asset)objectToCompare;
        if (!super.equals(objectToCompare)) {
            return false;
        }
        return Objects.equals(this.resourceName, asset.resourceName) && Objects.equals(this.resourceDescription, asset.resourceDescription) && Objects.equals(this.versionIdentifier, asset.versionIdentifier) && Objects.equals(this.displayName, asset.displayName) && Objects.equals(this.displaySummary, asset.displaySummary) && Objects.equals(this.displayDescription, asset.displayDescription) && Objects.equals(this.abbreviation, asset.abbreviation) && Objects.equals(this.usage, asset.usage);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.resourceName, this.resourceDescription, this.versionIdentifier, this.displayName, this.displaySummary, this.displayDescription, this.abbreviation, this.usage);
    }
}

