/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction.controls;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.governanceaction.controls.PlaceholderPropertyType;

public enum PlaceholderProperty {
    HOST_IDENTIFIER("hostIdentifier", "The host IP address or domain name.", "string", "coconet.com"),
    PORT_NUMBER("portNumber", "The number of the port to use to connect to a service.", "string", "1234"),
    CONNECTION_USER_ID("connectionUserId", "The userId to store in the userId attribute of the connection.", "string", "user1"),
    CONNECTION_PASSWORD("connectionPassword", "The password to store in the clearPassword attribute of the connection.", "string", "secret"),
    SERVER_NAME("serverName", "The name of the server being catalogued.", "string", "myServer"),
    SCHEMA_NAME("schemaName", "The name of the schema being catalogued.", "string", "MyServer.schema");

    public final String name;
    public final String description;
    public final String dataType;
    public final String example;

    private PlaceholderProperty(String name, String description, String dataType, String example) {
        this.name = name;
        this.description = description;
        this.dataType = dataType;
        this.example = example;
    }

    public String getName() {
        return this.name;
    }

    public String getPlaceholder() {
        return "{{" + this.name + "}}";
    }

    public String getDescription() {
        return this.description;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getExample() {
        return this.example;
    }

    public static List<PlaceholderPropertyType> getPlaceholderPropertyTypes() {
        ArrayList<PlaceholderPropertyType> placeholderPropertyTypes = new ArrayList<PlaceholderPropertyType>();
        for (PlaceholderProperty placeholderProperty : PlaceholderProperty.values()) {
            placeholderPropertyTypes.add(placeholderProperty.getPlaceholderType());
        }
        return placeholderPropertyTypes;
    }

    public PlaceholderPropertyType getPlaceholderType() {
        PlaceholderPropertyType placeholderPropertyType = new PlaceholderPropertyType();
        placeholderPropertyType.setName(this.name);
        placeholderPropertyType.setDescription(this.description);
        placeholderPropertyType.setDataType(this.dataType);
        placeholderPropertyType.setExample(this.example);
        placeholderPropertyType.setRequired(true);
        return placeholderPropertyType;
    }

    public String toString() {
        return "PlaceholderProperty{ name=" + this.name + "}";
    }
}

