/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction.fileclassifier;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.OpenMetadataStore;
import org.odpi.openmetadata.frameworks.governanceaction.fileclassifier.FileClassification;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ValidMetadataValue;
import org.odpi.openmetadata.frameworks.openmetadata.mapper.OpenMetadataValidValues;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public class FileClassifier {
    private static final String folderDivider = "/";
    private static final String fileExtensionDivider = "\\.";
    private static final Map<String, FileReferenceDataCache> fileNameReferenceDataCache = new HashMap<String, FileReferenceDataCache>();
    private static final Map<String, FileReferenceDataCache> fileExtensionReferenceDataCache = new HashMap<String, FileReferenceDataCache>();
    private final OpenMetadataStore openMetadataStore;
    private static final String fileTypeCategory = OpenMetadataValidValues.constructValidValueCategory(OpenMetadataType.DATA_FILE.typeName, OpenMetadataProperty.FILE_TYPE.name, null);
    private static final String deployedImplementationTypeCategory = OpenMetadataValidValues.constructValidValueCategory(OpenMetadataType.DATA_FILE.typeName, OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, null);

    public FileClassifier(OpenMetadataStore openMetadataStore) {
        this.openMetadataStore = openMetadataStore;
    }

    public FileClassification classifyFile(String pathName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, IOException {
        return this.classifyFile(new File(pathName));
    }

    public FileClassification classifyFile(File file) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, IOException {
        Date creationTime = null;
        Date lastModifiedTime = null;
        Date lastAccessedTime = null;
        BasicFileAttributes attr = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
        if (attr.creationTime() != null) {
            creationTime = new Date(attr.creationTime().toMillis());
        }
        if (attr.lastModifiedTime() != null) {
            lastModifiedTime = new Date(attr.lastModifiedTime().toMillis());
        }
        if (attr.lastAccessTime() != null) {
            lastAccessedTime = new Date(attr.lastAccessTime().toMillis());
        }
        String fileExtension = this.getFileExtension(file.getName());
        FileReferenceDataCache fileReferenceDataCache = this.getFileReferenceDataCache(file.getName(), fileExtension);
        return new FileClassification(file.getName(), file.getAbsolutePath(), fileExtension, creationTime, lastModifiedTime, lastAccessedTime, file.canRead(), file.canWrite(), file.canExecute(), file.isHidden(), FileUtils.isSymlink(file), fileReferenceDataCache.fileType, fileReferenceDataCache.deployedImplementationType, fileReferenceDataCache.encoding, fileReferenceDataCache.assetTypeName, attr.size());
    }

    synchronized FileReferenceDataCache getFileReferenceDataCache(String fileName, String fileExtension) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        FileReferenceDataCache fileReferenceDataCache = fileNameReferenceDataCache.get(fileName);
        if (fileReferenceDataCache == null) {
            fileReferenceDataCache = fileExtensionReferenceDataCache.get(fileExtension);
        }
        if (fileReferenceDataCache == null) {
            fileReferenceDataCache = this.lookupFileReferenceData(fileName, fileExtension);
        }
        return fileReferenceDataCache;
    }

    public String getFileExtension(String fileName) {
        String result = null;
        if (fileName != null && !fileName.isEmpty()) {
            String[] tokens = fileName.split(fileExtensionDivider);
            if (fileName.startsWith(".")) {
                if (tokens.length > 2) {
                    result = tokens[tokens.length - 1];
                }
            } else if (tokens.length > 1) {
                result = tokens[tokens.length - 1];
            }
        }
        return result;
    }

    private FileReferenceDataCache lookupFileReferenceData(String fileName, String fileExtension) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ValidMetadataValue validMetadataValue;
        FileReferenceDataCache fileReferenceDataCache = new FileReferenceDataCache();
        boolean fileNameMatched = false;
        boolean fileExtensionMatched = false;
        try {
            validMetadataValue = this.openMetadataStore.getValidMetadataValue(OpenMetadataType.DATA_FILE.typeName, OpenMetadataProperty.FILE_NAME.name, fileName);
        }
        catch (InvalidParameterException notKnown) {
            validMetadataValue = null;
        }
        List<ValidMetadataValue> consistentValues = null;
        if (validMetadataValue != null) {
            consistentValues = this.openMetadataStore.getConsistentMetadataValues(OpenMetadataType.DATA_FILE.typeName, OpenMetadataProperty.FILE_NAME.name, null, validMetadataValue.getPreferredValue(), 0, 5);
            fileNameMatched = true;
        } else if (fileExtension != null) {
            try {
                validMetadataValue = this.openMetadataStore.getValidMetadataValue(OpenMetadataType.DATA_FILE.typeName, OpenMetadataProperty.FILE_EXTENSION.name, fileExtension);
            }
            catch (InvalidParameterException invalidParameterException) {
                // empty catch block
            }
            if (validMetadataValue != null) {
                consistentValues = this.openMetadataStore.getConsistentMetadataValues(OpenMetadataType.DATA_FILE.typeName, OpenMetadataProperty.FILE_EXTENSION.name, null, validMetadataValue.getPreferredValue(), 0, 5);
                fileExtensionMatched = true;
            }
        }
        if (consistentValues != null) {
            for (ValidMetadataValue consistentValue : consistentValues) {
                List<ValidMetadataValue> consistentFileTypeValues;
                if (consistentValue == null || !fileTypeCategory.equals(consistentValue.getCategory())) continue;
                fileReferenceDataCache.fileType = consistentValue.getPreferredValue();
                if (consistentValue.getAdditionalProperties() != null) {
                    if (consistentValue.getAdditionalProperties().get("assetSubTypeName") != null) {
                        fileReferenceDataCache.assetTypeName = consistentValue.getAdditionalProperties().get("assetSubTypeName");
                    }
                    if (consistentValue.getAdditionalProperties().get(OpenMetadataProperty.ENCODING.name) != null) {
                        fileReferenceDataCache.encoding = consistentValue.getAdditionalProperties().get(OpenMetadataProperty.ENCODING.name);
                    }
                }
                if ((consistentFileTypeValues = this.openMetadataStore.getConsistentMetadataValues(OpenMetadataType.DATA_FILE.typeName, OpenMetadataProperty.FILE_TYPE.name, null, consistentValue.getPreferredValue(), 0, 5)) == null) continue;
                for (ValidMetadataValue consistentFileTypeValue : consistentFileTypeValues) {
                    if (consistentFileTypeValue == null || !deployedImplementationTypeCategory.equals(consistentFileTypeValue.getCategory())) continue;
                    fileReferenceDataCache.deployedImplementationType = consistentFileTypeValue.getPreferredValue();
                }
            }
        }
        if (fileNameMatched) {
            fileNameReferenceDataCache.put(fileName, fileReferenceDataCache);
        }
        if (fileExtensionMatched) {
            fileExtensionReferenceDataCache.put(fileExtension, fileReferenceDataCache);
        }
        return fileReferenceDataCache;
    }

    static class FileReferenceDataCache {
        String fileType = null;
        String assetTypeName = null;
        String encoding = null;
        String deployedImplementationType = null;

        FileReferenceDataCache() {
        }
    }
}

