/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataAttributeTypeDef;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataAttributeTypeDefCategory;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataEnumElementDef;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class OpenMetadataEnumDef
extends OpenMetadataAttributeTypeDef {
    private List<OpenMetadataEnumElementDef> elementDefs = null;
    private OpenMetadataEnumElementDef defaultValue = null;

    public OpenMetadataEnumDef() {
        super(OpenMetadataAttributeTypeDefCategory.ENUM_DEF);
    }

    public OpenMetadataEnumDef(OpenMetadataEnumDef template) {
        super(template);
        if (template != null) {
            if (template.getElementDefs() != null) {
                this.elementDefs = new ArrayList<OpenMetadataEnumElementDef>(template.getElementDefs());
            }
            this.defaultValue = template.getDefaultValue();
        }
    }

    @Override
    public OpenMetadataAttributeTypeDef cloneFromSubclass() {
        return new OpenMetadataEnumDef(this);
    }

    public List<OpenMetadataEnumElementDef> getElementDefs() {
        if (this.elementDefs == null) {
            return null;
        }
        if (this.elementDefs.isEmpty()) {
            return null;
        }
        return new ArrayList<OpenMetadataEnumElementDef>(this.elementDefs);
    }

    public void setElementDefs(List<OpenMetadataEnumElementDef> elementDefs) {
        this.elementDefs = new ArrayList<OpenMetadataEnumElementDef>(elementDefs);
    }

    public OpenMetadataEnumElementDef getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(OpenMetadataEnumElementDef defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public String toString() {
        return "OpenMetadataEnumDef{name='" + this.getName() + "', description='" + this.getDescription() + "', version=" + this.getVersion() + ", versionName='" + this.getVersionName() + "', category=" + this.getCategory() + ", GUID='" + this.getGUID() + "', descriptionGUID='" + this.getDescriptionGUID() + "'}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        OpenMetadataEnumDef enumDef = (OpenMetadataEnumDef)objectToCompare;
        return Objects.equals(this.elementDefs, enumDef.elementDefs) && Objects.equals(this.defaultValue, enumDef.defaultValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.elementDefs, this.defaultValue);
    }
}

