/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive2_10;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttributeStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefStatus;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive2_11 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "2.11";
    private static final String originatorName = "Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive2_11() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive2_11(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive2_10 previousTypes = new OpenMetadataTypesArchive2_10(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.update0010BaseModel();
        this.update0050ApplicationsAndProcesses();
        this.update0380SubjectArea();
        this.update04xxGovernanceDefinitions();
        this.update0530TabularSchema();
        this.update0531DocumentSchema();
        this.update0534RelationalSchema();
        this.update0535EventSchemas();
        this.update0536APISchemas();
        this.update0537DisplaySchemas();
    }

    private void update0010BaseModel() {
        this.archiveBuilder.addTypeDefPatch(this.updateAsset());
    }

    private TypeDefPatch updateAsset() {
        String typeName = OpenMetadataType.ASSET.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "owner";
        String attribute1Description = "Deprecated Attribute. Person, team or engine responsible for this type of action. Use Ownership classification";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "ownerType";
        String attribute2Description = "Deprecated Attribute. Type of element representing the owner. Use Ownership classification";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "zoneMembership";
        String attribute3Description = "Deprecated Attribute. The list of zones that this asset belongs to. Use AssetZoneMembership classification";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "latestChange";
        String attribute4Description = "Deprecated Attribute. Description of the last change to the asset's metadata. Use LatestChange classification";
        String attribute4DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("owner", "Deprecated Attribute. Person, team or engine responsible for this type of action. Use Ownership classification", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("AssetOwnerType", "ownerType", "Deprecated Attribute. Type of element representing the owner. Use Ownership classification", attribute2DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute("zoneMembership", "Deprecated Attribute. The list of zones that this asset belongs to. Use AssetZoneMembership classification", attribute3DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("latestChange", "Deprecated Attribute. Description of the last change to the asset's metadata. Use LatestChange classification", attribute4DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0050ApplicationsAndProcesses() {
        this.archiveBuilder.addEntityDef(this.addAPIManagerEntity());
        this.archiveBuilder.addEntityDef(this.addEventBrokerEntity());
    }

    private EntityDef addAPIManagerEntity() {
        String guid = OpenMetadataType.API_MANAGER.typeGUID;
        String name = OpenMetadataType.API_MANAGER.typeName;
        String description = OpenMetadataType.API_MANAGER.description;
        String descriptionGUID = OpenMetadataType.API_MANAGER.descriptionGUID;
        String descriptionWiki = OpenMetadataType.API_MANAGER.wikiURL;
        String superTypeName = OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeName;
        return this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
    }

    private EntityDef addEventBrokerEntity() {
        String guid = OpenMetadataType.EVENT_BROKER.typeGUID;
        String name = OpenMetadataType.EVENT_BROKER.typeName;
        String description = OpenMetadataType.EVENT_BROKER.description;
        String descriptionGUID = OpenMetadataType.EVENT_BROKER.descriptionGUID;
        String descriptionWiki = OpenMetadataType.EVENT_BROKER.wikiURL;
        String superTypeName = OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeName;
        return this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
    }

    private void update0380SubjectArea() {
        this.archiveBuilder.addRelationshipDef(this.addIsATypeOfRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateTermIsATypeOfRelationship());
    }

    private RelationshipDef addIsATypeOfRelationship() {
        String guid = "9b6a91b5-a339-4245-b208-040805f95a75";
        String name = "IsATypeOfRelationship";
        String description = "Defines an inheritance relationship between two spine objects.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("9b6a91b5-a339-4245-b208-040805f95a75", "IsATypeOfRelationship", null, "Defines an inheritance relationship between two spine objects.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "GlossaryTerm";
        String end1AttributeName = "Inherited";
        String end1AttributeDescription = "Inherited (Subtypes) for this object.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GlossaryTerm"), "Inherited", "Inherited (Subtypes) for this object.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "GlossaryTerm";
        String end2AttributeName = "InheritedFrom";
        String end2AttributeDescription = "Inherited from type (Supertypes) for this object.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GlossaryTerm"), "InheritedFrom", "Inherited from type (Supertypes) for this object.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute1Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        String attribute2Name = "status";
        String attribute2Description = "The status of or confidence in the relationship.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = OpenMetadataProperty.STEWARD.name;
        String attribute3Description = OpenMetadataProperty.STEWARD.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.STEWARD.descriptionGUID;
        String attribute4Name = OpenMetadataProperty.SOURCE.name;
        String attribute4Description = OpenMetadataProperty.SOURCE.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.SOURCE.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("TermRelationshipStatus", "status", "The status of or confidence in the relationship.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private TypeDefPatch updateTermIsATypeOfRelationship() {
        String typeName = "TermISATypeOFRelationship";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("TermISATypeOFRelationship");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private void update04xxGovernanceDefinitions() {
        this.archiveBuilder.addEntityDef(this.addThreatEntity());
        this.archiveBuilder.addRelationshipDef(this.addGovernanceDefinitionScopeRelationship());
    }

    private RelationshipDef addGovernanceDefinitionScopeRelationship() {
        String guid = "3845b5cc-8c85-462f-b7e6-47472a568793";
        String name = "GovernanceDefinitionScope";
        String description = "Link between a scope - such as a digital service, infrastructure element or organization - and a governance definition.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("3845b5cc-8c85-462f-b7e6-47472a568793", "GovernanceDefinitionScope", null, "Link between a scope - such as a digital service, infrastructure element or organization - and a governance definition.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end1AttributeName = "definitionAppliesTo";
        String end1AttributeDescription = "Elements defining the scope that the governance definition applies to.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "definitionAppliesTo", "Elements defining the scope that the governance definition applies to.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "GovernanceDefinition";
        String end2AttributeName = "associatedGovernanceDefinitions";
        String end2AttributeDescription = "Governance definitions for this scope.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernanceDefinition"), "associatedGovernanceDefinitions", "Governance definitions for this scope.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private EntityDef addThreatEntity() {
        String guid = "4ca51fdf-9b70-46b1-bdf6-8860429e78d8";
        String name = "Threat";
        String description = "A description of a specific threat.";
        String descriptionGUID = null;
        String superTypeName = "GovernanceDriver";
        return this.archiveHelper.getDefaultEntityDef("4ca51fdf-9b70-46b1-bdf6-8860429e78d8", "Threat", this.archiveBuilder.getEntityDef("GovernanceDriver"), "A description of a specific threat.", descriptionGUID);
    }

    private void update0530TabularSchema() {
        this.archiveBuilder.addTypeDefPatch(this.deprecateTabularColumnType());
        this.archiveBuilder.addEntityDef(this.addTabularFileColumnEntity());
    }

    private TypeDefPatch deprecateTabularColumnType() {
        String typeName = "TabularColumnType";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("TabularColumnType");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private EntityDef addTabularFileColumnEntity() {
        String guid = "af6265e7-5f58-4a9c-9ae7-8d4284be62bd";
        String name = "TabularFileColumn";
        String description = "A column in a tabular file.";
        String descriptionGUID = null;
        String superTypeName = "TabularColumn";
        return this.archiveHelper.getDefaultEntityDef("af6265e7-5f58-4a9c-9ae7-8d4284be62bd", "TabularFileColumn", this.archiveBuilder.getEntityDef("TabularColumn"), "A column in a tabular file.", descriptionGUID);
    }

    private void update0531DocumentSchema() {
        this.archiveBuilder.addTypeDefPatch(this.deprecateSimpleDocumentType());
        this.archiveBuilder.addTypeDefPatch(this.deprecateStructDocumentType());
        this.archiveBuilder.addTypeDefPatch(this.deprecateMapDocumentType());
    }

    private TypeDefPatch deprecateSimpleDocumentType() {
        String typeName = "SimpleDocumentType";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("SimpleDocumentType");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private TypeDefPatch deprecateStructDocumentType() {
        String typeName = "StructDocumentType";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("StructDocumentType");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private TypeDefPatch deprecateMapDocumentType() {
        String typeName = "MapDocumentType";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("MapDocumentType");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private void update0534RelationalSchema() {
        this.archiveBuilder.addTypeDefPatch(this.updateRelationalTableTypeEntity());
    }

    private TypeDefPatch updateRelationalTableTypeEntity() {
        String typeName = "RelationalTableType";
        String superTypeName = "ComplexSchemaType";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("RelationalTableType");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef("ComplexSchemaType"));
        return typeDefPatch;
    }

    private void update0535EventSchemas() {
        this.archiveBuilder.addEntityDef(this.addEventTypeListEntity());
        this.archiveBuilder.addEntityDef(this.addEventSchemaAttributeEntity());
    }

    private EntityDef addEventTypeListEntity() {
        String guid = "77ccda3d-c4c6-464c-a424-4b2cb27ac06c";
        String name = "EventTypeList";
        String description = "A list of event types that flow on a topic.";
        String descriptionGUID = null;
        String superTypeName = "SchemaTypeChoice";
        return this.archiveHelper.getDefaultEntityDef("77ccda3d-c4c6-464c-a424-4b2cb27ac06c", "EventTypeList", this.archiveBuilder.getEntityDef("SchemaTypeChoice"), "A list of event types that flow on a topic.", descriptionGUID);
    }

    private EntityDef addEventSchemaAttributeEntity() {
        String guid = "5be4ee8f-4d0c-45cd-a411-22a468950342";
        String name = "EventSchemaAttribute";
        String description = "A data field in an event type.";
        String descriptionGUID = null;
        String superTypeName = "SchemaAttribute";
        return this.archiveHelper.getDefaultEntityDef("5be4ee8f-4d0c-45cd-a411-22a468950342", "EventSchemaAttribute", this.archiveBuilder.getEntityDef("SchemaAttribute"), "A data field in an event type.", descriptionGUID);
    }

    private void update0536APISchemas() {
        this.archiveBuilder.addEntityDef(this.addAPIParameterListEntity());
        this.archiveBuilder.addEntityDef(this.addAPIParameterEntity());
    }

    private EntityDef addAPIParameterListEntity() {
        String guid = "ba167b12-969f-49d3-8bea-d04228d9a44b";
        String name = "APIParameterList";
        String description = "A list of parameters for an API.";
        String descriptionGUID = null;
        String superTypeName = "ComplexSchemaType";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("ba167b12-969f-49d3-8bea-d04228d9a44b", "APIParameterList", this.archiveBuilder.getEntityDef("ComplexSchemaType"), "A list of parameters for an API.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute2Name = "required";
        String attribute2Description = "Is this parameter list required when calling the API.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getBooleanTypeDefAttribute("required", "Is this parameter list required when calling the API.", attribute2DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef addAPIParameterEntity() {
        String guid = "10277b13-509c-480e-9829-bc16d0eafc53";
        String name = "APIParameter";
        String description = "A data value that is part of a API definition.";
        String descriptionGUID = null;
        String superTypeName = "SchemaAttribute";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("10277b13-509c-480e-9829-bc16d0eafc53", "APIParameter", this.archiveBuilder.getEntityDef("SchemaAttribute"), "A data value that is part of a API definition.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute3Name = "parameterType";
        String attribute3Description = "What type of parameter is it";
        String attribute3DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("parameterType", "What type of parameter is it", attribute3DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private void update0537DisplaySchemas() {
        this.archiveBuilder.addEntityDef(this.addDisplayDataSchemaTypeEntity());
        this.archiveBuilder.addEntityDef(this.addDisplayDataContainerEntity());
        this.archiveBuilder.addEntityDef(this.addDisplayDataFieldEntity());
        this.archiveBuilder.addEntityDef(this.addQuerySchemaTypeEntity());
        this.archiveBuilder.addEntityDef(this.addQueryDataContainerEntity());
        this.archiveBuilder.addEntityDef(this.addQueryDataFieldEntity());
    }

    private EntityDef addDisplayDataSchemaTypeEntity() {
        String guid = "2f5796f5-3fac-4501-9d0d-207aa8620d16";
        String name = "DisplayDataSchemaType";
        String description = "A structure describing data that is to be displayed.";
        String descriptionGUID = null;
        String superTypeName = "ComplexSchemaType";
        return this.archiveHelper.getDefaultEntityDef("2f5796f5-3fac-4501-9d0d-207aa8620d16", "DisplayDataSchemaType", this.archiveBuilder.getEntityDef("ComplexSchemaType"), "A structure describing data that is to be displayed.", descriptionGUID);
    }

    private EntityDef addDisplayDataContainerEntity() {
        String guid = "f2a4ff99-1954-48c0-8081-92d1a4dfd910";
        String name = "DisplayDataContainer";
        String description = "A grouping of display data fields (and nested containers) for a report, form or similar data display asset.";
        String descriptionGUID = null;
        String superTypeName = "SchemaAttribute";
        return this.archiveHelper.getDefaultEntityDef("f2a4ff99-1954-48c0-8081-92d1a4dfd910", "DisplayDataContainer", this.archiveBuilder.getEntityDef("SchemaAttribute"), "A grouping of display data fields (and nested containers) for a report, form or similar data display asset.", descriptionGUID);
    }

    private EntityDef addDisplayDataFieldEntity() {
        String guid = "46f9ea33-996e-4c62-a67d-803df75ef9d4";
        String name = "DisplayDataField";
        String description = "A data display field.";
        String descriptionGUID = null;
        String superTypeName = "SchemaAttribute";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("46f9ea33-996e-4c62-a67d-803df75ef9d4", "DisplayDataField", this.archiveBuilder.getEntityDef("SchemaAttribute"), "A data display field.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute2Name = "inputField";
        String attribute2Description = "Is this data field accepting new  data from the end user or not.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getBooleanTypeDefAttribute("inputField", "Is this data field accepting new  data from the end user or not.", attribute2DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef addQuerySchemaTypeEntity() {
        String guid = "4d11bdbb-5d4a-488b-9f16-bf1e34d34dd9";
        String name = "QuerySchemaType";
        String description = "A structure describing data that being queried and formatted to support a user display or report.";
        String descriptionGUID = null;
        String superTypeName = "ComplexSchemaType";
        return this.archiveHelper.getDefaultEntityDef("4d11bdbb-5d4a-488b-9f16-bf1e34d34dd9", "QuerySchemaType", this.archiveBuilder.getEntityDef("ComplexSchemaType"), "A structure describing data that being queried and formatted to support a user display or report.", descriptionGUID);
    }

    private EntityDef addQueryDataContainerEntity() {
        String guid = "b55c2740-2d41-4433-a099-596c8e9b7bf6";
        String name = "QueryDataContainer";
        String description = "A grouping of display data fields (and nested containers) for a query.";
        String descriptionGUID = null;
        String superTypeName = "SchemaAttribute";
        return this.archiveHelper.getDefaultEntityDef("b55c2740-2d41-4433-a099-596c8e9b7bf6", "QueryDataContainer", this.archiveBuilder.getEntityDef("SchemaAttribute"), "A grouping of display data fields (and nested containers) for a query.", descriptionGUID);
    }

    private EntityDef addQueryDataFieldEntity() {
        String guid = "0eb92215-52b1-4fac-92e7-ff02ff385a68";
        String name = "QueryDataField";
        String description = "A data field that is returned by a query.";
        String descriptionGUID = null;
        String superTypeName = "SchemaAttribute";
        return this.archiveHelper.getDefaultEntityDef("0eb92215-52b1-4fac-92e7-ff02ff385a68", "QueryDataField", this.archiveBuilder.getEntityDef("SchemaAttribute"), "A data field that is returned by a query.", descriptionGUID);
    }
}

