/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ByteOrdering;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive2_0;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumElementDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttributeStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefStatus;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive2_4 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "2.4";
    private static final String originatorName = "ODPi Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive2_4() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive2_4(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive2_0 previousTypes = new OpenMetadataTypesArchive2_0(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.update0011ManagingReferenceables();
        this.update0012SearchKeywords();
        this.update0030HostsAndPlatforms();
        this.add0057IntegrationCapabilities();
        this.update0150Feedback();
        this.update0215SoftwareComponents();
        this.update04xxGovernanceEnums();
        this.update05xxSchemaAttributes();
        this.update0545ReferenceData();
        this.update06xxDiscovery();
        this.updateClashingControlProperties();
    }

    private void update0011ManagingReferenceables() {
        this.archiveBuilder.addEnumDef(this.getLatestChangeTargetEnum());
        this.archiveBuilder.addEnumDef(this.getLatestChangeActionEnum());
        this.archiveBuilder.addClassificationDef(this.addAnchorsClassification());
        this.archiveBuilder.addClassificationDef(this.addLatestChangeClassification());
        this.archiveBuilder.addRelationshipDef(this.addSourcedFromRelationship());
    }

    private EnumDef getLatestChangeTargetEnum() {
        String guid = "a0b7d7a0-4af5-4539-9b81-cbef52d8cc5d";
        String name = "LatestChangeTarget";
        String description = "Defines the type of repository element that has changed.";
        String descriptionGUID = null;
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef("a0b7d7a0-4af5-4539-9b81-cbef52d8cc5d", "LatestChangeTarget", "Defines the type of repository element that has changed.", descriptionGUID);
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        boolean element0Ordinal = false;
        String element0Value = "EntityStatus";
        String element0Description = "The status of the anchor entity has changed.";
        String element0DescriptionGUID = null;
        EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(0, "EntityStatus", "The status of the anchor entity has changed.", element0DescriptionGUID);
        elementDefs.add(elementDef);
        boolean element1Ordinal = true;
        String element1Value = "EntityProperty";
        String element1Description = "A property in the anchor entity has changed.";
        String element1DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(1, "EntityProperty", "A property in the anchor entity has changed.", element1DescriptionGUID);
        elementDefs.add(elementDef);
        int element2Ordinal = 2;
        String element2Value = "EntityClassification";
        String element2Description = "A classification attached to the anchor entity has changed.";
        String element2DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(2, "EntityClassification", "A classification attached to the anchor entity has changed.", element2DescriptionGUID);
        elementDefs.add(elementDef);
        int element3Ordinal = 3;
        String element3Value = "EntityRelationship";
        String element3Description = "A relationship linking the anchor entity to an attachment has changed.";
        String element3DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(3, "EntityRelationship", "A relationship linking the anchor entity to an attachment has changed.", element3DescriptionGUID);
        elementDefs.add(elementDef);
        int element4Ordinal = 4;
        String element4Value = "Attachment";
        String element4Description = "An entity attached either directly or indirectly to the anchor entity has changed.";
        String element4DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(4, "Attachment", "An entity attached either directly or indirectly to the anchor entity has changed.", element4DescriptionGUID);
        elementDefs.add(elementDef);
        int element5Ordinal = 5;
        String element5Value = "AttachmentStatus";
        String element5Description = "The status of an entity attached either directly or indirectly to the anchor entity has changed.";
        String element5DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(5, "AttachmentStatus", "The status of an entity attached either directly or indirectly to the anchor entity has changed.", element5DescriptionGUID);
        elementDefs.add(elementDef);
        int element6Ordinal = 6;
        String element6Value = "AttachmentProperty";
        String element6Description = "A property in an entity attached either directly or indirectly to the anchor entity has changed.";
        String element6DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(6, "AttachmentProperty", "A property in an entity attached either directly or indirectly to the anchor entity has changed.", element6DescriptionGUID);
        elementDefs.add(elementDef);
        int element7Ordinal = 7;
        String element7Value = "AttachmentClassification";
        String element7Description = "A classification attached to an entity that is, in turn, attached either directly or indirectly to the anchor entity has changed.";
        String element7DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(7, "AttachmentClassification", "A classification attached to an entity that is, in turn, attached either directly or indirectly to the anchor entity has changed.", element7DescriptionGUID);
        elementDefs.add(elementDef);
        int element8Ordinal = 8;
        String element8Value = "AttachmentRelationship";
        String element8Description = "A relationship linking to an entity that is, in turn, attached either directly or indirectly to the anchor entity has changed.";
        String element8DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(8, "AttachmentRelationship", "A relationship linking to an entity that is, in turn, attached either directly or indirectly to the anchor entity has changed.", element8DescriptionGUID);
        elementDefs.add(elementDef);
        int element99Ordinal = 99;
        String element99Value = "Other";
        String element99Description = "Another type of change.";
        String element99DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(99, "Other", "Another type of change.", element99DescriptionGUID);
        elementDefs.add(elementDef);
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EnumDef getLatestChangeActionEnum() {
        String guid = "032d844b-868f-4c4a-bc5d-81f0f9704c4d";
        String name = "LatestChangeAction";
        String description = "Defines the type of change that was made to a repository instance.";
        String descriptionGUID = null;
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef("032d844b-868f-4c4a-bc5d-81f0f9704c4d", "LatestChangeAction", "Defines the type of change that was made to a repository instance.", descriptionGUID);
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        boolean element1Ordinal = false;
        String element1Value = "Created";
        String element1Description = "The target element has been created.";
        String element1DescriptionGUID = null;
        EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(0, "Created", "The target element has been created.", element1DescriptionGUID);
        elementDefs.add(elementDef);
        boolean element2Ordinal = true;
        String element2Value = "Updated";
        String element2Description = "The properties of the target element have been changed.";
        String element2DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(1, "Updated", "The properties of the target element have been changed.", element2DescriptionGUID);
        elementDefs.add(elementDef);
        int element3Ordinal = 2;
        String element3Value = "Deleted";
        String element3Description = "The target element has been deleted.";
        String element3DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(2, "Deleted", "The target element has been deleted.", element3DescriptionGUID);
        elementDefs.add(elementDef);
        int element6Ordinal = 99;
        String element6Value = "Other";
        String element6Description = "Another type of action.";
        String element6DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(99, "Other", "Another type of action.", element6DescriptionGUID);
        elementDefs.add(elementDef);
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private ClassificationDef addLatestChangeClassification() {
        String guid = OpenMetadataType.LATEST_CHANGE_CLASSIFICATION.typeGUID;
        String name = OpenMetadataType.LATEST_CHANGE_CLASSIFICATION.typeName;
        String description = OpenMetadataType.LATEST_CHANGE_CLASSIFICATION.description;
        String descriptionGUID = OpenMetadataType.LATEST_CHANGE_CLASSIFICATION.descriptionGUID;
        String descriptionWiki = OpenMetadataType.LATEST_CHANGE_CLASSIFICATION.wikiURL;
        String linkedToEntity = OpenMetadataType.REFERENCEABLE.typeName;
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(guid, name, null, description, descriptionGUID, descriptionWiki, this.archiveBuilder.getEntityDef(linkedToEntity), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.CHANGE_TARGET.name;
        String attribute1Description = OpenMetadataProperty.CHANGE_TARGET.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.CHANGE_TARGET.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.CHANGE_ACTION.name;
        String attribute2Description = OpenMetadataProperty.CHANGE_ACTION.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.CHANGE_ACTION.descriptionGUID;
        String attribute3Name = OpenMetadataProperty.CLASSIFICATION_NAME.name;
        String attribute3Description = OpenMetadataProperty.CLASSIFICATION_NAME.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.CLASSIFICATION_NAME.descriptionGUID;
        String attribute4Name = OpenMetadataProperty.ATTACHMENT_GUID.name;
        String attribute4Description = OpenMetadataProperty.ATTACHMENT_GUID.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.ATTACHMENT_GUID.descriptionGUID;
        String attribute5Name = OpenMetadataProperty.ATTACHMENT_TYPE.name;
        String attribute5Description = OpenMetadataProperty.ATTACHMENT_TYPE.description;
        String attribute5DescriptionGUID = OpenMetadataProperty.ATTACHMENT_TYPE.descriptionGUID;
        String attribute6Name = OpenMetadataProperty.RELATIONSHIP_TYPE.name;
        String attribute6Description = OpenMetadataProperty.RELATIONSHIP_TYPE.description;
        String attribute6DescriptionGUID = OpenMetadataProperty.RELATIONSHIP_TYPE.descriptionGUID;
        String attribute7Name = OpenMetadataProperty.USER.name;
        String attribute7Description = OpenMetadataProperty.USER.description;
        String attribute7DescriptionGUID = OpenMetadataProperty.USER.descriptionGUID;
        String attribute8Name = OpenMetadataProperty.ACTION_DESCRIPTION.name;
        String attribute8Description = OpenMetadataProperty.ACTION_DESCRIPTION.description;
        String attribute8DescriptionGUID = OpenMetadataProperty.ACTION_DESCRIPTION.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute("LatestChangeTarget", attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("LatestChangeAction", attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute5Name, attribute5Description, attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute6Name, attribute6Description, attribute6DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute7Name, attribute7Description, attribute7DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute8Name, attribute8Description, attribute8DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef addAnchorsClassification() {
        String guid = OpenMetadataType.ANCHORS_CLASSIFICATION.typeGUID;
        String name = OpenMetadataType.ANCHORS_CLASSIFICATION.typeName;
        String description = OpenMetadataType.ANCHORS_CLASSIFICATION.description;
        String descriptionGUID = OpenMetadataType.ANCHORS_CLASSIFICATION.descriptionGUID;
        String descriptionWiki = OpenMetadataType.ANCHORS_CLASSIFICATION.wikiURL;
        ArrayList<TypeDefLink> linkedToEntities = new ArrayList<TypeDefLink>();
        linkedToEntities.add(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        linkedToEntities.add(this.archiveBuilder.getEntityDef(OpenMetadataType.ANNOTATION.typeName));
        linkedToEntities.add(this.archiveBuilder.getEntityDef(OpenMetadataType.ANNOTATION_REVIEW.typeName));
        linkedToEntities.add(this.archiveBuilder.getEntityDef("Like"));
        linkedToEntities.add(this.archiveBuilder.getEntityDef("Rating"));
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(guid, name, null, description, descriptionGUID, descriptionWiki, linkedToEntities, true);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.ANCHOR_GUID.name;
        String attribute1Description = OpenMetadataProperty.ANCHOR_GUID.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.ANCHOR_GUID.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private RelationshipDef addSourcedFromRelationship() {
        String guid = OpenMetadataType.SOURCED_FROM_RELATIONSHIP.typeGUID;
        String name = OpenMetadataType.SOURCED_FROM_RELATIONSHIP.typeName;
        String description = OpenMetadataType.SOURCED_FROM_RELATIONSHIP.description;
        String descriptionGUID = OpenMetadataType.SOURCED_FROM_RELATIONSHIP.descriptionGUID;
        String descriptionWiki = OpenMetadataType.SOURCED_FROM_RELATIONSHIP.wikiURL;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(guid, name, null, description, descriptionGUID, descriptionWiki, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end1AttributeName = "resultingElement";
        String end1AttributeDescription = "Element created from the template.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "resultingElement", "Element created from the template.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end2AttributeName = "templateElement";
        String end2AttributeDescription = "Template element providing information.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "templateElement", "Template element providing information.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void update0012SearchKeywords() {
        this.archiveBuilder.addEntityDef(this.getSearchKeywordEntity());
        this.archiveBuilder.addRelationshipDef(this.addSearchKeywordLinkRelationship());
        this.archiveBuilder.addRelationshipDef(this.addRelatedKeywordRelationship());
    }

    private EntityDef getSearchKeywordEntity() {
        String guid = OpenMetadataType.SEARCH_KEYWORD.typeGUID;
        String name = OpenMetadataType.SEARCH_KEYWORD.typeName;
        String description = OpenMetadataType.SEARCH_KEYWORD.description;
        String descriptionGUID = OpenMetadataType.SEARCH_KEYWORD.descriptionGUID;
        String descriptionWiki = OpenMetadataType.SEARCH_KEYWORD.wikiURL;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(guid, name, null, description, descriptionGUID, descriptionWiki);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.KEYWORD.name;
        String attribute1Description = OpenMetadataProperty.KEYWORD.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.KEYWORD.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute2Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef addSearchKeywordLinkRelationship() {
        String guid = OpenMetadataType.SEARCH_KEYWORD_LINK_RELATIONSHIP.typeGUID;
        String name = OpenMetadataType.SEARCH_KEYWORD_LINK_RELATIONSHIP.typeName;
        String description = OpenMetadataType.SEARCH_KEYWORD_LINK_RELATIONSHIP.description;
        String descriptionGUID = OpenMetadataType.SEARCH_KEYWORD_LINK_RELATIONSHIP.descriptionGUID;
        String descriptionWiki = OpenMetadataType.SEARCH_KEYWORD_LINK_RELATIONSHIP.wikiURL;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(guid, name, null, description, descriptionGUID, descriptionWiki, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end1AttributeName = "linkedElements";
        String end1AttributeDescription = "Element described by the search keyword.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "linkedElements", "Element described by the search keyword.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.SEARCH_KEYWORD.typeName;
        String end2AttributeName = "searchKeywords";
        String end2AttributeDescription = "Keywords to describe the element.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "searchKeywords", "Keywords to describe the element.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef addRelatedKeywordRelationship() {
        String guid = OpenMetadataType.RELATED_KEYWORD_RELATIONSHIP.typeGUID;
        String name = OpenMetadataType.RELATED_KEYWORD_RELATIONSHIP.typeName;
        String description = OpenMetadataType.RELATED_KEYWORD_RELATIONSHIP.description;
        String descriptionGUID = OpenMetadataType.RELATED_KEYWORD_RELATIONSHIP.descriptionGUID;
        String descriptionWiki = OpenMetadataType.RELATED_KEYWORD_RELATIONSHIP.wikiURL;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(guid, name, null, description, descriptionGUID, descriptionWiki, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.SEARCH_KEYWORD.typeName;
        String end1AttributeName = "relatedKeyword";
        String end1AttributeDescription = "Keyword with similar meaning or usage.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "relatedKeyword", "Keyword with similar meaning or usage.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.SEARCH_KEYWORD.typeName;
        String end2AttributeName = "relatedKeyword";
        String end2AttributeDescription = "Keyword with similar meaning or usage.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "relatedKeyword", "Keyword with similar meaning or usage.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void update0030HostsAndPlatforms() {
        this.archiveBuilder.addTypeDefPatch(this.correctOperatingPlatformEntity());
    }

    private TypeDefPatch correctOperatingPlatformEntity() {
        String typeName = "OperatingPlatform";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("OperatingPlatform");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "endianness";
        String attribute1Description = "Deprecated attribute. Use the byteOrdering attribute instead.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = OpenMetadataProperty.BYTE_ORDERING.name;
        String attribute2Description = OpenMetadataProperty.BYTE_ORDERING.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.BYTE_ORDERING.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("endianness", "Deprecated attribute. Use the byteOrdering attribute instead.", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute(attribute2Name);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute(ByteOrdering.getOpenTypeName(), attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void add0057IntegrationCapabilities() {
        this.archiveBuilder.addEntityDef(this.addSoftwareServiceEntity());
        this.archiveBuilder.addEntityDef(this.addMetadataIntegrationServiceEntity());
        this.archiveBuilder.addEntityDef(this.addMetadataAccessServiceEntity());
        this.archiveBuilder.addEntityDef(this.addEngineHostingServiceEntity());
        this.archiveBuilder.addEntityDef(this.addUserViewServiceEntity());
    }

    private EntityDef addSoftwareServiceEntity() {
        String guid = "f3f69251-adb1-4042-9d95-70082f95a028";
        String name = "SoftwareService";
        String description = "Defines a capability that provides externally callable functions to other services.";
        String descriptionGUID = null;
        String superTypeName = "SoftwareServerCapability";
        return this.archiveHelper.getDefaultEntityDef("f3f69251-adb1-4042-9d95-70082f95a028", "SoftwareService", this.archiveBuilder.getEntityDef("SoftwareServerCapability"), "Defines a capability that provides externally callable functions to other services.", descriptionGUID);
    }

    private EntityDef addMetadataIntegrationServiceEntity() {
        String guid = "92f7fe27-cd2f-441c-a084-156821aa5bca";
        String name = "MetadataIntegrationService";
        String description = "Defines a capability that exchanges metadata between servers.";
        String descriptionGUID = null;
        String superTypeName = "SoftwareService";
        return this.archiveHelper.getDefaultEntityDef("92f7fe27-cd2f-441c-a084-156821aa5bca", "MetadataIntegrationService", this.archiveBuilder.getEntityDef("SoftwareService"), "Defines a capability that exchanges metadata between servers.", descriptionGUID);
    }

    private EntityDef addMetadataAccessServiceEntity() {
        String guid = "0bc3a16a-e8ed-4ad0-a302-0773365fdef0";
        String name = "MetadataAccessService";
        String description = "Defines a capability that provides access to stored metadata.";
        String descriptionGUID = null;
        String superTypeName = "SoftwareService";
        return this.archiveHelper.getDefaultEntityDef("0bc3a16a-e8ed-4ad0-a302-0773365fdef0", "MetadataAccessService", this.archiveBuilder.getEntityDef("SoftwareService"), "Defines a capability that provides access to stored metadata.", descriptionGUID);
    }

    private EntityDef addEngineHostingServiceEntity() {
        String guid = "90880f0b-c7a3-4d1d-93cc-0b877f27cd33";
        String name = "EngineHostingService";
        String description = "Defines a capability that provides services that delegate to a hosted engine.";
        String descriptionGUID = null;
        String superTypeName = "SoftwareService";
        return this.archiveHelper.getDefaultEntityDef("90880f0b-c7a3-4d1d-93cc-0b877f27cd33", "EngineHostingService", this.archiveBuilder.getEntityDef("SoftwareService"), "Defines a capability that provides services that delegate to a hosted engine.", descriptionGUID);
    }

    private EntityDef addUserViewServiceEntity() {
        String guid = "1f83fc7c-75bb-491d-980d-ff9a6f80ae02";
        String name = "UserViewService";
        String description = "Defines a capability that provides user interfaces access to digital resources.";
        String descriptionGUID = null;
        String superTypeName = "SoftwareService";
        return this.archiveHelper.getDefaultEntityDef("1f83fc7c-75bb-491d-980d-ff9a6f80ae02", "UserViewService", this.archiveBuilder.getEntityDef("SoftwareService"), "Defines a capability that provides user interfaces access to digital resources.", descriptionGUID);
    }

    private void update0150Feedback() {
        this.archiveBuilder.addTypeDefPatch(this.updateLikeEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateCommentEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateRatingEntity());
    }

    private TypeDefPatch updateLikeEntity() {
        String typeName = "Like";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("Like");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "anchorGUID";
        String attribute1Description = "Deprecated attribute. Use the Anchors classification instead.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("anchorGUID", "Deprecated attribute. Use the Anchors classification instead.", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateCommentEntity() {
        String typeName = "Comment";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("Comment");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "anchorGUID";
        String attribute1Description = "Deprecated attribute. Use the Anchors classification instead.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("anchorGUID", "Deprecated attribute. Use the Anchors classification instead.", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        properties.add(property);
        String attribute2Name = "type";
        String attribute2Description = "Deprecated attribute. Use the commentType attribute to describe the type of comment.";
        String attribute2DescriptionGUID = null;
        String attribute2ReplacedBy = "commentType";
        property = this.archiveHelper.getEnumTypeDefAttribute("CommentType", "type", "Deprecated attribute. Use the commentType attribute to describe the type of comment.", attribute2DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("commentType");
        properties.add(property);
        String attribute3Name = "commentType";
        String attribute3Description = "Type of comment.";
        String attribute3DescriptionGUID = null;
        property = this.archiveHelper.getEnumTypeDefAttribute("CommentType", "commentType", "Type of comment.", attribute3DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateRatingEntity() {
        String typeName = "Rating";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("Rating");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "anchorGUID";
        String attribute1Description = "Deprecated attribute. Use the Anchors classification instead.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("anchorGUID", "Deprecated attribute. Use the Anchors classification instead.", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0215SoftwareComponents() {
        this.archiveBuilder.addEntityDef(this.addDeployedConnectorEntity());
    }

    private EntityDef addDeployedConnectorEntity() {
        String guid = "c9a183ab-67f4-46a4-8836-16fa041769b7";
        String name = "DeployedConnector";
        String description = "A connector that is configured and deployed to run in a specific software server capability.";
        String descriptionGUID = null;
        String superTypeName = "DeployedSoftwareComponent";
        return this.archiveHelper.getDefaultEntityDef("c9a183ab-67f4-46a4-8836-16fa041769b7", "DeployedConnector", this.archiveBuilder.getEntityDef("DeployedSoftwareComponent"), "A connector that is configured and deployed to run in a specific software server capability.", descriptionGUID);
    }

    private void update04xxGovernanceEnums() {
        this.archiveBuilder.addEntityDef(this.addGovernanceDomainDescriptionEntity());
        this.archiveBuilder.addEntityDef(this.addGovernanceClassificationLevelEntity());
        this.archiveBuilder.addClassificationDef(this.addGovernanceDomainSetClassification());
        this.archiveBuilder.addClassificationDef(this.addGovernanceClassificationSetClassification());
        this.archiveBuilder.addRelationshipDef(this.getGovernedByRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateCriticalityClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateRetentionClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateConfidenceClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateConfidentialityClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateGovernanceOfficerEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateGovernanceDefinitionEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateGovernanceRoleEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateGovernanceMetricEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateGovernanceZoneEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateSubjectAreaDefinitionEntity());
        this.archiveBuilder.addTypeDefPatch(this.deprecateGovernanceConfidentialityLevelEntity());
        this.archiveBuilder.addTypeDefPatch(this.deprecateZoneGovernanceRelationship());
        this.archiveBuilder.addTypeDefPatch(this.deprecateSubjectAreaGovernanceRelationship());
    }

    private EnumDef getConfidentialityLevelEnum() {
        String guid = "abc48ca2-4d29-4de9-99a1-bc4db9816d68";
        String name = "ConfidentialityLevel";
        String description = "Defines how confidential a data item is.";
        String descriptionGUID = null;
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef("abc48ca2-4d29-4de9-99a1-bc4db9816d68", "ConfidentialityLevel", "Defines how confidential a data item is.", descriptionGUID);
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        boolean element1Ordinal = false;
        String element1Value = "Unclassified";
        String element1Description = "The data is public information.";
        String element1DescriptionGUID = null;
        EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(0, "Unclassified", "The data is public information.", element1DescriptionGUID);
        elementDefs.add(elementDef);
        enumDef.setDefaultValue(elementDef);
        boolean element2Ordinal = true;
        String element2Value = "Internal";
        String element2Description = "The data should not be exposed outside of this organization.";
        String element2DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(1, "Internal", "The data should not be exposed outside of this organization.", element2DescriptionGUID);
        elementDefs.add(elementDef);
        int element3Ordinal = 2;
        String element3Value = "Confidential";
        String element3Description = "The data should be protected and only shared with people with a need to see it.";
        String element3DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(2, "Confidential", "The data should be protected and only shared with people with a need to see it.", element3DescriptionGUID);
        elementDefs.add(elementDef);
        int element4Ordinal = 3;
        String element4Value = "Sensitive";
        String element4Description = "The data is sensitive and inappropriate use may adversely impact the data subject.";
        String element4DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(3, "Sensitive", "The data is sensitive and inappropriate use may adversely impact the data subject.", element4DescriptionGUID);
        elementDefs.add(elementDef);
        int element5Ordinal = 4;
        String element5Value = "Restricted";
        String element5Description = "The data is very valuable and must be restricted to a very small number of people.";
        String element5DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(4, "Restricted", "The data is very valuable and must be restricted to a very small number of people.", element5DescriptionGUID);
        elementDefs.add(elementDef);
        int element99Ordinal = 99;
        String element99Value = "Other";
        String element99Description = "Another confidentially level.";
        String element99DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(99, "Other", "Another confidentially level.", element99DescriptionGUID);
        elementDefs.add(elementDef);
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EntityDef addGovernanceDomainDescriptionEntity() {
        String guid = "084cd115-5d0d-4f12-8093-697526a120ea";
        String name = "GovernanceDomainDescription";
        String description = "A description of a governance domain along with an identifier for use in governance definitions.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("084cd115-5d0d-4f12-8093-697526a120ea", "GovernanceDomainDescription", this.archiveBuilder.getEntityDef(superTypeName), "A description of a governance domain along with an identifier for use in governance definitions.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "domainIdentifier";
        String attribute1Description = "Identifier used in governance definitions to show which governance domain they belong to.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = OpenMetadataProperty.DISPLAY_NAME.name;
        String attribute2Description = OpenMetadataProperty.DISPLAY_NAME.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.DISPLAY_NAME.descriptionGUID;
        String attribute3Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute3Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute("domainIdentifier", "Identifier used in governance definitions to show which governance domain they belong to.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef addGovernanceClassificationLevelEntity() {
        String guid = "8af91d61-2ae8-4255-992e-14d7f745a556";
        String name = "GovernanceClassificationLevel";
        String description = "A value to represent a specific level in a governance classification definition.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("8af91d61-2ae8-4255-992e-14d7f745a556", "GovernanceClassificationLevel", this.archiveBuilder.getEntityDef(superTypeName), "A value to represent a specific level in a governance classification definition.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "levelIdentifier";
        String attribute1Description = "Numeric value for the classification level";
        String attribute1DescriptionGUID = null;
        String attribute2Name = OpenMetadataProperty.DISPLAY_NAME.name;
        String attribute2Description = OpenMetadataProperty.DISPLAY_NAME.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.DISPLAY_NAME.descriptionGUID;
        String attribute3Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute3Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute("levelIdentifier", "Numeric value for the classification level", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private ClassificationDef addGovernanceDomainSetClassification() {
        String guid = "e66bb681-99a1-4712-a2c9-712c8b0f83ae";
        String name = "GovernanceDomainSet";
        String description = "Identifies the definitions for the different governance domains in use by the organization.";
        String descriptionGUID = null;
        ArrayList<TypeDefLink> linkedToEntities = new ArrayList<TypeDefLink>();
        linkedToEntities.add(this.archiveBuilder.getEntityDef("Collection"));
        return this.archiveHelper.getClassificationDef("e66bb681-99a1-4712-a2c9-712c8b0f83ae", "GovernanceDomainSet", null, "Identifies the definitions for the different governance domains in use by the organization.", descriptionGUID, linkedToEntities, false);
    }

    private ClassificationDef addGovernanceClassificationSetClassification() {
        String guid = "d92b7f31-c92d-418d-b345-ea45bb3f73f5";
        String name = "GovernanceClassificationSet";
        String description = "Identifies the set of levels that are used within a specific governance classification.";
        String descriptionGUID = null;
        ArrayList<TypeDefLink> linkedToEntities = new ArrayList<TypeDefLink>();
        linkedToEntities.add(this.archiveBuilder.getEntityDef("Collection"));
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("d92b7f31-c92d-418d-b345-ea45bb3f73f5", "GovernanceClassificationSet", null, "Identifies the set of levels that are used within a specific governance classification.", descriptionGUID, linkedToEntities, false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "domainIdentifier";
        String attribute1Description = "Identifier of the governance domain that recognizes this set of levels.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "classificationName";
        String attribute2Description = "Name of the classification where this set of levels is used.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "classificationPropertyName";
        String attribute3Description = "Name of the property in the classification where this value is used.";
        String attribute3DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute("domainIdentifier", "Identifier of the governance domain that recognizes this set of levels.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("classificationName", "Name of the classification where this set of levels is used.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("classificationPropertyName", "Name of the property in the classification where this value is used.", attribute3DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private RelationshipDef getGovernedByRelationship() {
        String guid = "89c3c695-9e8d-4660-9f44-ed971fd55f89";
        String name = "GovernedBy";
        String description = "Shows the resources that are governed by a specific governance definition.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("89c3c695-9e8d-4660-9f44-ed971fd55f89", "GovernedBy", null, "Shows the resources that are governed by a specific governance definition.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "GovernanceDefinition";
        String end1AttributeName = "governedBy";
        String end1AttributeDescription = "The governance definition that defines how this element is governed.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernanceDefinition"), "governedBy", "The governance definition that defines how this element is governed.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end2AttributeName = "governedElements";
        String end2AttributeDescription = "An element that is governed according to the governance definition.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "governedElements", "An element that is governed according to the governance definition.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private TypeDefPatch updateCriticalityClassification() {
        String typeName = "Criticality";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("Criticality");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute2Name = "levelIdentifier";
        String attribute2Description = "Defined level for this classification.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute("levelIdentifier", "Defined level for this classification.", attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateRetentionClassification() {
        String typeName = "Retention";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("Retention");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute2Name = "basisIdentifier";
        String attribute2Description = "Defined level of the retention basis for this classification.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute("basisIdentifier", "Defined level of the retention basis for this classification.", attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateConfidenceClassification() {
        String typeName = "Confidence";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("Confidence");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute2Name = "levelIdentifier";
        String attribute2Description = "Defined level for this classification.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute("levelIdentifier", "Defined level for this classification.", attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateConfidentialityClassification() {
        String typeName = "Confidentiality";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("Confidentiality");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "level";
        String attribute1Description = "Deprecated attribute. Use the levelIdentifier attribute instead.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "levelIdentifier";
        String attribute2Description = "Defined level for this classification.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "confidentialityLevel";
        String attribute3Description = "Pre-defined level for this classification.";
        String attribute3DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute("level", "Deprecated attribute. Use the levelIdentifier attribute instead.", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("levelIdentifier");
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute("levelIdentifier", "Defined level for this classification.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("ConfidentialityLevel", "confidentialityLevel", "Pre-defined level for this classification.", attribute3DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateGovernanceOfficerEntity() {
        String typeName = "GovernanceOfficer";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("GovernanceOfficer");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute2Name = "domainIdentifier";
        String attribute2Description = "Identifier of the governance domain that this definition belongs to.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute("domainIdentifier", "Identifier of the governance domain that this definition belongs to.", attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateGovernanceDefinitionEntity() {
        String typeName = "GovernanceDefinition";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("GovernanceDefinition");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute2Name = "domainIdentifier";
        String attribute2Description = "Identifier of the governance domain that this definition belongs to.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute("domainIdentifier", "Identifier of the governance domain that this definition belongs to.", attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateSubjectAreaDefinitionEntity() {
        String typeName = "SubjectAreaDefinition";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("SubjectAreaDefinition");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute2Name = "domainIdentifier";
        String attribute2Description = "Identifier of the governance domain that this definition belongs to.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute("domainIdentifier", "Identifier of the governance domain that this definition belongs to.", attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateGovernanceRoleEntity() {
        String typeName = "GovernanceRole";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("GovernanceRole");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute2Name = "domainIdentifier";
        String attribute2Description = "Identifier of the governance domain that this definition belongs to.";
        String attribute2DescriptionGUID = null;
        String attribute5Name = "domain";
        String attribute5Description = "Governance domain for this governance definition.";
        String attribute5DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute("domainIdentifier", "Identifier of the governance domain that this definition belongs to.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("GovernanceDomain", "domain", "Governance domain for this governance definition.", attribute5DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateGovernanceMetricEntity() {
        String typeName = "GovernanceMetric";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("GovernanceMetric");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute2Name = "domainIdentifier";
        String attribute2Description = "Identifier of the governance domain that this definition belongs to.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute("domainIdentifier", "Identifier of the governance domain that this definition belongs to.", attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateGovernanceZoneEntity() {
        String typeName = "GovernanceZone";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("GovernanceZone");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute2Name = "domainIdentifier";
        String attribute2Description = "Identifier of the governance domain that this definition belongs to.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute("domainIdentifier", "Identifier of the governance domain that this definition belongs to.", attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch deprecateGovernanceConfidentialityLevelEntity() {
        String typeName = "GovernanceConfidentialityLevel";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("GovernanceConfidentialityLevel");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private TypeDefPatch deprecateSubjectAreaGovernanceRelationship() {
        String typeName = "SubjectAreaGovernance";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("SubjectAreaGovernance");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private TypeDefPatch deprecateZoneGovernanceRelationship() {
        String typeName = "ZoneGovernance";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ZoneGovernance");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private void update05xxSchemaAttributes() {
        this.archiveBuilder.addTypeDefPatch(this.deprecateAnchorGUID());
        this.archiveBuilder.addTypeDefPatch(this.deprecateRelationalViewClassification());
        this.archiveBuilder.addTypeDefPatch(this.deprecateDerivedSchemaAttributeEntity());
        this.archiveBuilder.addTypeDefPatch(this.deprecateDerivedRelationalColumnEntity());
        this.archiveBuilder.addTypeDefPatch(this.deprecateSchemaLinkElementEntity());
        this.archiveBuilder.addTypeDefPatch(this.deprecateSchemaLinkToTypeRelationship());
        this.archiveBuilder.addTypeDefPatch(this.deprecateLinkedTypeRelationship());
        this.archiveBuilder.addTypeDefPatch(this.deprecateSchemaQueryImplementationRelationship());
        this.archiveBuilder.addTypeDefPatch(this.addPrecisionToSchemaAttributeEntity());
        this.archiveBuilder.addClassificationDef(this.getCalculatedValueClassification());
        this.archiveBuilder.addEntityDef(this.getExternalSchemaTypeEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateMapFromElementTypeRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateMapToElementTypeRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateSchemaTypeOptionRelationship());
        this.archiveBuilder.addRelationshipDef(this.getDerivedSchemaTypeQueryTargetRelationship());
        this.archiveBuilder.addRelationshipDef(this.getLinkedExternalSchemaTypeRelationship());
    }

    private TypeDefPatch deprecateAnchorGUID() {
        String typeName = "SchemaElement";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("SchemaElement");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "anchorGUID";
        String attribute1Description = "Optional identification of the Asset that this schema element is a part of.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("anchorGUID", "Optional identification of the Asset that this schema element is a part of.", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch deprecateRelationalViewClassification() {
        String typeName = "RelationalView";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("RelationalView");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private TypeDefPatch deprecateDerivedSchemaAttributeEntity() {
        String typeName = "DerivedSchemaAttribute";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("DerivedSchemaAttribute");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private TypeDefPatch deprecateSchemaLinkElementEntity() {
        String typeName = "SchemaLinkElement";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("SchemaLinkElement");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private TypeDefPatch deprecateDerivedRelationalColumnEntity() {
        String typeName = "DerivedRelationalColumn";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("DerivedRelationalColumn");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private TypeDefPatch deprecateSchemaLinkToTypeRelationship() {
        String typeName = "SchemaLinkToType";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("SchemaLinkToType");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private TypeDefPatch deprecateLinkedTypeRelationship() {
        String typeName = "LinkedType";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("LinkedType");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private TypeDefPatch deprecateSchemaQueryImplementationRelationship() {
        String typeName = "SchemaQueryImplementation";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("SchemaQueryImplementation");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private TypeDefPatch addPrecisionToSchemaAttributeEntity() {
        String typeName = "SchemaAttribute";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("SchemaAttribute");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "precision";
        String attribute1Description = "Number of digits after the decimal point.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("precision", "Number of digits after the decimal point.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private ClassificationDef getCalculatedValueClassification() {
        String guid = "4814bec8-482d-463d-8376-160b0358e139";
        String name = "CalculatedValue";
        String description = "A field within a schema that is calculated via the formula and query targets rather than stored.";
        String descriptionGUID = null;
        String linkedToEntity = "SchemaType";
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("4814bec8-482d-463d-8376-160b0358e139", "CalculatedValue", null, "A field within a schema that is calculated via the formula and query targets rather than stored.", descriptionGUID, this.archiveBuilder.getEntityDef("SchemaType"), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "formula";
        String attribute1Description = "Expression to create the value.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("formula", "Expression to create the value.", attribute1DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private EntityDef getExternalSchemaTypeEntity() {
        String guid = "78de00ea-3d69-47ff-a6d6-767587526624";
        String name = "ExternalSchemaType";
        String description = "The schema type is defined using an external schema.";
        String descriptionGUID = null;
        String superTypeName = "SchemaType";
        return this.archiveHelper.getDefaultEntityDef("78de00ea-3d69-47ff-a6d6-767587526624", "ExternalSchemaType", this.archiveBuilder.getEntityDef("SchemaType"), "The schema type is defined using an external schema.", descriptionGUID);
    }

    private RelationshipDef getLinkedExternalSchemaTypeRelationship() {
        String guid = "9a5d78c2-1716-4783-bfc6-c300a9e2d092";
        String name = "LinkedExternalSchemaType";
        String description = "Links to a reusable schema type that is external to this schema.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("9a5d78c2-1716-4783-bfc6-c300a9e2d092", "LinkedExternalSchemaType", null, "Links to a reusable schema type that is external to this schema.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "SchemaElement";
        String end1AttributeName = "usedInSchema";
        String end1AttributeDescription = "Connection point for a reusable schema type.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SchemaElement"), "usedInSchema", "Connection point for a reusable schema type.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "SchemaType";
        String end2AttributeName = "externalSchemaType";
        String end2AttributeDescription = "The schema type that is being reused in another schema.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SchemaType"), "externalSchemaType", "The schema type that is being reused in another schema.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getDerivedSchemaTypeQueryTargetRelationship() {
        String guid = "1c2622b7-ac21-413c-89e1-6f61f348cd19";
        String name = "DerivedSchemaTypeQueryTarget";
        String description = "Details of how a derived schema element is calculated.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("1c2622b7-ac21-413c-89e1-6f61f348cd19", "DerivedSchemaTypeQueryTarget", null, "Details of how a derived schema element is calculated.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "SchemaElement";
        String end1AttributeName = "usedBy";
        String end1AttributeDescription = "Use of another schema type to derive all or part of this schema type's value.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SchemaElement"), "usedBy", "Use of another schema type to derive all or part of this schema type's value.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "SchemaElement";
        String end2AttributeName = "queryTarget";
        String end2AttributeDescription = "Used to provide data values to the other schema type.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SchemaElement"), "queryTarget", "Used to provide data values to the other schema type.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "queryId";
        String attribute1Description = "Identifier for placeholder in derived schema type's formula.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("queryId", "Identifier for placeholder in derived schema type's formula.", attribute1DescriptionGUID);
        properties.add(property);
        String attribute2Name = "query";
        String attribute2Description = "Details of how the value(s) is/are retrieved.";
        String attribute2DescriptionGUID = null;
        property = this.archiveHelper.getStringTypeDefAttribute("query", "Details of how the value(s) is/are retrieved.", attribute2DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private TypeDefPatch updateSchemaTypeOptionRelationship() {
        String typeName = "SchemaTypeOption";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("SchemaTypeOption");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end1EntityType = "SchemaElement";
        String end1AttributeName = "schemaOptionalUses";
        String end1AttributeDescription = "Schema where this schema type is reused.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SchemaElement"), "schemaOptionalUses", "Schema where this schema type is reused.", end1AttributeDescriptionGUID, end1Cardinality);
        typeDefPatch.setEndDef2(relationshipEndDef);
        return typeDefPatch;
    }

    private TypeDefPatch updateMapFromElementTypeRelationship() {
        String typeName = "MapFromElementType";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("MapFromElementType");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end1EntityType = "SchemaElement";
        String end1AttributeName = "parentMapFrom";
        String end1AttributeDescription = "Used in map to describe the domain (value mapped from).";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SchemaElement"), "parentMapFrom", "Used in map to describe the domain (value mapped from).", end1AttributeDescriptionGUID, end1Cardinality);
        typeDefPatch.setEndDef2(relationshipEndDef);
        return typeDefPatch;
    }

    private TypeDefPatch updateMapToElementTypeRelationship() {
        String typeName = "MapToElementType";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("MapToElementType");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end1EntityType = "SchemaElement";
        String end1AttributeName = "parentMapTo";
        String end1AttributeDescription = "Used in map to describe the range (value mapped to).";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SchemaElement"), "parentMapTo", "Used in map to describe the range (value mapped to).", end1AttributeDescriptionGUID, end1Cardinality);
        typeDefPatch.setEndDef2(relationshipEndDef);
        return typeDefPatch;
    }

    private void update06xxDiscovery() {
        this.archiveBuilder.addTypeDefPatch(this.updateDiscoveryReportEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateAnnotationEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateDataFieldEntity());
    }

    private TypeDefPatch updateDiscoveryReportEntity() {
        String typeName = "OpenDiscoveryAnalysisReport";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("OpenDiscoveryAnalysisReport");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "anchorGUID";
        String attribute1Description = "Deprecated attribute. Use the Anchors classification instead.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("anchorGUID", "Deprecated attribute. Use the Anchors classification instead.", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateAnnotationEntity() {
        String typeName = OpenMetadataType.ANNOTATION.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "anchorGUID";
        String attribute1Description = "Deprecated attribute. Use the Anchors classification instead.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("anchorGUID", "Deprecated attribute. Use the Anchors classification instead.", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateDataFieldEntity() {
        String typeName = "DataField";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("DataField");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "anchorGUID";
        String attribute1Description = "Deprecated attribute. Use the Anchors classification instead.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("anchorGUID", "Deprecated attribute. Use the Anchors classification instead.", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0545ReferenceData() {
        this.archiveBuilder.addTypeDefPatch(this.addIsDeprecated());
    }

    private TypeDefPatch addIsDeprecated() {
        String typeName = "ValidValueDefinition";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ValidValueDefinition");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "isDeprecated";
        String attribute1Description = "Indicates that this value is deprecated and all uses should be discontinued as soon as possible.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getBooleanTypeDefAttribute("isDeprecated", "Indicates that this value is deprecated and all uses should be discontinued as soon as possible.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void updateClashingControlProperties() {
        this.archiveBuilder.addTypeDefPatch(this.updateSoftwareServerPlatformEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateSoftwareServerEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateSoftwareServerCapabilityEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateCloudPlatformClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateCloudTenantClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateCloudServiceClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateGraphStoreEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateLogFileEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateDatabaseEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateDatabaseServerClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateMetadataRepositoryEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateMetadataServerClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateRepositoryProxyClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateBusinessCapabilityEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateEnterpriseAccessLayerEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateMetadataCollectionEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateExternalReferenceEntity());
        this.archiveBuilder.addTypeDefPatch(this.updatePropertyFacetEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateCohortMemberEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateImplementationSnippetEntity());
        this.archiveBuilder.addTypeDefPatch(this.updatePolicyAdministrationPointClassification());
        this.archiveBuilder.addTypeDefPatch(this.updatePolicyDecisionPointClassification());
        this.archiveBuilder.addTypeDefPatch(this.updatePolicyEnforcementPointClassification());
        this.archiveBuilder.addTypeDefPatch(this.updatePolicyInformationPointClassification());
        this.archiveBuilder.addTypeDefPatch(this.updatePolicyRetrievalPointClassification());
    }

    private TypeDefPatch updateSoftwareServerPlatformEntity() {
        String typeName = "SoftwareServerPlatform";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("SoftwareServerPlatform");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "type";
        String attribute1Description = "Deprecated attribute. Use the deployedImplementationType attribute to describe the type of software server platform.";
        String attribute1DescriptionGUID = null;
        String attribute1ReplacedBy = "deployedImplementationType";
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("type", "Deprecated attribute. Use the deployedImplementationType attribute to describe the type of software server platform.", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("deployedImplementationType");
        properties.add(property);
        String attribute3Name = "version";
        String attribute3Description = "Deprecated attribute. Use the platformVersion attribute to define the version number of software server platform.";
        String attribute3DescriptionGUID = null;
        String attribute3ReplacedBy = "platformVersion";
        property = this.archiveHelper.getStringTypeDefAttribute("version", "Deprecated attribute. Use the platformVersion attribute to define the version number of software server platform.", attribute3DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("platformVersion");
        properties.add(property);
        String attribute4Name = "platformVersion";
        String attribute4Description = "Version number of the software server platform.";
        String attribute4DescriptionGUID = null;
        property = this.archiveHelper.getStringTypeDefAttribute("platformVersion", "Version number of the software server platform.", attribute4DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateSoftwareServerEntity() {
        String typeName = "SoftwareServer";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("SoftwareServer");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "type";
        String attribute1Description = "Deprecated attribute. Use the deployedImplementationType attribute to describe the type of software server.";
        String attribute1DescriptionGUID = null;
        String attribute1ReplacedBy = "deployedImplementationType";
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("type", "Deprecated attribute. Use the deployedImplementationType attribute to describe the type of software server.", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("deployedImplementationType");
        properties.add(property);
        String attribute3Name = "version";
        String attribute3Description = "Deprecated attribute. Use the serverVersion attribute to define the version number of software server.";
        String attribute3DescriptionGUID = null;
        String attribute3ReplacedBy = "serverVersion";
        property = this.archiveHelper.getStringTypeDefAttribute("version", "Deprecated attribute. Use the serverVersion attribute to define the version number of software server.", attribute3DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("serverVersion");
        properties.add(property);
        String attribute4Name = "serverVersion";
        String attribute4Description = "Version number of the software server.";
        String attribute4DescriptionGUID = null;
        property = this.archiveHelper.getStringTypeDefAttribute("serverVersion", "Version number of the software server.", attribute4DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateSoftwareServerCapabilityEntity() {
        String typeName = "SoftwareServerCapability";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("SoftwareServerCapability");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "type";
        String attribute1Description = "Deprecated attribute. Use the deployedImplementationType attribute to describe the type of software server capability.";
        String attribute1DescriptionGUID = null;
        String attribute1ReplacedBy = "capabilityType";
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("type", "Deprecated attribute. Use the deployedImplementationType attribute to describe the type of software server capability.", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("capabilityType");
        properties.add(property);
        String attribute3Name = "version";
        String attribute3Description = "Deprecated attribute. Use the capabilityVersion attribute to define the version number of software server capability.";
        String attribute3DescriptionGUID = null;
        String attribute3ReplacedBy = "capabilityVersion";
        property = this.archiveHelper.getStringTypeDefAttribute("version", "Deprecated attribute. Use the capabilityVersion attribute to define the version number of software server capability.", attribute3DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("capabilityVersion");
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateCloudPlatformClassification() {
        String typeName = "CloudPlatform";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("CloudPlatform");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "type";
        String attribute1Description = "Deprecated attribute. Use the deployedImplementationType attribute to describe the type of cloud platform.";
        String attribute1DescriptionGUID = null;
        String attribute1ReplacedBy = "deployedImplementationType";
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("type", "Deprecated attribute. Use the deployedImplementationType attribute to describe the type of cloud platform.", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("deployedImplementationType");
        properties.add(property);
        String attribute2Name = "deployedImplementationType";
        String attribute2Description = "Type of implemented or deployed cloud platform.";
        String attribute2DescriptionGUID = null;
        property = this.archiveHelper.getStringTypeDefAttribute("deployedImplementationType", "Type of implemented or deployed cloud platform.", attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateCloudTenantClassification() {
        String typeName = "CloudTenant";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("CloudTenant");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "type";
        String attribute1Description = "Deprecated attribute. Use the tenantType attribute to describe the type of cloud tenant.";
        String attribute1DescriptionGUID = null;
        String attribute1ReplacedBy = "tenantType";
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("type", "Deprecated attribute. Use the tenantType attribute to describe the type of cloud tenant.", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("tenantType");
        properties.add(property);
        String attribute2Name = "tenantType";
        String attribute2Description = "Description of the type of tenant.";
        String attribute2DescriptionGUID = null;
        property = this.archiveHelper.getStringTypeDefAttribute("tenantType", "Description of the type of tenant.", attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateCloudServiceClassification() {
        String typeName = "CloudService";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("CloudService");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "type";
        String attribute1Description = "Deprecated attribute. Use the serviceType attribute to describe the type of cloud service.";
        String attribute1DescriptionGUID = null;
        String attribute1ReplacedBy = "serviceType";
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("type", "Deprecated attribute. Use the serviceType attribute to describe the type of cloud service.", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("serviceType");
        properties.add(property);
        String attribute2Name = "serviceType";
        String attribute2Description = "Description of the type of the service.";
        String attribute2DescriptionGUID = null;
        property = this.archiveHelper.getStringTypeDefAttribute("serviceType", "Description of the type of the service.", attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateGraphStoreEntity() {
        String typeName = "GraphStore";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("GraphStore");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "type";
        String attribute1Description = "Deprecated attribute. Use the deployedImplementationType attribute to describe the type of graph store.";
        String attribute1DescriptionGUID = null;
        String attribute1ReplacedBy = "deployedImplementationType";
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("type", "Deprecated attribute. Use the deployedImplementationType attribute to describe the type of graph store.", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("deployedImplementationType");
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateLogFileEntity() {
        String typeName = OpenMetadataType.LOG_FILE.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "type";
        String attribute1Description = "Deprecated attribute. Use the deployedImplementationType attribute to describe the type of log file.";
        String attribute1DescriptionGUID = null;
        String attribute1ReplacedBy = OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("type", "Deprecated attribute. Use the deployedImplementationType attribute to describe the type of log file.", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute(attribute1ReplacedBy);
        properties.add(property);
        String attribute2Name = OpenMetadataProperty.PURPOSE.name;
        String attribute2Description = OpenMetadataProperty.PURPOSE.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.PURPOSE.descriptionGUID;
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateDatabaseEntity() {
        String typeName = "Database";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("Database");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "type";
        String attribute1Description = "Deprecated attribute. Use the deployedImplementationType attribute to describe the type of database.";
        String attribute1DescriptionGUID = null;
        String attribute1ReplacedBy = "deployedImplementationType";
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("type", "Deprecated attribute. Use the deployedImplementationType attribute to describe the type of database.", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("deployedImplementationType");
        properties.add(property);
        String attribute3Name = "version";
        String attribute3Description = "Deprecated attribute. Use the databaseVersion attribute to define the version number of database.";
        String attribute3DescriptionGUID = null;
        String attribute3ReplacedBy = "databaseVersion";
        property = this.archiveHelper.getStringTypeDefAttribute("version", "Deprecated attribute. Use the databaseVersion attribute to define the version number of database.", attribute3DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("databaseVersion");
        properties.add(property);
        String attribute4Name = "databaseVersion";
        String attribute4Description = "Version of the database.";
        String attribute4DescriptionGUID = null;
        property = this.archiveHelper.getStringTypeDefAttribute("databaseVersion", "Version of the database.", attribute4DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateDatabaseServerClassification() {
        String typeName = "DatabaseServer";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("DatabaseServer");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "type";
        String attribute1Description = "Deprecated attribute. Use the deployedImplementationType attribute to describe the type of database server.";
        String attribute1DescriptionGUID = null;
        String attribute1ReplacedBy = "deployedImplementationType";
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("type", "Deprecated attribute. Use the deployedImplementationType attribute to describe the type of database server.", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("deployedImplementationType");
        properties.add(property);
        String attribute3Name = "version";
        String attribute3Description = "Deprecated attribute. Use the softwareVersion attribute to define the version number of database server software.";
        String attribute3DescriptionGUID = null;
        String attribute3ReplacedBy = "softwareVersion";
        property = this.archiveHelper.getStringTypeDefAttribute("version", "Deprecated attribute. Use the softwareVersion attribute to define the version number of database server software.", attribute3DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("softwareVersion");
        properties.add(property);
        String attribute4Name = "softwareVersion";
        String attribute4Description = "Version of the database server software.";
        String attribute4DescriptionGUID = null;
        property = this.archiveHelper.getStringTypeDefAttribute("softwareVersion", "Version of the database server software.", attribute4DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateMetadataRepositoryEntity() {
        String typeName = "MetadataRepository";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("MetadataRepository");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "type";
        String attribute1Description = "Deprecated attribute. Use the deployedImplementationType attribute to describe the type of metadata repository.";
        String attribute1DescriptionGUID = null;
        String attribute1ReplacedBy = "deployedImplementationType";
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("type", "Deprecated attribute. Use the deployedImplementationType attribute to describe the type of metadata repository.", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("deployedImplementationType");
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateMetadataServerClassification() {
        String typeName = "MetadataServer";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("MetadataServer");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "type";
        String attribute1Description = "Deprecated attribute. Use the deployedImplementationType attribute to describe the type of metadata server.";
        String attribute1DescriptionGUID = null;
        String attribute1ReplacedBy = "deployedImplementationType";
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("type", "Deprecated attribute. Use the deployedImplementationType attribute to describe the type of metadata server.", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("deployedImplementationType");
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateRepositoryProxyClassification() {
        String typeName = "RepositoryProxy";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("RepositoryProxy");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "type";
        String attribute1Description = "Deprecated attribute. Use the deployedImplementationType attribute to describe the type of repository proxy.";
        String attribute1DescriptionGUID = null;
        String attribute1ReplacedBy = "deployedImplementationType";
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("type", "Deprecated attribute. Use the deployedImplementationType attribute to describe the type of repository proxy.", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("deployedImplementationType");
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateBusinessCapabilityEntity() {
        String typeName = "BusinessCapability";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("BusinessCapability");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "type";
        String attribute1Description = "Deprecated attribute. Use the businessImplementationType attribute to describe the type of business capability.";
        String attribute1DescriptionGUID = null;
        String attribute1ReplacedBy = "businessImplementationType";
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute("BusinessCapabilityType", "type", "Deprecated attribute. Use the businessImplementationType attribute to describe the type of business capability.", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("businessImplementationType");
        properties.add(property);
        String attribute2Name = "businessImplementationType";
        String attribute2Description = "Type of implemented or deployed business capability.";
        String attribute2DescriptionGUID = null;
        property = this.archiveHelper.getEnumTypeDefAttribute("BusinessCapabilityType", "businessImplementationType", "Type of implemented or deployed business capability.", attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateEnterpriseAccessLayerEntity() {
        String typeName = "EnterpriseAccessLayer";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("EnterpriseAccessLayer");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "metadataCollectionId";
        String attribute1Description = "Deprecated attribute. Use the accessedMetadataCollectionId attribute to define the unique identifier for the metadata collection accessed through this enterprise access layer.";
        String attribute1DescriptionGUID = null;
        String attribute1ReplacedBy = "accessedMetadataCollectionId";
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("metadataCollectionId", "Deprecated attribute. Use the accessedMetadataCollectionId attribute to define the unique identifier for the metadata collection accessed through this enterprise access layer.", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("accessedMetadataCollectionId");
        properties.add(property);
        String attribute2Name = "accessedMetadataCollectionId";
        String attribute2Description = "Unique identifier for the metadata collection accessed through this enterprise access layer.";
        String attribute2DescriptionGUID = null;
        property = this.archiveHelper.getStringTypeDefAttribute("accessedMetadataCollectionId", "Unique identifier for the metadata collection accessed through this enterprise access layer.", attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateMetadataCollectionEntity() {
        String typeName = "MetadataCollection";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("MetadataCollection");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "metadataCollectionId";
        String attribute1Description = "Deprecated attribute. Use the managedMetadataCollectionId attribute to define the unique identifier for the metadata collection managed in the local repository.";
        String attribute1DescriptionGUID = null;
        String attribute1ReplacedBy = "managedMetadataCollectionId";
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("metadataCollectionId", "Deprecated attribute. Use the managedMetadataCollectionId attribute to define the unique identifier for the metadata collection managed in the local repository.", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("managedMetadataCollectionId");
        properties.add(property);
        String attribute2Name = "managedMetadataCollectionId";
        String attribute2Description = "Unique identifier for the metadata collection managed in the local repository.";
        String attribute2DescriptionGUID = null;
        property = this.archiveHelper.getStringTypeDefAttribute("managedMetadataCollectionId", "Unique identifier for the metadata collection managed in the local repository.", attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateExternalReferenceEntity() {
        String typeName = "ExternalReference";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ExternalReference");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "version";
        String attribute1Description = "Deprecated attribute. Use the referenceVersion attribute to define the version number of the external reference.";
        String attribute1DescriptionGUID = null;
        String attribute1ReplacedBy = "referenceVersion";
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("version", "Deprecated attribute. Use the referenceVersion attribute to define the version number of the external reference.", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("referenceVersion");
        properties.add(property);
        String attribute2Name = "referenceVersion";
        String attribute2Description = "Version number of the external reference.";
        String attribute2DescriptionGUID = null;
        property = this.archiveHelper.getStringTypeDefAttribute("referenceVersion", "Version number of the external reference.", attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updatePropertyFacetEntity() {
        String typeName = "PropertyFacet";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("PropertyFacet");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "version";
        String attribute1Description = "Deprecated attribute. Use the schemaVersion attribute to define the version number of the property facet schema.";
        String attribute1DescriptionGUID = null;
        String attribute1ReplacedBy = "schemaVersion";
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("version", "Deprecated attribute. Use the schemaVersion attribute to define the version number of the property facet schema.", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("schemaVersion");
        properties.add(property);
        String attribute2Name = "schemaVersion";
        String attribute2Description = "Version of the property facet schema.";
        String attribute2DescriptionGUID = null;
        property = this.archiveHelper.getStringTypeDefAttribute("schemaVersion", "Version of the property facet schema.", attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateCohortMemberEntity() {
        String typeName = "CohortMember";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("CohortMember");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute2Name = "protocolVersion";
        String attribute2Description = "Version number of the protocol supported by the cohort registry.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("protocolVersion", "Version number of the protocol supported by the cohort registry.", attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateImplementationSnippetEntity() {
        String typeName = "ImplementationSnippet";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ImplementationSnippet");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "version";
        String attribute1Description = "Deprecated attribute. Use the snippetVersion attribute to define the version number of the snippet.";
        String attribute1DescriptionGUID = null;
        String attribute1ReplacedBy = "snippetVersion";
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("version", "Deprecated attribute. Use the snippetVersion attribute to define the version number of the snippet.", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("snippetVersion");
        properties.add(property);
        String attribute2Name = "snippetVersion";
        String attribute2Description = "Version number of the snippet.";
        String attribute2DescriptionGUID = null;
        property = this.archiveHelper.getStringTypeDefAttribute("snippetVersion", "Version number of the snippet.", attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updatePolicyAdministrationPointClassification() {
        String typeName = "PolicyAdministrationPoint";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("PolicyAdministrationPoint");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "type";
        String attribute1Description = "Deprecated attribute. Use the pointType attribute to describe type information about the policy administration point.";
        String attribute1DescriptionGUID = null;
        String attribute1ReplacedBy = "pointType";
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("type", "Deprecated attribute. Use the pointType attribute to describe type information about the policy administration point.", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("pointType");
        properties.add(property);
        String attribute2Name = "pointType";
        String attribute2Description = "Descriptive type information about the policy administration point.";
        String attribute2DescriptionGUID = null;
        property = this.archiveHelper.getStringTypeDefAttribute("pointType", "Descriptive type information about the policy administration point.", attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updatePolicyDecisionPointClassification() {
        String typeName = "PolicyDecisionPoint";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("PolicyDecisionPoint");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "type";
        String attribute1Description = "Deprecated attribute. Use the pointType attribute to describe type information about the policy decision point.";
        String attribute1DescriptionGUID = null;
        String attribute1ReplacedBy = "pointType";
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("type", "Deprecated attribute. Use the pointType attribute to describe type information about the policy decision point.", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("pointType");
        properties.add(property);
        String attribute2Name = "pointType";
        String attribute2Description = "Descriptive type information about the policy decision point.";
        String attribute2DescriptionGUID = null;
        property = this.archiveHelper.getStringTypeDefAttribute("pointType", "Descriptive type information about the policy decision point.", attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updatePolicyEnforcementPointClassification() {
        String typeName = "PolicyEnforcementPoint";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("PolicyEnforcementPoint");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "type";
        String attribute1Description = "Deprecated attribute. Use the pointType attribute to describe type information about the policy enforcement point.";
        String attribute1DescriptionGUID = null;
        String attribute1ReplacedBy = "pointType";
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("type", "Deprecated attribute. Use the pointType attribute to describe type information about the policy enforcement point.", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("pointType");
        properties.add(property);
        String attribute2Name = "pointType";
        String attribute2Description = "Descriptive type information about the policy enforcement point.";
        String attribute2DescriptionGUID = null;
        property = this.archiveHelper.getStringTypeDefAttribute("pointType", "Descriptive type information about the policy enforcement point.", attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updatePolicyInformationPointClassification() {
        String typeName = "PolicyInformationPoint";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("PolicyInformationPoint");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "type";
        String attribute1Description = "Deprecated attribute. Use the pointType attribute to describe type information about the policy information point.";
        String attribute1DescriptionGUID = null;
        String attribute1ReplacedBy = "pointType";
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("type", "Deprecated attribute. Use the pointType attribute to describe type information about the policy information point.", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("pointType");
        properties.add(property);
        String attribute2Name = "pointType";
        String attribute2Description = "Descriptive type information about the policy information point.";
        String attribute2DescriptionGUID = null;
        property = this.archiveHelper.getStringTypeDefAttribute("pointType", "Descriptive type information about the policy information point.", attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updatePolicyRetrievalPointClassification() {
        String typeName = "PolicyRetrievalPoint";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("PolicyRetrievalPoint");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "type";
        String attribute1Description = "Deprecated attribute. Use the pointType attribute to describe type information about the policy retrieval point.";
        String attribute1DescriptionGUID = null;
        String attribute1ReplacedBy = "pointType";
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("type", "Deprecated attribute. Use the pointType attribute to describe type information about the policy retrieval point.", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("pointType");
        properties.add(property);
        String attribute2Name = "pointType";
        String attribute2Description = "Descriptive type information about the policy retrieval point.";
        String attribute2DescriptionGUID = null;
        property = this.archiveHelper.getStringTypeDefAttribute("pointType", "Descriptive type information about the policy retrieval point.", attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }
}

