/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive2_11;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefStatus;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive3_1 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "3.1";
    private static final String originatorName = "Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive3_1() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive3_1(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive2_11 previousTypes = new OpenMetadataTypesArchive2_11(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.update0030HostsAndOperatingPlatforms();
        this.update0035ComplexHosts();
        this.update0036Storage();
        this.update0040SoftwareServers();
        this.update0045ServersAndAssets();
        this.update0050ApplicationsAndProcesses();
        this.update0057SoftwareServices();
        this.update0201Connections();
        this.update0223Events();
        this.add0485DataProcessingPurposes();
        this.update0507ObsoleteDefinitions();
    }

    private void update0030HostsAndOperatingPlatforms() {
        this.archiveBuilder.addTypeDefPatch(this.updateOperatingPlatformEntity());
        this.archiveBuilder.addClassificationDef(this.addSoftwarePackageManifestClassification());
        this.archiveBuilder.addRelationshipDef(this.addOperatingPlatformManifestRelationship());
    }

    private TypeDefPatch updateOperatingPlatformEntity() {
        String typeName = "OperatingPlatform";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("OperatingPlatform");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "operatingSystemPatchLevel";
        String attribute1Description = "Level of patches applied to the operating system.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("operatingSystemPatchLevel", "Level of patches applied to the operating system.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private ClassificationDef addSoftwarePackageManifestClassification() {
        String guid = "e328ae6e-0b16-4490-9883-c953b4258841";
        String name = "SoftwarePackageManifest";
        String description = "Identifies a collection of software packages.";
        String descriptionGUID = null;
        ArrayList<TypeDefLink> linkedToEntities = new ArrayList<TypeDefLink>();
        linkedToEntities.add(this.archiveBuilder.getEntityDef("Collection"));
        return this.archiveHelper.getClassificationDef("e328ae6e-0b16-4490-9883-c953b4258841", "SoftwarePackageManifest", null, "Identifies a collection of software packages.", descriptionGUID, linkedToEntities, false);
    }

    private RelationshipDef addOperatingPlatformManifestRelationship() {
        String guid = "e5bd6acf-932c-4d9c-85ff-941a8e4451db";
        String name = "OperatingPlatformManifest";
        String description = "Defines the base software installed on the operating platform.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("e5bd6acf-932c-4d9c-85ff-941a8e4451db", "OperatingPlatformManifest", null, "Defines the base software installed on the operating platform.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "OperatingPlatform";
        String end1AttributeName = "packagedInOperatingPlatforms";
        String end1AttributeDescription = "The operating platforms that use this collection of software packages.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("OperatingPlatform"), "packagedInOperatingPlatforms", "The operating platforms that use this collection of software packages.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "Collection";
        String end2AttributeName = "includesSoftwarePackages";
        String end2AttributeDescription = "The collection of software packages that are included in the operating platform.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Collection"), "includesSoftwarePackages", "The collection of software packages that are included in the operating platform.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void update0035ComplexHosts() {
        this.archiveBuilder.addEntityDef(this.addBareMetalComputerEntity());
        this.archiveBuilder.addEntityDef(this.addVirtualMachineEntity());
        this.archiveBuilder.addEntityDef(this.addDockerContainerEntity());
        this.archiveBuilder.addEntityDef(this.addHadoopClusterEntity());
        this.archiveBuilder.addEntityDef(this.addKubernetesClusterEntity());
        this.archiveBuilder.addTypeDefPatch(this.deprecateDeployedVirtualContainer());
    }

    private EntityDef addBareMetalComputerEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.BARE_METAL_COMPUTER.typeGUID, OpenMetadataType.BARE_METAL_COMPUTER.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.HOST.typeName), OpenMetadataType.BARE_METAL_COMPUTER.description, OpenMetadataType.BARE_METAL_COMPUTER.descriptionGUID, OpenMetadataType.BARE_METAL_COMPUTER.wikiURL);
    }

    private EntityDef addVirtualMachineEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.VIRTUAL_MACHINE.typeGUID, OpenMetadataType.VIRTUAL_MACHINE.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.HOST.typeName), OpenMetadataType.VIRTUAL_MACHINE.description, OpenMetadataType.VIRTUAL_MACHINE.descriptionGUID, OpenMetadataType.VIRTUAL_MACHINE.wikiURL);
    }

    private EntityDef addDockerContainerEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DOCKER_CONTAINER.typeGUID, OpenMetadataType.DOCKER_CONTAINER.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.VIRTUAL_CONTAINER.typeName), OpenMetadataType.DOCKER_CONTAINER.description, OpenMetadataType.DOCKER_CONTAINER.descriptionGUID, OpenMetadataType.DOCKER_CONTAINER.wikiURL);
    }

    private EntityDef addHadoopClusterEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.HADOOP_CLUSTER.typeGUID, OpenMetadataType.HADOOP_CLUSTER.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.HOST_CLUSTER.typeName), OpenMetadataType.HADOOP_CLUSTER.description, OpenMetadataType.HADOOP_CLUSTER.descriptionGUID, OpenMetadataType.HADOOP_CLUSTER.wikiURL);
    }

    private EntityDef addKubernetesClusterEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.KUBERNETES_CLUSTER.typeGUID, OpenMetadataType.KUBERNETES_CLUSTER.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.HOST_CLUSTER.typeName), OpenMetadataType.KUBERNETES_CLUSTER.description, OpenMetadataType.KUBERNETES_CLUSTER.descriptionGUID, OpenMetadataType.KUBERNETES_CLUSTER.wikiURL);
    }

    private TypeDefPatch deprecateDeployedVirtualContainer() {
        String typeName = "DeployedVirtualContainer";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("DeployedVirtualContainer");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private void update0036Storage() {
        this.archiveBuilder.addEntityDef(this.addStorageVolumeEntity());
        this.archiveBuilder.addRelationshipDef(this.addAttachedStorageRelationship());
    }

    private EntityDef addStorageVolumeEntity() {
        String guid = "14145458-f0d0-4955-8899-b8a2874708c9";
        String name = "StorageVolume";
        String description = "A persistent storage volume.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        return this.archiveHelper.getDefaultEntityDef("14145458-f0d0-4955-8899-b8a2874708c9", "StorageVolume", this.archiveBuilder.getEntityDef(superTypeName), "A persistent storage volume.", descriptionGUID);
    }

    private RelationshipDef addAttachedStorageRelationship() {
        String guid = "2cf1e949-7189-4bf2-8ee4-e1318e59abd7";
        String name = "AttachedStorage";
        String description = "Links a host to a persistent storage volume.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("2cf1e949-7189-4bf2-8ee4-e1318e59abd7", "AttachedStorage", null, "Links a host to a persistent storage volume.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "Host";
        String end1AttributeName = "hosts";
        String end1AttributeDescription = "The hosts that are accessing the storage.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Host"), "hosts", "The hosts that are accessing the storage.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "StorageVolume";
        String end2AttributeName = "storageVolumes";
        String end2AttributeDescription = "The storage available to a host.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("StorageVolume"), "storageVolumes", "The storage available to a host.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void update0045ServersAndAssets() {
        this.archiveBuilder.addTypeDefPatch(this.updateServerAssetUseRelationship());
    }

    private TypeDefPatch updateServerAssetUseRelationship() {
        String typeName = OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.MINIMUM_INSTANCES.name;
        String attribute1Description = OpenMetadataProperty.MINIMUM_INSTANCES.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.MINIMUM_INSTANCES.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.MAXIMUM_INSTANCES.name;
        String attribute2Description = OpenMetadataProperty.MAXIMUM_INSTANCES.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.MAXIMUM_INSTANCES.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0040SoftwareServers() {
        this.archiveBuilder.addTypeDefPatch(this.updateServerEndpointRelationship());
    }

    private TypeDefPatch updateServerEndpointRelationship() {
        String typeName = "ServerEndpoint";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ServerEndpoint");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end1EntityType = "ITInfrastructure";
        String end1AttributeName = "servers";
        String end1AttributeDescription = "Server supporting this endpoint.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("ITInfrastructure"), "servers", "Server supporting this endpoint.", end1AttributeDescriptionGUID, end1Cardinality);
        typeDefPatch.setEndDef2(relationshipEndDef);
        return typeDefPatch;
    }

    private void update0057SoftwareServices() {
        this.archiveBuilder.addEntityDef(this.addApplicationServiceEntity());
    }

    private EntityDef addApplicationServiceEntity() {
        String guid = "5b7f340e-7dc9-45c0-a636-c20605147c94";
        String name = "ApplicationService";
        String description = "A software service supporting a single reusable business function.";
        String descriptionGUID = null;
        String superTypeName = "SoftwareService";
        return this.archiveHelper.getDefaultEntityDef("5b7f340e-7dc9-45c0-a636-c20605147c94", "ApplicationService", this.archiveBuilder.getEntityDef("SoftwareService"), "A software service supporting a single reusable business function.", descriptionGUID);
    }

    private void update0050ApplicationsAndProcesses() {
        this.archiveBuilder.addEntityDef(this.addCatalogEntity());
        this.archiveBuilder.addEntityDef(this.addDataManagerEntity());
    }

    private EntityDef addCatalogEntity() {
        String guid = OpenMetadataType.CATALOG.typeGUID;
        String name = OpenMetadataType.CATALOG.typeName;
        String description = OpenMetadataType.CATALOG.description;
        String descriptionGUID = OpenMetadataType.CATALOG.descriptionGUID;
        String descriptionWiki = OpenMetadataType.CATALOG.wikiURL;
        String superTypeName = OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeName;
        return this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
    }

    private EntityDef addDataManagerEntity() {
        String guid = OpenMetadataType.DATA_MANAGER.typeGUID;
        String name = OpenMetadataType.DATA_MANAGER.typeName;
        String description = OpenMetadataType.DATA_MANAGER.description;
        String descriptionGUID = OpenMetadataType.DATA_MANAGER.descriptionGUID;
        String descriptionWiki = OpenMetadataType.DATA_MANAGER.wikiURL;
        String superTypeName = OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeName;
        return this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
    }

    private void update0201Connections() {
        this.archiveBuilder.addClassificationDef(this.addConnectorTypeDirectoryClassification());
        this.archiveBuilder.addEntityDef(this.addConnectorCategoryEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateConnectorTypeEntity());
        this.archiveBuilder.addRelationshipDef(this.addConnectorImplementationChoiceRelationship());
    }

    private ClassificationDef addConnectorTypeDirectoryClassification() {
        String guid = "9678ef11-ed7e-404b-a041-736df7514339";
        String name = "ConnectorTypeDirectory";
        String description = "Identifies a collection of related connector types.";
        String descriptionGUID = null;
        ArrayList<TypeDefLink> linkedToEntities = new ArrayList<TypeDefLink>();
        linkedToEntities.add(this.archiveBuilder.getEntityDef("Collection"));
        return this.archiveHelper.getClassificationDef("9678ef11-ed7e-404b-a041-736df7514339", "ConnectorTypeDirectory", null, "Identifies a collection of related connector types.", descriptionGUID, linkedToEntities, false);
    }

    private EntityDef addConnectorCategoryEntity() {
        String guid = "fb60761f-7afd-4d3d-9efa-24bc85a7b22e";
        String name = "ConnectorCategory";
        String description = "A detailed description of the effect of some data processing.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("fb60761f-7afd-4d3d-9efa-24bc85a7b22e", "ConnectorCategory", this.archiveBuilder.getEntityDef(superTypeName), "A detailed description of the effect of some data processing.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DISPLAY_NAME.name;
        String attribute1Description = OpenMetadataProperty.DISPLAY_NAME.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DISPLAY_NAME.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute2Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        String attribute3Name = "targetTechnologySource";
        String attribute3Description = "Name of the organization providing the technology that the connectors access. For example, Apache Software Foundation";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "targetTechnologyName";
        String attribute4Description = "Name of the technology that the connectors access. For example, Apache Kafka.";
        String attribute4DescriptionGUID = null;
        String attribute7Name = "recognizedAdditionalProperties";
        String attribute7Description = "List of additional connection property names supported by the connector implementations.";
        String attribute7DescriptionGUID = null;
        String attribute8Name = "recognizedSecuredProperties";
        String attribute8Description = "List of secured connection property names supported by the connector implementations.";
        String attribute8DescriptionGUID = null;
        String attribute9Name = "recognizedConfigurationProperties";
        String attribute9Description = "List of secured connection property names supported by the connector implementations.";
        String attribute9DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("targetTechnologySource", "Name of the organization providing the technology that the connectors access. For example, Apache Software Foundation", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("targetTechnologyName", "Name of the technology that the connectors access. For example, Apache Kafka.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringBooleanTypeDefAttribute("recognizedAdditionalProperties", "List of additional connection property names supported by the connector implementations.", attribute7DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringBooleanTypeDefAttribute("recognizedSecuredProperties", "List of secured connection property names supported by the connector implementations.", attribute8DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringBooleanTypeDefAttribute("recognizedConfigurationProperties", "List of secured connection property names supported by the connector implementations.", attribute9DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private TypeDefPatch updateConnectorTypeEntity() {
        String typeName = "ConnectorType";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ConnectorType");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "supportedAssetTypeName";
        String attribute1Description = "Type of asset supported by the connector implementation.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "expectedDataFormat";
        String attribute2Description = "Description of the format of the data expected by the connector implementation.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "connectorFrameworkName";
        String attribute3Description = "Name of the framework that the connector implements. The default is 'Open Connector Framework (OCF)'";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "connectorInterfaceLanguage";
        String attribute4Description = "The programming language used to implement the connector's interface.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "connectorInterfaces";
        String attribute5Description = "List of interfaces supported by the connector.";
        String attribute5DescriptionGUID = null;
        String attribute6Name = "targetTechnologySource";
        String attribute6Description = "Name of the organization providing the technology that the connectors access. For example, Apache Software Foundation";
        String attribute6DescriptionGUID = null;
        String attribute7Name = "targetTechnologyName";
        String attribute7Description = "Name of the technology that the connectors access. For example, Apache Kafka.";
        String attribute7DescriptionGUID = null;
        String attribute8Name = "targetTechnologyInterfaces";
        String attribute8Description = "Names of the technology's interfaces that the connectors use.";
        String attribute8DescriptionGUID = null;
        String attribute9Name = "targetTechnologyVersions";
        String attribute9Description = "List of versions of the technology that the connector implementation supports.";
        String attribute9DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("supportedAssetTypeName", "Type of asset supported by the connector implementation.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("expectedDataFormat", "Description of the format of the data expected by the connector implementation.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("connectorFrameworkName", "Name of the framework that the connector implements. The default is 'Open Connector Framework (OCF)'", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("connectorInterfaceLanguage", "The programming language used to implement the connector's interface.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute("connectorInterfaces", "List of interfaces supported by the connector.", attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("targetTechnologySource", "Name of the organization providing the technology that the connectors access. For example, Apache Software Foundation", attribute6DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("targetTechnologyName", "Name of the technology that the connectors access. For example, Apache Kafka.", attribute7DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute("targetTechnologyInterfaces", "Names of the technology's interfaces that the connectors use.", attribute8DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute("targetTechnologyVersions", "List of versions of the technology that the connector implementation supports.", attribute9DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private RelationshipDef addConnectorImplementationChoiceRelationship() {
        String guid = "633648f3-c951-4ad7-b975-9fc04e0f3d2e";
        String name = "ConnectorImplementationChoice";
        String description = "Relates a connector category for a specific type of technology with the connector types that support it.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("633648f3-c951-4ad7-b975-9fc04e0f3d2e", "ConnectorImplementationChoice", null, "Relates a connector category for a specific type of technology with the connector types that support it.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "ConnectorCategory";
        String end1AttributeName = "connectorCategories";
        String end1AttributeDescription = "The categories that a connector type belongs to.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("ConnectorCategory"), "connectorCategories", "The categories that a connector type belongs to.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "ConnectorType";
        String end2AttributeName = "connectorTypes";
        String end2AttributeDescription = "The connector types that support the technology described in the connector category.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("ConnectorType"), "connectorTypes", "The connector types that support the technology described in the connector category.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void update0223Events() {
        this.archiveBuilder.addEntityDef(this.addKafkaTopicEntity());
    }

    private EntityDef addKafkaTopicEntity() {
        String guid = OpenMetadataType.KAFKA_TOPIC.typeGUID;
        String name = OpenMetadataType.KAFKA_TOPIC.typeName;
        String description = OpenMetadataType.KAFKA_TOPIC.description;
        String descriptionGUID = OpenMetadataType.KAFKA_TOPIC.descriptionGUID;
        String descriptionWiki = OpenMetadataType.KAFKA_TOPIC.wikiURL;
        String superTypeName = OpenMetadataType.TOPIC.typeName;
        return this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
    }

    private void add0485DataProcessingPurposes() {
        this.archiveBuilder.addEntityDef(this.getDataProcessingDescriptionEntity());
        this.archiveBuilder.addEntityDef(this.getDataProcessingPurposeEntity());
        this.archiveBuilder.addEntityDef(this.getDataProcessingActionEntity());
        this.archiveBuilder.addRelationshipDef(this.getPermittedProcessingRelationship());
        this.archiveBuilder.addRelationshipDef(this.getApprovedPurposeRelationship());
        this.archiveBuilder.addRelationshipDef(this.getDetailedProcessingActionsRelationship());
        this.archiveBuilder.addRelationshipDef(this.getDataProcessingSpecificationRelationship());
        this.archiveBuilder.addRelationshipDef(this.getDataProcessingTargetRelationship());
    }

    private EntityDef getDataProcessingDescriptionEntity() {
        String guid = "685f91fb-c74b-437b-a9b6-c5e557c6d3b2";
        String name = "DataProcessingDescription";
        String description = "A detailed description of the effect of some data processing.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("685f91fb-c74b-437b-a9b6-c5e557c6d3b2", "DataProcessingDescription", this.archiveBuilder.getEntityDef(superTypeName), "A detailed description of the effect of some data processing.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DISPLAY_NAME.name;
        String attribute1Description = OpenMetadataProperty.DISPLAY_NAME.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DISPLAY_NAME.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute2Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getDataProcessingPurposeEntity() {
        String guid = "9062df4c-9f4a-4012-a67a-968d7a3f4bcf";
        String name = "DataProcessingPurpose";
        String description = "Expected outcome, service or value from processing.";
        String descriptionGUID = null;
        String superTypeName = "GovernanceDefinition";
        return this.archiveHelper.getDefaultEntityDef("9062df4c-9f4a-4012-a67a-968d7a3f4bcf", "DataProcessingPurpose", this.archiveBuilder.getEntityDef("GovernanceDefinition"), "Expected outcome, service or value from processing.", descriptionGUID);
    }

    private EntityDef getDataProcessingActionEntity() {
        String guid = "7f53928f-9148-4710-ad37-47633f33cb08";
        String name = "DataProcessingAction";
        String description = "Description of the processing on a single target item.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("7f53928f-9148-4710-ad37-47633f33cb08", "DataProcessingAction", this.archiveBuilder.getEntityDef(superTypeName), "Description of the processing on a single target item.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DISPLAY_NAME.name;
        String attribute1Description = OpenMetadataProperty.DISPLAY_NAME.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DISPLAY_NAME.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute2Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getPermittedProcessingRelationship() {
        String guid = "b472a2ec-f419-4d3f-86fb-e9d97365f961";
        String name = "PermittedProcessing";
        String description = "Relationship relates data processing descriptions with purposes (outcomes).";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("b472a2ec-f419-4d3f-86fb-e9d97365f961", "PermittedProcessing", null, "Relationship relates data processing descriptions with purposes (outcomes).", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "DataProcessingPurpose";
        String end1AttributeName = "supportedPurposes";
        String end1AttributeDescription = "The supported outcomes from the processing.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("DataProcessingPurpose"), "supportedPurposes", "The supported outcomes from the processing.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "DataProcessingDescription";
        String end2AttributeName = "permittedProcessing";
        String end2AttributeDescription = "The description of the processing that is permitted for the purposes.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("DataProcessingDescription"), "permittedProcessing", "The description of the processing that is permitted for the purposes.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getApprovedPurposeRelationship() {
        String guid = "33ec3aaa-dfb6-4f58-8d5d-c42d077be1b3";
        String name = "ApprovedPurpose";
        String description = "Relationship identifying the proposes that processes/people have permission to process data for.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("33ec3aaa-dfb6-4f58-8d5d-c42d077be1b3", "ApprovedPurpose", null, "Relationship identifying the proposes that processes/people have permission to process data for.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end1AttributeName = "approvedForPurposes";
        String end1AttributeDescription = "The people/processes that have permission to process data.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "approvedForPurposes", "The people/processes that have permission to process data.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "DataProcessingPurpose";
        String end2AttributeName = "approvedPurposes";
        String end2AttributeDescription = "The purposes (outcomes) that the people/processes have permission for.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("DataProcessingPurpose"), "approvedPurposes", "The purposes (outcomes) that the people/processes have permission for.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getDetailedProcessingActionsRelationship() {
        String guid = "0ac0e793-6727-45d2-9403-06bd19d9ce2e";
        String name = "DetailedProcessingActions";
        String description = "Relationship identifying the individual actions in a data processing description.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("0ac0e793-6727-45d2-9403-06bd19d9ce2e", "DetailedProcessingActions", null, "Relationship identifying the individual actions in a data processing description.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "DataProcessingDescription";
        String end1AttributeName = "parentProcessingDescriptions";
        String end1AttributeDescription = "The aggregating processing descriptions.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("DataProcessingDescription"), "parentProcessingDescriptions", "The aggregating processing descriptions.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "DataProcessingAction";
        String end2AttributeName = "dataProcessingActions";
        String end2AttributeDescription = "The individual actions that make up the data processing description.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("DataProcessingAction"), "dataProcessingActions", "The individual actions that make up the data processing description.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getDataProcessingSpecificationRelationship() {
        String guid = "1dfdec0f-f206-4db7-bac8-ec344205fb3c";
        String name = "DataProcessingSpecification";
        String description = "Relationship identifying the processing being performed by processes or people.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("1dfdec0f-f206-4db7-bac8-ec344205fb3c", "DataProcessingSpecification", null, "Relationship identifying the processing being performed by processes or people.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end1AttributeName = "dataProcessingElements";
        String end1AttributeDescription = "The people/processes performing the processing.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "dataProcessingElements", "The people/processes performing the processing.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "DataProcessingDescription";
        String end2AttributeName = "dataProcessingDescriptions";
        String end2AttributeDescription = "The description of the processing.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("DataProcessingDescription"), "dataProcessingDescriptions", "The description of the processing.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getDataProcessingTargetRelationship() {
        String guid = "6ad18aa4-f5fc-47e7-99e1-80acfc536c9a";
        String name = "DataProcessingTarget";
        String description = "Relationship identifying the actions being performed on data.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("6ad18aa4-f5fc-47e7-99e1-80acfc536c9a", "DataProcessingTarget", null, "Relationship identifying the actions being performed on data.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "DataProcessingAction";
        String end1AttributeName = "dataProcessingActions";
        String end1AttributeDescription = "Actions being performed on the data.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("DataProcessingAction"), "dataProcessingActions", "Actions being performed on the data.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end2AttributeName = "dataProcessingTarget";
        String end2AttributeDescription = "The data that is being acted upon.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "dataProcessingTarget", "The data that is being acted upon.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void update0507ObsoleteDefinitions() {
        this.archiveBuilder.addTypeDefPatch(this.deprecateBoundedSchemaType());
        this.archiveBuilder.addTypeDefPatch(this.deprecateBoundedSchemaElementType());
        this.archiveBuilder.addTypeDefPatch(this.deprecateArraySchemaType());
        this.archiveBuilder.addTypeDefPatch(this.deprecateArrayDocumentType());
        this.archiveBuilder.addTypeDefPatch(this.deprecateSetSchemaType());
        this.archiveBuilder.addTypeDefPatch(this.deprecateSetDocumentType());
    }

    private TypeDefPatch deprecateBoundedSchemaType() {
        String typeName = "BoundedSchemaType";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("BoundedSchemaType");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private TypeDefPatch deprecateBoundedSchemaElementType() {
        String typeName = "BoundedSchemaElementType";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("BoundedSchemaElementType");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private TypeDefPatch deprecateArraySchemaType() {
        String typeName = "ArraySchemaType";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ArraySchemaType");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private TypeDefPatch deprecateArrayDocumentType() {
        String typeName = "ArrayDocumentType";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ArrayDocumentType");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private TypeDefPatch deprecateSetSchemaType() {
        String typeName = "SetSchemaType";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("SetSchemaType");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private TypeDefPatch deprecateSetDocumentType() {
        String typeName = "SetDocumentType";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("SetDocumentType");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }
}

