/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.archiveutilities;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRSArchiveGUIDMap {
    private static final Logger log = LoggerFactory.getLogger(OMRSArchiveGUIDMap.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final ObjectWriter OBJECT_WRITER = OBJECT_MAPPER.writer();
    private static final ObjectReader OBJECT_READER = OBJECT_MAPPER.reader();
    private final String guidMapFileName;
    private Map<String, String> idToGUIDMap;
    private Map<String, String> usedIdToGUIDMap = new HashMap<String, String>();

    public OMRSArchiveGUIDMap(String guidMapFileName) {
        this.guidMapFileName = guidMapFileName;
        this.loadGUIDs();
    }

    private void loadGUIDs() {
        File idFile = new File(this.guidMapFileName);
        try {
            log.debug("Retrieving Id to GUID Map");
            String idFileContents = FileUtils.readFileToString(idFile, "UTF-8");
            this.idToGUIDMap = OBJECT_READER.readValue(idFileContents, Map.class);
        }
        catch (Exception error) {
            this.idToGUIDMap = new HashMap<String, String>();
        }
        log.debug("Id to GUID Map contains: " + this.idToGUIDMap);
    }

    public void setGUID(String id, String guid) {
        this.idToGUIDMap.put(id, guid);
        this.usedIdToGUIDMap.put(id, guid);
    }

    public String getGUID(String id) {
        String guid = this.idToGUIDMap.get(id);
        if (guid == null) {
            guid = UUID.randomUUID().toString();
        }
        this.setGUID(id, guid);
        return guid;
    }

    public String queryGUID(String id) {
        String guid = this.idToGUIDMap.get(id);
        if (guid != null) {
            this.usedIdToGUIDMap.put(id, guid);
        }
        return guid;
    }

    public void saveGUIDs() {
        System.out.println("Writing to Id File: " + this.guidMapFileName);
        File idFile = new File(this.guidMapFileName);
        try {
            if (this.idToGUIDMap.isEmpty()) {
                log.debug("Deleting id file because map is empty: " + this.guidMapFileName);
                idFile.delete();
            } else {
                log.debug("Writing id file " + this.guidMapFileName);
                String mapContents = OBJECT_WRITER.writeValueAsString(this.idToGUIDMap);
                FileUtils.writeStringToFile(idFile, mapContents, (String)null, false);
            }
        }
        catch (Exception exc) {
            log.error("Unusable Map Store :(", exc);
        }
    }

    public void saveUsedGUIDs() {
        System.out.println("Writing to Id File: " + this.guidMapFileName);
        File idFile = new File(this.guidMapFileName);
        try {
            if (this.usedIdToGUIDMap.isEmpty()) {
                log.debug("Deleting id file because map is empty: " + this.guidMapFileName);
                idFile.delete();
            } else {
                log.debug("Writing id file " + this.guidMapFileName);
                String mapContents = OBJECT_WRITER.writeValueAsString(this.usedIdToGUIDMap);
                FileUtils.writeStringToFile(idFile, mapContents, (String)null, false);
            }
        }
        catch (Exception exc) {
            log.error("Unusable Map Store :(", exc);
        }
    }

    public int getSize() {
        if (this.idToGUIDMap == null) {
            return 0;
        }
        return this.idToGUIDMap.size();
    }

    public int getUsedSize() {
        if (this.usedIdToGUIDMap == null) {
            return 0;
        }
        return this.usedIdToGUIDMap.size();
    }
}

