/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.rest.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import java.util.Objects;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.HistorySequencingOrder;
import org.odpi.openmetadata.repositoryservices.rest.properties.OMRSAPIRequest;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class HistoryRangeRequest
extends OMRSAPIRequest {
    private static final long serialVersionUID = 1L;
    private Date fromTime = null;
    private Date toTime = null;
    private int offset = 0;
    private int pageSize = 0;
    private HistorySequencingOrder sequencingOrder = HistorySequencingOrder.BACKWARDS;

    public HistoryRangeRequest() {
    }

    public HistoryRangeRequest(HistoryRangeRequest template) {
        super(template);
        if (template != null) {
            this.fromTime = template.getFromTime();
            this.toTime = template.getToTime();
            this.offset = template.getOffset();
            this.pageSize = template.getPageSize();
            this.sequencingOrder = template.getSequencingOrder();
        }
    }

    public Date getFromTime() {
        return this.fromTime;
    }

    public void setFromTime(Date fromTime) {
        this.fromTime = fromTime;
    }

    public Date getToTime() {
        return this.toTime;
    }

    public void setToTime(Date toTime) {
        this.toTime = toTime;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public HistorySequencingOrder getSequencingOrder() {
        return this.sequencingOrder;
    }

    public void setSequencingOrder(HistorySequencingOrder sequencingOrder) {
        this.sequencingOrder = sequencingOrder;
    }

    public String toString() {
        return "HistoryRangeRequest{fromTime=" + this.fromTime + ", toTime=" + this.toTime + ", offset=" + this.offset + ", pageSize=" + this.pageSize + ", sequencingOrder=" + this.sequencingOrder + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof HistoryRangeRequest)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        HistoryRangeRequest that = (HistoryRangeRequest)objectToCompare;
        return this.getOffset() == that.getOffset() && this.getPageSize() == that.getPageSize() && Objects.equals(this.getFromTime(), that.getFromTime()) && Objects.equals(this.getToTime(), that.getToTime()) && this.getSequencingOrder() == that.getSequencingOrder();
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getFromTime(), this.getToTime(), this.getOffset(), this.getPageSize(), this.getSequencingOrder());
    }
}

