/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementBase;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class InformalTag
extends ElementBase {
    protected boolean isPublic = false;
    protected boolean isPrivateTag = false;
    protected String name = null;
    protected String description = null;
    protected String user = null;

    public InformalTag() {
    }

    public InformalTag(InformalTag template) {
        super(template);
        if (template != null) {
            this.isPublic = template.getIsPublic();
            this.isPrivateTag = template.getIsPrivateTag();
            this.user = template.getUser();
            this.name = template.getName();
            this.description = template.getDescription();
        }
    }

    public boolean getIsPublic() {
        return this.isPublic;
    }

    public void setIsPublic(boolean aPublic) {
        this.isPublic = aPublic;
    }

    public boolean getIsPrivateTag() {
        return this.isPrivateTag;
    }

    public void setIsPrivateTag(boolean privateTag) {
        this.isPrivateTag = privateTag;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String tagDescription) {
        this.description = tagDescription;
    }

    @Override
    public String toString() {
        return "InformalTag{extendedProperties=" + this.getExtendedProperties() + ", status=" + this.getStatus() + ", type=" + this.getType() + ", origin=" + this.getOrigin() + ", versions=" + this.getVersions() + ", GUID='" + this.getGUID() + "', classifications=" + this.getClassifications() + ", isPublic=" + this.isPublic + ", isPrivateTag=" + this.isPrivateTag + ", name='" + this.name + "', description='" + this.description + "', user='" + this.user + "', headerVersion=" + this.getHeaderVersion() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        InformalTag that = (InformalTag)objectToCompare;
        return this.isPublic == that.isPublic && this.isPrivateTag == that.isPrivateTag && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getDescription(), that.getDescription()) && Objects.equals(this.getUser(), that.getUser());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.isPublic, this.isPrivateTag, this.getName(), this.getDescription(), this.getUser());
    }
}

