/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.integration.iterator;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.MetadataCorrelationHeader;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.integration.context.OpenMetadataAccess;
import org.odpi.openmetadata.frameworks.integration.iterator.MemberElement;
import org.odpi.openmetadata.frameworks.openmetadata.enums.PermittedSynchronization;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public abstract class IntegrationIterator {
    protected final PropertyHelper propertyHelper = new PropertyHelper();
    protected final String metadataCollectionGUID;
    protected final String metadataCollectionQualifiedName;
    protected final String catalogTargetName;
    protected final String connectorName;
    protected final String metadataTypeName;
    protected final OpenMetadataAccess openMetadataAccess;
    protected final PermittedSynchronization targetPermittedSynchronization;
    protected final int maxPageSize;
    protected final AuditLog auditLog;
    protected List<OpenMetadataElement> elementCache = null;
    protected int startFrom = 0;

    public IntegrationIterator(String metadataCollectionGUID, String metadataCollectionQualifiedName, String catalogTargetName, String connectorName, String metadataTypeName, OpenMetadataAccess openMetadataAccess, PermittedSynchronization targetPermittedSynchronization, int maxPageSize, AuditLog auditLog) {
        this.metadataCollectionGUID = metadataCollectionGUID;
        this.metadataCollectionQualifiedName = metadataCollectionQualifiedName;
        this.catalogTargetName = catalogTargetName;
        this.connectorName = connectorName;
        this.metadataTypeName = metadataTypeName;
        this.openMetadataAccess = openMetadataAccess;
        this.targetPermittedSynchronization = targetPermittedSynchronization;
        this.maxPageSize = maxPageSize;
        this.auditLog = auditLog;
    }

    protected abstract boolean fillCache() throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException;

    public boolean moreToReceive() throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.fillCache();
    }

    public MemberElement getNextMember() throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        OpenMetadataElement element = this.elementCache.remove(0);
        return this.fillOutMemberElement(element, true);
    }

    public MemberElement getMemberByQualifiedName(String qualifiedName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        OpenMetadataElement element = this.openMetadataAccess.getMetadataElementByUniqueName(qualifiedName, OpenMetadataProperty.QUALIFIED_NAME.name);
        if (element != null) {
            return this.fillOutMemberElement(element, true);
        }
        element = this.openMetadataAccess.getLineageElementByUniqueName(qualifiedName, OpenMetadataProperty.QUALIFIED_NAME.name);
        if (element != null) {
            return this.fillOutMemberElement(element, false);
        }
        element = this.openMetadataAccess.getDeletedElementByUniqueName(qualifiedName, OpenMetadataProperty.QUALIFIED_NAME.name);
        return this.fillOutMemberElement(element, false);
    }

    private MemberElement fillOutMemberElement(OpenMetadataElement element, boolean isElementActive) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "fillOutMemberElement";
        List<MetadataCorrelationHeader> correlationHeaders = null;
        RelatedMetadataElement rootSchemaType = null;
        Map<String, Map<String, String>> vendorProperties = null;
        if (isElementActive) {
            if (this.metadataCollectionGUID != null) {
                correlationHeaders = this.openMetadataAccess.getMetadataCorrelationHeaders(this.metadataCollectionGUID, this.metadataCollectionQualifiedName, element.getElementGUID(), element.getType().getTypeName());
            } else if (this.propertyHelper.isTypeOf(element, OpenMetadataType.SOFTWARE_CAPABILITY.typeName)) {
                correlationHeaders = this.openMetadataAccess.getMetadataCorrelationHeaders(element.getElementGUID(), this.propertyHelper.getStringProperty(element.getElementGUID(), OpenMetadataProperty.QUALIFIED_NAME.name, element.getElementProperties(), "fillOutMemberElement"), element.getElementGUID(), element.getType().getTypeName());
            }
            vendorProperties = this.openMetadataAccess.getVendorProperties(element.getElementGUID(), element.getType().getTypeName());
            rootSchemaType = this.openMetadataAccess.getRelatedMetadataElement(element.getElementGUID(), 1, "AssetSchemaType", new Date());
        }
        if (vendorProperties == null) {
            vendorProperties = new HashMap<String, Map<String, String>>();
        }
        return new MemberElement(element, rootSchemaType, correlationHeaders, vendorProperties, isElementActive, this.catalogTargetName, this.connectorName, this.targetPermittedSynchronization, this.auditLog);
    }
}

