/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.integration.iterator;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.governanceaction.properties.MetadataCorrelationHeader;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.integration.ffdc.OIFAuditCode;
import org.odpi.openmetadata.frameworks.integration.iterator.MemberAction;
import org.odpi.openmetadata.frameworks.openmetadata.enums.PermittedSynchronization;

public class MemberElement {
    private final OpenMetadataElement element;
    private final RelatedMetadataElement rootSchemaType;
    private final List<MetadataCorrelationHeader> externalIdentifiers;
    private final Map<String, Map<String, String>> vendorProperties;
    private final String catalogTargetName;
    private final String connectorName;
    private final boolean isElementActive;
    private final PermittedSynchronization targetPermittedSynchronization;
    private final AuditLog auditLog;
    private PermittedSynchronization instanceSyncDirection = null;

    MemberElement(OpenMetadataElement element, RelatedMetadataElement rootSchemaType, List<MetadataCorrelationHeader> externalIdentifiers, Map<String, Map<String, String>> vendorProperties, boolean isElementActive, String catalogTargetName, String connectorName, PermittedSynchronization targetPermittedSynchronization, AuditLog auditLog) {
        this.element = element;
        this.rootSchemaType = rootSchemaType;
        this.externalIdentifiers = externalIdentifiers;
        this.vendorProperties = vendorProperties;
        this.isElementActive = isElementActive;
        this.catalogTargetName = catalogTargetName;
        this.connectorName = connectorName;
        this.targetPermittedSynchronization = targetPermittedSynchronization;
        this.auditLog = auditLog;
        if (element == null) {
            this.instanceSyncDirection = PermittedSynchronization.FROM_THIRD_PARTY;
        }
        if (externalIdentifiers != null) {
            for (MetadataCorrelationHeader externalIdentifier : externalIdentifiers) {
                if (externalIdentifier == null || externalIdentifier.getSynchronizationDirection() == null) continue;
                this.instanceSyncDirection = externalIdentifier.getSynchronizationDirection();
            }
        }
        if (this.instanceSyncDirection == null) {
            this.instanceSyncDirection = targetPermittedSynchronization;
        }
    }

    public OpenMetadataElement getElement() {
        return this.element;
    }

    public RelatedMetadataElement getRootSchemaType() {
        return this.rootSchemaType;
    }

    public List<MetadataCorrelationHeader> getExternalIdentifiers() {
        return this.externalIdentifiers;
    }

    public Map<String, String> getVendorProperties(String vendorIdentifier) {
        return this.vendorProperties.get(vendorIdentifier);
    }

    public MemberAction getMemberAction(Date thirdPartyElementCreationTime, Date thirdPartyElementLastUpdateTime) {
        String methodName = "getMemberAction";
        if (this.element != null) {
            if (this.isElementActive) {
                if (thirdPartyElementCreationTime == null) {
                    if (this.externalIdentifiers == null) {
                        if (this.targetPermittedSynchronization == PermittedSynchronization.BOTH_DIRECTIONS || this.targetPermittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
                            return MemberAction.CREATE_INSTANCE_IN_THIRD_PARTY;
                        }
                        if (this.targetPermittedSynchronization == PermittedSynchronization.FROM_THIRD_PARTY) {
                            this.auditLog.logMessage("getMemberAction", OIFAuditCode.IGNORED_EGERIA_ELEMENT.getMessageDefinition(this.connectorName, this.element.getType().getTypeName(), this.element.getElementGUID(), this.element.getOrigin().getHomeMetadataCollectionName(), this.element.getOrigin().getHomeMetadataCollectionId(), this.catalogTargetName, this.targetPermittedSynchronization.getName()));
                            return MemberAction.NO_ACTION;
                        }
                    } else if (this.instanceSyncDirection != null) {
                        if (this.instanceSyncDirection == PermittedSynchronization.BOTH_DIRECTIONS || this.instanceSyncDirection == PermittedSynchronization.FROM_THIRD_PARTY) {
                            return MemberAction.DELETE_INSTANCE_IN_OPEN_METADATA;
                        }
                        if (this.instanceSyncDirection == PermittedSynchronization.TO_THIRD_PARTY) {
                            return MemberAction.CREATE_INSTANCE_IN_THIRD_PARTY;
                        }
                    }
                } else {
                    DateComparison dateComparison = this.compareAges(thirdPartyElementCreationTime, thirdPartyElementLastUpdateTime);
                    if (dateComparison == DateComparison.DATES_EQUAL) {
                        return MemberAction.NO_ACTION;
                    }
                    if (dateComparison == DateComparison.EGERIA_COPY_NEWEST) {
                        if (this.instanceSyncDirection == PermittedSynchronization.FROM_THIRD_PARTY) {
                            return MemberAction.UPDATE_INSTANCE_IN_OPEN_METADATA;
                        }
                        if (this.instanceSyncDirection == PermittedSynchronization.BOTH_DIRECTIONS || this.instanceSyncDirection == PermittedSynchronization.TO_THIRD_PARTY) {
                            return MemberAction.UPDATE_INSTANCE_IN_THIRD_PARTY;
                        }
                    }
                    if (dateComparison == DateComparison.THIRD_PARTY_COPY_NEWEST) {
                        if (this.instanceSyncDirection == PermittedSynchronization.TO_THIRD_PARTY) {
                            return MemberAction.UPDATE_INSTANCE_IN_THIRD_PARTY;
                        }
                        if (this.instanceSyncDirection == PermittedSynchronization.BOTH_DIRECTIONS || this.instanceSyncDirection == PermittedSynchronization.FROM_THIRD_PARTY) {
                            return MemberAction.UPDATE_INSTANCE_IN_OPEN_METADATA;
                        }
                    }
                }
            } else {
                if (this.targetPermittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
                    return MemberAction.DELETE_INSTANCE_IN_THIRD_PARTY;
                }
                if (this.targetPermittedSynchronization == PermittedSynchronization.FROM_THIRD_PARTY) {
                    return MemberAction.CREATE_INSTANCE_IN_OPEN_METADATA;
                }
                if (this.targetPermittedSynchronization == PermittedSynchronization.BOTH_DIRECTIONS) {
                    DateComparison dateComparison = this.compareAges(thirdPartyElementCreationTime, thirdPartyElementLastUpdateTime);
                    if (dateComparison == DateComparison.EGERIA_COPY_NEWEST || dateComparison == DateComparison.DATES_EQUAL) {
                        return MemberAction.DELETE_INSTANCE_IN_THIRD_PARTY;
                    }
                    if (dateComparison == DateComparison.THIRD_PARTY_COPY_NEWEST) {
                        return MemberAction.CREATE_INSTANCE_IN_OPEN_METADATA;
                    }
                }
            }
        } else {
            return MemberAction.CREATE_INSTANCE_IN_OPEN_METADATA;
        }
        this.auditLog.logMessage("getMemberAction", OIFAuditCode.UNKNOWN_ACTION.getMessageDefinition(this.connectorName, this.toString()));
        return MemberAction.UNKNOWN_ACTION;
    }

    private DateComparison compareAges(Date thirdPartyElementCreationTime, Date thirdPartyElementLastUpdateTime) {
        Date thirdPartyComparisonDate;
        Date elementComparisonDate = this.element.getVersions().getUpdateTime();
        if (elementComparisonDate == null) {
            elementComparisonDate = this.element.getVersions().getCreateTime();
        }
        if ((thirdPartyComparisonDate = thirdPartyElementLastUpdateTime) == null) {
            thirdPartyComparisonDate = thirdPartyElementCreationTime;
        }
        assert (thirdPartyComparisonDate != null);
        if (elementComparisonDate.before(thirdPartyComparisonDate)) {
            return DateComparison.THIRD_PARTY_COPY_NEWEST;
        }
        if (elementComparisonDate.after(thirdPartyComparisonDate)) {
            if (this.externalIdentifiers != null) {
                for (MetadataCorrelationHeader externalIdentifier : this.externalIdentifiers) {
                    if (externalIdentifier == null || externalIdentifier.getLastSynchronized() == null || !externalIdentifier.getLastSynchronized().before(elementComparisonDate)) continue;
                    return DateComparison.EGERIA_COPY_NEWEST;
                }
                return DateComparison.DATES_EQUAL;
            }
            return DateComparison.EGERIA_COPY_NEWEST;
        }
        return DateComparison.DATES_EQUAL;
    }

    public String toString() {
        String elementGUID = "null";
        if (this.element != null) {
            elementGUID = this.element.getElementGUID();
        }
        return "MemberElement{element=" + elementGUID + "externalIdentifiers=" + this.externalIdentifiers + ", catalogTargetName='" + this.catalogTargetName + "', isElementActive=" + this.isElementActive + ", targetPermittedSynchronization=" + this.targetPermittedSynchronization + ", auditLog=" + this.auditLog + ", instanceSyncDirection=" + this.instanceSyncDirection + "}";
    }

    static enum DateComparison {
        EGERIA_COPY_NEWEST,
        DATES_EQUAL,
        THIRD_PARTY_COPY_NEWEST;

    }
}

