/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.enums;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OpenMetadataEnum;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum ElementStatus implements OpenMetadataEnum
{
    UNKNOWN(0, "<Unknown>", "Unknown instance status.", "b557752a-e44a-467e-85c1-9716d105f8fb"),
    DRAFT(1, "Draft", "The content is incomplete.", "62363ab9-e290-45de-8f48-40476295cc2e"),
    PREPARED(2, "Prepared", "The content is ready for review.", "05ce396b-32fa-4d10-99cc-b51bb3bd14fa"),
    PROPOSED(3, "Proposed", "The content is in review.", "192f17f9-4c4e-4475-867a-08c1049490c5"),
    APPROVED(4, "Approved", "The content is approved.", "79bf466a-6c29-4ccb-ac3e-6dea5c615105"),
    REJECTED(5, "Rejected", "The request or proposal is rejected.", "7133d0d1-0ff9-4de0-8221-75ba5a06948c"),
    APPROVED_CONCEPT(6, "Approved concept", "The request or proposal is approved for development.", "0117b3e2-e3eb-4121-adce-b3ee690f0927"),
    UNDER_DEVELOPMENT(7, "Under development", "The instance is being developed.", "5770306b-e138-47a1-9a19-795961ec6eed"),
    DEVELOPMENT_COMPLETE(8, "Development complete", "The development of the instance is complete.", "161e0435-cb28-48d6-b403-b408b547b217"),
    APPROVED_FOR_DEPLOYMENT(9, "Approved for deployment", "The instance is approved for deployment.", "81e5b82e-e354-4b26-88bb-781a62f2c5a7"),
    STANDBY(10, "StandBy", "The instance is deployed in standby mode.", "9fd7eefe-2ee5-4fac-850f-9a78cfe59ac1"),
    ACTIVE(15, "Active", "The instance is approved and in use.", "10e474c2-e98d-4cfc-b10c-a00998369c3b"),
    FAILED(20, "Failed", "The instance is not in use due to failure.", "8a01f280-3360-4d48-a1a2-0351de57c5af"),
    DISABLED(21, "Disabled", "The instance is shutdown or disabled.", "a414db34-20a5-4394-b33a-94eeee7f44c2"),
    COMPLETE(22, "Complete", "The activity associated with the instance is complete.", "34d96768-bf4c-460e-ac86-42907188fe22"),
    DEPRECATED(30, "Deprecated", "The instance is out of date and should not be used.", "b1f5b468-60ad-452e-957e-82d1bbbb2ea9"),
    DELETED(99, "Deleted", "The instance has been deleted and is no longer available.", "44dc841f-f406-443d-8b3f-c87a810e29f6"),
    OTHER(50, "Other", "The instance is in a locally defined state.", "40c72f5b-9342-405e-a69c-710cb605ef12");

    private final int ordinal;
    private final String name;
    private final String description;
    private final String descriptionGUID;

    private ElementStatus(int ordinal, String name, String description, String descriptionGUID) {
        this.ordinal = ordinal;
        this.name = name;
        this.description = description;
        this.descriptionGUID = descriptionGUID;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDescriptionGUID() {
        return this.descriptionGUID;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    public String toString() {
        return "InstanceStatus{ordinal=" + this.ordinal + ", name='" + this.name + "', description='" + this.description + "'}";
    }
}

