/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.enums;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OpenMetadataEnum;
import org.odpi.openmetadata.frameworks.openmetadata.mapper.OpenMetadataValidValues;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum GlossaryTermAssignmentStatus implements OpenMetadataEnum
{
    DISCOVERED("6bfd3f33-e550-4575-a29f-7199f5865615", 0, "Discovered", "The term assignment was discovered by an automated process.", false),
    PROPOSED("2c939678-7381-44ba-beec-f30791e0b560", 1, "Proposed", "The term assignment was proposed by a subject-matter expert.", false),
    IMPORTED("ac932f9e-a573-4c70-a49f-56830a5a535a", 2, "Imported", "The term assignment was imported from another metadata system.", false),
    VALIDATED("18b3d426-e406-4098-ba6a-bb1e42318b21", 3, "Validated", "The term assignment has been validated and approved by a subject-matter expert.", false),
    DEPRECATED("6234a509-6d96-4450-adaf-d97918ec8646", 4, "Deprecated", "The term assignment should no longer be used.", false),
    OBSOLETE("289ffbed-3fb7-4e6a-a4e1-8f11e83bd1ac", 5, "Obsolete", "The term assignment must no longer be used.", false),
    OTHER("74cfc2eb-4669-4780-a9b7-ca49d3661630", 99, "Other", "The term assignment is in a locally defined state.", false);

    private static final String ENUM_TYPE_GUID = "c8fe36ac-369f-4799-af75-46b9c1343ab3";
    private static final String ENUM_TYPE_NAME = "TermAssignmentStatus";
    private static final String ENUM_DESCRIPTION = "Defines the provenance and confidence of a term assignment.";
    private static final String ENUM_DESCRIPTION_GUID = "ae0313dd-921d-4a1f-a71c-b234e1b2e543";
    private static final String ENUM_DESCRIPTION_WIKI = "https://egeria-project.org/types/3/0370-Semantic-Assignment/";
    private final String descriptionGUID;
    private final int ordinal;
    private final String name;
    private final String description;
    private final boolean isDefault;

    private GlossaryTermAssignmentStatus(String descriptionGUID, int ordinal, String name, String description, boolean isDefault) {
        this.ordinal = ordinal;
        this.name = name;
        this.descriptionGUID = descriptionGUID;
        this.description = description;
        this.isDefault = isDefault;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDescriptionGUID() {
        return this.descriptionGUID;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    public static String getOpenTypeGUID() {
        return ENUM_TYPE_GUID;
    }

    public static String getOpenTypeName() {
        return ENUM_TYPE_NAME;
    }

    public static String getOpenTypeDescription() {
        return ENUM_DESCRIPTION;
    }

    public static String getOpenTypeDescriptionGUID() {
        return ENUM_DESCRIPTION_GUID;
    }

    public static String getOpenTypeDescriptionWiki() {
        return ENUM_DESCRIPTION_WIKI;
    }

    public String getQualifiedName() {
        return OpenMetadataValidValues.constructValidValueQualifiedName(ENUM_TYPE_NAME, OpenMetadataProperty.TERM_ASSIGNMENT_STATUS.name, null, this.name);
    }

    public String getCategory() {
        return OpenMetadataValidValues.constructValidValueCategory(ENUM_TYPE_NAME, OpenMetadataProperty.TERM_ASSIGNMENT_STATUS.name, null);
    }

    public String toString() {
        return "GlossaryTermAssignmentStatus{name='" + this.name + "}";
    }
}

