/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.enums;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OpenMetadataEnum;
import org.odpi.openmetadata.frameworks.openmetadata.mapper.OpenMetadataValidValues;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum GovernanceClassificationStatus implements OpenMetadataEnum
{
    DISCOVERED("fa86c9f2-00d4-4acd-a232-1d58ee19703c", 0, "Discovered", "The classification assignment was discovered by an automated process.", false),
    PROPOSED("ba53bff2-1c9c-4b49-8ab2-c2403354726b", 1, "Proposed", "The classification assignment was proposed by a subject matter expert.", false),
    IMPORTED("e64e8337-b5cb-40e9-b1af-1aed1ee54ea1", 2, "Imported", "The classification assignment was imported from another metadata system.", false),
    VALIDATED("f0e4b19e-8f08-4bfd-91aa-8070bce01b69", 3, "Validated", "The classification assignment has been validated and approved by a subject matter expert.", false),
    DEPRECATED("42db10ad-3e9e-4e7c-875a-3b095f9f0434", 4, "Deprecated", "The classification assignment should no longer be used.", false),
    OBSOLETE("850930ea-63f5-4dbe-ba1d-e970c6e3e26c", 5, "Obsolete", "The classification assignment must no longer be used.", false),
    OTHER("d6bfaecb-de02-4f86-a318-a189e9a5aa5a", 99, "Other", "Another classification assignment status.", false);

    private static final String ENUM_TYPE_GUID = "cc540586-ac7c-41ba-8cc1-4da694a6a8e4";
    private static final String ENUM_TYPE_NAME = "GovernanceClassificationStatus";
    private static final String ENUM_DESCRIPTION = "Defines the status values of a governance action classification.";
    private static final String ENUM_DESCRIPTION_GUID = "34fd0e5d-4ecd-4939-8245-054872c188d9";
    private static final String ENUM_DESCRIPTION_WIKI = "https://egeria-project.org/types/4/0421-Governance-Classification-Levels/";
    private final String descriptionGUID;
    private final int ordinal;
    private final String name;
    private final String description;
    private final boolean isDefault;

    private GovernanceClassificationStatus(String descriptionGUID, int ordinal, String name, String description, boolean isDefault) {
        this.ordinal = ordinal;
        this.name = name;
        this.descriptionGUID = descriptionGUID;
        this.description = description;
        this.isDefault = isDefault;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDescriptionGUID() {
        return this.descriptionGUID;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    public static String getOpenTypeGUID() {
        return ENUM_TYPE_GUID;
    }

    public static String getOpenTypeName() {
        return ENUM_TYPE_NAME;
    }

    public static String getOpenTypeDescription() {
        return ENUM_DESCRIPTION;
    }

    public static String getOpenTypeDescriptionGUID() {
        return ENUM_DESCRIPTION_GUID;
    }

    public static String getOpenTypeDescriptionWiki() {
        return ENUM_DESCRIPTION_WIKI;
    }

    public String getQualifiedName() {
        return OpenMetadataValidValues.constructValidValueQualifiedName(ENUM_TYPE_NAME, OpenMetadataProperty.STATUS_IDENTIFIER.name, null, this.name);
    }

    public String getCategory() {
        return OpenMetadataValidValues.constructValidValueCategory(ENUM_TYPE_NAME, OpenMetadataProperty.STATUS_IDENTIFIER.name, null);
    }

    public String toString() {
        return "GovernanceClassificationStatus{name='" + this.name + "}";
    }
}

