/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.enums;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OpenMetadataEnum;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum PermittedSynchronization implements OpenMetadataEnum
{
    BOTH_DIRECTIONS(0, "3ecbbab2-8c60-49be-97cd-be1d0bca49e9", "Both Directions", "Metadata exchange is permitted in both directions.  Synchronization is halted on a specific element if potentially clashing updates have occurred both in the third party technology and open metadata.  Such conflicts are logged on the audit log and resolved through manual stewardship.", true),
    TO_THIRD_PARTY(1, "7fe0046d-8b1a-4931-b9b7-18279c6f449a", "To Third Party", "The third party technology is logically downstream of open metadata.  This means the open metadata ecosystem is the originator and owner of the metadata being synchronized. Any updates detected in the third technology are overridden by the latest open metadata values.", false),
    FROM_THIRD_PARTY(2, "9ed53b29-f843-4af2-b510-44683d84b2d0", "From Third Party", "The third party technology is logically upstream (the originator and owner of the metadata).  Any updates made in open metadata are not passed to the third party technology and the third party technology is requested to refresh the open metadata version.", false),
    OTHER(99, "332853a9-af08-4210-a9dd-48e40db5ee09", "Other", "Another type of synchronization rule - see description property.", false);

    private static final String ENUM_TYPE_GUID = "973a9f4c-93fa-43a5-a0c5-d97dbd164e78";
    private static final String ENUM_TYPE_NAME = "PermittedSynchronization";
    private static final String ENUM_DESCRIPTION = "Defines the permitted direction of exchange of metadata with a third party technology.";
    private static final String ENUM_DESCRIPTION_GUID = "c6233ba5-1438-4391-90c5-569d1f54746e";
    private static final String ENUM_DESCRIPTION_WIKI = "https://egeria-project.org/types/0/0017-External-Identifiers/";
    private final int ordinal;
    private final String name;
    private final String description;
    private final String descriptionGUID;
    private final boolean isDefault;

    private PermittedSynchronization(int ordinal, String descriptionGUID, String name, String description, boolean isDefault) {
        this.ordinal = ordinal;
        this.name = name;
        this.descriptionGUID = descriptionGUID;
        this.description = description;
        this.isDefault = isDefault;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDescriptionGUID() {
        return this.descriptionGUID;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    public static String getOpenTypeGUID() {
        return ENUM_TYPE_GUID;
    }

    public static String getOpenTypeName() {
        return ENUM_TYPE_NAME;
    }

    public static String getOpenTypeDescription() {
        return ENUM_DESCRIPTION;
    }

    public static String getOpenTypeDescriptionGUID() {
        return ENUM_DESCRIPTION_GUID;
    }

    public static String getOpenTypeDescriptionWiki() {
        return ENUM_DESCRIPTION_WIKI;
    }

    public String toString() {
        return "PermittedSynchronization{ name=" + this.name + " }";
    }
}

