/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.enums;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OpenMetadataEnum;
import org.odpi.openmetadata.frameworks.openmetadata.mapper.OpenMetadataValidValues;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum ServerAssetUseType implements OpenMetadataEnum
{
    OWNS(0, "2cd9be3f-aab1-45cb-86d8-b73e5e1287d5", "Owns", "The software server capability is accountable for the maintenance and protection of the asset.", true),
    GOVERNS(1, "264f123e-8675-4bc1-a4b4-1cfc96b95a08", "Governs", "The software server capability provides management or oversight of the asset.", false),
    MAINTAINS(2, "e2bae930-4cef-431f-add3-44d3e1e32112", "Maintains", "The software server capability keeps the asset up-to-date.", false),
    USES(3, "8a91ee82-f840-4eef-aa8f-b5eda277692a", "Uses", "The server capability consumes the content of the asset.", false),
    OTHER(99, "e9cfe66e-6b54-46f7-8351-038088c0e83b", "Other", "Other usage.", false);

    private static final String ENUM_TYPE_GUID = "09439481-9489-467c-9ae5-178a6e0b6b5a";
    private static final String ENUM_TYPE_NAME = "ServerAssetUseType";
    private static final String ENUM_DESCRIPTION = "Defines how a software server capability may use an asset.";
    private static final String ENUM_DESCRIPTION_GUID = "7d9d5d67-1915-4944-a985-f01cc5394da7";
    private static final String ENUM_DESCRIPTION_WIKI = "https://egeria-project.org/types/0/0045-Servers-and-Assets/";
    private final String descriptionGUID;
    private final int ordinal;
    private final String name;
    private final String description;
    private final boolean isDefault;

    private ServerAssetUseType(int ordinal, String descriptionGUID, String name, String description, boolean isDefault) {
        this.ordinal = ordinal;
        this.name = name;
        this.descriptionGUID = descriptionGUID;
        this.description = description;
        this.isDefault = isDefault;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDescriptionGUID() {
        return this.descriptionGUID;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    public static String getOpenTypeGUID() {
        return ENUM_TYPE_GUID;
    }

    public static String getOpenTypeName() {
        return ENUM_TYPE_NAME;
    }

    public static String getOpenTypeDescription() {
        return ENUM_DESCRIPTION;
    }

    public static String getOpenTypeDescriptionGUID() {
        return ENUM_DESCRIPTION_GUID;
    }

    public static String getOpenTypeDescriptionWiki() {
        return ENUM_DESCRIPTION_WIKI;
    }

    public String getQualifiedName() {
        return OpenMetadataValidValues.constructValidValueQualifiedName(ENUM_TYPE_NAME, OpenMetadataProperty.USE_TYPE.name, null, this.name);
    }

    public String getCategory() {
        return OpenMetadataValidValues.constructValidValueCategory(ENUM_TYPE_NAME, OpenMetadataProperty.USE_TYPE.name, null);
    }

    public String toString() {
        return "SeverAssetUseType{name='" + this.name + "}";
    }
}

