/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ActorProfileElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.AgreementRoleAppointee;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.PersonRoleElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.PersonRoleHistory;
import org.odpi.openmetadata.frameworks.openmetadata.properties.actors.AppointmentProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=PersonRoleHistory.class, name="PersonRoleHistory"), @JsonSubTypes.Type(value=AgreementRoleAppointee.class, name="AgreementRoleAppointee")})
public class PersonRoleAppointee
extends PersonRoleElement {
    private AppointmentProperties appointmentProperties = null;
    private ActorProfileElement profile = null;

    public PersonRoleAppointee() {
    }

    public PersonRoleAppointee(PersonRoleAppointee template) {
        super(template);
        if (template != null) {
            this.profile = template.getProfile();
            this.appointmentProperties = template.getAppointmentProperties();
        }
    }

    public PersonRoleAppointee(PersonRoleElement template) {
        super(template);
    }

    public AppointmentProperties getAppointmentProperties() {
        return this.appointmentProperties;
    }

    public void setAppointmentProperties(AppointmentProperties appointmentProperties) {
        this.appointmentProperties = appointmentProperties;
    }

    public ActorProfileElement getProfile() {
        return this.profile;
    }

    public void setProfile(ActorProfileElement profile) {
        this.profile = profile;
    }

    @Override
    public String toString() {
        return "PersonRoleAppointee{, appointmentProperties=" + this.appointmentProperties + ", profile=" + this.profile + "} " + super.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        PersonRoleAppointee that = (PersonRoleAppointee)objectToCompare;
        return Objects.equals(this.appointmentProperties, that.appointmentProperties) && Objects.equals(this.profile, that.profile);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.appointmentProperties, this.profile);
    }
}

