/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.refdata;

public enum SpecificationPropertyType {
    REPLACEMENT_ATTRIBUTE("replacementAttribute", "Name of attribute that should be provided when using the attached template.  Replacement attributes map to the root entity of the template, or, the first occurrence of the attribute in attached relationships, classifications or entities."),
    PLACEHOLDER_PROPERTY("placeholderProperty", "Placeholder names are located through the attribute values found in a template.  They are identified with double braces, for example {{variableName}}.  The value supplied is substituted for the placeholder variable."),
    SUPPORTED_TEMPLATE("supportedTemplate", "Description of a template that should be used by the connector when creating new elements of a certain type."),
    SUPPORTED_CONFIGURATION_PROPERTY("supportedConfigurationProperty", "Description of a configuration property that is used to affect the behaviour of a connector."),
    SUPPORTED_REQUEST_TYPE("supportedRequestType", "Description of a request type used to describe a request to a governance engine/service."),
    SUPPORTED_REQUEST_PARAMETER("supportedRequestParameter", "Description of a request parameter that is used to affect the behaviour of a governance service."),
    SUPPORTED_ACTION_TARGET("supportedActionTarget", "Description of an element that is linked to a governance action request.  The resulting call to the governance engine/service will work with this element."),
    SUPPORTED_ANALYSIS_STEP("supportedAnalysisStep", "Description of an analysis step supported by a survey action service."),
    PRODUCED_GUARD("producedGuard", "Description of a guard that is returned by a governance service when it completes."),
    PRODUCED_REQUEST_PARAMETER("producedRequestParameter", "Description of a request parameter that is produced by a governance service and is used to affect the behaviour of the next governance service(s) called in the same governance action process."),
    PRODUCED_ACTION_TARGET("producedActionTarget", "Description of an element that is produced by a governance service and is passed to the next governance service(s) called in the same governance action process as an action target."),
    PRODUCED_ANNOTATION_TYPE("producedAnnotationType", "Description of a type of annotation produced by a survey action service.");

    public final String attributeName;
    public final String description;

    private SpecificationPropertyType(String attributeName, String description) {
        this.attributeName = attributeName;
        this.description = description;
    }

    public String getPropertyType() {
        return this.attributeName;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "ReferenceValueAttributeName{" + this.attributeName + "}";
    }
}

