/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.surveyaction.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.surveyaction.properties.DataFieldAnnotation;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RequestForActionAnnotation
extends DataFieldAnnotation {
    private String surveyActivity = null;
    private String actionRequested = null;
    private Map<String, String> actionProperties = null;
    private List<String> actionTargetGUIDs = null;

    public RequestForActionAnnotation() {
    }

    public RequestForActionAnnotation(RequestForActionAnnotation template) {
        super(template);
        if (template != null) {
            this.surveyActivity = template.getSurveyActivity();
            this.actionRequested = template.getActionRequested();
            this.actionProperties = template.getActionProperties();
            this.actionTargetGUIDs = template.getActionTargetGUIDs();
        }
    }

    public String getSurveyActivity() {
        return this.surveyActivity;
    }

    public void setSurveyActivity(String surveyActivity) {
        this.surveyActivity = surveyActivity;
    }

    public String getActionRequested() {
        return this.actionRequested;
    }

    public void setActionRequested(String actionRequested) {
        this.actionRequested = actionRequested;
    }

    public Map<String, String> getActionProperties() {
        return this.actionProperties;
    }

    public void setActionProperties(Map<String, String> actionProperties) {
        this.actionProperties = actionProperties;
    }

    public List<String> getActionTargetGUIDs() {
        return this.actionTargetGUIDs;
    }

    public void setActionTargetGUIDs(List<String> actionTargetGUIDs) {
        this.actionTargetGUIDs = actionTargetGUIDs;
    }

    @Override
    public String toString() {
        return "RequestForActionAnnotation{surveyActivity='" + this.surveyActivity + "', actionRequested='" + this.actionRequested + "', actionProperties=" + this.actionProperties + ", actionTargetGUIDs=" + this.actionTargetGUIDs + "} " + super.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        RequestForActionAnnotation that = (RequestForActionAnnotation)objectToCompare;
        return Objects.equals(this.surveyActivity, that.surveyActivity) && Objects.equals(this.actionRequested, that.actionRequested) && Objects.equals(this.actionProperties, that.actionProperties) && Objects.equals(this.actionTargetGUIDs, that.actionTargetGUIDs);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.surveyActivity, this.actionRequested, this.actionProperties, this.actionTargetGUIDs);
    }
}

