/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.surveyaction.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.surveyaction.properties.DataFieldAnnotation;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ResourceProfileAnnotation
extends DataFieldAnnotation {
    private List<String> profilePropertyNames = null;
    private int length = 0;
    private String inferredDataType = null;
    private String inferredFormat = null;
    private int inferredLength = 0;
    private int inferredPrecision = 0;
    private int inferredScale = 0;
    private Date profileStartDate = null;
    private Date profileEndDate = null;
    private Map<String, String> profileProperties = null;
    private Map<String, Boolean> profileFlags = null;
    private Map<String, Date> profileDates = null;
    private Map<String, Long> profileCounts = null;
    private Map<String, Double> profileDoubles = null;
    private List<String> valueList = null;
    private Map<String, Integer> valueCount = null;
    private String valueRangeFrom = null;
    private String valueRangeTo = null;
    private String averageValue = null;

    public ResourceProfileAnnotation() {
    }

    public ResourceProfileAnnotation(ResourceProfileAnnotation template) {
        super(template);
        if (template != null) {
            this.profilePropertyNames = template.getProfilePropertyNames();
            this.length = template.getLength();
            this.inferredDataType = template.getInferredDataType();
            this.inferredFormat = template.getInferredFormat();
            this.inferredLength = template.getInferredLength();
            this.inferredPrecision = template.getInferredPrecision();
            this.inferredScale = template.getInferredScale();
            this.profileStartDate = template.getProfileStartDate();
            this.profileEndDate = template.getProfileEndDate();
            this.profileProperties = template.getProfileProperties();
            this.profileFlags = template.getProfileFlags();
            this.profileDates = template.getProfileDates();
            this.profileCounts = template.getProfileCounts();
            this.profileDoubles = template.getProfileDoubles();
            this.valueList = template.getValueList();
            this.valueCount = template.getValueCount();
            this.valueRangeFrom = template.getValueRangeFrom();
            this.valueRangeTo = template.getValueRangeTo();
            this.averageValue = template.getAverageValue();
        }
    }

    public List<String> getProfilePropertyNames() {
        return this.profilePropertyNames;
    }

    public void setProfilePropertyNames(List<String> profilePropertyNames) {
        this.profilePropertyNames = profilePropertyNames;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getInferredDataType() {
        return this.inferredDataType;
    }

    public void setInferredDataType(String inferredDataType) {
        this.inferredDataType = inferredDataType;
    }

    public String getInferredFormat() {
        return this.inferredFormat;
    }

    public void setInferredFormat(String inferredFormat) {
        this.inferredFormat = inferredFormat;
    }

    public int getInferredLength() {
        return this.inferredLength;
    }

    public void setInferredLength(int inferredLength) {
        this.inferredLength = inferredLength;
    }

    public int getInferredPrecision() {
        return this.inferredPrecision;
    }

    public void setInferredPrecision(int inferredPrecision) {
        this.inferredPrecision = inferredPrecision;
    }

    public int getInferredScale() {
        return this.inferredScale;
    }

    public void setInferredScale(int inferredScale) {
        this.inferredScale = inferredScale;
    }

    public Date getProfileStartDate() {
        return this.profileStartDate;
    }

    public void setProfileStartDate(Date profileStartDate) {
        this.profileStartDate = profileStartDate;
    }

    public Date getProfileEndDate() {
        return this.profileEndDate;
    }

    public void setProfileEndDate(Date profileEndDate) {
        this.profileEndDate = profileEndDate;
    }

    public Map<String, String> getProfileProperties() {
        return this.profileProperties;
    }

    public void setProfileProperties(Map<String, String> profileProperties) {
        this.profileProperties = profileProperties;
    }

    public Map<String, Boolean> getProfileFlags() {
        return this.profileFlags;
    }

    public void setProfileFlags(Map<String, Boolean> profileFlags) {
        this.profileFlags = profileFlags;
    }

    public Map<String, Date> getProfileDates() {
        return this.profileDates;
    }

    public void setProfileDates(Map<String, Date> profileDates) {
        this.profileDates = profileDates;
    }

    public Map<String, Long> getProfileCounts() {
        return this.profileCounts;
    }

    public void setProfileCounts(Map<String, Long> profileCounts) {
        this.profileCounts = profileCounts;
    }

    public Map<String, Double> getProfileDoubles() {
        return this.profileDoubles;
    }

    public void setProfileDoubles(Map<String, Double> profileDoubles) {
        this.profileDoubles = profileDoubles;
    }

    public List<String> getValueList() {
        return this.valueList;
    }

    public void setValueList(List<String> valueList) {
        this.valueList = valueList;
    }

    public Map<String, Integer> getValueCount() {
        return this.valueCount;
    }

    public void setValueCount(Map<String, Integer> valueCount) {
        this.valueCount = valueCount;
    }

    public String getValueRangeFrom() {
        return this.valueRangeFrom;
    }

    public void setValueRangeFrom(String valueRangeFrom) {
        this.valueRangeFrom = valueRangeFrom;
    }

    public String getValueRangeTo() {
        return this.valueRangeTo;
    }

    public void setValueRangeTo(String valueRangeTo) {
        this.valueRangeTo = valueRangeTo;
    }

    public String getAverageValue() {
        return this.averageValue;
    }

    public void setAverageValue(String averageValue) {
        this.averageValue = averageValue;
    }

    @Override
    public String toString() {
        return "ResourceProfileAnnotation{length=" + this.length + ", profilePropertyNames='" + this.profilePropertyNames + "', inferredDataType='" + this.inferredDataType + "', inferredFormat='" + this.inferredFormat + "', inferredLength=" + this.inferredLength + ", inferredPrecision=" + this.inferredPrecision + ", inferredScale=" + this.inferredScale + ", profileStartDate=" + this.profileStartDate + ", profileEndDate=" + this.profileEndDate + ", profileProperties=" + this.profileProperties + ", profileFlags=" + this.profileFlags + ", profileDates=" + this.profileDates + ", profileCounts=" + this.profileCounts + ", profileDoubles=" + this.profileDoubles + ", valueList=" + this.valueList + ", valueCount=" + this.valueCount + ", valueRangeFrom='" + this.valueRangeFrom + "', valueRangeTo='" + this.valueRangeTo + "', averageValue='" + this.averageValue + "'} " + super.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        ResourceProfileAnnotation that = (ResourceProfileAnnotation)objectToCompare;
        return this.length == that.length && this.inferredLength == that.inferredLength && this.inferredPrecision == that.inferredPrecision && this.inferredScale == that.inferredScale && Objects.equals(this.profilePropertyNames, that.profilePropertyNames) && Objects.equals(this.inferredDataType, that.inferredDataType) && Objects.equals(this.inferredFormat, that.inferredFormat) && Objects.equals(this.profileStartDate, that.profileStartDate) && Objects.equals(this.profileEndDate, that.profileEndDate) && Objects.equals(this.profileProperties, that.profileProperties) && Objects.equals(this.profileFlags, that.profileFlags) && Objects.equals(this.profileDates, that.profileDates) && Objects.equals(this.profileCounts, that.profileCounts) && Objects.equals(this.profileDoubles, that.profileDoubles) && Objects.equals(this.valueList, that.valueList) && Objects.equals(this.valueCount, that.valueCount) && Objects.equals(this.valueRangeFrom, that.valueRangeFrom) && Objects.equals(this.valueRangeTo, that.valueRangeTo) && Objects.equals(this.averageValue, that.averageValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.length, this.inferredDataType, this.inferredFormat, this.inferredLength, this.inferredPrecision, this.inferredScale, this.profilePropertyNames, this.profileStartDate, this.profileEndDate, this.profileDoubles, this.profileProperties, this.profileFlags, this.profileDates, this.profileCounts, this.valueList, this.valueCount, this.valueRangeFrom, this.valueRangeTo, this.averageValue);
    }
}

