/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ProcessContainmentType;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive1_4;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumElementDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttributeStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive1_5 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "1.5";
    private static final String originatorName = "ODPi Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1516313040008L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private OMRSArchiveBuilder archiveBuilder;
    private OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive1_5() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive1_5(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive1_4 previousTypes = new OpenMetadataTypesArchive1_4(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.update0298LineageRelationships();
        this.update0501SchemaElements();
        this.update0605OpenDiscoveryAnalysisReports();
    }

    private void update0298LineageRelationships() {
        this.archiveBuilder.addEnumDef(this.getProcessContainmentTypeEnum());
        this.archiveBuilder.addRelationshipDef(this.getProcessHierarchyRelationship());
    }

    private EnumDef getProcessContainmentTypeEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(ProcessContainmentType.getOpenTypeGUID(), ProcessContainmentType.getOpenTypeName(), ProcessContainmentType.getOpenTypeDescription(), ProcessContainmentType.getOpenTypeDescriptionGUID(), ProcessContainmentType.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (ProcessContainmentType processContainmentType : ProcessContainmentType.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(processContainmentType.getOrdinal(), processContainmentType.getName(), processContainmentType.getDescription(), processContainmentType.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!processContainmentType.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private RelationshipDef getProcessHierarchyRelationship() {
        String guid = "70dbbda3-903f-49f7-9782-32b503c43e0e";
        String name = "ProcessHierarchy";
        String description = "A hierarchical relationship between processes.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("70dbbda3-903f-49f7-9782-32b503c43e0e", "ProcessHierarchy", null, "A hierarchical relationship between processes.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.PROCESS.typeName;
        String end1AttributeName = "parentProcess";
        String end1AttributeDescription = "The more abstract or higher-level process.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "parentProcess", "The more abstract or higher-level process.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.PROCESS.typeName;
        String end2AttributeName = "childProcess";
        String end2AttributeDescription = "The more detailed or lower-level process.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "childProcess", "The more detailed or lower-level process.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Enum = "ProcessContainmentType";
        String attribute1Name = "containmentType";
        String attribute1Description = "The type of containment that exists between the related processes.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute("ProcessContainmentType", "containmentType", "The type of containment that exists between the related processes.", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void update0501SchemaElements() {
        this.archiveBuilder.addTypeDefPatch(this.updateSchemaElementEntity());
    }

    private TypeDefPatch updateSchemaElementEntity() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.SCHEMA_ELEMENT.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.ANCHOR_GUID.name, OpenMetadataProperty.ANCHOR_GUID.description, OpenMetadataProperty.ANCHOR_GUID.descriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0605OpenDiscoveryAnalysisReports() {
        this.archiveBuilder.addEnumDef(this.getDiscoveryServiceRequestStatusEnum());
        this.archiveBuilder.addTypeDefPatch(this.updateOpenDiscoveryAnalysisReportEntity());
    }

    private EnumDef getDiscoveryServiceRequestStatusEnum() {
        String guid = "b2fdeddd-24eb-4e9c-a2a4-2693828d4a69";
        String name = "DiscoveryServiceRequestStatus";
        String description = "Defines the progress or completion of a requested discovery service.";
        String descriptionGUID = null;
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef("b2fdeddd-24eb-4e9c-a2a4-2693828d4a69", "DiscoveryServiceRequestStatus", "Defines the progress or completion of a requested discovery service.", descriptionGUID);
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        boolean element1Ordinal = false;
        String element1Value = "Waiting";
        String element1Description = "Discovery service is waiting to execute.";
        String element1DescriptionGUID = null;
        EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(0, "Waiting", "Discovery service is waiting to execute.", element1DescriptionGUID);
        elementDefs.add(elementDef);
        enumDef.setDefaultValue(elementDef);
        boolean element2Ordinal = true;
        String element2Value = "Activating";
        String element2Description = "Discovery service is being initialized in the discovery engine.";
        String element2DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(1, "Activating", "Discovery service is being initialized in the discovery engine.", element2DescriptionGUID);
        elementDefs.add(elementDef);
        int element3Ordinal = 2;
        String element3Value = "InProgress";
        String element3Description = "Discovery service is executing.";
        String element3DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(2, "InProgress", "Discovery service is executing.", element3DescriptionGUID);
        elementDefs.add(elementDef);
        int element4Ordinal = 3;
        String element4Value = "Failed";
        String element4Description = "Discovery service has failed.";
        String element4DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(3, "Failed", "Discovery service has failed.", element4DescriptionGUID);
        elementDefs.add(elementDef);
        int element5Ordinal = 4;
        String element5Value = "Completed";
        String element5Description = "Discovery service has completed successfully.";
        String element5DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(4, "Completed", "Discovery service has completed successfully.", element5DescriptionGUID);
        elementDefs.add(elementDef);
        int element6Ordinal = 5;
        String element6Value = "Other";
        String element6Description = "Discovery service has a status that is not covered by this enum.";
        String element6DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(5, "Other", "Discovery service has a status that is not covered by this enum.", element6DescriptionGUID);
        elementDefs.add(elementDef);
        int element99Ordinal = 99;
        String element99Value = "Unknown";
        String element99Description = "Discovery service status is unknown.";
        String element99DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(99, "Unknown", "Discovery service status is unknown.", element99DescriptionGUID);
        elementDefs.add(elementDef);
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private TypeDefPatch updateOpenDiscoveryAnalysisReportEntity() {
        String typeName = "OpenDiscoveryAnalysisReport";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("OpenDiscoveryAnalysisReport");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "discoveryRequestStatus";
        String attribute1Description = "Deprecated property.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "discoveryServiceStatus";
        String attribute2Description = "The status of a requested discovery service.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "discoveryRequestStep";
        String attribute3Description = "Deprecated property.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "discoveryAnalysisStep";
        String attribute4Description = "The current processing step of a running discovery service.";
        String attribute4DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute("DiscoveryRequestStatus", "discoveryRequestStatus", "Deprecated property.", attribute1DescriptionGUID);
        property.setReplacedByAttribute("discoveryServiceStatus");
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("DiscoveryServiceRequestStatus", "discoveryServiceStatus", "The status of a requested discovery service.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("discoveryRequestStep", "Deprecated property.", attribute3DescriptionGUID);
        property.setReplacedByAttribute("discoveryAnalysisStep");
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("discoveryAnalysisStep", "The current processing step of a running discovery service.", attribute4DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }
}

