/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive2_8;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefStatus;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive2_9 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "2.9";
    private static final String originatorName = "Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive2_9() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive2_9(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive2_8 previousTypes = new OpenMetadataTypesArchive2_8(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.update0056AssetManagers();
        this.update0137ToDos();
        this.update0450GovernanceRollout();
        this.update0217Ports();
        this.update0534RelationalSchema();
        this.add0335PrimaryCategoryClassification();
    }

    private void update0056AssetManagers() {
        this.archiveBuilder.addClassificationDef(this.getUserProfileManagerClassification());
        this.archiveBuilder.addClassificationDef(this.getUserAccessDirectoryClassification());
        this.archiveBuilder.addClassificationDef(this.getMasterDataManagerClassification());
    }

    private ClassificationDef getUserProfileManagerClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.USER_PROFILE_MANAGER.typeGUID, OpenMetadataType.USER_PROFILE_MANAGER.typeName, null, OpenMetadataType.USER_PROFILE_MANAGER.description, OpenMetadataType.USER_PROFILE_MANAGER.descriptionGUID, OpenMetadataType.USER_PROFILE_MANAGER.wikiURL, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), false);
    }

    private ClassificationDef getUserAccessDirectoryClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.USER_ACCESS_DIRECTORY.typeGUID, OpenMetadataType.USER_ACCESS_DIRECTORY.typeName, null, OpenMetadataType.USER_ACCESS_DIRECTORY.description, OpenMetadataType.USER_ACCESS_DIRECTORY.descriptionGUID, OpenMetadataType.USER_ACCESS_DIRECTORY.wikiURL, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), false);
    }

    private ClassificationDef getMasterDataManagerClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.MASTER_DATA_MANAGER.typeGUID, OpenMetadataType.MASTER_DATA_MANAGER.typeName, null, OpenMetadataType.MASTER_DATA_MANAGER.description, OpenMetadataType.MASTER_DATA_MANAGER.descriptionGUID, OpenMetadataType.MASTER_DATA_MANAGER.wikiURL, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), false);
    }

    private void update0137ToDos() {
        this.archiveBuilder.addRelationshipDef(this.getActionTargetRelationship());
    }

    private RelationshipDef getActionTargetRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.ACTION_TARGET_RELATIONSHIP.typeGUID, OpenMetadataType.ACTION_TARGET_RELATIONSHIP.typeName, null, OpenMetadataType.ACTION_TARGET_RELATIONSHIP.description, OpenMetadataType.ACTION_TARGET_RELATIONSHIP.descriptionGUID, OpenMetadataType.ACTION_TARGET_RELATIONSHIP.wikiURL, ClassificationPropagationRule.NONE);
        String end1AttributeName = "identifiedToDoActions";
        String end1AttributeDescription = "Actions that have been identified for this element.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.TO_DO.typeName), "identifiedToDoActions", "Actions that have been identified for this element.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "elementsToWorkOn";
        String end2AttributeDescription = "Elements that will be updated or used to complete the action.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "elementsToWorkOn", "Elements that will be updated or used to complete the action.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void update0450GovernanceRollout() {
        this.archiveBuilder.addClassificationDef(this.getGovernanceMeasurementClassification());
    }

    private ClassificationDef getGovernanceMeasurementClassification() {
        String guid = "9d99d962-0214-49ba-83f7-c9b1f9f5bed4";
        String name = "GovernanceMeasurements";
        String description = "A set of measurements on the performance and use of the connected resource.";
        String descriptionGUID = null;
        String linkedToEntity = OpenMetadataType.REFERENCEABLE.typeName;
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("9d99d962-0214-49ba-83f7-c9b1f9f5bed4", "GovernanceMeasurements", null, "A set of measurements on the performance and use of the connected resource.", descriptionGUID, this.archiveBuilder.getEntityDef(linkedToEntity), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "measurementCounts";
        String attribute1Description = "A set of metric name to current count value pairs.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "measurementValues";
        String attribute2Description = "A set of metric name to current value pairs.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "measurementFlags";
        String attribute3Description = "A set of metric name to current boolean value pairs.";
        String attribute3DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getMapStringIntTypeDefAttribute("measurementCounts", "A set of metric name to current count value pairs.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute("measurementValues", "A set of metric name to current value pairs.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringBooleanTypeDefAttribute("measurementFlags", "A set of metric name to current boolean value pairs.", attribute3DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void update0217Ports() {
        this.archiveBuilder.addTypeDefPatch(this.updatePortEntity());
    }

    private TypeDefPatch updatePortEntity() {
        String typeName = "Port";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("Port");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "filterExpression";
        String attribute1Description = "Expression used to filter data values passing through port.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("filterExpression", "Expression used to filter data values passing through port.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0534RelationalSchema() {
        this.archiveBuilder.addTypeDefPatch(this.deprecateRelationalColumnType());
    }

    private TypeDefPatch deprecateRelationalColumnType() {
        String typeName = "RelationalColumnType";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("RelationalColumnType");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private void add0335PrimaryCategoryClassification() {
        this.archiveBuilder.addClassificationDef(this.addPrimaryCategoryClassification());
    }

    private ClassificationDef addPrimaryCategoryClassification() {
        String guid = "3a6c4ba7-3cc5-48cd-8952-bwra92da016d";
        String name = "PrimaryCategory";
        String description = "Defines a category as being the base category of a glossary term";
        String descriptionGUID = null;
        String linkedToEntity = "GlossaryTerm";
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("3a6c4ba7-3cc5-48cd-8952-bwra92da016d", "PrimaryCategory", null, "Defines a category as being the base category of a glossary term", descriptionGUID, this.archiveBuilder.getEntityDef("GlossaryTerm"), true);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "categoryQualifiedName";
        String attribute1Description = "The qualified name of the primary category of a GlossaryTerm.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("categoryQualifiedName", "The qualified name of the primary category of a GlossaryTerm.", attribute1DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }
}

