/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive2_11;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefStatus;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive3_1 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "3.1";
    private static final String originatorName = "Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive3_1() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive3_1(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive2_11 previousTypes = new OpenMetadataTypesArchive2_11(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.update0030HostsAndOperatingPlatforms();
        this.update0035ComplexHosts();
        this.update0036Storage();
        this.update0040SoftwareServers();
        this.update0045ServersAndAssets();
        this.update0050ApplicationsAndProcesses();
        this.update0057SoftwareServices();
        this.update0201Connections();
        this.update0223Events();
        this.add0485DataProcessingPurposes();
        this.update0507ObsoleteDefinitions();
    }

    private void update0030HostsAndOperatingPlatforms() {
        this.archiveBuilder.addTypeDefPatch(this.updateOperatingPlatformEntity());
        this.archiveBuilder.addClassificationDef(this.addSoftwarePackageManifestClassification());
        this.archiveBuilder.addRelationshipDef(this.addOperatingPlatformManifestRelationship());
    }

    private TypeDefPatch updateOperatingPlatformEntity() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.OPERATING_PLATFORM.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.OPERATING_SYSTEM_PATCH_LEVEL.name, OpenMetadataProperty.OPERATING_SYSTEM_PATCH_LEVEL.description, OpenMetadataProperty.OPERATING_SYSTEM_PATCH_LEVEL.descriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private ClassificationDef addSoftwarePackageManifestClassification() {
        String guid = "e328ae6e-0b16-4490-9883-c953b4258841";
        String name = "SoftwarePackageManifest";
        String description = "Identifies a collection of software packages.";
        String descriptionGUID = null;
        ArrayList<TypeDefLink> linkedToEntities = new ArrayList<TypeDefLink>();
        linkedToEntities.add(this.archiveBuilder.getEntityDef("Collection"));
        return this.archiveHelper.getClassificationDef("e328ae6e-0b16-4490-9883-c953b4258841", "SoftwarePackageManifest", null, "Identifies a collection of software packages.", descriptionGUID, linkedToEntities, false);
    }

    private RelationshipDef addOperatingPlatformManifestRelationship() {
        String guid = "e5bd6acf-932c-4d9c-85ff-941a8e4451db";
        String name = "OperatingPlatformManifest";
        String description = "Defines the base software installed on the operating platform.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("e5bd6acf-932c-4d9c-85ff-941a8e4451db", "OperatingPlatformManifest", null, "Defines the base software installed on the operating platform.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "OperatingPlatform";
        String end1AttributeName = "packagedInOperatingPlatforms";
        String end1AttributeDescription = "The operating platforms that use this collection of software packages.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("OperatingPlatform"), "packagedInOperatingPlatforms", "The operating platforms that use this collection of software packages.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "Collection";
        String end2AttributeName = "includesSoftwarePackages";
        String end2AttributeDescription = "The collection of software packages that are included in the operating platform.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Collection"), "includesSoftwarePackages", "The collection of software packages that are included in the operating platform.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void update0035ComplexHosts() {
        this.archiveBuilder.addEntityDef(this.addBareMetalComputerEntity());
        this.archiveBuilder.addEntityDef(this.addVirtualMachineEntity());
        this.archiveBuilder.addEntityDef(this.addDockerContainerEntity());
        this.archiveBuilder.addEntityDef(this.addHadoopClusterEntity());
        this.archiveBuilder.addEntityDef(this.addKubernetesClusterEntity());
        this.archiveBuilder.addTypeDefPatch(this.deprecateDeployedVirtualContainer());
    }

    private EntityDef addBareMetalComputerEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.BARE_METAL_COMPUTER.typeGUID, OpenMetadataType.BARE_METAL_COMPUTER.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.HOST.typeName), OpenMetadataType.BARE_METAL_COMPUTER.description, OpenMetadataType.BARE_METAL_COMPUTER.descriptionGUID, OpenMetadataType.BARE_METAL_COMPUTER.wikiURL);
    }

    private EntityDef addVirtualMachineEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.VIRTUAL_MACHINE.typeGUID, OpenMetadataType.VIRTUAL_MACHINE.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.HOST.typeName), OpenMetadataType.VIRTUAL_MACHINE.description, OpenMetadataType.VIRTUAL_MACHINE.descriptionGUID, OpenMetadataType.VIRTUAL_MACHINE.wikiURL);
    }

    private EntityDef addDockerContainerEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DOCKER_CONTAINER.typeGUID, OpenMetadataType.DOCKER_CONTAINER.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.VIRTUAL_CONTAINER.typeName), OpenMetadataType.DOCKER_CONTAINER.description, OpenMetadataType.DOCKER_CONTAINER.descriptionGUID, OpenMetadataType.DOCKER_CONTAINER.wikiURL);
    }

    private EntityDef addHadoopClusterEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.HADOOP_CLUSTER.typeGUID, OpenMetadataType.HADOOP_CLUSTER.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.HOST_CLUSTER.typeName), OpenMetadataType.HADOOP_CLUSTER.description, OpenMetadataType.HADOOP_CLUSTER.descriptionGUID, OpenMetadataType.HADOOP_CLUSTER.wikiURL);
    }

    private EntityDef addKubernetesClusterEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.KUBERNETES_CLUSTER.typeGUID, OpenMetadataType.KUBERNETES_CLUSTER.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.HOST_CLUSTER.typeName), OpenMetadataType.KUBERNETES_CLUSTER.description, OpenMetadataType.KUBERNETES_CLUSTER.descriptionGUID, OpenMetadataType.KUBERNETES_CLUSTER.wikiURL);
    }

    private TypeDefPatch deprecateDeployedVirtualContainer() {
        String typeName = "DeployedVirtualContainer";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("DeployedVirtualContainer");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private void update0036Storage() {
        this.archiveBuilder.addEntityDef(this.addStorageVolumeEntity());
        this.archiveBuilder.addRelationshipDef(this.addAttachedStorageRelationship());
    }

    private EntityDef addStorageVolumeEntity() {
        String guid = "14145458-f0d0-4955-8899-b8a2874708c9";
        String name = "StorageVolume";
        String description = "A persistent storage volume.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        return this.archiveHelper.getDefaultEntityDef("14145458-f0d0-4955-8899-b8a2874708c9", "StorageVolume", this.archiveBuilder.getEntityDef(superTypeName), "A persistent storage volume.", descriptionGUID);
    }

    private RelationshipDef addAttachedStorageRelationship() {
        String guid = "2cf1e949-7189-4bf2-8ee4-e1318e59abd7";
        String name = "AttachedStorage";
        String description = "Links a host to a persistent storage volume.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("2cf1e949-7189-4bf2-8ee4-e1318e59abd7", "AttachedStorage", null, "Links a host to a persistent storage volume.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "Host";
        String end1AttributeName = "hosts";
        String end1AttributeDescription = "The hosts that are accessing the storage.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Host"), "hosts", "The hosts that are accessing the storage.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "StorageVolume";
        String end2AttributeName = "storageVolumes";
        String end2AttributeDescription = "The storage available to a host.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("StorageVolume"), "storageVolumes", "The storage available to a host.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void update0045ServersAndAssets() {
        this.archiveBuilder.addTypeDefPatch(this.updateServerAssetUseRelationship());
    }

    private TypeDefPatch updateServerAssetUseRelationship() {
        String typeName = OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.MINIMUM_INSTANCES.name;
        String attribute1Description = OpenMetadataProperty.MINIMUM_INSTANCES.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.MINIMUM_INSTANCES.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.MAXIMUM_INSTANCES.name;
        String attribute2Description = OpenMetadataProperty.MAXIMUM_INSTANCES.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.MAXIMUM_INSTANCES.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0040SoftwareServers() {
        this.archiveBuilder.addTypeDefPatch(this.updateServerEndpointRelationship());
    }

    private TypeDefPatch updateServerEndpointRelationship() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.SERVER_ENDPOINT_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end1AttributeName = "servers";
        String end1AttributeDescription = "Server supporting this endpoint.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.IT_INFRASTRUCTURE.typeName), "servers", "Server supporting this endpoint.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        typeDefPatch.setEndDef2(relationshipEndDef);
        return typeDefPatch;
    }

    private void update0057SoftwareServices() {
        this.archiveBuilder.addEntityDef(this.addApplicationServiceEntity());
    }

    private EntityDef addApplicationServiceEntity() {
        String guid = "5b7f340e-7dc9-45c0-a636-c20605147c94";
        String name = "ApplicationService";
        String description = "A software service supporting a single reusable business function.";
        String descriptionGUID = null;
        String superTypeName = "SoftwareService";
        return this.archiveHelper.getDefaultEntityDef("5b7f340e-7dc9-45c0-a636-c20605147c94", "ApplicationService", this.archiveBuilder.getEntityDef("SoftwareService"), "A software service supporting a single reusable business function.", descriptionGUID);
    }

    private void update0050ApplicationsAndProcesses() {
        this.archiveBuilder.addEntityDef(this.addCatalogEntity());
        this.archiveBuilder.addEntityDef(this.addDataManagerEntity());
    }

    private EntityDef addCatalogEntity() {
        String guid = OpenMetadataType.CATALOG.typeGUID;
        String name = OpenMetadataType.CATALOG.typeName;
        String description = OpenMetadataType.CATALOG.description;
        String descriptionGUID = OpenMetadataType.CATALOG.descriptionGUID;
        String descriptionWiki = OpenMetadataType.CATALOG.wikiURL;
        String superTypeName = OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeName;
        return this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
    }

    private EntityDef addDataManagerEntity() {
        String guid = OpenMetadataType.DATA_MANAGER.typeGUID;
        String name = OpenMetadataType.DATA_MANAGER.typeName;
        String description = OpenMetadataType.DATA_MANAGER.description;
        String descriptionGUID = OpenMetadataType.DATA_MANAGER.descriptionGUID;
        String descriptionWiki = OpenMetadataType.DATA_MANAGER.wikiURL;
        String superTypeName = OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeName;
        return this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
    }

    private void update0201Connections() {
        this.archiveBuilder.addClassificationDef(this.addConnectorTypeDirectoryClassification());
        this.archiveBuilder.addEntityDef(this.addConnectorCategoryEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateConnectorTypeEntity());
        this.archiveBuilder.addRelationshipDef(this.addConnectorImplementationChoiceRelationship());
    }

    private ClassificationDef addConnectorTypeDirectoryClassification() {
        String guid = "9678ef11-ed7e-404b-a041-736df7514339";
        String name = "ConnectorTypeDirectory";
        String description = "Identifies a collection of related connector types.";
        String descriptionGUID = null;
        ArrayList<TypeDefLink> linkedToEntities = new ArrayList<TypeDefLink>();
        linkedToEntities.add(this.archiveBuilder.getEntityDef("Collection"));
        return this.archiveHelper.getClassificationDef("9678ef11-ed7e-404b-a041-736df7514339", "ConnectorTypeDirectory", null, "Identifies a collection of related connector types.", descriptionGUID, linkedToEntities, false);
    }

    private EntityDef addConnectorCategoryEntity() {
        String guid = "fb60761f-7afd-4d3d-9efa-24bc85a7b22e";
        String name = "ConnectorCategory";
        String description = "A detailed description of the effect of some data processing.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("fb60761f-7afd-4d3d-9efa-24bc85a7b22e", "ConnectorCategory", this.archiveBuilder.getEntityDef(superTypeName), "A detailed description of the effect of some data processing.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute3Name = "targetTechnologySource";
        String attribute3Description = "Name of the organization providing the technology that the connectors access. For example, Apache Software Foundation";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "targetTechnologyName";
        String attribute4Description = "Name of the technology that the connectors access. For example, Apache Kafka.";
        String attribute4DescriptionGUID = null;
        String attribute7Name = "recognizedAdditionalProperties";
        String attribute7Description = "List of additional connection property names supported by the connector implementations.";
        String attribute7DescriptionGUID = null;
        String attribute8Name = "recognizedSecuredProperties";
        String attribute8Description = "List of secured connection property names supported by the connector implementations.";
        String attribute8DescriptionGUID = null;
        String attribute9Name = "recognizedConfigurationProperties";
        String attribute9Description = "List of secured connection property names supported by the connector implementations.";
        String attribute9DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.DISPLAY_NAME.name, OpenMetadataProperty.DISPLAY_NAME.description, OpenMetadataProperty.DISPLAY_NAME.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.DESCRIPTION.name, OpenMetadataProperty.DESCRIPTION.description, OpenMetadataProperty.DESCRIPTION.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("targetTechnologySource", "Name of the organization providing the technology that the connectors access. For example, Apache Software Foundation", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("targetTechnologyName", "Name of the technology that the connectors access. For example, Apache Kafka.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringBooleanTypeDefAttribute("recognizedAdditionalProperties", "List of additional connection property names supported by the connector implementations.", attribute7DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringBooleanTypeDefAttribute("recognizedSecuredProperties", "List of secured connection property names supported by the connector implementations.", attribute8DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringBooleanTypeDefAttribute("recognizedConfigurationProperties", "List of secured connection property names supported by the connector implementations.", attribute9DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private TypeDefPatch updateConnectorTypeEntity() {
        String typeName = "ConnectorType";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ConnectorType");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "supportedAssetTypeName";
        String attribute1Description = "Type of asset supported by the connector implementation.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "expectedDataFormat";
        String attribute2Description = "Description of the format of the data expected by the connector implementation.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "connectorFrameworkName";
        String attribute3Description = "Name of the framework that the connector implements. The default is 'Open Connector Framework (OCF)'";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "connectorInterfaceLanguage";
        String attribute4Description = "The programming language used to implement the connector's interface.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "connectorInterfaces";
        String attribute5Description = "List of interfaces supported by the connector.";
        String attribute5DescriptionGUID = null;
        String attribute6Name = "targetTechnologySource";
        String attribute6Description = "Name of the organization providing the technology that the connectors access. For example, Apache Software Foundation";
        String attribute6DescriptionGUID = null;
        String attribute7Name = "targetTechnologyName";
        String attribute7Description = "Name of the technology that the connectors access. For example, Apache Kafka.";
        String attribute7DescriptionGUID = null;
        String attribute8Name = "targetTechnologyInterfaces";
        String attribute8Description = "Names of the technology's interfaces that the connectors use.";
        String attribute8DescriptionGUID = null;
        String attribute9Name = "targetTechnologyVersions";
        String attribute9Description = "List of versions of the technology that the connector implementation supports.";
        String attribute9DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("supportedAssetTypeName", "Type of asset supported by the connector implementation.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("expectedDataFormat", "Description of the format of the data expected by the connector implementation.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("connectorFrameworkName", "Name of the framework that the connector implements. The default is 'Open Connector Framework (OCF)'", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("connectorInterfaceLanguage", "The programming language used to implement the connector's interface.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute("connectorInterfaces", "List of interfaces supported by the connector.", attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("targetTechnologySource", "Name of the organization providing the technology that the connectors access. For example, Apache Software Foundation", attribute6DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("targetTechnologyName", "Name of the technology that the connectors access. For example, Apache Kafka.", attribute7DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute("targetTechnologyInterfaces", "Names of the technology's interfaces that the connectors use.", attribute8DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute("targetTechnologyVersions", "List of versions of the technology that the connector implementation supports.", attribute9DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private RelationshipDef addConnectorImplementationChoiceRelationship() {
        String guid = "633648f3-c951-4ad7-b975-9fc04e0f3d2e";
        String name = "ConnectorImplementationChoice";
        String description = "Relates a connector category for a specific type of technology with the connector types that support it.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("633648f3-c951-4ad7-b975-9fc04e0f3d2e", "ConnectorImplementationChoice", null, "Relates a connector category for a specific type of technology with the connector types that support it.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "ConnectorCategory";
        String end1AttributeName = "connectorCategories";
        String end1AttributeDescription = "The categories that a connector type belongs to.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("ConnectorCategory"), "connectorCategories", "The categories that a connector type belongs to.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "ConnectorType";
        String end2AttributeName = "connectorTypes";
        String end2AttributeDescription = "The connector types that support the technology described in the connector category.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("ConnectorType"), "connectorTypes", "The connector types that support the technology described in the connector category.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void update0223Events() {
        this.archiveBuilder.addEntityDef(this.addKafkaTopicEntity());
    }

    private EntityDef addKafkaTopicEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.KAFKA_TOPIC.typeGUID, OpenMetadataType.KAFKA_TOPIC.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.TOPIC.typeName), OpenMetadataType.KAFKA_TOPIC.description, OpenMetadataType.KAFKA_TOPIC.descriptionGUID, OpenMetadataType.KAFKA_TOPIC.wikiURL);
    }

    private void add0485DataProcessingPurposes() {
        this.archiveBuilder.addEntityDef(this.getDataProcessingPurposeEntity());
        this.archiveBuilder.addEntityDef(this.getDataProcessingActionEntity());
        this.archiveBuilder.addEntityDef(this.getDataProcessingDescriptionEntity());
        this.archiveBuilder.addRelationshipDef(this.getPermittedProcessingRelationship());
        this.archiveBuilder.addRelationshipDef(this.getApprovedPurposeRelationship());
        this.archiveBuilder.addRelationshipDef(this.getDetailedProcessingActionsRelationship());
        this.archiveBuilder.addRelationshipDef(this.getDataProcessingSpecificationRelationship());
        this.archiveBuilder.addRelationshipDef(this.getDataProcessingTargetRelationship());
    }

    private EntityDef getDataProcessingDescriptionEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DATA_PROCESSING_DESCRIPTION.typeGUID, OpenMetadataType.DATA_PROCESSING_DESCRIPTION.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_PROCESSING_ACTION.typeName), OpenMetadataType.DATA_PROCESSING_DESCRIPTION.description, OpenMetadataType.DATA_PROCESSING_DESCRIPTION.descriptionGUID, OpenMetadataType.DATA_PROCESSING_DESCRIPTION.wikiURL);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.DISPLAY_NAME.name, OpenMetadataProperty.DISPLAY_NAME.description, OpenMetadataProperty.DISPLAY_NAME.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.DESCRIPTION.name, OpenMetadataProperty.DESCRIPTION.description, OpenMetadataProperty.DESCRIPTION.descriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getDataProcessingPurposeEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DATA_PROCESSING_PURPOSE.typeGUID, OpenMetadataType.DATA_PROCESSING_PURPOSE.typeName, this.archiveBuilder.getEntityDef("GovernanceDefinition"), OpenMetadataType.DATA_PROCESSING_PURPOSE.description, OpenMetadataType.DATA_PROCESSING_PURPOSE.descriptionGUID, OpenMetadataType.DATA_PROCESSING_PURPOSE.wikiURL);
    }

    private EntityDef getDataProcessingActionEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DATA_PROCESSING_ACTION.typeGUID, OpenMetadataType.DATA_PROCESSING_ACTION.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), OpenMetadataType.DATA_PROCESSING_ACTION.description, OpenMetadataType.DATA_PROCESSING_ACTION.descriptionGUID, OpenMetadataType.DATA_PROCESSING_ACTION.wikiURL);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.DISPLAY_NAME.name, OpenMetadataProperty.DISPLAY_NAME.description, OpenMetadataProperty.DISPLAY_NAME.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.DESCRIPTION.name, OpenMetadataProperty.DESCRIPTION.description, OpenMetadataProperty.DESCRIPTION.descriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getPermittedProcessingRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.PERMITTED_PROCESSING_RELATIONSHIP.typeGUID, OpenMetadataType.PERMITTED_PROCESSING_RELATIONSHIP.typeName, null, OpenMetadataType.PERMITTED_PROCESSING_RELATIONSHIP.description, OpenMetadataType.PERMITTED_PROCESSING_RELATIONSHIP.descriptionGUID, OpenMetadataType.PERMITTED_PROCESSING_RELATIONSHIP.wikiURL, ClassificationPropagationRule.NONE);
        String end1AttributeName = "supportedPurposes";
        String end1AttributeDescription = "The supported outcomes from the processing.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_PROCESSING_PURPOSE.typeName), "supportedPurposes", "The supported outcomes from the processing.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "permittedProcessing";
        String end2AttributeDescription = "The description of the processing that is permitted for the purposes.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_PROCESSING_DESCRIPTION.typeName), "permittedProcessing", "The description of the processing that is permitted for the purposes.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getApprovedPurposeRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.APPROVED_PURPOSE_RELATIONSHIP.typeGUID, OpenMetadataType.APPROVED_PURPOSE_RELATIONSHIP.typeName, null, OpenMetadataType.APPROVED_PURPOSE_RELATIONSHIP.description, OpenMetadataType.APPROVED_PURPOSE_RELATIONSHIP.descriptionGUID, OpenMetadataType.APPROVED_PURPOSE_RELATIONSHIP.wikiURL, ClassificationPropagationRule.NONE);
        String end1AttributeName = "approvedForPurposes";
        String end1AttributeDescription = "The people/processes that have permission to process data.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "approvedForPurposes", "The people/processes that have permission to process data.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "approvedPurposes";
        String end2AttributeDescription = "The purposes (outcomes) that the people/processes have permission for.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_PROCESSING_PURPOSE.typeName), "approvedPurposes", "The purposes (outcomes) that the people/processes have permission for.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getDetailedProcessingActionsRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.DETAILED_PROCESSING_ACTION_RELATIONSHIP.typeGUID, OpenMetadataType.DETAILED_PROCESSING_ACTION_RELATIONSHIP.typeName, null, OpenMetadataType.DETAILED_PROCESSING_ACTION_RELATIONSHIP.description, OpenMetadataType.DETAILED_PROCESSING_ACTION_RELATIONSHIP.descriptionGUID, OpenMetadataType.DETAILED_PROCESSING_ACTION_RELATIONSHIP.wikiURL, ClassificationPropagationRule.NONE);
        String end1AttributeName = "parentProcessingActions";
        String end1AttributeDescription = "The aggregating processing descriptions.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_PROCESSING_ACTION.typeName), "parentProcessingActions", "The aggregating processing descriptions.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "childProcessingActions";
        String end2AttributeDescription = "The individual actions that make up the data processing description.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_PROCESSING_ACTION.typeName), "childProcessingActions", "The individual actions that make up the data processing description.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getDataProcessingSpecificationRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.DATA_PROCESSING_SPECIFICATION_RELATIONSHIP.typeGUID, OpenMetadataType.DATA_PROCESSING_SPECIFICATION_RELATIONSHIP.typeName, null, OpenMetadataType.DATA_PROCESSING_SPECIFICATION_RELATIONSHIP.description, OpenMetadataType.DATA_PROCESSING_SPECIFICATION_RELATIONSHIP.descriptionGUID, OpenMetadataType.DATA_PROCESSING_SPECIFICATION_RELATIONSHIP.wikiURL, ClassificationPropagationRule.NONE);
        String end1AttributeName = "dataProcessingElements";
        String end1AttributeDescription = "The people/processes performing the processing.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "dataProcessingElements", "The people/processes performing the processing.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "dataProcessingDescriptions";
        String end2AttributeDescription = "The description of the processing.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_PROCESSING_DESCRIPTION.typeName), "dataProcessingDescriptions", "The description of the processing.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getDataProcessingTargetRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.DATA_PROCESSING_TARGET_RELATIONSHIP.typeGUID, OpenMetadataType.DATA_PROCESSING_TARGET_RELATIONSHIP.typeName, null, OpenMetadataType.DATA_PROCESSING_TARGET_RELATIONSHIP.description, OpenMetadataType.DATA_PROCESSING_TARGET_RELATIONSHIP.descriptionGUID, OpenMetadataType.DATA_PROCESSING_TARGET_RELATIONSHIP.wikiURL, ClassificationPropagationRule.NONE);
        String end1AttributeName = "dataProcessingActions";
        String end1AttributeDescription = "Actions being performed on the data.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_PROCESSING_ACTION.typeName), "dataProcessingActions", "Actions being performed on the data.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "dataProcessingTarget";
        String end2AttributeDescription = "The data that is being acted upon.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "dataProcessingTarget", "The data that is being acted upon.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void update0507ObsoleteDefinitions() {
        this.archiveBuilder.addTypeDefPatch(this.deprecateBoundedSchemaType());
        this.archiveBuilder.addTypeDefPatch(this.deprecateBoundedSchemaElementType());
        this.archiveBuilder.addTypeDefPatch(this.deprecateArraySchemaType());
        this.archiveBuilder.addTypeDefPatch(this.deprecateArrayDocumentType());
        this.archiveBuilder.addTypeDefPatch(this.deprecateSetSchemaType());
        this.archiveBuilder.addTypeDefPatch(this.deprecateSetDocumentType());
    }

    private TypeDefPatch deprecateBoundedSchemaType() {
        String typeName = "BoundedSchemaType";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("BoundedSchemaType");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private TypeDefPatch deprecateBoundedSchemaElementType() {
        String typeName = "BoundedSchemaElementType";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("BoundedSchemaElementType");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private TypeDefPatch deprecateArraySchemaType() {
        String typeName = "ArraySchemaType";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ArraySchemaType");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private TypeDefPatch deprecateArrayDocumentType() {
        String typeName = "ArrayDocumentType";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ArrayDocumentType");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private TypeDefPatch deprecateSetSchemaType() {
        String typeName = "SetSchemaType";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("SetSchemaType");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private TypeDefPatch deprecateSetDocumentType() {
        String typeName = "SetDocumentType";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("SetDocumentType");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }
}

