/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive3_1;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttributeStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefStatus;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive3_2 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "3.2";
    private static final String originatorName = "Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive3_2() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive3_2(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive3_1 previousTypes = new OpenMetadataTypesArchive3_1(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.update0030HostsAndOperatingPlatforms();
        this.update0421GovernanceClassificationLevels();
        this.update0422GovernanceActionClassifications();
        this.update0450GovernanceRollout();
        this.update0455ExceptionManagement();
        this.update0465DuplicateProcessing();
        this.update0620DataProfiling();
    }

    private void update0030HostsAndOperatingPlatforms() {
        this.archiveBuilder.addEntityDef(this.addSoftwareArchiveEntity());
    }

    private EntityDef addSoftwareArchiveEntity() {
        String guid = "4c4bfc3f-1374-4e4c-a76d-c8e82b2cafaa";
        String name = "SoftwareArchive";
        String description = "A collection of runnable software components.";
        String descriptionGUID = null;
        String superTypeName = "Collection";
        return this.archiveHelper.getDefaultEntityDef("4c4bfc3f-1374-4e4c-a76d-c8e82b2cafaa", "SoftwareArchive", this.archiveBuilder.getEntityDef("Collection"), "A collection of runnable software components.", descriptionGUID);
    }

    private void update0421GovernanceClassificationLevels() {
        this.archiveBuilder.addEntityDef(this.addGovernanceStatusLevelEntity());
        this.archiveBuilder.addClassificationDef(this.addGovernanceStatusSetClassification());
    }

    private EntityDef addGovernanceStatusLevelEntity() {
        String guid = "a518de03-0f72-4944-9cd5-e05b43ae9c5e";
        String name = "GovernanceStatusLevel";
        String description = "A value to represent a specific level of status in a governance element.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("a518de03-0f72-4944-9cd5-e05b43ae9c5e", "GovernanceStatusLevel", this.archiveBuilder.getEntityDef(superTypeName), "A value to represent a specific level of status in a governance element.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "levelIdentifier";
        String attribute1Description = "Numeric value for the classification level";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute("levelIdentifier", "Numeric value for the classification level", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.DISPLAY_NAME.name, OpenMetadataProperty.DISPLAY_NAME.description, OpenMetadataProperty.DISPLAY_NAME.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.DESCRIPTION.name, OpenMetadataProperty.DESCRIPTION.description, OpenMetadataProperty.DESCRIPTION.descriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private ClassificationDef addGovernanceStatusSetClassification() {
        String guid = "c13261bb-0cfe-4540-a44a-cca2b14f412b";
        String name = "GovernanceStatusSet";
        String description = "Identifies the set of levels that are used to describe the status of a governance element.";
        String descriptionGUID = null;
        ArrayList<TypeDefLink> linkedToEntities = new ArrayList<TypeDefLink>();
        linkedToEntities.add(this.archiveBuilder.getEntityDef("Collection"));
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("c13261bb-0cfe-4540-a44a-cca2b14f412b", "GovernanceStatusSet", null, "Identifies the set of levels that are used to describe the status of a governance element.", descriptionGUID, linkedToEntities, false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "domainIdentifier";
        String attribute1Description = "Identifier of the governance domain that recognizes this set of levels.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute("domainIdentifier", "Identifier of the governance domain that recognizes this set of levels.", attribute1DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void update0422GovernanceActionClassifications() {
        this.archiveBuilder.addTypeDefPatch(this.updateImpactClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateCriticalityClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateConfidentialityClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateConfidenceClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateRetentionClassification());
    }

    private TypeDefPatch updateImpactClassification() {
        String typeName = "Impact";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("Impact");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "status";
        String attribute1Description = "Deprecated attribute. Use the statusIdentifier attribute to describe the status of this classification.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "statusIdentifier";
        String attribute2Description = "Description of the status of this classification.  Values defined by GovernanceStatusLevel.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "level";
        String attribute3Description = "Deprecated attribute. Use the severityIdentifier attribute to describe the severity level of this classification.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "levelIdentifier";
        String attribute4Description = "Deprecated attribute. Use the severityIdentifier attribute to describe the severity level of this classification.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "severityIdentifier";
        String attribute5Description = "Defined level of severity for this classification. Values defined by GovernanceClassificationLevel.";
        String attribute5DescriptionGUID = null;
        String attribute6Name = OpenMetadataProperty.STEWARD_TYPE_NAME.name;
        String attribute6Description = OpenMetadataProperty.STEWARD_TYPE_NAME.description;
        String attribute6DescriptionGUID = OpenMetadataProperty.STEWARD_TYPE_NAME.descriptionGUID;
        String attribute7Name = OpenMetadataProperty.STEWARD_PROPERTY_NAME.name;
        String attribute7Description = OpenMetadataProperty.STEWARD_PROPERTY_NAME.description;
        String attribute7DescriptionGUID = OpenMetadataProperty.STEWARD_PROPERTY_NAME.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute("GovernanceClassificationStatus", "status", "Deprecated attribute. Use the statusIdentifier attribute to describe the status of this classification.", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("statusIdentifier");
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute("statusIdentifier", "Description of the status of this classification.  Values defined by GovernanceStatusLevel.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("ImpactSeverity", "level", "Deprecated attribute. Use the severityIdentifier attribute to describe the severity level of this classification.", attribute3DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("severityIdentifier");
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute("levelIdentifier", "Deprecated attribute. Use the severityIdentifier attribute to describe the severity level of this classification.", attribute4DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("severityIdentifier");
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute("severityIdentifier", "Defined level of severity for this classification. Values defined by GovernanceClassificationLevel.", attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute6Name, attribute6Description, attribute6DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute7Name, attribute7Description, attribute7DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateCriticalityClassification() {
        String typeName = "Criticality";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("Criticality");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "status";
        String attribute1Description = "Deprecated attribute. Use the statusIdentifier attribute to describe the status of this classification.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "statusIdentifier";
        String attribute2Description = "Description of the status of this classification.  Values defined by GovernanceStatusLevel.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "level";
        String attribute3Description = "Deprecated attribute. Use the levelIdentifier attribute to describe the criticality level of this classification.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "levelIdentifier";
        String attribute4Description = "Defined criticality level for this classification. Values defined by GovernanceClassificationLevel.";
        String attribute4DescriptionGUID = null;
        String attribute6Name = OpenMetadataProperty.STEWARD_TYPE_NAME.name;
        String attribute6Description = OpenMetadataProperty.STEWARD_TYPE_NAME.description;
        String attribute6DescriptionGUID = OpenMetadataProperty.STEWARD_TYPE_NAME.descriptionGUID;
        String attribute7Name = OpenMetadataProperty.STEWARD_PROPERTY_NAME.name;
        String attribute7Description = OpenMetadataProperty.STEWARD_PROPERTY_NAME.description;
        String attribute7DescriptionGUID = OpenMetadataProperty.STEWARD_PROPERTY_NAME.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute("GovernanceClassificationStatus", "status", "Deprecated attribute. Use the statusIdentifier attribute to describe the status of this classification.", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("statusIdentifier");
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute("statusIdentifier", "Description of the status of this classification.  Values defined by GovernanceStatusLevel.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("CriticalityLevel", "level", "Deprecated attribute. Use the levelIdentifier attribute to describe the criticality level of this classification.", attribute3DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("levelIdentifier");
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute("levelIdentifier", "Defined criticality level for this classification. Values defined by GovernanceClassificationLevel.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute6Name, attribute6Description, attribute6DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute7Name, attribute7Description, attribute7DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateConfidentialityClassification() {
        String typeName = "Confidentiality";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("Confidentiality");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "status";
        String attribute1Description = "Deprecated attribute. Use the statusIdentifier attribute to describe the status of this classification.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "statusIdentifier";
        String attribute2Description = "Description of the status of this classification.  Values defined by GovernanceStatusLevel.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "level";
        String attribute3Description = "Deprecated attribute. Use the levelIdentifier attribute to describe the confidentiality level of this classification.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "levelIdentifier";
        String attribute4Description = "Defined confidentiality level for this classification. Values defined by GovernanceClassificationLevel.";
        String attribute4DescriptionGUID = null;
        String attribute6Name = OpenMetadataProperty.STEWARD_TYPE_NAME.name;
        String attribute6Description = OpenMetadataProperty.STEWARD_TYPE_NAME.description;
        String attribute6DescriptionGUID = OpenMetadataProperty.STEWARD_TYPE_NAME.descriptionGUID;
        String attribute7Name = OpenMetadataProperty.STEWARD_PROPERTY_NAME.name;
        String attribute7Description = OpenMetadataProperty.STEWARD_PROPERTY_NAME.description;
        String attribute7DescriptionGUID = OpenMetadataProperty.STEWARD_PROPERTY_NAME.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute("GovernanceClassificationStatus", "status", "Deprecated attribute. Use the statusIdentifier attribute to describe the status of this classification.", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("statusIdentifier");
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute("statusIdentifier", "Description of the status of this classification.  Values defined by GovernanceStatusLevel.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute("level", "Deprecated attribute. Use the levelIdentifier attribute to describe the confidentiality level of this classification.", attribute3DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("levelIdentifier");
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute("levelIdentifier", "Defined confidentiality level for this classification. Values defined by GovernanceClassificationLevel.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute6Name, attribute6Description, attribute6DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute7Name, attribute7Description, attribute7DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateConfidenceClassification() {
        String typeName = "Confidence";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("Confidence");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "status";
        String attribute1Description = "Deprecated attribute. Use the statusIdentifier attribute to describe the status of this classification.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "statusIdentifier";
        String attribute2Description = "Description of the status of this classification.  Values defined by GovernanceStatusLevel.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "level";
        String attribute3Description = "Deprecated attribute. Use the levelIdentifier attribute to describe the confidence level of this classification.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "levelIdentifier";
        String attribute4Description = "Defined confidence level for this classification. Values defined by GovernanceClassificationLevel.";
        String attribute4DescriptionGUID = null;
        String attribute6Name = OpenMetadataProperty.STEWARD_TYPE_NAME.name;
        String attribute6Description = OpenMetadataProperty.STEWARD_TYPE_NAME.description;
        String attribute6DescriptionGUID = OpenMetadataProperty.STEWARD_TYPE_NAME.descriptionGUID;
        String attribute7Name = OpenMetadataProperty.STEWARD_PROPERTY_NAME.name;
        String attribute7Description = OpenMetadataProperty.STEWARD_PROPERTY_NAME.description;
        String attribute7DescriptionGUID = OpenMetadataProperty.STEWARD_PROPERTY_NAME.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute("GovernanceClassificationStatus", "status", "Deprecated attribute. Use the statusIdentifier attribute to describe the status of this classification.", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("statusIdentifier");
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute("statusIdentifier", "Description of the status of this classification.  Values defined by GovernanceStatusLevel.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("ConfidenceLevel", "level", "Deprecated attribute. Use the levelIdentifier attribute to describe the confidence level of this classification.", attribute3DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("levelIdentifier");
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute("levelIdentifier", "Defined confidence level for this classification. Values defined by GovernanceClassificationLevel.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute6Name, attribute6Description, attribute6DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute7Name, attribute7Description, attribute7DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateRetentionClassification() {
        String typeName = "Retention";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("Retention");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "status";
        String attribute1Description = "Deprecated attribute. Use the statusIdentifier attribute to describe the status of this classification.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "statusIdentifier";
        String attribute2Description = "Description of the status of this classification.  Values defined by GovernanceStatusLevel.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "basis";
        String attribute3Description = "Deprecated attribute. Use the basisIdentifier attribute to describe the retention basis of this classification.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "basisIdentifier";
        String attribute4Description = "Defined retention basis for this classification. Values defined by GovernanceClassificationLevel.";
        String attribute4DescriptionGUID = null;
        String attribute6Name = OpenMetadataProperty.STEWARD_TYPE_NAME.name;
        String attribute6Description = OpenMetadataProperty.STEWARD_TYPE_NAME.description;
        String attribute6DescriptionGUID = OpenMetadataProperty.STEWARD_TYPE_NAME.descriptionGUID;
        String attribute7Name = OpenMetadataProperty.STEWARD_PROPERTY_NAME.name;
        String attribute7Description = OpenMetadataProperty.STEWARD_PROPERTY_NAME.description;
        String attribute7DescriptionGUID = OpenMetadataProperty.STEWARD_PROPERTY_NAME.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute("GovernanceClassificationStatus", "status", "Deprecated attribute. Use the statusIdentifier attribute to describe the status of this classification.", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("statusIdentifier");
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute("statusIdentifier", "Description of the status of this classification.  Values defined by GovernanceStatusLevel.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("RetentionBasis", "basis", "Deprecated attribute. Use the basisIdentifier attribute to describe the retention basis of this classification.", attribute3DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("basisIdentifier");
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute("basisIdentifier", "Defined retention basis for this classification. Values defined by GovernanceClassificationLevel.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute6Name, attribute6Description, attribute6DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute7Name, attribute7Description, attribute7DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0450GovernanceRollout() {
        this.archiveBuilder.addClassificationDef(this.getGovernanceExpectationsClassification());
    }

    private ClassificationDef getGovernanceExpectationsClassification() {
        String guid = "fcda7261-865d-464d-b279-7d9880aaab39";
        String name = "GovernanceExpectations";
        String description = "A set of expectation values on the performance and use of the connected resource.";
        String descriptionGUID = null;
        String linkedToEntity = OpenMetadataType.REFERENCEABLE.typeName;
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("fcda7261-865d-464d-b279-7d9880aaab39", "GovernanceExpectations", null, "A set of expectation values on the performance and use of the connected resource.", descriptionGUID, this.archiveBuilder.getEntityDef(linkedToEntity), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "counts";
        String attribute1Description = "A set of metric name to count value pairs.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "values";
        String attribute2Description = "A set of metric name to string value pairs.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "flags";
        String attribute3Description = "A set of metric name to boolean value pairs.";
        String attribute3DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getMapStringIntTypeDefAttribute("counts", "A set of metric name to count value pairs.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute("values", "A set of metric name to string value pairs.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringBooleanTypeDefAttribute("flags", "A set of metric name to boolean value pairs.", attribute3DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void update0455ExceptionManagement() {
        this.archiveBuilder.addClassificationDef(this.getLogAnalysisClassification());
        this.archiveBuilder.addClassificationDef(this.getLineageLogClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateExceptionBacklogClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateMeteringLogClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateAuditLogClassification());
    }

    private ClassificationDef getLogAnalysisClassification() {
        String guid = "38cf214c-244d-435c-a328-251026356e6b";
        String name = "LogAnalysis";
        String description = "A set of results from the analysis of a log record - or collection of log records.";
        String descriptionGUID = null;
        String linkedToEntity = OpenMetadataType.ASSET.typeName;
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("38cf214c-244d-435c-a328-251026356e6b", "LogAnalysis", null, "A set of results from the analysis of a log record - or collection of log records.", descriptionGUID, this.archiveBuilder.getEntityDef(linkedToEntity), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute2Name = "process";
        String attribute2Description = "Unique identifier of the automated process that produced this analysis.";
        String attribute2DescriptionGUID = null;
        String attribute4Name = "counts";
        String attribute4Description = "A set of metric name to count value pairs.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "values";
        String attribute5Description = "A set of metric name to string value pairs.";
        String attribute5DescriptionGUID = null;
        String attribute6Name = "flags";
        String attribute6Description = "A set of metric name to boolean value pairs.";
        String attribute6DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.NOTES.name, OpenMetadataProperty.NOTES.description, OpenMetadataProperty.NOTES.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("process", "Unique identifier of the automated process that produced this analysis.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.SOURCE.name, OpenMetadataProperty.SOURCE.description, OpenMetadataProperty.SOURCE.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringIntTypeDefAttribute("counts", "A set of metric name to count value pairs.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute("values", "A set of metric name to string value pairs.", attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringBooleanTypeDefAttribute("flags", "A set of metric name to boolean value pairs.", attribute6DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef getLineageLogClassification() {
        String guid = "876e55db-27b9-4132-ad00-bbf882ea8e8a";
        String name = "LineageLog";
        String description = "A collection of related lineage log records.";
        String descriptionGUID = null;
        String linkedToEntity = OpenMetadataType.ASSET.typeName;
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("876e55db-27b9-4132-ad00-bbf882ea8e8a", "LineageLog", null, "A collection of related lineage log records.", descriptionGUID, this.archiveBuilder.getEntityDef(linkedToEntity), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute2Name = "process";
        String attribute2Description = "Unique identifier of the automated process that processes this lineage log.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.NOTES.name, OpenMetadataProperty.NOTES.description, OpenMetadataProperty.NOTES.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("process", "Unique identifier of the automated process that processes this lineage log.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.SOURCE.name, OpenMetadataProperty.SOURCE.description, OpenMetadataProperty.SOURCE.descriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private TypeDefPatch updateAuditLogClassification() {
        String typeName = "AuditLog";
        String linkedToEntity = OpenMetadataType.ASSET.typeName;
        String description = "A collection of related audit log records.";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("AuditLog");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setDescription("A collection of related audit log records.");
        ArrayList<TypeDefLink> linkToList = new ArrayList<TypeDefLink>();
        linkToList.add(this.archiveBuilder.getEntityDef(linkedToEntity));
        typeDefPatch.setValidEntityDefs(linkToList);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute2Name = "process";
        String attribute2Description = "Unique identifier of the automated process that processes this audit log.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.NOTES.name, OpenMetadataProperty.NOTES.description, OpenMetadataProperty.NOTES.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("process", "Unique identifier of the automated process that processes this audit log.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.SOURCE.name, OpenMetadataProperty.SOURCE.description, OpenMetadataProperty.SOURCE.descriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateMeteringLogClassification() {
        String typeName = "MeteringLog";
        String linkedToEntity = OpenMetadataType.ASSET.typeName;
        String description = "A collection of related metering log records.";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("MeteringLog");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setDescription("A collection of related metering log records.");
        ArrayList<TypeDefLink> linkToList = new ArrayList<TypeDefLink>();
        linkToList.add(this.archiveBuilder.getEntityDef(linkedToEntity));
        typeDefPatch.setValidEntityDefs(linkToList);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute2Name = "process";
        String attribute2Description = "Unique identifier of the automated process that processes this metering log.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.NOTES.name, OpenMetadataProperty.NOTES.description, OpenMetadataProperty.NOTES.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("process", "Unique identifier of the automated process that processes this metering log.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.SOURCE.name, OpenMetadataProperty.SOURCE.description, OpenMetadataProperty.SOURCE.descriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateExceptionBacklogClassification() {
        String typeName = "ExceptionBacklog";
        String linkedToEntity = OpenMetadataType.ASSET.typeName;
        String description = "A collection of exceptions that need to be resolved";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ExceptionBacklog");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setDescription("A collection of exceptions that need to be resolved");
        ArrayList<TypeDefLink> linkToList = new ArrayList<TypeDefLink>();
        linkToList.add(this.archiveBuilder.getEntityDef(linkedToEntity));
        typeDefPatch.setValidEntityDefs(linkToList);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute3Name = OpenMetadataProperty.STEWARD_TYPE_NAME.name;
        String attribute3Description = OpenMetadataProperty.STEWARD_TYPE_NAME.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.STEWARD_TYPE_NAME.descriptionGUID;
        String attribute4Name = OpenMetadataProperty.STEWARD_PROPERTY_NAME.name;
        String attribute4Description = OpenMetadataProperty.STEWARD_PROPERTY_NAME.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.STEWARD_PROPERTY_NAME.descriptionGUID;
        String attribute5Name = "process";
        String attribute5Description = "Unique identifier of the automated process that processes this exception backlog.";
        String attribute5DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.NOTES.name, OpenMetadataProperty.NOTES.description, OpenMetadataProperty.NOTES.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.STEWARD.name, OpenMetadataProperty.STEWARD.description, OpenMetadataProperty.STEWARD.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("process", "Unique identifier of the automated process that processes this exception backlog.", attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.SOURCE.name, OpenMetadataProperty.SOURCE.description, OpenMetadataProperty.SOURCE.descriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0465DuplicateProcessing() {
        this.archiveBuilder.addTypeDefPatch(this.deprecateKnownDuplicateLink());
        this.archiveBuilder.addClassificationDef(this.addConsolidatedDuplicateClassification());
        this.archiveBuilder.addRelationshipDef(this.addPeerDuplicateLinkRelationship());
        this.archiveBuilder.addRelationshipDef(this.addConsolidatedDuplicateLinkRelationship());
    }

    private TypeDefPatch deprecateKnownDuplicateLink() {
        String typeName = "KnownDuplicateLink";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("KnownDuplicateLink");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private ClassificationDef addConsolidatedDuplicateClassification() {
        String guid = "e40e80d7-5a29-482c-9a88-0dc7251f08de";
        String name = "ConsolidatedDuplicate";
        String description = "An element that has be formed by combining the properties, classifications and relationships from multiple duplicate entities.";
        String descriptionGUID = null;
        String linkedToEntity = OpenMetadataType.REFERENCEABLE.typeName;
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("e40e80d7-5a29-482c-9a88-0dc7251f08de", "ConsolidatedDuplicate", null, "An element that has be formed by combining the properties, classifications and relationships from multiple duplicate entities.", descriptionGUID, this.archiveBuilder.getEntityDef(linkedToEntity), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute2Name = "statusIdentifier";
        String attribute2Description = "Status of the consolidated entity. Value defined by GovernanceClassificationLevel.";
        String attribute2DescriptionGUID = null;
        String attribute4Name = OpenMetadataProperty.STEWARD_TYPE_NAME.name;
        String attribute4Description = OpenMetadataProperty.STEWARD_TYPE_NAME.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.STEWARD_TYPE_NAME.descriptionGUID;
        String attribute5Name = OpenMetadataProperty.STEWARD_PROPERTY_NAME.name;
        String attribute5Description = OpenMetadataProperty.STEWARD_PROPERTY_NAME.description;
        String attribute5DescriptionGUID = OpenMetadataProperty.STEWARD_PROPERTY_NAME.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute("statusIdentifier", "Status of the consolidated entity. Value defined by GovernanceClassificationLevel.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.STEWARD.name, OpenMetadataProperty.STEWARD.description, OpenMetadataProperty.STEWARD.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute5Name, attribute5Description, attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.SOURCE.name, OpenMetadataProperty.SOURCE.description, OpenMetadataProperty.SOURCE.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.NOTES.name, OpenMetadataProperty.NOTES.description, OpenMetadataProperty.NOTES.descriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private RelationshipDef addPeerDuplicateLinkRelationship() {
        String guid = "a94b2929-9e62-4b12-98ab-8ac45691e5bd";
        String name = "PeerDuplicateLink";
        String description = "Link between detected duplicate entities.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("a94b2929-9e62-4b12-98ab-8ac45691e5bd", "PeerDuplicateLink", null, "Link between detected duplicate entities.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end1AttributeName = "peerDuplicateOrigin";
        String end1AttributeDescription = "Oldest element.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "peerDuplicateOrigin", "Oldest element.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end2AttributeName = "peerDuplicatePartner";
        String end2AttributeDescription = "Newest element.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "peerDuplicatePartner", "Newest element.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute2Name = "statusIdentifier";
        String attribute2Description = "Status of the duplicate processing. Value defined by GovernanceClassificationLevel.";
        String attribute2DescriptionGUID = null;
        String attribute4Name = OpenMetadataProperty.STEWARD_TYPE_NAME.name;
        String attribute4Description = OpenMetadataProperty.STEWARD_TYPE_NAME.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.STEWARD_TYPE_NAME.descriptionGUID;
        String attribute5Name = OpenMetadataProperty.STEWARD_PROPERTY_NAME.name;
        String attribute5Description = OpenMetadataProperty.STEWARD_PROPERTY_NAME.description;
        String attribute5DescriptionGUID = OpenMetadataProperty.STEWARD_PROPERTY_NAME.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute("statusIdentifier", "Status of the duplicate processing. Value defined by GovernanceClassificationLevel.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.STEWARD.name, OpenMetadataProperty.STEWARD.description, OpenMetadataProperty.STEWARD.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute5Name, attribute5Description, attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.SOURCE.name, OpenMetadataProperty.SOURCE.description, OpenMetadataProperty.SOURCE.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.NOTES.name, OpenMetadataProperty.NOTES.description, OpenMetadataProperty.NOTES.descriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef addConsolidatedDuplicateLinkRelationship() {
        String guid = "a1fabffd-d6ec-4b2d-bfe4-646f27c07c82";
        String name = "ConsolidatedDuplicateLink";
        String description = "Link between a detected duplicate entity and an entity that contains the combined values of this entity and its other duplicates.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("a1fabffd-d6ec-4b2d-bfe4-646f27c07c82", "ConsolidatedDuplicateLink", null, "Link between a detected duplicate entity and an entity that contains the combined values of this entity and its other duplicates.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end1AttributeName = "consolidatedDuplicateOrigin";
        String end1AttributeDescription = "Detected duplicate element - the source of the properties.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "consolidatedDuplicateOrigin", "Detected duplicate element - the source of the properties.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end2AttributeName = "consolidatedDuplicateResult";
        String end2AttributeDescription = "Element resulting from combining the duplicate entities.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "consolidatedDuplicateResult", "Element resulting from combining the duplicate entities.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void update0620DataProfiling() {
        this.archiveBuilder.addEntityDef(this.addFingerprintAnnotationEntity());
    }

    private EntityDef addFingerprintAnnotationEntity() {
        String guid = "b3adca2a-ce66-4b29-bf2e-7406ada8ab49";
        String name = "FingerprintAnnotation";
        String description = "An annotation capturing asset fingerprint information.";
        String descriptionGUID = null;
        String superTypeName = "DataFieldAnnotation";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("b3adca2a-ce66-4b29-bf2e-7406ada8ab49", "FingerprintAnnotation", this.archiveBuilder.getEntityDef("DataFieldAnnotation"), "An annotation capturing asset fingerprint information.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "fingerprint";
        String attribute1Description = "A string value that represents the content of the asset.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "hash";
        String attribute2Description = "An integer value that represents the content of the asset.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "fingerprintAlgorithm";
        String attribute3Description = "The algorithm use to generate either the fingerprint.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "hashAlgorithm";
        String attribute4Description = "The algorithm use to generate either the hash.";
        String attribute4DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("fingerprint", "A string value that represents the content of the asset.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute("hash", "An integer value that represents the content of the asset.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("fingerprintAlgorithm", "The algorithm use to generate either the fingerprint.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("hashAlgorithm", "The algorithm use to generate either the hash.", attribute4DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }
}

